/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.ADTreeOnDropListener;
import org.adempiere.webui.component.ZkCssHelper;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;

public class SimpleTreeModel
extends DefaultTreeModel<Object>
implements TreeitemRenderer<Object>,
EventListener<Event> {
    private static final long serialVersionUID = 4945968834244672653L;
    private static final CLogger logger = CLogger.getCLogger(SimpleTreeModel.class);
    private boolean itemDraggable;
    private List<EventListener<Event>> onDropListners = new ArrayList<EventListener<Event>>();
    private boolean isTreeDrivenByValue = false;
    private boolean isValueDisplayed = false;

    public SimpleTreeModel(DefaultTreeNode<Object> root) {
        super(root);
    }

    public static SimpleTreeModel initADTree(Tree tree, int AD_Tree_ID, int windowNo) {
        return SimpleTreeModel.initADTree(tree, AD_Tree_ID, windowNo, true, null);
    }

    public static SimpleTreeModel initADTree(Tree tree, int AD_Tree_ID, int windowNo, String linkColName, int linkID) {
        return SimpleTreeModel.initADTree(tree, AD_Tree_ID, windowNo, true, null, linkColName, linkID);
    }

    public static SimpleTreeModel initADTree(Tree tree, int AD_Tree_ID, int windowNo, boolean editable, String trxName) {
        return SimpleTreeModel.initADTree(tree, AD_Tree_ID, windowNo, editable, trxName, null, 0);
    }

    public static SimpleTreeModel initADTree(Tree tree, int AD_Tree_ID, int windowNo, boolean editable, String trxName, String linkColName, int linkID) {
        MTree vTree = new MTree(Env.getCtx(), AD_Tree_ID, editable, true, trxName, linkColName, linkID);
        MTreeNode root = vTree.getRoot();
        SimpleTreeModel treeModel = SimpleTreeModel.createFrom(root);
        treeModel.setItemDraggable(true);
        treeModel.setTreeDrivenByValue(vTree.isTreeDrivenByValue());
        treeModel.setIsValueDisplayed(vTree.isValueDisplayed());
        treeModel.addOnDropEventListener(new ADTreeOnDropListener(tree, treeModel, vTree, windowNo));
        if (tree.getTreecols() == null) {
            Treecols treeCols = new Treecols();
            tree.getTreecols();
            tree.appendChild((Component)treeCols);
            Treecol treeCol = new Treecol();
            treeCols.appendChild((Component)treeCol);
        }
        tree.setPageSize(-1);
        try {
            tree.setItemRenderer((TreeitemRenderer)treeModel);
            tree.setModel((TreeModel)treeModel);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to setup tree");
        }
        return treeModel;
    }

    public boolean isTreeDrivenByValue() {
        return this.isTreeDrivenByValue;
    }

    public void setTreeDrivenByValue(boolean isTreeDrivenByValue) {
        this.isTreeDrivenByValue = isTreeDrivenByValue;
    }

    public boolean isValueDisplayed() {
        return this.isValueDisplayed;
    }

    public void setIsValueDisplayed(boolean isValueDisplayed) {
        this.isValueDisplayed = isValueDisplayed;
    }

    public static SimpleTreeModel createFrom(MTreeNode root) {
        SimpleTreeModel model = null;
        Enumeration nodeEnum = root.children();
        DefaultTreeNode stRoot = new DefaultTreeNode((Object)root, (Collection)(nodeEnum.hasMoreElements() ? new ArrayList() : null));
        while (nodeEnum.hasMoreElements()) {
            MTreeNode childNode = (MTreeNode)nodeEnum.nextElement();
            DefaultTreeNode stNode = childNode.getChildCount() > 0 ? new DefaultTreeNode((Object)childNode, new ArrayList()) : new DefaultTreeNode((Object)childNode);
            stRoot.getChildren().add(stNode);
            if (childNode.getChildCount() <= 0) continue;
            SimpleTreeModel.populate((DefaultTreeNode<Object>)stNode, childNode);
        }
        model = new SimpleTreeModel((DefaultTreeNode<Object>)stRoot);
        return model;
    }

    private static void populate(DefaultTreeNode<Object> stNode, MTreeNode root) {
        Enumeration nodeEnum = root.children();
        while (nodeEnum.hasMoreElements()) {
            MTreeNode childNode = (MTreeNode)nodeEnum.nextElement();
            DefaultTreeNode stChildNode = childNode.getChildCount() > 0 ? new DefaultTreeNode((Object)childNode, new ArrayList()) : new DefaultTreeNode((Object)childNode);
            stNode.getChildren().add(stChildNode);
            if (childNode.getChildCount() <= 0) continue;
            SimpleTreeModel.populate((DefaultTreeNode<Object>)stChildNode, childNode);
        }
    }

    public void render(Treeitem ti, Object node, int index) {
        Treecell tc = new Treecell(Objects.toString((Object)node));
        Treerow tr2 = null;
        if (ti.getTreerow() == null) {
            Object data;
            tr2 = new Treerow();
            tr2.setParent((Component)ti);
            if (this.isItemDraggable()) {
                if (ClientInfo.isMobile()) {
                    tr2.setAttribute("tree.row.movable", (Object)Boolean.TRUE);
                } else {
                    tr2.setDraggable("true");
                }
            }
            if (!this.onDropListners.isEmpty()) {
                tr2.setDroppable("true");
                tr2.addEventListener("onDrop", (EventListener)this);
            }
            if ((data = ((DefaultTreeNode)node).getData()) instanceof MTreeNode) {
                MTreeNode mNode = (MTreeNode)data;
                Color color = mNode.getColor();
                if (color != null) {
                    String hex = ZkCssHelper.createHexColorString(color);
                    ZkCssHelper.appendStyle((HtmlBasedComponent)tc, "color: #" + hex);
                }
                ti.setTooltiptext(mNode.getDescription());
                if (mNode.isSummary()) {
                    ZkCssHelper.appendStyle((HtmlBasedComponent)tc, "font-weight: bold");
                }
            }
        } else {
            tr2 = ti.getTreerow();
            tr2.getChildren().clear();
        }
        tc.setParent((Component)tr2);
        ti.setValue(node);
    }

    public void addNode(DefaultTreeNode<Object> newNode) {
        DefaultTreeNode<Object> root = this.getRoot();
        root.getChildren().add(newNode);
    }

    public DefaultTreeNode<Object> getRoot() {
        return (DefaultTreeNode)super.getRoot();
    }

    public void removeNode(DefaultTreeNode<Object> treeNode) {
        int[] path = this.getPath((TreeNode)treeNode);
        if (path != null && path.length > 0) {
            DefaultTreeNode parentNode = this.getRoot();
            int index = path.length - 1;
            int i = 0;
            while (i < index) {
                parentNode = (DefaultTreeNode)this.getChild((TreeNode)parentNode, path[i]);
                ++i;
            }
            parentNode.getChildren().remove(path[index]);
        }
    }

    public void setItemDraggable(boolean b) {
        this.itemDraggable = b;
    }

    public boolean isItemDraggable() {
        return this.itemDraggable;
    }

    public void addOnDropEventListener(EventListener<Event> listener) {
        this.onDropListners.add(listener);
    }

    public void onEvent(Event event) throws Exception {
        if ("onDrop".equals(event.getName())) {
            for (EventListener<Event> listener : this.onDropListners) {
                listener.onEvent(event);
            }
        }
    }

    public DefaultTreeNode<Object> getParent(DefaultTreeNode<Object> treeNode) {
        int[] path = this.getPath((TreeNode)treeNode);
        if (path != null && path.length > 0) {
            DefaultTreeNode parentNode = this.getRoot();
            int index = path.length - 1;
            int i = 0;
            while (i < index) {
                parentNode = (DefaultTreeNode)this.getChild((TreeNode)parentNode, path[i]);
                ++i;
            }
            return parentNode;
        }
        return null;
    }

    public DefaultTreeNode<Object> addNode(DefaultTreeNode<Object> newParent, DefaultTreeNode<Object> newNode, int index) {
        DefaultTreeNode parent = newParent;
        if (newParent.getChildren() == null) {
            parent = new DefaultTreeNode(newParent.getData(), new ArrayList());
            newParent.getParent().insert((TreeNode)parent, newParent.getParent().getIndex((TreeNode)newParent));
            this.removeNode((DefaultTreeNode<Object>)newParent);
        }
        parent.getChildren().add(index, newNode);
        return parent;
    }

    public DefaultTreeNode<Object> find(DefaultTreeNode<Object> fromNode, int recordId) {
        MTreeNode data;
        if (fromNode == null) {
            fromNode = this.getRoot();
        }
        if ((data = (MTreeNode)fromNode.getData()).getNode_ID() == recordId) {
            return fromNode;
        }
        if (this.isLeaf((TreeNode)fromNode)) {
            return null;
        }
        int cnt = this.getChildCount((TreeNode)fromNode);
        int i = 0;
        while (i < cnt) {
            DefaultTreeNode child = (DefaultTreeNode)this.getChild((TreeNode)fromNode, i);
            DefaultTreeNode<Object> treeNode = this.find((DefaultTreeNode<Object>)child, recordId);
            if (treeNode != null) {
                return treeNode;
            }
            ++i;
        }
        return null;
    }

    public void nodeUpdated(DefaultTreeNode<Object> node) {
        DefaultTreeNode<Object> parent = this.getParent(node);
        if (parent != null) {
            int i = parent.getChildren().indexOf(node);
            this.fireEvent(0, this.getPath((TreeNode)parent), i, i);
        }
    }
}

