/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.io.File;
import java.util.Arrays;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MSysConfig;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class FolderBrowser
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 5477614056976038703L;
    private Textbox txtPath = new Textbox();
    private Listbox listDir = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private boolean browseForFolder = false;
    private String path;
    private File root;

    public FolderBrowser() {
        this(null, false);
    }

    public FolderBrowser(boolean browseForFolder) {
        this(null, browseForFolder);
    }

    public FolderBrowser(String rootPath, boolean browseForFolder) {
        if (Util.isEmpty((String)rootPath)) {
            rootPath = MSysConfig.getValue((String)"ZK_ROOT_FOLDER_BROWSER", (String)Ini.getAdempiereHome());
        }
        this.root = new File(rootPath);
        this.browseForFolder = browseForFolder;
        this.setTitle(browseForFolder ? "Directory Browser" : "File Browser");
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 500);
        this.setBorder("normal");
        Borderlayout contentLayout = new Borderlayout();
        this.appendChild((Component)contentLayout);
        North north = new North();
        contentLayout.appendChild((Component)north);
        north.appendChild((Component)this.txtPath);
        Center center = new Center();
        contentLayout.appendChild((Component)center);
        center.appendChild((Component)this.listDir);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listDir, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listDir, "1");
        South south = new South();
        south.setStyle("border: none");
        contentLayout.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtPath, "475px");
        this.txtPath.setReadonly(true);
        this.getFileListing(this.root.getPath());
        this.listDir.setMultiple(false);
        this.listDir.addDoubleClickListener(this);
        this.listDir.addActionListener(this);
        this.confirmPanel.addActionListener(this);
        AEnv.showWindow(this);
    }

    private void getFileListing(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            ListItem li;
            Object file;
            this.listDir.removeAllItems();
            if (!dir.getParent().equals(this.root.getParent())) {
                ListItem li2 = new ListItem(dir.getName(), dir.getParent());
                li2.setImage(ThemeManager.getThemeResource("images/Undo16.png"));
                this.listDir.appendChild((Component)li2);
            }
            Object[] files = dir.listFiles();
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                file = objectArray[n2];
                if (((File)file).isDirectory()) {
                    li = new ListItem(((File)file).getName(), ((File)file).getAbsolutePath());
                    li.setImage(ThemeManager.getThemeResource("images/Folder16.png"));
                    this.listDir.appendChild((Component)li);
                }
                ++n2;
            }
            if (!this.browseForFolder) {
                objectArray = files;
                n = files.length;
                n2 = 0;
                while (n2 < n) {
                    file = objectArray[n2];
                    if (((File)file).isFile()) {
                        li = new ListItem(((File)file).getName(), ((File)file).getAbsolutePath());
                        this.listDir.appendChild((Component)li);
                    }
                    ++n2;
                }
            }
        }
        this.txtPath.setValue(dir.getAbsolutePath());
    }

    public void onEvent(Event e) throws Exception {
        int index;
        if (e.getName().equals("onDoubleClick") && e.getTarget() instanceof ListItem) {
            index = this.listDir.getSelectedIndex();
            if (index >= 0) {
                ValueNamePair vnp = this.listDir.getItemAtIndex(index).toValueNamePair();
                this.getFileListing(vnp.getValue());
            }
        } else if (e.getName().equals("onSelect") && e.getTarget() == this.listDir && (index = this.listDir.getSelectedIndex()) >= 0) {
            ValueNamePair vnp = this.listDir.getItemAtIndex(index).toValueNamePair();
            this.txtPath.setValue(vnp.getValue());
        }
        if (e.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.path = this.txtPath.getValue();
            if (this.path != null) {
                File file = new File(this.path);
                if (this.browseForFolder) {
                    if (!file.isDirectory() || !file.exists()) {
                        FDialog.error(0, "Invalid directory");
                        return;
                    }
                } else if (!file.isFile() || !file.exists()) {
                    FDialog.error(0, "Invalid file");
                    return;
                }
                this.path = file.getAbsolutePath();
            }
            this.dispose();
        } else if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.path = null;
            this.dispose();
        }
    }

    public String getPath() {
        return this.path;
    }
}

