/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Messagebox;

public final class ConfirmPanel
extends Div {
    private static final long serialVersionUID = 3257542169107223645L;
    public static final String A_OK = "Ok";
    public static final String A_CANCEL = "Cancel";
    public static final String A_REFRESH = "Refresh";
    public static final String A_RESET = "Reset";
    public static final String A_CUSTOMIZE = "Customize";
    public static final String A_HISTORY = "History";
    public static final String A_ZOOM = "Zoom";
    public static final String A_PROCESS = "Process";
    public static final String A_PRINT = "Print";
    public static final String A_EXPORT = "Export";
    public static final String A_HELP = "Help";
    public static final String A_DELETE = "Delete";
    public static final String A_PATTRIBUTE = "PAttribute";
    public static final String A_NEW = "New";
    private boolean m_withText = false;
    private Map<String, Button> buttonMap = new HashMap<String, Button>();
    private boolean m_withImage = true;
    private Hlayout pnlBtnRight;
    private Hlayout pnlBtnLeft;
    private Hlayout pnlBtnCenter;
    private String extraButtonSClass;

    public Button createButton(String name) {
        Button button = ButtonFactory.createNamedButton(name, this.m_withText, this.m_withImage);
        button.setId(name);
        this.buttonMap.put(name, button);
        if (!Util.isEmpty((String)this.extraButtonSClass)) {
            LayoutUtils.addSclass(this.extraButtonSClass, (HtmlBasedComponent)button);
        }
        return button;
    }

    public ConfirmPanel(boolean withCancelButton, boolean withRefreshButton, boolean withResetButton, boolean withCustomizeButton, boolean withHistoryButton, boolean withZoomButton) {
        this(withCancelButton, withRefreshButton, withResetButton, withCustomizeButton, withHistoryButton, withZoomButton, ButtonFactory.isWithText());
    }

    public ConfirmPanel(boolean withCancelButton, boolean withRefreshButton, boolean withResetButton, boolean withCustomizeButton, boolean withHistoryButton, boolean withZoomButton, boolean withText) {
        this(withCancelButton, withRefreshButton, withResetButton, withCustomizeButton, withHistoryButton, withZoomButton, withText, !withText ? true : ButtonFactory.isWithImage());
    }

    public ConfirmPanel(boolean withCancelButton, boolean withRefreshButton, boolean withResetButton, boolean withCustomizeButton, boolean withHistoryButton, boolean withZoomButton, boolean withText, boolean withImage) {
        this.m_withText = withText;
        this.m_withImage = withImage;
        this.init();
        this.addComponentsRight(this.createButton(A_OK));
        this.setVisible(A_CANCEL, withCancelButton);
        if (withCancelButton) {
            this.addComponentsRight(this.createButton(A_CANCEL));
        }
        if (withRefreshButton) {
            this.addComponentsLeft(this.createButton(A_REFRESH));
        }
        if (withResetButton) {
            this.addComponentsLeft(this.createButton(A_RESET));
        }
        if (withCustomizeButton) {
            this.addComponentsLeft(this.createButton(A_CUSTOMIZE));
        }
        if (withHistoryButton) {
            this.addComponentsLeft(this.createButton(A_HISTORY));
        }
        if (withZoomButton) {
            this.addComponentsLeft(this.createButton(A_ZOOM));
        }
    }

    public ConfirmPanel() {
        this(false, false, false, false, false, false);
    }

    public ConfirmPanel(boolean withCancel) {
        this(withCancel, false, false, false, false, false);
    }

    private void init() {
        this.pnlBtnLeft = new Hlayout();
        this.pnlBtnLeft.setSclass("confirm-panel-left");
        this.pnlBtnRight = new Hlayout();
        this.pnlBtnRight.setSclass("confirm-panel-right");
        this.pnlBtnCenter = new Hlayout();
        this.pnlBtnCenter.setSclass("confirm-panel-center");
        this.appendChild((Component)this.pnlBtnLeft);
        this.appendChild((Component)this.pnlBtnCenter);
        this.appendChild((Component)this.pnlBtnRight);
        this.setSclass("confirm-panel");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "min");
        this.setId("confirmPanel");
    }

    public Button addProcessButton(String btName, String imgName) {
        Button btProcess = this.createButton(btName);
        if (this.m_withImage && imgName != null && imgName.trim().length() > 0) {
            btProcess.setImage(ThemeManager.getThemeResource("images/" + imgName));
        }
        this.addComponentsCenter(btProcess);
        return btProcess;
    }

    public void addComponentsLeft(Button button) {
        if (!this.buttonMap.containsKey(button.getId())) {
            this.buttonMap.put(button.getId(), button);
        }
        this.pnlBtnLeft.appendChild((Component)button);
    }

    public void addComponentsRight(Button button) {
        if (!this.buttonMap.containsKey(button.getId())) {
            this.buttonMap.put(button.getId(), button);
        }
        this.pnlBtnRight.appendChild((Component)button);
    }

    public void addComponentsCenter(Button button) {
        if (!this.buttonMap.containsKey(button.getId())) {
            this.buttonMap.put(button.getId(), button);
        }
        this.pnlBtnCenter.appendChild((Component)button);
    }

    public void addComponentsCenter(Combobox cbb) {
        this.pnlBtnCenter.appendChild((Component)cbb);
    }

    public Button getButton(String id) {
        return this.buttonMap.get(id);
    }

    public void setVisible(String id, boolean visible) {
        Button btn = this.getButton(id);
        if (btn != null) {
            btn.setVisible(visible);
        }
    }

    public boolean isVisible(String btnName) {
        Button btn = this.getButton(btnName);
        if (btn != null) {
            return btn.isVisible();
        }
        try {
            Messagebox.show((String)("No " + btnName + " button available"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setEnabled(String id, boolean enabled) {
        Button button = this.getButton(id);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public void setEnabledAll(boolean enabled) {
        Button button;
        List list1 = this.pnlBtnLeft.getChildren();
        List list2 = this.pnlBtnRight.getChildren();
        List list3 = this.pnlBtnCenter.getChildren();
        Iterator iter1 = list1.iterator();
        Iterator iter2 = list2.iterator();
        Iterator iter3 = list3.iterator();
        while (iter1.hasNext()) {
            button = (Button)((Object)iter1.next());
            button.setEnabled(enabled);
        }
        while (iter2.hasNext()) {
            button = (Button)((Object)iter2.next());
            button.setEnabled(enabled);
        }
        while (iter3.hasNext()) {
            button = (Button)((Object)iter3.next());
            button.setEnabled(enabled);
        }
    }

    public void addActionListener(String event, EventListener<?> listener) {
        Button button;
        List list1 = this.pnlBtnLeft.getChildren();
        List list2 = this.pnlBtnRight.getChildren();
        List list3 = this.pnlBtnCenter.getChildren();
        Iterator iter1 = list1.iterator();
        Iterator iter2 = list2.iterator();
        Iterator iter3 = list3.iterator();
        while (iter1.hasNext()) {
            button = (Button)((Object)iter1.next());
            button.addEventListener(event, listener);
        }
        while (iter2.hasNext()) {
            button = (Button)((Object)iter2.next());
            button.addEventListener(event, listener);
        }
        while (iter3.hasNext()) {
            button = (Button)((Object)iter3.next());
            button.addEventListener(event, listener);
        }
    }

    public void addActionListener(EventListener<?> listener) {
        this.addActionListener("onClick", listener);
    }

    public void addButton(Button button) {
        this.addComponentsLeft(button);
    }

    public Button getOKButton() {
        return this.getButton(A_OK);
    }

    public void addButtonSclass(String cls) {
        for (Button btn : this.buttonMap.values()) {
            LayoutUtils.addSclass(cls, (HtmlBasedComponent)btn);
        }
        this.extraButtonSClass = cls;
    }

    public void removeButtonSclass(String cls) {
        for (Button btn : this.buttonMap.values()) {
            LayoutUtils.removeSclass(cls, (HtmlBasedComponent)btn);
        }
    }
}

