/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.adempiere.webui.component.Combobox;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Comboitem;

public class AutoComplete
extends Combobox {
    private static final long serialVersionUID = 7437206681528058083L;
    private String[] comboItems;
    private String[] strDescription;
    private String[] images;
    private String[] contents;
    private Object[] values;
    private HashMap<Comboitem, String> mapItems = new HashMap();

    public void setDict(String[] vals) {
        this.setDict(vals, true);
    }

    public void setDict(String[] vals, boolean sort) {
        this.comboItems = vals;
        if (this.comboItems != null && sort) {
            Arrays.sort(this.comboItems);
        }
    }

    public void setDescription(String[] vals) {
        this.strDescription = vals;
    }

    public void setContents(String[] vals) {
        this.contents = vals;
    }

    public void setImages(String[] images) {
        this.images = images;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public AutoComplete() {
        if (this.comboItems != null) {
            this.refresh("");
        }
    }

    public AutoComplete(String value) {
        super.setValue(value);
    }

    public void setValue(String value) {
        super.setValue(value);
        this.refresh(value);
    }

    public void onChanging(InputEvent evt) {
        if (!evt.isChangingBySelectBack()) {
            this.refresh(evt.getValue());
        }
    }

    public void refresh(String val) {
        if (this.comboItems == null || val == null) {
            super.getChildren().clear();
            this.mapItems.clear();
            return;
        }
        String compare = val.toLowerCase().trim();
        Iterator it = this.getItems().iterator();
        int i = 0;
        while (i < this.comboItems.length) {
            boolean match = false;
            match = compare.length() < 3 ? this.comboItems[i].toLowerCase().startsWith(compare) : this.comboItems[i].toLowerCase().contains(compare);
            if (match) {
                Comboitem comboitem = null;
                if (it != null && it.hasNext()) {
                    comboitem = (Comboitem)it.next();
                } else {
                    it = null;
                    comboitem = new Comboitem();
                    super.appendChild((Component)comboitem);
                }
                comboitem.setLabel(this.comboItems[i]);
                if (this.values != null) {
                    comboitem.setValue(this.values[i]);
                }
                comboitem.setDescription(this.strDescription[i]);
                if (this.images != null && i < this.images.length && this.images[i] != null && this.images[i].trim().length() > 0) {
                    comboitem.setImage(this.images[i]);
                }
                if (this.contents != null && i < this.contents.length && this.contents[i] != null && this.contents[i].trim().length() > 0) {
                    this.mapItems.put(comboitem, this.contents[i]);
                }
            }
            ++i;
        }
        while (it != null && it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public String getContent(Comboitem item) {
        return this.mapItems.get(item);
    }
}

