/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.wf;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WWFActivity
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -8405802852868437716L;
    private int m_WindowNo = 0;
    private MWFActivity[] m_activities = null;
    private MWFActivity m_activity = null;
    private int m_index = 0;
    private MColumn m_column = null;
    private static CLogger log = CLogger.getCLogger(WWFActivity.class);
    private Label lNode = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_WF_Node_ID"));
    private Textbox fNode = new Textbox();
    private Label lDesctiption = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private Textbox fDescription = new Textbox();
    private Label lHelp = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Help"));
    private Textbox fHelp = new Textbox();
    private Label lHistory = new Label(Msg.translate((Properties)Env.getCtx(), (String)"History"));
    private Html fHistory = new Html();
    private Label lAnswer = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Answer"));
    private Textbox fAnswerText = new Textbox();
    private Listbox fAnswerList = new Listbox();
    private Button fAnswerButton = new Button();
    private Button bZoom = new Button();
    private Label lTextMsg = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Messages"));
    private Textbox fTextMsg = new Textbox();
    private Button bOK = new Button();
    private WSearchEditor fForward = null;
    private Label lForward = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Forward"));
    private Label lOptional = new Label("(" + Msg.translate((Properties)Env.getCtx(), (String)"Optional") + ")");
    private StatusBarPanel statusBar = new StatusBarPanel();
    private ListModelTable model = null;
    private WListbox listbox = new WListbox();
    private static final String HISTORY_DIV_START_TAG = "<div style='height: 100px; border: 1px solid #7F9DB9;'>";

    public WWFActivity() {
        LayoutUtils.addSclass("workflow-activity-form", (HtmlBasedComponent)this);
    }

    @Override
    protected void initForm() {
        this.loadActivities();
        this.fAnswerList.setMold("select");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bZoom.setIconSclass("z-icon-Zoom");
        } else {
            this.bZoom.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
        }
        if (ThemeManager.isUseFontIconForImage()) {
            this.bOK.setIconSclass("z-icon-Ok");
        } else {
            this.bOK.setImage(ThemeManager.getThemeResource("images/Ok16.png"));
        }
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)10443, (int)30);
        this.fForward = new WSearchEditor((Lookup)lookup, Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"), "", true, false, true);
        this.init();
        this.display(-1);
    }

    private void init() {
        Grid grid = new Grid();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)grid, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)grid, "100%");
        grid.setStyle("margin:0; padding:0; position: absolute; align: center; valign: center;");
        grid.makeNoStrip();
        grid.setOddRowSclass("even");
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lNode);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fNode);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fNode, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fNode, "true");
        this.fNode.setReadonly(true);
        row = new Row();
        rows.appendChild((Component)row);
        row.setValign("top");
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lDesctiption);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fDescription);
        this.fDescription.setMultiline(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fDescription, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fDescription, "true");
        this.fDescription.setReadonly(true);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lHelp);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fHelp);
        this.fHelp.setMultiline(true);
        this.fHelp.setRows(3);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fHelp, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.fHelp, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fHelp, "true");
        this.fHelp.setReadonly(true);
        row.appendChild((Component)new Label());
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lHistory);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fHistory);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fHistory, "true");
        row.appendChild((Component)new Label());
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lAnswer);
        row.appendChild((Component)div);
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.fAnswerText);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fAnswerText, "true");
        hbox.appendChild((Component)this.fAnswerList);
        hbox.appendChild((Component)this.fAnswerButton);
        this.fAnswerButton.addEventListener("onClick", this);
        row.appendChild((Component)hbox);
        row.appendChild((Component)this.bZoom);
        this.bZoom.addEventListener("onClick", this);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lTextMsg);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fTextMsg);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fTextMsg, "true");
        this.fTextMsg.setMultiline(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fTextMsg, "100%");
        row.appendChild((Component)new Label());
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lForward);
        row.appendChild((Component)div);
        hbox = new Hbox();
        hbox.appendChild((Component)this.fForward.getComponent());
        hbox.appendChild((Component)this.lOptional);
        row.appendChild((Component)hbox);
        row.appendChild((Component)this.bOK);
        this.bOK.addEventListener("onClick", this);
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        layout.setStyle("background-color: transparent; position: absolute;");
        North north = new North();
        north.appendChild((Component)this.listbox);
        north.setSplittable(true);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)north, "50%");
        layout.appendChild((Component)north);
        north.setStyle("background-color: transparent");
        this.listbox.addEventListener("onSelect", this);
        Center center = new Center();
        center.appendChild((Component)grid);
        layout.appendChild((Component)center);
        center.setStyle("background-color: transparent");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        South south = new South();
        south.appendChild((Component)this.statusBar);
        layout.appendChild((Component)south);
        south.setStyle("background-color: transparent");
        this.appendChild((Component)layout);
        this.setStyle("height: 100%; width: 100%; position: absolute;");
    }

    @Override
    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            if (comp == this.bZoom) {
                this.cmd_zoom();
            } else if (comp == this.bOK) {
                Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                Events.echoEvent((String)"onOK", (Component)this, null);
            } else if (comp == this.fAnswerButton) {
                this.cmd_button();
            }
        } else if ("onSelect".equals(eventName) && comp == this.listbox) {
            this.m_index = this.listbox.getSelectedIndex();
            if (this.m_index >= 0) {
                this.display(this.m_index);
            }
        } else {
            super.onEvent(event);
        }
    }

    public int getActivitiesCount() {
        int count;
        block6: {
            count = 0;
            String sql = "SELECT COUNT(*) FROM AD_WF_Activity a WHERE " + this.getWhereActivities();
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
            sql = role.addAccessSQL(sql, "a", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_User_ID);
                    pstmt.setInt(3, AD_User_ID);
                    pstmt.setInt(4, AD_User_ID);
                    pstmt.setInt(5, AD_User_ID);
                    pstmt.setInt(6, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    public int loadActivities() {
        ArrayList<MWFActivity> list;
        long start;
        block7: {
            start = System.currentTimeMillis();
            int MAX_ACTIVITIES_IN_LIST = MSysConfig.getIntValue((String)"MAX_ACTIVITIES_IN_LIST", (int)200, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.model = new ListModelTable();
            list = new ArrayList<MWFActivity>();
            String sql = "SELECT * FROM AD_WF_Activity a WHERE " + this.getWhereActivities() + " ORDER BY a.Priority DESC, Created";
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
            sql = role.addAccessSQL(sql, "a", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_User_ID);
                    pstmt.setInt(3, AD_User_ID);
                    pstmt.setInt(4, AD_User_ID);
                    pstmt.setInt(5, AD_User_ID);
                    pstmt.setInt(6, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MWFActivity activity = new MWFActivity(Env.getCtx(), rs, null);
                        list.add(activity);
                        ArrayList<Object> rowData = new ArrayList<Object>();
                        rowData.add(activity.getPriority());
                        rowData.add(activity.getNodeName());
                        rowData.add(activity.getSummary());
                        this.model.add(rowData);
                        if (list.size() <= MAX_ACTIVITIES_IN_LIST || MAX_ACTIVITIES_IN_LIST <= 0) continue;
                        log.warning("More then 200 Activities - ignored");
                        break;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_activities = new MWFActivity[list.size()];
        list.toArray(this.m_activities);
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + this.m_activities.length + "(" + (System.currentTimeMillis() - start) + "ms)");
        }
        this.m_index = 0;
        String[] columns = new String[]{Msg.translate((Properties)Env.getCtx(), (String)"Priority"), Msg.translate((Properties)Env.getCtx(), (String)"AD_WF_Node_ID"), Msg.translate((Properties)Env.getCtx(), (String)"Summary")};
        WListItemRenderer renderer = new WListItemRenderer(Arrays.asList(columns));
        ListHeader header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, "60px");
        renderer.setListHeader(0, header);
        header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, null);
        renderer.setListHeader(1, header);
        header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, null);
        renderer.setListHeader(2, header);
        renderer.addTableValueChangeListener(this.listbox);
        this.model.setNoColumns(columns.length);
        this.listbox.setModel((ListModel<?>)this.model);
        this.listbox.setItemRenderer(renderer);
        this.listbox.repaint();
        this.listbox.setSizedByContent(false);
        return this.m_activities.length;
    }

    private String getWhereActivities() {
        String where = "a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='R' AND ur.AD_User_ID=? AND ur.isActive = 'Y') OR EXISTS (SELECT * FROM AD_WF_ActivityApprover r  WHERE a.AD_WF_Activity_ID=r.AD_WF_Activity_ID AND r.AD_User_ID=? AND r.isActive = 'Y')) AND a.AD_Client_ID=?";
        return "a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND COALESCE(r.AD_User_ID,0)=0 AND COALESCE(r.AD_Role_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='H' AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.ResponsibleType='R' AND ur.AD_User_ID=? AND ur.isActive = 'Y') OR EXISTS (SELECT * FROM AD_WF_ActivityApprover r  WHERE a.AD_WF_Activity_ID=r.AD_WF_Activity_ID AND r.AD_User_ID=? AND r.isActive = 'Y')) AND a.AD_Client_ID=?";
    }

    private MWFActivity resetDisplay(int selIndex) {
        this.fAnswerText.setVisible(false);
        this.fAnswerList.setVisible(false);
        this.fAnswerButton.setVisible(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.fAnswerButton.setIconSclass("z-icon-Window");
        } else {
            this.fAnswerButton.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
        }
        this.fTextMsg.setReadonly(selIndex < 0);
        this.bZoom.setEnabled(selIndex >= 0);
        this.bOK.setEnabled(selIndex >= 0);
        this.fForward.setValue(null);
        this.fForward.setReadWrite(selIndex >= 0);
        this.statusBar.setStatusDB(String.valueOf(String.valueOf(selIndex + 1)) + "/" + this.m_activities.length);
        this.m_activity = null;
        this.m_column = null;
        if (this.m_activities.length > 0 && selIndex >= 0 && selIndex < this.m_activities.length) {
            this.m_activity = this.m_activities[selIndex];
        }
        if (this.m_activity == null) {
            this.fNode.setText("");
            this.fDescription.setText("");
            this.fHelp.setText("");
            this.fHistory.setContent("<div style='height: 100px; border: 1px solid #7F9DB9;'>&nbsp;</div>");
            this.statusBar.setStatusDB("0/0");
            this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"WFNoActivities"));
        }
        return this.m_activity;
    }

    public void display(int index) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Index=" + index);
        }
        this.m_activity = this.resetDisplay(index);
        if (this.m_activity == null) {
            return;
        }
        this.fNode.setText(this.m_activity.getNodeName());
        this.fDescription.setValue(this.m_activity.getNodeDescription());
        this.fHelp.setValue(this.m_activity.getNodeHelp());
        this.fHistory.setContent(HISTORY_DIV_START_TAG + this.m_activity.getHistoryHTML() + "</div>");
        MWFNode node = this.m_activity.getNode();
        if ("C".equals(node.getAction())) {
            if (this.m_column == null) {
                this.m_column = node.getColumn();
            }
            if (this.m_column != null && this.m_column.get_ID() != 0) {
                this.fAnswerList.removeAllItems();
                int dt = this.m_column.getAD_Reference_ID();
                if (dt == 20) {
                    ValueNamePair[] values = MRefList.getList((Properties)Env.getCtx(), (int)319, (boolean)false);
                    int i = 0;
                    while (i < values.length) {
                        this.fAnswerList.appendItem(values[i].getName(), values[i].getValue());
                        ++i;
                    }
                    this.fAnswerList.setVisible(true);
                } else if (dt == 17) {
                    ValueNamePair[] values = MRefList.getList((Properties)Env.getCtx(), (int)this.m_column.getAD_Reference_Value_ID(), (boolean)false);
                    int i = 0;
                    while (i < values.length) {
                        this.fAnswerList.appendItem(values[i].getName(), values[i].getValue());
                        ++i;
                    }
                    this.fAnswerList.setVisible(true);
                } else {
                    this.fAnswerText.setText("");
                    this.fAnswerText.setVisible(true);
                }
            }
        } else if ("W".equals(node.getAction()) || "X".equals(node.getAction()) || "I".equals(node.getAction())) {
            this.fAnswerButton.setLabel(node.getName());
            this.fAnswerButton.setTooltiptext(node.getDescription());
            this.fAnswerButton.setVisible(true);
        } else {
            log.log(Level.SEVERE, "Unknown Node Action: " + node.getAction());
        }
        this.statusBar.setStatusDB(String.valueOf(this.m_index + 1) + "/" + this.m_activities.length);
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"WFActivities"));
    }

    private void cmd_zoom() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            return;
        }
        AEnv.zoom(this.m_activity.getAD_Table_ID(), this.m_activity.getRecord_ID());
    }

    private void cmd_button() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            return;
        }
        MWFNode node = this.m_activity.getNode();
        if ("W".equals(node.getAction())) {
            int AD_Window_ID = node.getAD_Window_ID();
            String ColumnName = String.valueOf(this.m_activity.getPO().get_TableName()) + "_ID";
            int Record_ID = this.m_activity.getRecord_ID();
            MQuery query = MQuery.getEqualQuery((String)ColumnName, (int)Record_ID);
            boolean IsSOTrx = this.m_activity.isSOTrx();
            log.info("Zoom to AD_Window_ID=" + AD_Window_ID + " - " + query + " (IsSOTrx=" + IsSOTrx + ")");
            AEnv.zoom(AD_Window_ID, query);
        } else if ("X".equals(node.getAction())) {
            int AD_Form_ID = node.getAD_Form_ID();
            ADForm form = ADForm.openForm(AD_Form_ID);
            form.setAttribute("mode", form.getWindowMode());
            AEnv.showWindow(form);
        } else if ("I".equals(node.getAction())) {
            SessionManager.getAppDesktop().openInfo(node.getAD_InfoWindow_ID());
        } else {
            log.log(Level.SEVERE, "No User Action:" + node.getAction());
        }
    }

    public void onOK() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            Clients.clearBusy();
            return;
        }
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        String textMsg = this.fTextMsg.getValue();
        MWFNode node = this.m_activity.getNode();
        Object forward = this.fForward.getValue();
        Trx trx = null;
        try {
            trx = Trx.get((String)Trx.createTrxName((String)"FWFA"), (boolean)true);
            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_onOK");
            this.m_activity.set_TrxName(trx.getTrxName());
            if (forward != null) {
                int fw;
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Forward to " + forward);
                }
                if ((fw = ((Integer)forward).intValue()) == AD_User_ID || fw == 0) {
                    log.log(Level.SEVERE, "Forward User=" + fw);
                    trx.rollback();
                    trx.close();
                    return;
                }
                if (!this.m_activity.forwardTo(fw, textMsg)) {
                    FDialog.error(this.m_WindowNo, (Component)this, "CannotForward");
                    trx.rollback();
                    trx.close();
                    return;
                }
            } else {
                if ("C".equals(node.getAction())) {
                    ListItem li;
                    if (this.m_column == null) {
                        this.m_column = node.getColumn();
                    }
                    int dt = this.m_column.getAD_Reference_ID();
                    String value = this.fAnswerText.getText();
                    if ((dt == 20 || dt == 17) && (li = this.fAnswerList.getSelectedItem()) != null) {
                        value = li.getValue().toString();
                    }
                    if (value == null || value.length() == 0) {
                        FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", Msg.getMsg((Properties)Env.getCtx(), (String)"Answer"));
                        trx.rollback();
                        trx.close();
                        return;
                    }
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Answer=" + value + " - " + textMsg);
                    }
                    try {
                        this.m_activity.setUserChoice(AD_User_ID, value, dt, textMsg);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, node.getName(), (Throwable)e);
                        FDialog.error(this.m_WindowNo, (Component)this, "Error", e.toString());
                        trx.rollback();
                        trx.close();
                        Clients.clearBusy();
                        if (trx != null) {
                            trx.close();
                        }
                        return;
                    }
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Action=" + node.getAction() + " - " + textMsg);
                }
                try {
                    this.m_activity.setUserConfirmation(AD_User_ID, textMsg);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, node.getName(), (Throwable)e);
                    FDialog.error(this.m_WindowNo, (Component)this, "Error", e.toString());
                    trx.rollback();
                    trx.close();
                    Clients.clearBusy();
                    if (trx != null) {
                        trx.close();
                    }
                    return;
                }
            }
            trx.commit();
        }
        finally {
            Clients.clearBusy();
            if (trx != null) {
                trx.close();
            }
        }
        this.loadActivities();
        this.display(-1);
    }
}

