/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph;

import java.util.Properties;
import org.adempiere.webui.apps.graph.WPerformanceDetail;
import org.adempiere.webui.apps.graph.WPerformanceIndicator;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.compiere.model.MGoal;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;

public class WPAPanel
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = -6491684272848160726L;
    private MGoal[] m_goals = null;
    private static CLogger log = CLogger.getCLogger(WPAPanel.class);

    public static WPAPanel get() {
        return WPAPanel.get(null);
    }

    public static WPAPanel get(WPerformanceIndicator.Options options) {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        MGoal[] goals = MGoal.getUserGoals((Properties)Env.getCtx(), (int)AD_User_ID);
        if (goals.length == 0) {
            return null;
        }
        return new WPAPanel(goals, options);
    }

    private WPAPanel(MGoal[] goals, WPerformanceIndicator.Options options) {
        this.m_goals = goals;
        this.init(options);
    }

    private void init(WPerformanceIndicator.Options options) {
        this.setSclass("performance-panel");
        Grid grid = new Grid();
        this.appendChild((Component)grid);
        grid.makeNoStrip();
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = null;
        int i = 0;
        while (i < this.m_goals.length) {
            if (row == null || i % 2 == 0) {
                row = new Row();
                rows.appendChild((Component)row);
            }
            Div div = new Div();
            row.appendChild((Component)div);
            div.setSclass("performance-indicator-box");
            WPerformanceIndicator pi = new WPerformanceIndicator(this.m_goals[i], options);
            div.appendChild((Component)pi);
            pi.addEventListener("onClick", this);
            Div titleDiv = new Div();
            titleDiv.setSclass("performance-indicator-title");
            Label label = new Label(pi.getTitle());
            div.appendChild((Component)titleDiv);
            titleDiv.appendChild((Component)label);
            ++i;
        }
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() instanceof WPerformanceIndicator) {
            WPerformanceIndicator pi = (WPerformanceIndicator)e.getTarget();
            log.info(pi.toString());
            MGoal goal = pi.getGoal();
            if (goal.getMeasure() != null) {
                new WPerformanceDetail(goal);
            }
        }
    }
}

