/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Searchbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.form.TreeMaintenance;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.East;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Space;
import org.zkoss.zul.Splitter;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;

public class WTreeMaintenance
extends TreeMaintenance
implements IFormController,
EventListener<Event> {
    private CustomForm form = new CustomForm();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel northPanel = new Panel();
    private Label treeLabel = new Label();
    private Listbox treeField;
    private ToolBarButton bAddAll = new ToolBarButton();
    private ToolBarButton bAdd = new ToolBarButton();
    private ToolBarButton bDelete = new ToolBarButton();
    private ToolBarButton bDeleteAll = new ToolBarButton();
    private Checkbox cbAllNodes = new Checkbox();
    private Searchbox searchBox = new Searchbox();
    private Splitter splitPane = new Splitter();
    private Tree centerTree;
    private Listbox centerList = new Listbox();

    public WTreeMaintenance() {
        try {
            this.m_WindowNo = this.form.getWindowNo();
            this.preInit();
            this.jbInit();
            this.action_loadTree();
            LayoutUtils.sendDeferLayoutEvent(this.mainLayout, 100);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", (Throwable)ex);
        }
    }

    private void preInit() {
        this.treeField = new Listbox(this.getTreeData());
        this.treeField.setMold("select");
        this.treeField.addActionListener(this);
        this.treeField.setSelectedIndex(0);
        this.centerTree = new Tree();
        this.centerTree.addEventListener("onSelect", (EventListener)this);
    }

    private void jbInit() throws Exception {
        this.bAddAll.setImage(ThemeManager.getThemeResource("images/FastBack24.png"));
        this.bAdd.setImage(ThemeManager.getThemeResource("images/StepBack24.png"));
        this.bDelete.setImage(ThemeManager.getThemeResource("images/StepForward24.png"));
        this.bDeleteAll.setImage(ThemeManager.getThemeResource("images/FastForward24.png"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.form, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, "100%");
        this.form.setStyle("position: relative; padding: 0; margin: 0");
        this.form.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        this.treeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Tree_ID"));
        this.cbAllNodes.setEnabled(false);
        this.cbAllNodes.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsAllNodes"));
        this.bAdd.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddToTree"));
        this.bAddAll.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddAllToTree"));
        this.bDelete.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteFromTree"));
        this.bDeleteAll.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteAllFromTree"));
        this.bAdd.addEventListener("onClick", this);
        this.bAddAll.addEventListener("onClick", this);
        this.bDelete.addEventListener("onClick", this);
        this.bDeleteAll.addEventListener("onClick", this);
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.northPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)north, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.northPanel, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.northPanel, "min");
        Hbox hbox = new Hbox();
        hbox.setStyle("padding: 3px;");
        hbox.setAlign("center");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "1");
        this.northPanel.appendChild((Component)hbox);
        if (ClientInfo.maxWidth(499)) {
            this.treeField.setStyle("max-width: 200px");
        }
        hbox.appendChild((Component)this.treeLabel);
        hbox.appendChild((Component)this.treeField);
        hbox.appendChild((Component)new Space());
        hbox.appendChild((Component)this.cbAllNodes);
        if (ClientInfo.maxWidth(699)) {
            hbox = new Hbox();
            hbox.setAlign("center");
            hbox.setStyle("padding-top: 3px; padding-bottom: 3px;");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)hbox, "100%");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "min");
            this.northPanel.appendChild((Component)hbox);
        } else {
            hbox.appendChild((Component)new Space());
        }
        Hlayout div = new Hlayout();
        div.appendChild((Component)this.bAddAll);
        div.appendChild((Component)this.bAdd);
        div.appendChild((Component)this.bDelete);
        div.appendChild((Component)this.bDeleteAll);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "min");
        this.searchBox.addEventListener("onClick", this);
        this.searchBox.getTextbox().addEventListener("onOK", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.searchBox.getButton().setIconSclass("z-icon-Search");
        } else {
            this.searchBox.getButton().setImage(ThemeManager.getThemeResource("images/Find16.png"));
        }
        this.searchBox.setToolTipText(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"TreeSearch"));
        if (ClientInfo.maxWidth(699)) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.searchBox, "1");
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.searchBox, "200px");
        }
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.searchBox, "min");
        div.appendChild((Component)this.searchBox);
        hbox.appendChild((Component)div);
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.centerTree);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerTree, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerTree, "1");
        center.setAutoscroll(true);
        East east = new East();
        this.mainLayout.appendChild((Component)east);
        east.appendChild((Component)this.centerList);
        east.setCollapsible(false);
        east.setSplittable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)east, "45%");
        ZKUpdateUtil.setVflex(this.centerList, true);
        this.centerList.setSizedByContent(false);
        this.centerList.addEventListener("onSelect", this);
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.treeField) {
            this.action_loadTree();
            LayoutUtils.sendDeferLayoutEvent(this.mainLayout, 100);
        } else if (e.getTarget() == this.bAddAll) {
            this.action_treeAddAll();
        } else if (e.getTarget() == this.bAdd) {
            SimpleListModel model = (SimpleListModel)this.centerList.getModel();
            int i = this.centerList.getSelectedIndex();
            if (i >= 0) {
                this.action_treeAdd((TreeMaintenance.ListItem)model.getElementAt(i));
            }
        } else if (e.getTarget() == this.bDelete) {
            SimpleListModel model = (SimpleListModel)this.centerList.getModel();
            int i = this.centerList.getSelectedIndex();
            if (i >= 0) {
                this.action_treeDelete((TreeMaintenance.ListItem)model.getElementAt(i));
            }
        } else if (e.getTarget() == this.bDeleteAll) {
            this.action_treeDeleteAll();
        } else if (e.getTarget() == this.centerList) {
            this.onListSelection(e);
        } else if (e.getTarget() == this.centerTree) {
            this.onTreeSelection(e);
        } else if (e.getTarget() == this.searchBox.getButton() || e.getTarget() == this.searchBox.getTextbox()) {
            this.searchElement();
        }
    }

    private void searchElement() {
        String filter = this.searchBox.getText() == null ? "" : this.searchBox.getText();
        filter = Util.deleteAccents((String)filter.trim().toUpperCase());
        this.action_loadTree(filter);
    }

    private void action_loadTree() {
        this.action_loadTree(null);
    }

    private void action_loadTree(String filter) {
        KeyNamePair tree = this.treeField.getSelectedItem().toKeyNamePair();
        log.info("Tree=" + tree);
        if (tree.getKey() <= 0) {
            SimpleListModel tmp = new SimpleListModel();
            this.centerList.setItemRenderer(tmp);
            this.centerList.setModel((ListModel)tmp);
            return;
        }
        this.m_tree = new MTree(Env.getCtx(), tree.getKey(), null);
        this.cbAllNodes.setSelected(this.m_tree.isAllNodes());
        this.bAddAll.setDisabled(this.m_tree.isAllNodes());
        this.bAdd.setDisabled(this.m_tree.isAllNodes());
        this.bDelete.setDisabled(this.m_tree.isAllNodes());
        this.bDeleteAll.setDisabled(this.m_tree.isAllNodes());
        SimpleListModel model = new SimpleListModel();
        ArrayList items = this.getTreeItemData();
        for (TreeMaintenance.ListItem item : items) {
            String valueItem;
            if (Util.isEmpty((String)filter)) {
                model.addElement(item);
                continue;
            }
            String string = valueItem = item.toString() == null ? "" : Util.deleteAccents((String)item.toString().toUpperCase());
            if (!valueItem.contains(filter)) continue;
            model.addElement(item);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + model.getSize());
        }
        this.centerList.setItemRenderer(model);
        this.centerList.setModel((ListModel)model);
        try {
            this.centerTree.setModel(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.centerTree.getTreecols() != null) {
            this.centerTree.getTreecols().detach();
        }
        if (this.centerTree.getTreefoot() != null) {
            this.centerTree.getTreefoot().detach();
        }
        if (this.centerTree.getTreechildren() != null) {
            this.centerTree.getTreechildren().detach();
        }
        SimpleTreeModel.initADTree(this.centerTree, this.m_tree.getAD_Tree_ID(), this.m_WindowNo);
        if (this.m_tree.isLoadAllNodesImmediately()) {
            TreeUtils.collapseTree((Component)this.centerTree, true);
        }
    }

    private void onListSelection(Event e) {
        TreeMaintenance.ListItem selected = null;
        try {
            SimpleListModel model = (SimpleListModel)this.centerList.getModel();
            int i = this.centerList.getSelectedIndex();
            selected = (TreeMaintenance.ListItem)model.getElementAt(i);
        }
        catch (Exception model) {
            // empty catch block
        }
        log.info("Selected=" + selected);
        if (selected != null) {
            SimpleTreeModel tm = (SimpleTreeModel)this.centerTree.getModel();
            DefaultTreeNode<Object> stn = tm.find(tm.getRoot(), selected.id);
            if (stn != null) {
                int[] path = tm.getPath((TreeNode)stn);
                Treeitem ti = this.centerTree.renderItemByPath(path);
                ti.setSelected(true);
            }
            this.bAdd.setDisabled(stn != null);
        }
    }

    private void onTreeSelection(Event e) {
        Treeitem ti = this.centerTree.getSelectedItem();
        DefaultTreeNode stn = (DefaultTreeNode)ti.getValue();
        MTreeNode tn = (MTreeNode)stn.getData();
        if (tn == null) {
            return;
        }
        log.info(tn.toString());
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int found = -1;
        int index = 0;
        while (index < size) {
            TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
            if (item.id == tn.getNode_ID()) {
                found = index;
                break;
            }
            ++index;
        }
        this.centerList.setSelectedIndex(found);
    }

    private void action_treeAdd(TreeMaintenance.ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            SimpleTreeModel model = (SimpleTreeModel)this.centerTree.getModel();
            DefaultTreeNode stn = model.find(model.getRoot(), item.id);
            if (stn != null) {
                MTreeNode tNode = (MTreeNode)stn.getData();
                tNode.setName(item.name);
                tNode.setAllowsChildren(item.isSummary);
                tNode.setImageIndicator(item.imageIndicator);
                model.nodeUpdated(stn);
                Treeitem ti = this.centerTree.renderItemByPath(model.getPath((TreeNode)stn));
                ti.setTooltiptext(item.description);
            } else {
                stn = new DefaultTreeNode((Object)new MTreeNode(item.id, 0, item.name, item.description, 0, item.isSummary, item.imageIndicator, false, null), new ArrayList());
                model.addNode((DefaultTreeNode<Object>)stn);
            }
            this.addNode(item);
        }
    }

    private void action_treeDelete(TreeMaintenance.ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            SimpleTreeModel model = (SimpleTreeModel)this.centerTree.getModel();
            DefaultTreeNode<Object> stn = model.find(model.getRoot(), item.id);
            if (stn != null) {
                model.removeNode(stn);
            }
            this.deleteNode(item);
        }
    }

    private void action_treeAddAll() {
        FDialog.ask(this.m_WindowNo, null, "TreeAddAllItems", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    log.info("");
                    ListModel model = WTreeMaintenance.this.centerList.getModel();
                    int size = model.getSize();
                    int index = -1;
                    index = 0;
                    while (index < size) {
                        TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
                        WTreeMaintenance.this.action_treeAdd(item);
                        ++index;
                    }
                }
            }
        });
    }

    private void action_treeDeleteAll() {
        log.info("");
        FDialog.ask(this.m_WindowNo, null, "TreeRemoveAllItems", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    ListModel model = WTreeMaintenance.this.centerList.getModel();
                    int size = model.getSize();
                    int index = -1;
                    index = 0;
                    while (index < size) {
                        TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
                        WTreeMaintenance.this.action_treeDelete(item);
                        ++index;
                    }
                }
            }
        });
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

