/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WImageEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.editor.WYesNoEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.WTabEditorForm;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.TabEditor;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MField;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Div;
import org.zkoss.zul.East;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.West;

public class WTabEditor
extends TabEditor
implements IFormController,
EventListener<Event>,
ValueChangeListener {
    private WTabEditorForm tabform = null;
    private Borderlayout mainLayout = new Borderlayout();
    public int m_WindowNo = 0;
    private Label displayedLabel = new Label();
    private Label nodisplayedLabel = new Label();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    WEditor editorName = null;
    WEditor editorAD_FieldGroup_ID = null;
    WEditor editorIsDisplayed = null;
    WEditor editorSeqNo = null;
    WEditor editorXPosition = null;
    WEditor editorColumnSpan = null;
    WEditor editorNumLines = null;
    private Listbox visible = new Listbox();
    private Listbox invisible = new Listbox();
    Group currentGroup;
    ArrayList<Row> rowList;
    Map<Cell, GridField> mapCellField = new HashMap<Cell, GridField>();
    Map<Cell, Integer> mapEmptyCellField = new HashMap<Cell, Integer>();
    Grid form;
    Vlayout centerVLayout;
    Vlayout westVLayout;
    private static final int POSSEQMULTIPLIER = 10000000;

    public WTabEditor() {
        this.tabform = new WTabEditorForm(this);
        LayoutUtils.addSclass("tab-editor-form", (HtmlBasedComponent)this.tabform);
    }

    public void initForm() {
        try {
            this.initMFields(this.tabform.getWindowNo(), this.tabform.getProcessInfo().getRecord_ID());
            this.dynList();
            this.jbInit();
            LayoutUtils.sendDeferLayoutEvent(this.mainLayout, 100);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WTabEditor.preInit", (Throwable)ex);
        }
    }

    private void dynList() {
        this.visible.addEventListener("onSelect", this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.visible, "70");
        this.visible.setItemDraggable(true);
        this.visible.setDroppable("true");
        this.visible.addOnDropListener(this);
        this.invisible.addEventListener("onSelect", this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invisible, "30");
        this.invisible.setItemDraggable(true);
        this.invisible.setDroppable("true");
        this.invisible.addOnDropListener(this);
        this.updateLists(null);
    }

    private void createUI() {
        this.mapCellField.clear();
        this.mapEmptyCellField.clear();
        this.currentGroup = null;
        this.rowList = null;
        this.form = new Grid();
        this.form.makeNoStrip();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.form, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, null);
        this.form.setVflex(false);
        int numCols = this.getNumColumns();
        if (numCols <= 0) {
            numCols = 4;
        }
        Columns columns = new Columns();
        this.form.appendChild((Component)columns);
        int equalWidth = 98 / numCols;
        int h = 0;
        while (h < numCols) {
            Column col = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, String.valueOf(equalWidth) + "%");
            columns.appendChild((Component)col);
            ++h;
        }
        Rows rows = this.form.newRows();
        Row row = new Row();
        int actualxpos = 0;
        int lastseq = 0;
        String currentFieldGroup = null;
        for (GridField gridField : this.getGridFields()) {
            Div div;
            boolean paintLabel;
            MField field = this.getMField(gridField.getAD_Field_ID());
            if (!gridField.isDisplayed() || gridField.isToolbarOnlyButton()) continue;
            String fieldGroup = gridField.getFieldGroup();
            if (!Util.isEmpty((String)fieldGroup) && !fieldGroup.equals(currentFieldGroup)) {
                currentFieldGroup = fieldGroup;
                while (numCols - actualxpos + 1 > 0) {
                    row.appendCellChild(this.createSpacer(), 1);
                    this.setLastCellProps(row.getLastCell(), actualxpos, field.getSeqNo());
                    ++actualxpos;
                }
                row.setGroup(this.currentGroup);
                rows.appendChild((Component)row);
                if (this.rowList != null) {
                    this.rowList.add(row);
                }
                this.rowList = new ArrayList();
                if ("L".equals(gridField.getFieldGroupType())) {
                    row = new Row();
                    Label groupLabel = new Label(fieldGroup);
                    row.appendCellChild((Component)groupLabel, numCols);
                    rows.appendChild((Component)row);
                    row = new Row();
                    Separator separator = new Separator();
                    separator.setBar(true);
                    row.appendCellChild((Component)separator, numCols);
                    rows.appendChild((Component)row);
                    this.currentGroup = null;
                } else {
                    Group rowg = new Group(fieldGroup);
                    Cell cell = (Cell)rowg.getFirstChild();
                    cell.setSclass("z-group-inner");
                    cell.setColspan(numCols + 1);
                    if ("T".equals(gridField.getFieldGroupType()) || gridField.getIsCollapsedByDefault()) {
                        rowg.setOpen(false);
                    }
                    this.currentGroup = rowg;
                    rows.appendChild((Component)rowg);
                }
                row = new Row();
                actualxpos = 0;
            }
            if (gridField.getXPosition() <= actualxpos) {
                while (numCols - actualxpos + 1 > 0) {
                    row.appendCellChild(this.createSpacer(), 1);
                    this.setLastCellProps(row.getLastCell(), actualxpos, field.getSeqNo());
                    ++actualxpos;
                }
                row.setGroup(this.currentGroup);
                rows.appendChild((Component)row);
                if (this.rowList != null) {
                    this.rowList.add(row);
                }
                row = new Row();
                actualxpos = 0;
            }
            if (gridField.getXPosition() - 1 - actualxpos > 0) {
                row.appendCellChild(this.createSpacer(), gridField.getXPosition() - 1 - actualxpos);
                this.setLastCellProps(row.getLastCell(), actualxpos, field.getSeqNo());
            }
            boolean bl = paintLabel = gridField.getDisplayType() != 28 && gridField.getDisplayType() != 20 && !gridField.isFieldOnly();
            actualxpos = gridField.isHeading() ? gridField.getXPosition() : gridField.getXPosition() + gridField.getColumnSpan() - 1 + (paintLabel ? 1 : 0);
            if (!gridField.isHeading()) {
                WEditor editor = WebEditorFactory.getEditor(null, gridField, false);
                if (editor != null) {
                    editor.setReadWrite(true);
                    if (editor.getComponent() instanceof EditorBox) {
                        EditorBox editorbox = (EditorBox)editor.getComponent();
                        editorbox.getButton().setDisabled(true);
                    } else if (editor instanceof WImageEditor) {
                        editor.setReadWrite(false);
                    }
                    if (paintLabel) {
                        div = new Div();
                        div.setStyle("text-align: right;");
                        Label label = editor.getLabel();
                        div.appendChild((Component)label);
                        if (label.getDecorator() != null) {
                            div.appendChild(label.getDecorator());
                        }
                        row.appendCellChild((Component)div, 1);
                        this.setLastCellProps(row.getLastCell(), gridField);
                    }
                    row.appendCellChild(editor.getComponent(), gridField.getColumnSpan());
                    this.setLastCellProps(row.getLastCell(), gridField);
                    editor.fillHorizontal();
                }
            } else {
                Label label = new Label(gridField.getHeader());
                div = new Div();
                div.setStyle("text-align: center;");
                row.appendCellChild(this.createSpacer());
                div.appendChild((Component)label);
                row.appendCellChild((Component)div);
                this.setLastCellProps(row.getLastCell(), gridField);
            }
            lastseq = field.getSeqNo();
        }
        while (numCols - actualxpos + 1 > 0) {
            row.appendCellChild(this.createSpacer(), 1);
            this.setLastCellProps(row.getLastCell(), actualxpos, lastseq += 10);
            ++actualxpos;
        }
        row.setGroup(this.currentGroup);
        rows.appendChild((Component)row);
        if (this.rowList != null) {
            this.rowList.add(row);
        }
    }

    private void setLastCellProps(Cell lastCell, GridField field) {
        lastCell.setDraggable("true");
        lastCell.setDroppable("true");
        lastCell.addEventListener("onDrop", (EventListener)this);
        lastCell.addEventListener("onClick", (EventListener)this);
        lastCell.addEventListener("onDoubleClick", (EventListener)this);
        this.mapCellField.put(lastCell, field);
    }

    private void setLastCellProps(Cell lastCell, int actualxpos, int seqNo) {
        lastCell.setDroppable("true");
        lastCell.addEventListener("onDrop", (EventListener)this);
        int value = (actualxpos + 1) * 10000000 + seqNo;
        this.mapEmptyCellField.put(lastCell, value);
    }

    private Component createSpacer() {
        return new Space();
    }

    private int getNumColumns() {
        int maxcol = 0;
        for (GridField gridField : this.getGridFields()) {
            if (!gridField.isDisplayed() || gridField.isToolbarOnlyButton()) continue;
            int col = gridField.getXPosition() + gridField.getColumnSpan();
            if (gridField.isFieldOnly() || gridField.getDisplayType() == 28 && !gridField.isToolbarOnlyButton() || gridField.getDisplayType() == 20) {
                --col;
            }
            if (col <= maxcol) continue;
            maxcol = col;
        }
        return maxcol;
    }

    private Grid createPropertiesGrid() {
        Grid gridView = GridFactory.newGridLayout();
        Columns columns = new Columns();
        gridView.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
        column.setAlign("right");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "1");
        Rows rows = new Rows();
        gridView.appendChild((Component)rows);
        Row row = null;
        row = new Row();
        Group group = new Group(Msg.getMsg((Properties)Env.getCtx(), (String)"Property"));
        Cell cell = (Cell)group.getFirstChild();
        cell.setSclass("z-group-inner");
        cell.setColspan(2);
        group.setOpen(true);
        rows.appendChild((Component)group);
        row = new Row();
        Label labelName = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Name"));
        this.editorName = new WStringEditor("Name", false, true, false, 0, 0, null, null);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)((WStringEditor)this.editorName).getComponent(), "1");
        row.appendChild(labelName.rightAlign());
        row.appendChild(this.editorName.getComponent());
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelIsDisplayed = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"IsDisplayed"));
        this.editorIsDisplayed = new WYesNoEditor("IsDisplayed", "", labelIsDisplayed.getValue(), false, true, false);
        row.appendChild(labelIsDisplayed.rightAlign());
        row.appendChild(this.editorIsDisplayed.getComponent());
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelSeqNo = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"SeqNo"));
        this.editorSeqNo = new WNumberEditor("SeqNo", false, true, false, 11, labelSeqNo.getValue());
        row.appendChild(labelSeqNo.rightAlign());
        row.appendChild(this.editorSeqNo.getComponent());
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelAD_FieldGroup_ID = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"AD_FieldGroup_ID"));
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.tabform.getWindowNo(), (int)0, (int)5375, (int)19);
        this.editorAD_FieldGroup_ID = new WTableDirEditor("AD_FieldGroup_ID", false, false, true, (Lookup)lookup);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)((WTableDirEditor)this.editorAD_FieldGroup_ID).getComponent(), "1");
        row.appendChild(labelAD_FieldGroup_ID.rightAlign());
        row.appendChild(this.editorAD_FieldGroup_ID.getComponent());
        this.editorAD_FieldGroup_ID.addValueChangeListener(this);
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelXPosition = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"XPosition"));
        this.editorXPosition = new WNumberEditor("XPosition", true, false, true, 11, labelXPosition.getValue());
        row.appendChild(labelXPosition.rightAlign());
        row.appendChild(this.editorXPosition.getComponent());
        this.editorXPosition.addValueChangeListener(this);
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelColumnSpan = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"ColumnSpan"));
        this.editorColumnSpan = new WNumberEditor("ColumnSpan", true, false, true, 11, labelColumnSpan.getValue());
        row.appendChild(labelColumnSpan.rightAlign());
        row.appendChild(this.editorColumnSpan.getComponent());
        this.editorColumnSpan.addValueChangeListener(this);
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Label labelNumLines = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"NumLines"));
        this.editorNumLines = new WNumberEditor("NumLines", true, false, true, 11, labelNumLines.getValue());
        row.appendChild(labelNumLines.rightAlign());
        row.appendChild(this.editorNumLines.getComponent());
        this.editorNumLines.addValueChangeListener(this);
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        Separator esep = new Separator("horizontal");
        esep.setSpacing("10px");
        row.appendCellChild((Component)esep, 2);
        row.setGroup(group);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild((Component)this.confirmPanel, 2);
        row.setGroup(group);
        rows.appendChild((Component)row);
        return gridView;
    }

    private void jbInit() throws Exception {
        this.tabform.setSizable(true);
        this.tabform.setClosable(true);
        this.tabform.setMaximizable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabform, "95%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabform, "95%");
        this.tabform.appendChild((Component)this.mainLayout);
        LayoutUtils.addSclass("tab-editor-form-content", (HtmlBasedComponent)this.mainLayout);
        this.tabform.setBorder("normal");
        this.confirmPanel.addActionListener("onClick", this);
        Grid propGrid = this.createPropertiesGrid();
        East east = new East();
        LayoutUtils.addSclass("tab-editor-form-east-panel", (HtmlBasedComponent)east);
        this.mainLayout.appendChild((Component)east);
        east.appendChild((Component)propGrid);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)east, "320px");
        ListHead visibleHead = new ListHead();
        visibleHead.setParent((Component)this.visible);
        ListHeader visibleHeader = new ListHeader();
        this.displayedLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"VisibleFields"));
        visibleHeader.appendChild((Component)this.displayedLabel);
        visibleHeader.setParent((Component)visibleHead);
        ListHead invisibleHead = new ListHead();
        invisibleHead.setParent((Component)this.invisible);
        ListHeader invisibleHeader = new ListHeader();
        this.nodisplayedLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"NonVisibleFields"));
        invisibleHeader.appendChild((Component)this.nodisplayedLabel);
        invisibleHeader.setParent((Component)invisibleHead);
        this.westVLayout = new Vlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.westVLayout, "100%");
        this.westVLayout.appendChild((Component)this.visible);
        this.westVLayout.appendChild((Component)this.invisible);
        this.createUI();
        this.centerVLayout = new Vlayout();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.centerVLayout, "100%");
        this.centerVLayout.appendChild((Component)this.form);
        this.centerVLayout.setStyle("overflow:auto");
        Center center = new Center();
        LayoutUtils.addSclass("tab-editor-form-center-panel", (HtmlBasedComponent)center);
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.centerVLayout);
        West west = new West();
        LayoutUtils.addSclass("tab-editor-form-west-panel", (HtmlBasedComponent)west);
        this.mainLayout.appendChild((Component)west);
        west.appendChild((Component)this.westVLayout);
        west.setCollapsible(true);
        west.setSplittable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)west, "200px");
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) throws Exception {
        if ("onSelect".equals(e.getName()) && e.getTarget() instanceof Listbox) {
            int fieldid;
            MField field;
            Listbox list = (Listbox)e.getTarget();
            if (list.getSelectedItem() != null && (field = this.getMField(fieldid = ((Integer)list.getSelectedItem().getValue()).intValue())) != null) {
                this.setActiveMField(field);
                this.setProperties(field);
                this.setBackgroundField(field);
            }
        } else if ("onClick".equals(e.getName()) && e.getTarget() instanceof Cell) {
            MField field;
            GridField gridField = this.mapCellField.get(e.getTarget());
            if (gridField != null && (field = this.getMField(gridField.getAD_Field_ID())) != null) {
                this.setActiveMField(field);
                this.setProperties(field);
                this.setBackgroundField(field);
                for (Listitem item : this.visible.getItems()) {
                    if (field.getAD_Field_ID() != ((Integer)item.getValue()).intValue()) continue;
                    this.visible.setSelectedItem(item);
                    break;
                }
            }
        } else if ("onDoubleClick".equals(e.getName()) && e.getTarget() instanceof Cell) {
            GridField gridField;
            MouseEvent me = (MouseEvent)e;
            int mult = 1;
            if ((me.getKeys() & 2) > 0) {
                mult = -1;
            }
            if ((gridField = this.mapCellField.get(e.getTarget())) != null) {
                MField field = this.getMField(gridField.getAD_Field_ID());
                if (mult != -1 || field.getColumnSpan() > 1) {
                    field.setColumnSpan(field.getColumnSpan() + mult);
                }
                for (Listitem item : this.visible.getItems()) {
                    if (field.getAD_Field_ID() != ((Integer)item.getValue()).intValue()) continue;
                    this.visible.setSelectedItem(item);
                    break;
                }
                this.setActiveMField(field);
                this.setProperties(field);
                this.repaintGrid();
                this.setBackgroundField(field);
            }
        } else if (e instanceof DropEvent) {
            MField field;
            Integer posseq;
            DropEvent me = (DropEvent)e;
            ListItem startItem = null;
            if (me.getDragged() instanceof ListItem) {
                startItem = (ListItem)me.getDragged();
            } else if (me.getDragged() instanceof Cell) {
                startItem = this.getItemFromCell((Cell)me.getDragged());
            }
            ListItem endItem = null;
            if (me.getTarget() instanceof ListItem) {
                endItem = (ListItem)me.getTarget();
            } else if (me.getTarget() instanceof Cell && (endItem = this.getItemFromCell((Cell)me.getTarget())) == null && (posseq = this.mapEmptyCellField.get(me.getTarget())) != null) {
                int actualxpos = posseq / 10000000;
                int seqno = posseq - actualxpos * 10000000;
                MField field2 = this.getMField((Integer)startItem.getValue());
                field2.setSeqNo(seqno - 5);
                field2.setIsDisplayed(true);
                field2.setXPosition(actualxpos);
                this.resortArrays();
                this.setProperties(field2);
                this.updateLists(field2);
                this.repaintGrid();
                this.setActiveMField(field2);
                this.setBackgroundField(field2);
                return;
            }
            if (startItem.getListbox() == this.visible && endItem.getListbox() == this.invisible) {
                field = this.getMField((Integer)startItem.getValue());
                this.setActiveMField(field);
                field.setSeqNo(0);
                field.setIsDisplayed(false);
                field.setXPosition(1);
                this.resortArrays();
                this.setProperties(field);
                this.updateLists(field);
                this.repaintGrid();
                this.setBackgroundField(field);
            } else if (startItem.getListbox() == this.invisible && endItem.getListbox() == this.visible && (Integer)startItem.getValue() != 0) {
                field = this.getMField((Integer)startItem.getValue());
                MField fieldTo = this.getMField((Integer)endItem.getValue());
                field.setSeqNo(fieldTo.getSeqNo() - 5);
                field.setIsDisplayed(true);
                field.setXPosition(fieldTo.getXPosition());
                this.resortArrays();
                this.setProperties(field);
                this.updateLists(field);
                this.repaintGrid();
                this.setActiveMField(field);
                this.setBackgroundField(field);
            } else if (startItem.getListbox() == this.visible && endItem.getListbox() == this.visible) {
                field = this.getMField((Integer)startItem.getValue());
                MField fieldTo = this.getMField((Integer)endItem.getValue());
                field.setSeqNo(fieldTo.getSeqNo() - 5);
                field.setIsDisplayed(true);
                field.setXPosition(fieldTo.getXPosition());
                this.resortArrays();
                this.setProperties(field);
                this.updateLists(field);
                this.repaintGrid();
                this.setActiveMField(field);
                this.setBackgroundField(field);
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.tabform.detach();
        } else if (e.getTarget().getId().equals("Ok") && this.cmd_save()) {
            this.tabform.detach();
        }
    }

    private ListItem getItemFromCell(Cell cell) {
        GridField field = this.mapCellField.get(cell);
        if (field != null) {
            int idx = 0;
            while (idx < this.visible.getItemCount()) {
                ListItem item = this.visible.getItemAtIndex(idx);
                if (item != null && field.getAD_Field_ID() == ((Integer)item.getValue()).intValue()) {
                    return item;
                }
                ++idx;
            }
        }
        return null;
    }

    private void setBackgroundField(MField field) {
        for (Map.Entry<Cell, GridField> pairs : this.mapCellField.entrySet()) {
            Cell cell = pairs.getKey();
            GridField gridField = pairs.getValue();
            if (gridField.getAD_Field_ID() == field.getAD_Field_ID()) {
                cell.setStyle("background-color: #BBC2DB;");
                continue;
            }
            cell.setStyle("");
        }
    }

    private void setProperties(MField field) {
        this.editorName.setValue(field.getName());
        this.editorSeqNo.setValue(field.getSeqNo());
        this.editorIsDisplayed.setValue(field.isDisplayed());
        if (field.getAD_FieldGroup_ID() > 0) {
            this.editorAD_FieldGroup_ID.setValue(field.getAD_FieldGroup_ID());
        } else {
            this.editorAD_FieldGroup_ID.setValue(null);
        }
        this.editorXPosition.setValue(field.getXPosition());
        this.editorColumnSpan.setValue(field.getColumnSpan());
        this.editorNumLines.setValue(field.getNumLines());
        GridField gridField = this.getGridField(field);
        String fieldGroup = "";
        String fieldGroupType = "";
        if (field.getAD_FieldGroup_ID() > 0) {
            fieldGroup = field.getAD_FieldGroup().getName();
            fieldGroupType = field.getAD_FieldGroup().getFieldGroupType();
        }
        gridField.getVO().IsDisplayed = field.isDisplayed();
        gridField.getVO().FieldGroup = fieldGroup;
        gridField.getVO().FieldGroupType = fieldGroupType;
        gridField.getVO().XPosition = field.getXPosition();
        gridField.getVO().ColumnSpan = field.getColumnSpan();
        gridField.getVO().NumLines = field.getNumLines();
    }

    @Override
    public ADForm getForm() {
        return this.tabform;
    }

    private void updateLists(MField focusField) {
        this.visible.removeAllItems();
        this.invisible.removeAllItems();
        for (MField field : this.getMFields()) {
            GridField gridField = this.getGridField(field);
            if (!field.isActive() || gridField.isToolbarOnlyButton()) continue;
            KeyNamePair pair = new KeyNamePair(field.getAD_Field_ID(), field.getName());
            if (field.isDisplayed()) {
                this.visible.addItem(pair);
                if (field != focusField) continue;
                this.visible.setSelectedKeyNamePair(pair);
                continue;
            }
            this.invisible.addItem(pair);
            if (field != focusField) continue;
            this.invisible.setSelectedKeyNamePair(pair);
        }
        if (this.invisible.getItems().isEmpty()) {
            this.invisible.addItem(new KeyNamePair(0, "..."));
        }
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        MField field = this.getActiveMField();
        if (field != null) {
            String propertyName = e.getPropertyName();
            int intvalue = 0;
            if (e.getNewValue() != null) {
                intvalue = (Integer)e.getNewValue();
            }
            if ("AD_FieldGroup_ID".equals(propertyName)) {
                field.setAD_FieldGroup_ID(intvalue);
            } else if ("XPosition".equals(propertyName)) {
                field.setXPosition(intvalue);
            } else if ("ColumnSpan".equals(propertyName)) {
                int prevcolspan = field.getColumnSpan();
                if (!field.set_ValueOfColumnReturningBoolean("ColumnSpan", (Object)intvalue)) {
                    field.setColumnSpan(prevcolspan);
                }
            } else if ("NumLines".equals(propertyName)) {
                field.setNumLines(intvalue);
            }
            this.setProperties(field);
            this.repaintGrid();
        }
    }

    private void repaintGrid() {
        this.centerVLayout.removeChild((Component)this.form);
        if (this.form.getRows() != null) {
            this.form.removeChild((Component)this.form.getRows());
        }
        this.createUI();
        this.centerVLayout.appendChild((Component)this.form);
    }
}

