/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.MWizardProcess;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.SetupWizard;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.East;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.North;
import org.zkoss.zul.Progressmeter;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.Vbox;

public class WSetupWizard
extends SetupWizard
implements IFormController,
EventListener<Event> {
    private CustomForm form = null;
    private Borderlayout mainLayout = new Borderlayout();
    private Panel northPanel = new Panel();
    private Progressmeter progressbar = new Progressmeter();
    private Label progressLabel = new Label();
    private Tree wfnodeTree;
    private Treeitem prevti = null;
    private Treeitem firstOpenNode = null;
    private Treeitem firstOpenWF = null;
    private Treeitem firstWF = null;
    private int cntNodes = 0;
    private int cntSolved = 0;
    private Label pretitleLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SetupTask"));
    private Label titleLabel = new Label();
    private Iframe helpFrame = new Iframe();
    private Label notesLabel = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Note"));
    private Textbox notesField = new Textbox();
    private Label userLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"User"));
    private WSearchEditor userField;
    private Label statusLabel = new Label();
    private WTableDirEditor statusField;
    private Label bZoomLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"));
    private Button bRefresh = new Button();
    private Button bOK = new Button();
    private Button bNext = new Button();
    private Button bZoom = new Button();
    private Button bExpand = new Button();
    private Checkbox justmine = new Checkbox();
    private Checkbox showColors = new Checkbox();
    private ArrayList<Treeitem> nextItems = new ArrayList();
    private static final String WIZARD_LABEL_STYLE = "font-weight: bold";
    private boolean expandTree = false;
    private boolean allFinished = true;
    private boolean allPending = true;
    private Vbox centerBox = new Vbox();
    private Vbox centerBoxdown = new Vbox();
    private Vbox westdown = new Vbox();
    private ArrayList<Integer> openNodes = new ArrayList();

    public WSetupWizard() {
        try {
            this.preInit();
            this.jbInit();
            LayoutUtils.sendDeferLayoutEvent(this.mainLayout, 100);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSetupWizard.init", (Throwable)ex);
        }
    }

    private void preInit() {
        this.form = new CustomForm(){
            private static final long serialVersionUID = 8563773513335140396L;

            @Override
            public void onEvent(Event event) throws Exception {
                if (event.getName().equals("onWindowContainerSelectionChanged")) {
                    Treeitem ti = WSetupWizard.this.wfnodeTree.getSelectedItem();
                    if (ti != null) {
                        if (ti.getAttribute("AD_Workflow_ID") != null) {
                            int wfid = (Integer)ti.getAttribute("AD_Workflow_ID");
                            SessionManager.getAppDesktop().updateHelpContext("W", wfid);
                        } else if (ti.getAttribute("AD_WF_Node_ID") != null) {
                            int nodeid = (Integer)ti.getAttribute("AD_WF_Node_ID");
                            SessionManager.getAppDesktop().updateHelpContext("N", nodeid);
                        }
                    }
                } else {
                    super.onEvent(event);
                }
            }
        };
        this.wfnodeTree = new Tree();
        this.wfnodeTree.addEventListener("onSelect", (EventListener)this);
        this.showColors.setChecked(true);
        this.loadWizardNodes();
    }

    private void loadWizardNodes() {
        this.cntNodes = 0;
        this.cntSolved = 0;
        this.nextItems.removeAll(this.nextItems);
        Treechildren treeChildren = this.wfnodeTree.getTreechildren();
        List wfwizards = this.getWfWizards();
        if (treeChildren == null) {
            treeChildren = new Treechildren();
            this.wfnodeTree.appendChild((Component)treeChildren);
            this.wfnodeTree.setMultiple(false);
        }
        for (MWorkflow wfwizard : wfwizards) {
            this.addWfEntry(wfwizard);
        }
    }

    protected void addWfEntry(MWorkflow wfwizard) {
        this.allFinished = true;
        this.allPending = true;
        Treeitem treeitemwf = new Treeitem();
        Treechildren treeChildren = this.wfnodeTree.getTreechildren();
        treeChildren.appendChild((Component)treeitemwf);
        this.nextItems.add(treeitemwf);
        this.addNodes(wfwizard, treeitemwf);
        if (treeitemwf.getTreechildren() == null || treeitemwf.getTreechildren().getChildren() == null || treeitemwf.getTreechildren().getChildren().size() == 0) {
            treeChildren.removeChild((Component)treeitemwf);
            this.nextItems.remove(treeitemwf);
            treeitemwf = null;
            return;
        }
        if (this.firstWF == null) {
            this.firstWF = treeitemwf;
        }
        Label wizardLabel = new Label(wfwizard.getName(true));
        wizardLabel.setStyle(WIZARD_LABEL_STYLE);
        Div div = new Div();
        div.setStyle("display:inline;");
        div.appendChild((Component)wizardLabel);
        Treerow treerow = new Treerow();
        treerow.setStyle("vertical-align:top;");
        treeitemwf.appendChild((Component)treerow);
        treeitemwf.setOpen(false);
        Treecell treecell = new Treecell();
        treerow.appendChild((Component)treecell);
        treecell.appendChild((Component)div);
        if (this.openNodes.contains(wfwizard.getAD_Workflow_ID())) {
            treeitemwf.setOpen(true);
        }
        if (this.firstOpenWF == treeitemwf && this.allPending) {
            this.firstOpenNode = this.firstOpenWF;
        }
        if (this.showColors.isChecked()) {
            if (this.allFinished) {
                wizardLabel.setZclass("tree-wsetupwizard-finished-all");
            } else if (!this.allPending) {
                wizardLabel.setZclass("tree-wsetupwizard-open-tasks");
            }
        }
        treeitemwf.setAttribute("AD_Workflow_ID", (Object)wfwizard.getAD_Workflow_ID());
        if (this.prevti != null && this.prevti.getAttribute("AD_Workflow_ID") != null && this.prevti.getAttribute("AD_Workflow_ID").equals(treeitemwf.getAttribute("AD_Workflow_ID"))) {
            this.wfnodeTree.setSelectedItem(treeitemwf);
        }
    }

    private void addNodes(MWorkflow wfwizard, Treeitem treeitemwf) {
        MWFNode[] nodes;
        MWFNode[] mWFNodeArray = nodes = wfwizard.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            MWFNode node = mWFNodeArray[n2];
            this.addWfNode(node, treeitemwf);
            ++n2;
        }
    }

    private void addWfNode(MWFNode node, Treeitem treeitemwf) {
        if ("W".equals(node.getAction()) && node.getAD_Window_ID() > 0 ? MRole.getDefault().getWindowAccess(node.getAD_Window_ID()) == null : ("X".equals(node.getAction()) && node.getAD_Form_ID() > 0 ? MRole.getDefault().getFormAccess(node.getAD_Form_ID()) == null : (("P".equals(node.getAction()) || "R".equals(node.getAction())) && node.getAD_Process_ID() > 0 ? MRole.getDefault().getProcessAccess(node.getAD_Process_ID()) == null : "T".equals(node.getAction()) && node.getAD_Task_ID() > 0 && MRole.getDefault().getTaskAccess(node.getAD_Task_ID()) == null))) {
            return;
        }
        Label nodeLabel = new Label(node.getName(true));
        MWizardProcess wp = MWizardProcess.get((Properties)Env.getCtx(), (int)node.getAD_WF_Node_ID(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        String status = wp.getWizardStatus();
        if (this.showColors.isChecked()) {
            if ("F".equals(status)) {
                nodeLabel.setZclass("tree-wsetupwizard-finished");
            } else if ("S".equals(status)) {
                nodeLabel.setZclass("tree-wsetupwizard-skipped");
            } else if ("D".equals(status)) {
                nodeLabel.setZclass("tree-wsetupwizard-delayed");
            } else if ("I".equals(status)) {
                nodeLabel.setZclass("tree-wsetupwizard-in-progress");
            } else if ("P".equals(status)) {
                nodeLabel.setZclass("tree-wsetupwizard-pending");
            } else {
                nodeLabel.setZclass("tree-setupwizard-nostatus");
            }
        }
        ++this.cntNodes;
        if ("F".equals(status) || "S".equals(status)) {
            this.allPending = false;
            ++this.cntSolved;
        } else {
            this.allFinished = false;
        }
        Div div = new Div();
        div.setStyle("display:inline;");
        div.appendChild((Component)nodeLabel);
        Treechildren treeChildren = treeitemwf.getTreechildren();
        if (treeChildren == null) {
            treeChildren = new Treechildren();
            treeitemwf.appendChild((Component)treeChildren);
        }
        Treeitem childItem = new Treeitem();
        treeChildren.appendChild((Component)childItem);
        Treerow treerow = new Treerow();
        treerow.setStyle("vertical-align:top;");
        childItem.appendChild((Component)treerow);
        Treecell treecell = new Treecell();
        treerow.appendChild((Component)treecell);
        treecell.appendChild((Component)div);
        childItem.setAttribute("AD_WF_Node_ID", (Object)node.getAD_WF_Node_ID());
        if (this.prevti != null && this.prevti.getAttribute("AD_WF_Node_ID") != null && this.prevti.getAttribute("AD_WF_Node_ID").equals(childItem.getAttribute("AD_WF_Node_ID"))) {
            this.wfnodeTree.setSelectedItem(childItem);
        }
        this.nextItems.add(childItem);
        if (this.firstOpenNode == null && !"F".equals(status) && !"S".equals(status)) {
            this.firstOpenWF = treeitemwf;
            this.firstOpenNode = childItem;
        }
    }

    private void jbInit() throws Exception {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.form, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, "100%");
        this.form.setStyle("position: absolute; padding: 0; margin: 0");
        this.form.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        this.mainLayout.setStyle("position: absolute");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
        }
        this.bRefresh.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Refresh"));
        this.bRefresh.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bOK.setIconSclass("z-icon-Ok");
        } else {
            this.bOK.setImage(ThemeManager.getThemeResource("images/Ok16.png"));
        }
        this.bOK.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Update"));
        this.bOK.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bNext.setIconSclass("z-icon-Next");
        } else {
            this.bNext.setImage(ThemeManager.getThemeResource("images/Next16.png"));
        }
        this.bNext.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Next"));
        this.bNext.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bZoom.setIconSclass("z-icon-Zoom");
        } else {
            this.bZoom.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
        }
        this.bZoom.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Zoom"));
        this.bZoom.addEventListener("onClick", this);
        this.bExpand.setLabel(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"ExpandTree"));
        this.bExpand.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"ExpandTree"));
        this.bExpand.addEventListener("onClick", this);
        this.justmine.setLabel(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"JustMine"));
        this.justmine.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"JustMine"));
        this.justmine.addEventListener("onCheck", this);
        this.showColors.setLabel(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"ShowColors"));
        this.showColors.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"ShowColors"));
        this.showColors.addEventListener("onCheck", this);
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.northPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)north, "38px");
        this.northPanel.appendChild((Component)this.progressbar);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.progressbar, "100%");
        this.progressbar.setZclass("progressmeter-setupwizard");
        this.northPanel.appendChild((Component)this.progressLabel);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.progressLabel, "100%");
        this.progressLabel.setStyle("margin:0; padding:0; position: absolute; align: center; valign: center; border:0; text-align: center; ");
        this.refreshProgress();
        this.statusLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"WizardStatus"));
        MLookup wizardL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)200310, (int)17, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"WizardStatus", (int)200003, (boolean)false, (String)"AD_Ref_List.Value IN ('D','S','I','F','P')");
        this.statusField = new WTableDirEditor("WizardStatus", true, false, true, (Lookup)wizardL);
        this.statusField.setValue("P");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerBox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerBox, "1");
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.centerBox);
        this.centerBox.appendChild((Component)this.wfnodeTree);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.centerBox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.wfnodeTree, "1");
        this.centerBox.appendChild((Component)this.centerBoxdown);
        this.centerBoxdown.setOrient("horizontal");
        this.centerBoxdown.setAlign("center");
        this.centerBoxdown.setPack("start");
        this.centerBoxdown.appendChild((Component)this.bExpand);
        this.centerBoxdown.appendChild((Component)this.justmine);
        this.centerBoxdown.appendChild((Component)this.showColors);
        center.setAutoscroll(true);
        Div div = new Div();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "88%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
        div.setStyle("text-align:center ");
        this.pretitleLabel.setStyle("font-weight: bold; font-size: 14px");
        div.appendChild((Component)this.titleLabel);
        this.titleLabel.setStyle("font-weight: bold; font-size: 14px");
        this.titleLabel.setLeft("50%");
        div.appendChild((Component)this.helpFrame);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.helpFrame, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.helpFrame, "80%");
        this.helpFrame.setStyle("border: 1px solid lightgray; margin:auto");
        Div divNote = new Div();
        divNote.setStyle("text-align:left");
        Separator separator = new Separator();
        divNote.appendChild((Component)separator);
        divNote.appendChild((Component)this.notesLabel);
        divNote.appendChild((Component)this.notesField);
        this.notesField.setRows(4);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.notesField, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.notesField, "99%");
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)200913, (int)30);
        this.userField = new WSearchEditor((Lookup)lookup, Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"), "", false, false, true);
        this.westdown.setOrient("horizontal");
        this.westdown.setAlign("center");
        this.westdown.setPack("center");
        this.westdown.appendChild((Component)this.bZoomLabel);
        this.westdown.appendChild((Component)this.bZoom);
        this.westdown.appendChild((Component)this.userLabel);
        this.westdown.appendChild((Component)this.userField.getComponent());
        this.westdown.appendChild((Component)new Space());
        this.westdown.appendChild((Component)this.statusLabel);
        this.westdown.appendChild((Component)this.statusField.getComponent());
        this.westdown.appendChild((Component)new Space());
        this.westdown.appendChild((Component)this.bRefresh);
        this.westdown.appendChild((Component)this.bOK);
        this.westdown.appendChild((Component)this.bNext);
        Div divButton = new Div();
        divButton.setStyle("display: inline-block; float: right;");
        divButton.appendChild((Component)this.westdown);
        East east = new East();
        this.mainLayout.appendChild((Component)east);
        div.appendChild((Component)divNote);
        div.appendChild((Component)divButton);
        east.appendChild((Component)div);
        east.setCollapsible(true);
        east.setSplittable(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)east, "70%");
        east.setAutoscroll(true);
        this.setNotesPanelVisible(false);
        if (this.firstOpenNode == null) {
            this.firstOpenWF = this.firstWF;
            this.firstOpenNode = this.firstWF;
        }
        if (this.firstOpenWF != null) {
            this.firstOpenWF.setOpen(true);
        }
        if (this.firstOpenNode != null) {
            this.wfnodeTree.setSelectedItem(this.firstOpenNode);
            this.showItem(this.firstOpenNode);
        }
    }

    private void refreshProgress() {
        int percent = this.cntSolved * 100;
        percent = this.cntNodes > 0 ? (percent /= this.cntNodes) : 0;
        Object[] args = new Object[]{this.cntSolved, this.cntNodes, percent};
        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"SetupWizardProgress", (Object[])args);
        this.progressLabel.setText(msg);
        this.progressbar.setValue(percent);
        this.progressbar.setTooltiptext(msg);
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.wfnodeTree) {
            this.onTreeSelection(e);
        } else if (e.getTarget() == this.bRefresh) {
            this.repaintTree();
        } else if (e.getTarget() == this.bOK) {
            int userid = 0;
            this.allFinished = true;
            this.allPending = true;
            if (!this.userField.isNullOrEmpty()) {
                userid = (Integer)this.userField.getValue();
            }
            if (this.save(this.notesField.getText(), (String)this.statusField.getValue(), userid)) {
                this.repaintTree();
            }
        } else if (e.getTarget() == this.bNext) {
            this.navigateToNext();
        } else if (e.getTarget() == this.bZoom) {
            this.zoom();
        } else if (e.getTarget() == this.bExpand) {
            this.expandTree();
        } else if (e.getTarget() == this.justmine) {
            this.justMine();
        } else if (e.getTarget() == this.showColors) {
            this.showColors();
        }
    }

    private void showColors() {
        if (this.showColors.isChecked()) {
            this.allFinished = true;
            this.allPending = true;
        }
        this.repaintTree();
    }

    private void justMine() {
        if (this.justmine.isChecked()) {
            this.showChildren(false);
        } else {
            this.showChildren(true);
        }
    }

    private void showChildren(boolean showmine) {
        int user = Env.getAD_User_ID((Properties)Env.getCtx());
        for (Treeitem nextItem : this.nextItems) {
            MWizardProcess wp;
            Treeitem ti = nextItem;
            if (ti.getLevel() == 0 || (wp = MWizardProcess.get((Properties)Env.getCtx(), (int)((Integer)ti.getAttribute("AD_WF_Node_ID")), (int)Env.getAD_Client_ID((Properties)Env.getCtx()))).getAD_User_ID() == user) continue;
            ti.setVisible(showmine);
        }
    }

    private void expandTree() {
        if (!this.expandTree) {
            TreeUtils.expandAll(this.wfnodeTree);
            this.expandTree = true;
        } else {
            TreeUtils.collapseAll(this.wfnodeTree);
            this.expandTree = false;
        }
    }

    private void zoom() {
        if (this.m_node != null) {
            if ("W".equals(this.m_node.getAction())) {
                AEnv.zoom(this.m_node.getAD_Window_ID(), null);
            } else if ("X".equals(this.m_node.getAction())) {
                int AD_Form_ID = this.m_node.getAD_Form_ID();
                ADForm form = ADForm.openForm(AD_Form_ID);
                form.setAttribute("mode", form.getWindowMode());
                AEnv.showWindow(form);
            } else if ("I".equals(this.m_node.getAction())) {
                SessionManager.getAppDesktop().openInfo(this.m_node.getAD_InfoWindow_ID());
            }
        }
    }

    private void repaintTree() {
        this.openNodes.removeAll(this.openNodes);
        for (Treeitem nextItem : this.nextItems) {
            if (!nextItem.isOpen() || nextItem.getAttribute("AD_Workflow_ID") == null) continue;
            this.openNodes.add((Integer)nextItem.getAttribute("AD_Workflow_ID"));
        }
        this.prevti = this.wfnodeTree.getSelectedItem();
        this.wfnodeTree.clear();
        this.loadWizardNodes();
        this.refreshProgress();
    }

    private void navigateToNext() {
        Treeitem ti;
        boolean repaint = false;
        if (this.m_node != null) {
            int userid = 0;
            if (!this.userField.isNullOrEmpty()) {
                userid = (Integer)this.userField.getValue();
            }
            repaint = this.save(this.notesField.getText(), (String)this.statusField.getValue(), userid);
        }
        if ((ti = this.wfnodeTree.getSelectedItem()) == null || this.nextItems.indexOf(ti) + 1 == this.nextItems.size()) {
            ti = this.nextItems.get(0);
            this.wfnodeTree.setSelectedItem(ti);
            this.showItem(ti);
        } else {
            int idx = this.nextItems.indexOf(ti);
            Treeitem nextti = this.nextItems.get(idx + 1);
            this.wfnodeTree.setSelectedItem(nextti);
            this.showItem(nextti);
        }
        if (repaint) {
            this.repaintTree();
        }
    }

    private void onTreeSelection(Event e) {
        Treeitem ti = this.wfnodeTree.getSelectedItem();
        this.showItem(ti);
    }

    private void showItem(Treeitem ti) {
        if (ti == null) {
            return;
        }
        if (ti.getAttribute("AD_Workflow_ID") != null) {
            ti.setOpen(true);
            int wfid = (Integer)ti.getAttribute("AD_Workflow_ID");
            this.showInRightPanel(wfid, 0);
            SessionManager.getAppDesktop().updateHelpContext("W", wfid);
        } else if (ti.getAttribute("AD_WF_Node_ID") != null) {
            ((Treeitem)ti.getParent().getParent()).setOpen(true);
            int nodeid = (Integer)ti.getAttribute("AD_WF_Node_ID");
            this.showInRightPanel(0, nodeid);
            SessionManager.getAppDesktop().updateHelpContext("N", nodeid);
        }
    }

    private void showInRightPanel(int ad_workflow_id, int ad_wf_node_id) {
        String title = null;
        String help = null;
        if (ad_wf_node_id > 0) {
            MWFNode node = MWFNode.get((Properties)Env.getCtx(), (int)ad_wf_node_id);
            title = node.getName(true);
            help = node.getHelp(true);
            this.m_node = node;
            MWizardProcess wp = MWizardProcess.get((Properties)Env.getCtx(), (int)ad_wf_node_id, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.notesField.setText(wp.getNote());
            this.statusField.setValue(wp.getWizardStatus());
            this.userField.setValue(wp.getAD_User_ID() > 0 ? Integer.valueOf(wp.getAD_User_ID()) : null);
            this.setNotesPanelVisible(true);
        } else {
            MWorkflow wf = MWorkflow.get((Properties)Env.getCtx(), (int)ad_workflow_id);
            title = wf.getName(true);
            help = wf.getHelp(true);
            this.setNotesPanelVisible(false);
            this.m_node = null;
        }
        this.titleLabel.setText(String.valueOf(this.pretitleLabel.getValue()) + title);
        if (help != null) {
            AMedia media = new AMedia("Help", "html", "text/html", help.getBytes());
            this.helpFrame.setContent((Media)media);
            this.helpFrame.invalidate();
        } else {
            this.helpFrame.setContent(null);
        }
        this.helpFrame.invalidate();
    }

    private void setNotesPanelVisible(boolean visible) {
        this.notesLabel.setVisible(visible);
        this.notesField.setVisible(visible);
        this.bOK.setVisible(visible);
        this.statusLabel.setVisible(visible);
        this.statusField.setVisible(visible);
        this.userLabel.setVisible(visible);
        this.userField.setVisible(visible);
        this.bZoomLabel.setVisible(visible);
        this.bZoom.setVisible(visible);
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

