/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.GenericPO;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.WRC1DisplayFieldsPanel;
import org.adempiere.webui.panel.WRC2FieldOrderPanel;
import org.adempiere.webui.panel.WRC3SortCriteriaPanel;
import org.adempiere.webui.panel.WRC4GroupingCriteriaPanel;
import org.adempiere.webui.panel.WRC5SummaryFieldsPanel;
import org.adempiere.webui.panel.WRCTabPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Auxheader;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Foot;
import org.zkoss.zul.Footer;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Vbox;

public class WReportCustomization
implements IFormController,
EventListener<Event> {
    private CustomForm form = new CustomForm();
    private int m_WindowNo = -1;
    int curStep = 0;
    private Properties m_ctx;
    private boolean m_isCanExport;
    private ReportEngine m_reportEngine = null;
    public ArrayList<MPrintFormatItem> pfi;
    private Auxheader headerPanel = new Auxheader();
    private WStringEditor name = new WStringEditor();
    private String tempName = "";
    private Button newPrintFormat;
    private Label selectAll;
    private Label deselectAll;
    private Label pipeSeparator;
    private Button bExport = new Button();
    private Button bnext;
    private Button btnSave;
    private Tabbox tabbox = new Tabbox();
    private Tabs tabs = new Tabs();
    private Tabpanels tabpanels = new Tabpanels();
    private Window winExportFile = null;
    private Listbox cboType = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelMain = new ConfirmPanel(true);
    public boolean isChange = false;
    public ZkReportViewer viewer;
    MPrintFormat fm;
    Tab tabdf1 = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplayFields"));
    Tab tabfo2 = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"FieldOrder"));
    Tab tabsc3 = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"SortCriteria"));
    Tab tabgc4 = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"GroupingCriteria"));
    Tab tabsf5 = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"SummaryFields"));
    WRC1DisplayFieldsPanel tpdf1 = new WRC1DisplayFieldsPanel();
    WRC2FieldOrderPanel tpfo2 = new WRC2FieldOrderPanel();
    WRC3SortCriteriaPanel tpsc3 = new WRC3SortCriteriaPanel();
    WRC4GroupingCriteriaPanel tpgc4 = new WRC4GroupingCriteriaPanel();
    WRC5SummaryFieldsPanel tpsf5 = new WRC5SummaryFieldsPanel();
    private int oldtabidx = 0;
    private static CLogger log = CLogger.getCLogger(WReportCustomization.class);

    public WReportCustomization() {
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
    }

    public void setReportEngine(ReportEngine re) {
        this.m_reportEngine = re;
        this.m_isCanExport = MRole.getDefault().isCanExport();
        this.pfi = new ArrayList();
        MPrintFormatItem[] mPrintFormatItemArray = this.m_reportEngine.getPrintFormat().getAllItems("IsPrinted DESC, NULLIF(SeqNo,0), Name");
        int n = mPrintFormatItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPrintFormatItem item = mPrintFormatItemArray[n2];
            this.pfi.add(item);
            ++n2;
        }
        try {
            this.m_ctx = this.m_reportEngine.getCtx();
            this.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            FDialog.error(this.m_WindowNo, "LoadError", e.getLocalizedMessage());
        }
    }

    private void init() {
        this.form.setStyle("width: 90%; height: 90%; position: absolute; border:none; padding:none; margin:none;");
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        this.fm = this.m_reportEngine.getPrintFormat();
        this.name.setValue(this.fm.getName());
        if (Env.isMultiLingualDocument((Properties)this.m_ctx)) {
            this.name.setValue(this.fm.get_Translation("Name"));
        } else {
            this.name.setValue(this.fm.getName());
        }
        this.headerPanel.appendChild((Component)this.name.getComponent());
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        this.name.getComponent().addEventListener("onFocus", (EventListener)this);
        this.name.getComponent().addEventListener("onBlur", (EventListener)this);
        this.name.getComponent().addEventListener("onOK", (EventListener)this);
        this.newPrintFormat = new Button();
        this.newPrintFormat.setName("NewPrintFormat");
        this.newPrintFormat.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CreatePrintFormat"));
        this.newPrintFormat.addActionListener(this);
        this.headerPanel.appendChild((Component)this.newPrintFormat);
        Separator tor = new Separator("vertical");
        tor.setSpacing("23%");
        this.headerPanel.appendChild((Component)tor);
        this.selectAll = new Label(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"SelectAll")));
        this.selectAll.setStyle("cursor:pointer;text-decoration: underline;");
        this.deselectAll = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"DeSelectAll"));
        this.deselectAll.setStyle("cursor:pointer;text-decoration: underline;");
        this.pipeSeparator = new Label("|");
        this.selectAll.setAttribute("name", "SelectAll");
        this.deselectAll.setAttribute("name", "DeselectAll");
        this.selectAll.addEventListener("onClick", this);
        this.deselectAll.addEventListener("onClick", this);
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        this.headerPanel.appendChild((Component)this.selectAll);
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        this.headerPanel.appendChild((Component)this.pipeSeparator);
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        this.headerPanel.appendChild((Component)this.deselectAll);
        this.headerPanel.appendChild((Component)new Separator("vertical"));
        Auxhead head = new Auxhead();
        head.appendChild((Component)this.headerPanel);
        this.form.appendChild((Component)head);
        this.headerPanel.appendChild((Component)new Separator("horizontal"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabbox, "84%");
        this.tabfo2.addEventListener("onClick", this);
        this.tabsc3.addEventListener("onClick", this);
        this.tabgc4.addEventListener("onClick", this);
        this.tabsf5.addEventListener("onClick", this);
        this.tabs.appendChild((Component)this.tabdf1);
        this.tabs.appendChild((Component)this.tabfo2);
        this.tabs.appendChild((Component)this.tabsc3);
        this.tabs.appendChild((Component)this.tabgc4);
        this.tabs.appendChild((Component)this.tabsf5);
        this.tpdf1.setMPrintFormat(this.fm);
        this.tpdf1.setPrintFormatItems(this.pfi);
        this.tpdf1.setWReportCustomization(this);
        this.tpdf1.init();
        this.tabpanels.appendChild((Component)this.tpdf1);
        this.tpfo2.setMPrintFormat(this.fm);
        this.tpfo2.setPrintFormatItems(this.pfi);
        this.tpfo2.setListColumns();
        this.tpfo2.init();
        this.tpfo2.refresh();
        this.tpfo2.setWReportCustomization(this);
        this.tabpanels.appendChild((Component)this.tpfo2);
        this.tpsc3.setMPrintFormat(this.fm);
        this.tpsc3.setPrintFormatItems(this.pfi);
        this.tpsc3.setListsColumns();
        this.tpsc3.init();
        this.tpsc3.refresh();
        this.tpsc3.setWReportCustomization(this);
        this.tabpanels.appendChild((Component)this.tpsc3);
        this.tpgc4.setMPrintFormat(this.fm);
        this.tpgc4.setPrintFormatItems(this.pfi);
        this.tpgc4.init();
        this.tpgc4.refresh();
        this.tpgc4.setWReportCustomization(this);
        this.tabpanels.appendChild((Component)this.tpgc4);
        this.tpsf5.setMPrintFormat(this.fm);
        this.tpsf5.setPrintFormatItems(this.pfi);
        this.tpsf5.init();
        this.tpsf5.refresh();
        this.tpsf5.setWReportCustomization(this);
        this.tabpanels.appendChild((Component)this.tpsf5);
        this.tabbox.appendChild((Component)this.tabs);
        this.tabbox.appendChild((Component)this.tabpanels);
        this.tabbox.addEventListener("onSelect", this);
        this.form.appendChild((Component)this.tabbox);
        Footer foot = new Footer();
        Foot f = new Foot();
        Grid grid = new Grid();
        this.btnSave = new Button();
        this.btnSave.setName("btnSave");
        this.btnSave.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Save")));
        this.btnSave.setImage(ThemeManager.getThemeResource("images/Save24.png"));
        if (this.fm.getAD_Client_ID() == 0 || !this.isChange) {
            this.btnSave.setDisabled(true);
        }
        foot.setSclass("report-wizard-footer");
        this.confirmPanelMain.addComponentsLeft(this.btnSave);
        if (this.m_isCanExport) {
            this.bExport.setImage(ThemeManager.getThemeResource("images/Export24.png"));
            this.bExport.setName("btnExport");
            this.bExport.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Export")));
            this.confirmPanelMain.addComponentsLeft(this.bExport);
        }
        this.bnext = new Button();
        this.bnext.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"NextPage"));
        this.bnext.setName("Next");
        this.confirmPanelMain.addComponentsLeft(this.bnext);
        foot.appendChild((Component)this.confirmPanelMain);
        this.confirmPanelMain.addActionListener(this);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanelMain, "0");
        f.appendChild((Component)foot);
        grid.appendChild((Component)f);
        this.form.appendChild((Component)grid);
        this.form.setBorder("normal");
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            if (event.getTarget() instanceof Label) {
                if (this.tabbox.getSelectedIndex() == 0) {
                    Label lb = (Label)event.getTarget();
                    if ("SelectAll".equals(lb.getAttribute("name").toString())) {
                        this.tpdf1.updatePrinted(true);
                    } else if ("DeselectAll".equals(lb.getAttribute("name").toString())) {
                        this.tpdf1.updatePrinted(false);
                    }
                }
            } else if (event.getTarget() instanceof Button) {
                Button bt = (Button)event.getTarget();
                if ("Next".equals(bt.getName())) {
                    ((WRCTabPanel)this.tabbox.getTabpanel(this.oldtabidx)).updatePFI();
                    ++this.oldtabidx;
                    if (this.oldtabidx > 4) {
                        this.oldtabidx = 0;
                    }
                    ((WRCTabPanel)this.tabbox.getTabpanel(this.oldtabidx)).refresh();
                    this.tabbox.setSelectedIndex(this.oldtabidx);
                } else if ("btnSave".equals(bt.getName())) {
                    ((WRCTabPanel)this.tabbox.getSelectedTabpanel()).updatePFI();
                    this.onSave();
                } else if ("btnExport".equals(bt.getName())) {
                    ((WRCTabPanel)this.tabbox.getSelectedTabpanel()).updatePFI();
                    this.cmd_export();
                } else if ("NewPrintFormat".equals(bt.getName())) {
                    this.copyFormat();
                }
            }
        } else if ("onSelect".equals(event.getName())) {
            ((WRCTabPanel)this.tabbox.getTabpanel(this.oldtabidx)).updatePFI();
            int tabidx = this.tabbox.getSelectedIndex();
            ((WRCTabPanel)this.tabbox.getTabpanel(tabidx)).refresh();
            this.oldtabidx = tabidx;
        }
        if (event.getTarget().getId().equals("Cancel")) {
            this.close();
        } else if (event.getTarget().getId().equals("Ok")) {
            ((WRCTabPanel)this.tabbox.getSelectedTabpanel()).updatePFI();
            this.onSave();
            this.close();
        }
        if (event.getTarget() == this.name.getComponent()) {
            if (event.getName().equals("onFocus")) {
                this.tempName = (String)this.name.getValue();
            } else if ((event.getName().equals("onBlur") || event.getName().equals("onOK")) && !this.tempName.equals(this.name.getValue())) {
                this.setIsChanged(true);
            }
        }
        this.selectAll.setVisible(this.oldtabidx == 0);
        this.deselectAll.setVisible(this.oldtabidx == 0);
        this.pipeSeparator.setVisible(this.oldtabidx == 0);
    }

    private void onSave() {
        if (this.name.getValue() == null || Util.isEmpty((String)((String)this.name.getValue()))) {
            throw new WrongValueException((Component)this.name.getComponent(), Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory"));
        }
        if (Env.isMultiLingualDocument((Properties)this.m_ctx)) {
            if (Env.isBaseLanguage((Properties)this.m_ctx, (String)"AD_PrintFormat")) {
                if (!this.fm.getName().equals(this.name.getValue())) {
                    this.fm.setName((String)this.name.getValue());
                    this.fm.saveEx();
                    this.tempName = (String)this.name.getValue();
                }
            } else if (!this.fm.get_Translation("Name").equals(this.name.getValue())) {
                this.updateTrl();
                this.tempName = (String)this.name.getValue();
            }
        } else if (!this.fm.getName().equals(this.name.getValue())) {
            this.fm.setName((String)this.name.getValue());
            this.fm.saveEx();
            this.updateTrl();
            this.tempName = (String)this.name.getValue();
        }
        for (MPrintFormatItem item : this.pfi) {
            if (!item.is_Changed()) continue;
            item.saveEx();
        }
        this.setIsChanged(false);
    }

    private void updateTrl() {
        List list = new Query(this.m_ctx, "AD_PrintFormat_Trl", "AD_PrintFormat_ID = ?", null).setParameters(new Object[]{this.fm.getAD_PrintFormat_ID()}).list();
        for (GenericPO trl : list) {
            trl.set_ValueOfColumn("Name", (Object)((String)this.name.getValue()));
            trl.saveEx();
            this.fm.get_Translation("Name", trl.get_ValueAsString("AD_Language"), true);
        }
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    private void cmd_export() {
        log.config("");
        if (!this.m_isCanExport) {
            FDialog.error(this.m_WindowNo, "AccessCannotExport", "Export");
            return;
        }
        if (this.winExportFile == null) {
            this.winExportFile = new Window();
            this.winExportFile.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Export"));
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winExportFile, 450);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this.winExportFile, 300);
            this.winExportFile.setClosable(true);
            this.winExportFile.setBorder("normal");
            this.winExportFile.setStyle("position:absolute");
            this.cboType.setMold("select");
            this.cboType.getItems().clear();
            this.cboType.appendItem("ps - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS"), "ps");
            this.cboType.appendItem("xml - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML"), "xml");
            ListItem li = this.cboType.appendItem("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf");
            this.cboType.appendItem("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html");
            this.cboType.appendItem("txt - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileTXT"), "txt");
            this.cboType.appendItem("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv");
            this.cboType.appendItem("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv");
            this.cboType.appendItem("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls");
            this.cboType.setSelectedItem(li);
            Hbox hb = new Hbox();
            Div div = new Div();
            div.setStyle("text-align: right;");
            div.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"FilesOfType")));
            hb.appendChild((Component)div);
            hb.appendChild((Component)this.cboType);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.cboType, "100%");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)hb, "1");
            hb.setStyle("margin-top: 10px");
            Vbox vb = new Vbox();
            ZKUpdateUtil.setVflex((HtmlBasedComponent)vb, "1");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
            this.winExportFile.appendChild((Component)vb);
            vb.appendChild((Component)hb);
            vb.appendChild((Component)this.confirmPanel);
            EventListener<Event> exportListener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (event.getTarget().getId().equals("Cancel")) {
                        WReportCustomization.this.winExportFile.onClose();
                    } else if (event.getTarget().getId().equals("Ok")) {
                        WReportCustomization.this.exportFile();
                    }
                }
            };
            this.confirmPanel.addActionListener(exportListener);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.confirmPanel, "0");
        }
        this.winExportFile.setAttribute("mode", "highlighted");
        AEnv.showWindow(this.winExportFile);
    }

    private void exportFile() {
        try {
            StringWriter sw;
            ListItem li = this.cboType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                FDialog.error(this.m_WindowNo, (Component)this.winExportFile, "FileInvalidExtension");
                return;
            }
            String ext = li.getValue().toString();
            byte[] data = null;
            File inputFile = null;
            if (ext.equals("pdf")) {
                data = this.m_reportEngine.createPDFData();
            } else if (ext.equals("ps")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.m_reportEngine.createPS((OutputStream)baos);
                data = baos.toByteArray();
            } else if (ext.equals("xml")) {
                sw = new StringWriter();
                this.m_reportEngine.createXML((Writer)sw);
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("csv")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, ',', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("ssv")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, ';', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("txt")) {
                sw = new StringWriter();
                this.m_reportEngine.createCSV((Writer)sw, '\t', this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("html") || ext.equals("htm")) {
                sw = new StringWriter();
                this.m_reportEngine.createHTML((Writer)sw, false, this.m_reportEngine.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("xls")) {
                inputFile = File.createTempFile("Export", ".xls");
                this.m_reportEngine.createXLS(inputFile, this.m_reportEngine.getPrintFormat().getLanguage());
            } else {
                FDialog.error(this.m_WindowNo, (Component)this.winExportFile, "FileInvalidExtension");
                return;
            }
            this.winExportFile.onClose();
            AMedia media = null;
            media = data != null ? new AMedia(String.valueOf(this.m_reportEngine.getPrintFormat().getName()) + "." + ext, null, "application/octet-stream", data) : new AMedia(String.valueOf(this.m_reportEngine.getPrintFormat().getName()) + "." + ext, null, "application/octet-stream", inputFile, true);
            Filedownload.save((Media)media, (String)(String.valueOf(this.m_reportEngine.getPrintFormat().getName()) + "." + ext));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }

    public void close() {
        this.form.detach();
    }

    public void copyFormat() {
        this.pfi.clear();
        MPrintFormat newpf = MPrintFormat.copyToClient((Properties)this.m_ctx, (int)this.m_reportEngine.getPrintFormat().get_ID(), (int)Env.getAD_Client_ID((Properties)this.m_ctx));
        MPrintFormatItem[] mPrintFormatItemArray = newpf.getAllItems("IsPrinted DESC, NULLIF(SeqNo,0), Name");
        int n = mPrintFormatItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPrintFormatItem item = mPrintFormatItemArray[n2];
            this.pfi.add(item);
            ++n2;
        }
        this.tpdf1.setMPrintFormat(newpf);
        this.tpdf1.setPrintFormatItems(this.pfi);
        this.tpdf1.refresh();
        this.tpfo2.setMPrintFormat(newpf);
        this.tpfo2.setPrintFormatItems(this.pfi);
        this.tpfo2.setListColumns();
        this.tpfo2.refresh();
        this.tpsc3.setMPrintFormat(newpf);
        this.tpsc3.setPrintFormatItems(this.pfi);
        this.tpfo2.setListColumns();
        this.tpsc3.refresh();
        this.tpgc4.setMPrintFormat(newpf);
        this.tpgc4.setPrintFormatItems(this.pfi);
        this.tpsf5.setMPrintFormat(newpf);
        this.tpsf5.setPrintFormatItems(this.pfi);
        this.tpsf5.refresh();
        this.setIsChanged(false);
        this.name.setValue(newpf.getName());
        this.m_reportEngine.setPrintFormat(newpf);
        newpf.saveEx();
        this.fm = newpf;
    }

    public void setIsChanged(boolean change) {
        this.isChange = change;
        this.btnSave.setDisabled(!this.isChange);
        this.bExport.setDisabled(this.isChange);
        this.newPrintFormat.setDisabled(this.isChange);
    }
}

