/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.grid.PaymentForm;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;

public class WPaymentFormWindow
extends Window
implements EventListener<Event>,
DialogEvents {
    private static final long serialVersionUID = 2710316463655831868L;
    private PaymentForm paymentForm;
    private Panel mainPanel = new Panel();
    private Panel centerPanel = new Panel();
    private Borderlayout mainLayout = new Borderlayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private boolean m_isLocked = false;
    private boolean initOK = false;
    private BusyDialog progressWindow;

    public WPaymentFormWindow(PaymentForm paymentForm, int windowNo) {
        this.paymentForm = paymentForm;
        try {
            this.zkInit();
            this.initOK = this.dynInit();
        }
        catch (Exception ex) {
            FDialog.error(windowNo, (Component)this, ex.getMessage() == null ? ex.toString() : ex.getMessage());
            this.initOK = false;
        }
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Payment"));
        this.setSclass("popup-dialog payment-form-dialog");
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        }
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
    }

    private void zkInit() throws Exception {
        this.appendChild((Component)this.mainPanel);
        this.mainPanel.appendChild((Component)this.mainLayout);
        Center center = new Center();
        center.setSclass("dialog-content");
        this.mainLayout.appendChild((Component)center);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainLayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.mainLayout, "min");
        this.centerPanel = this.getPanel();
        center.appendChild((Component)this.centerPanel);
        LayoutUtils.addSclass("payment-form-content", (HtmlBasedComponent)this.centerPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "1");
        center.setAutoscroll(true);
        South south = new South();
        south.setSclass("dialog-footer");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
    }

    private boolean dynInit() throws Exception {
        boolean isInitOK = this.paymentForm.dynInit();
        this.centerPanel.setVisible(!this.paymentForm.isOnlyRule());
        return isInitOK;
    }

    public Panel getPanel() {
        return this.centerPanel;
    }

    public void onEvent(Event e) {
        if (e.getTarget().getId().equals("Ok")) {
            if (this.paymentForm.checkMandatory()) {
                this.paymentForm.saveChanges();
                this.dispose();
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.dispose();
        }
    }

    public void runProcessOnline() {
        try {
            this.paymentForm.processOnline();
        }
        finally {
            this.unlockUI();
        }
    }

    public void unlockUI() {
        if (!this.m_isLocked) {
            return;
        }
        this.m_isLocked = false;
        this.hideBusyDialog();
        this.updateUI();
    }

    public void lockUI() {
        if (this.m_isLocked) {
            return;
        }
        this.m_isLocked = true;
        this.showBusyDialog();
    }

    private void hideBusyDialog() {
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
    }

    private void updateUI() {
        if (this.paymentForm.isApproved()) {
            this.dispose();
        }
    }

    private void showBusyDialog() {
        this.progressWindow = new BusyDialog();
        this.progressWindow.setPage(this.getPage());
        this.progressWindow.doHighlighted();
    }

    public boolean isInitOK() {
        return this.initOK;
    }
}

