/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormOnCredit;
import org.compiere.model.GridTab;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;

public class WPaymentFormOnCredit
extends PaymentFormOnCredit {
    private WPaymentFormWindow window;
    private Label pTermLabel = new Label();
    private Listbox pTermCombo = ListboxFactory.newDropdownListbox();

    public WPaymentFormOnCredit(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.window = new WPaymentFormWindow((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        Grid pPanelLayout = GridFactory.newGridLayout();
        this.window.getPanel().appendChild((Component)pPanelLayout);
        this.pTermLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_PaymentTerm_ID"));
        this.window.getPanel().setId("pPanel");
        Columns columns = new Columns();
        pPanelLayout.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        Rows rows = pPanelLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.pTermLabel.rightAlign());
        row.appendChild((Component)this.pTermCombo);
    }

    public void loadData() {
        super.loadData();
        ArrayList list = this.getPaymentTermList();
        for (KeyNamePair pp : list) {
            this.pTermCombo.addItem(pp);
        }
        if (this.selectedPaymentTerm != null) {
            this.pTermCombo.setSelectedKeyNamePair(this.selectedPaymentTerm);
        }
    }

    public boolean checkMandatory() {
        return true;
    }

    public boolean saveChangesInTrx(String trxName) {
        KeyNamePair kp;
        int newC_PaymentTerm_ID = 0;
        ListItem selected = this.pTermCombo.getSelectedItem();
        KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
        if (kp != null) {
            newC_PaymentTerm_ID = kp.getKey();
        }
        return this.save(newC_PaymentTerm_ID);
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

