/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormDirect;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Space;

public abstract class WPaymentFormDirect
extends PaymentFormDirect
implements EventListener<Event> {
    private WPaymentFormWindow window;
    private Label tAccountLabel = new Label();
    private Listbox tAccountCombo = ListboxFactory.newDropdownListbox();
    private Button tOnline = new Button();
    private Textbox tRoutingField = new Textbox();
    private Textbox tNumberField = new Textbox();
    private Label tStatus = new Label();
    private Label tRoutingText = new Label();
    private Label tNumberText = new Label();

    public WPaymentFormDirect(int windowNo, GridTab mTab, boolean isDebit) {
        super(windowNo, mTab, isDebit);
        this.window = new WPaymentFormWindow((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        Grid tPanelLayout = GridFactory.newGridLayout();
        this.window.getPanel().appendChild((Component)tPanelLayout);
        this.tAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BP_BankAccount_ID"));
        this.tRoutingField.setCols(8);
        this.tNumberField.setCols(10);
        this.tRoutingText.setText(Msg.translate((Properties)Env.getCtx(), (String)"RoutingNo"));
        this.tNumberText.setText(Msg.translate((Properties)Env.getCtx(), (String)"AccountNo"));
        this.tOnline.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.tOnline);
        this.tOnline.addActionListener(this);
        this.window.getPanel().setId("tPanel");
        Columns columns = new Columns();
        tPanelLayout.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        Rows rows = tPanelLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.tAccountLabel.rightAlign());
        row.appendChild((Component)this.tAccountCombo);
        row = rows.newRow();
        row.appendChild(this.tRoutingText.rightAlign());
        row.appendChild((Component)this.tRoutingField);
        row = rows.newRow();
        row.appendChild(this.tNumberText.rightAlign());
        row.appendChild((Component)this.tNumberField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.tOnline);
        row = rows.newRow();
        row.appendCellChild((Component)this.tStatus, 2);
    }

    public void loadData() {
        if (this.m_C_Payment_ID != 0) {
            this.tRoutingField.setText(this.m_mPayment.getRoutingNo());
            this.tNumberField.setText(this.m_mPayment.getAccountNo());
            this.tStatus.setText(this.m_mPayment.getR_PnRef());
        }
        ArrayList list = this.getBPBankAccountList();
        for (KeyNamePair pp : list) {
            this.tAccountCombo.addItem(pp);
        }
        boolean exist = this.isBankAccountProcessorExist();
        this.tOnline.setVisible(exist);
        MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor();
        this.setBankAccountProcessor(bankAccountProcessor);
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.tOnline) {
            this.window.lockUI();
            Clients.response((AuResponse)new AuEcho((Component)this.window, "runProcessOnline", null));
        }
    }

    public boolean checkMandatory() {
        KeyNamePair bpba;
        boolean dataOK = true;
        ListItem selected = this.tAccountCombo.getSelectedItem();
        KeyNamePair keyNamePair = bpba = selected != null ? selected.toKeyNamePair() : null;
        if (bpba == null) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentBPBankNotFound");
            dataOK = false;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + dataOK);
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok = this.save(0, this.tRoutingField.getText(), this.tNumberField.getText(), trxName);
        if (!ok) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            FDialog.info(this.getWindowNo(), (Component)this.window, "PaymentCreated", this.m_mPayment.getDocumentNo());
        }
        return ok;
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

