/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.util.PaymentUtil;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCreditCard;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Space;

public class WPaymentFormCreditCard
extends PaymentFormCreditCard
implements EventListener<Event> {
    private WPaymentFormWindow window;
    private Label kTypeLabel = new Label();
    private Listbox kTypeCombo = ListboxFactory.newDropdownListbox();
    private Label kNumberLabel = new Label();
    private Textbox kNumberField = new Textbox();
    private Label kExpLabel = new Label();
    private Textbox kExpField = new Textbox();
    private Label kAmountLabel = new Label();
    private WNumberEditor kAmountField = new WNumberEditor();
    private Label kApprovalLabel = new Label();
    private Textbox kApprovalField = new Textbox();
    private Button kOnline = ButtonFactory.createNamedButton("Online");
    private Label kStatus = new Label();

    public WPaymentFormCreditCard(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.window = new WPaymentFormWindow((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        Grid kLayout = GridFactory.newGridLayout();
        this.window.getPanel().appendChild((Component)kLayout);
        this.kNumberField.setMaxlength(16);
        this.kNumberField.setCols(16);
        this.kExpField.setMaxlength(4);
        this.kExpField.setCols(4);
        this.kApprovalField.setMaxlength(4);
        this.kApprovalField.setCols(4);
        this.kApprovalField.setType("password");
        this.kTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CreditCardType"));
        this.kNumberLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CreditCardNumber"));
        this.kExpLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Expires"));
        this.kApprovalLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"VoiceAuthCode"));
        this.kAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.kOnline.addActionListener(this);
        this.window.getPanel().setId("kPanel");
        Columns columns = new Columns();
        kLayout.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.kAmountField.getComponent(), "150px");
        this.kAmountField.getComponent().setId("K_Ammount");
        Rows rows = kLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.kTypeLabel.rightAlign());
        row.appendChild((Component)this.kTypeCombo);
        this.kTypeCombo.addEventListener("onSelect", this);
        this.kTypeCombo.setId("K_Type");
        row = rows.newRow();
        row.appendChild(this.kNumberLabel.rightAlign());
        row.appendChild((Component)this.kNumberField);
        this.kNumberField.setId("K_CreditCardNumber");
        row = rows.newRow();
        row.appendChild(this.kExpLabel.rightAlign());
        row.appendChild((Component)this.kExpField);
        this.kExpField.setId("K_Expires");
        row = rows.newRow();
        row.appendChild(this.kAmountLabel.rightAlign());
        row.appendChild((Component)this.kAmountField.getComponent());
        this.kAmountField.getComponent().addEventListener("onBlur", this);
        row = rows.newRow();
        row.appendChild(this.kApprovalLabel.rightAlign());
        row.appendChild((Component)this.kApprovalField);
        this.kApprovalField.setId("K_Approval");
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.kOnline);
        this.kOnline.setId("K_Online");
        row = rows.newRow();
        row.appendCellChild((Component)this.kStatus, 2);
        this.kStatus.setId("status");
    }

    public void loadData() {
        super.loadData();
        this.kAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.m_CCType = this.m_mPayment.getCreditCardType();
            this.kNumberField.setText(this.m_mPayment.getCreditCardNumber());
            this.kExpField.setText(this.m_mPayment.getCreditCardExp(null));
            this.kApprovalField.setText(this.m_mPayment.getVoiceAuthCode());
            this.kStatus.setText(this.m_mPayment.getR_PnRef());
            this.kAmountField.setValue(this.m_mPayment.getPayAmt());
            this.kTypeCombo.setEnabled(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kNumberField.setReadonly(this.m_mPayment.isApproved() && this.m_DocStatus.equals("CO"));
            this.kExpField.setReadonly(this.m_mPayment.isApproved() && this.m_DocStatus.equals("CO"));
            this.kApprovalField.setReadonly(this.m_mPayment.isApproved() && this.m_DocStatus.equals("CO"));
            this.kOnline.setEnabled(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
            this.kAmountField.setReadWrite(!this.m_mPayment.isApproved() || !this.m_DocStatus.equals("CO"));
        } else if (this.m_mPaymentTransaction != null) {
            this.m_CCType = this.m_mPaymentTransaction.getCreditCardType();
            this.kNumberField.setText(this.m_mPaymentTransaction.getCreditCardNumber());
            this.kExpField.setText(PaymentUtil.getCreditCardExp((int)this.m_mPaymentTransaction.getCreditCardExpMM(), (int)this.m_mPaymentTransaction.getCreditCardExpYY(), null));
            this.kApprovalField.setText(this.m_mPaymentTransaction.getVoiceAuthCode());
            this.kStatus.setText(this.m_mPaymentTransaction.getR_PnRef());
            this.kAmountField.setValue(this.m_mPaymentTransaction.getPayAmt());
            this.kTypeCombo.setEnabled(!this.m_mPaymentTransaction.isApproved());
            this.kNumberField.setReadonly(this.m_mPaymentTransaction.isApproved());
            this.kExpField.setReadonly(this.m_mPaymentTransaction.isApproved());
            this.kApprovalField.setReadonly(this.m_mPaymentTransaction.isApproved());
            this.kOnline.setEnabled(!this.m_mPaymentTransaction.isApproved());
            this.kAmountField.setReadWrite(!this.m_mPaymentTransaction.isApproved());
        }
        this.kTypeCombo.removeAllItems();
        ValueNamePair[] ccs = this.getCreditCardList();
        int i = 0;
        while (i < ccs.length) {
            this.kTypeCombo.addItem(ccs[i]);
            ++i;
        }
        if (this.selectedCreditCard != null) {
            this.kTypeCombo.setSelectedValueNamePair(this.selectedCreditCard);
        }
        if (this.m_mPayment.isApproved() && this.m_DocStatus.equals("CO")) {
            this.kOnline.setVisible(this.m_mPayment.isOnline());
            this.kOnline.setEnabled(false);
            MBankAccountProcessor bankAccountProcessor = new MBankAccountProcessor(this.m_mPayment.getCtx(), this.m_mPayment.getC_BankAccount_ID(), this.m_mPayment.getC_PaymentProcessor_ID(), null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else if (this.m_mPaymentTransaction != null) {
            this.kOnline.setVisible(this.m_mPaymentTransaction.isOnline());
            this.kOnline.setEnabled(false);
            MBankAccountProcessor bankAccountProcessor = new MBankAccountProcessor(this.m_mPaymentTransaction.getCtx(), this.m_mPaymentTransaction.getC_BankAccount_ID(), this.m_mPaymentTransaction.getC_PaymentProcessor_ID(), null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else {
            boolean exist = this.isBankAccountProcessorExist("", (BigDecimal)this.kAmountField.getValue());
            this.kOnline.setVisible(exist);
            if (exist) {
                this.updateOnlineButton();
            } else {
                this.kApprovalField.setReadonly(false);
            }
        }
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.kOnline) {
            this.window.lockUI();
            Clients.response((AuResponse)new AuEcho((Component)this.window, "runProcessOnline", null));
        } else if (e.getTarget() == this.kTypeCombo || e.getTarget() == this.kAmountField) {
            this.updateOnlineButton();
        }
    }

    private void updateOnlineButton() {
        ValueNamePair vp;
        String CCType = null;
        ListItem selected = this.kTypeCombo.getSelectedItem();
        ValueNamePair valueNamePair = vp = selected != null ? selected.toValueNamePair() : null;
        if (vp != null) {
            CCType = vp.getValue();
        }
        BigDecimal PayAmt = (BigDecimal)this.kAmountField.getValue();
        if (CCType != null && CCType.length() != 0 && PayAmt != null) {
            MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor(CCType, PayAmt);
            this.kOnline.setEnabled(bankAccountProcessor != null);
            this.setBankAccountProcessor(bankAccountProcessor);
            if (bankAccountProcessor != null) {
                this.kApprovalField.setReadonly(!bankAccountProcessor.isRequireVV());
            } else {
                this.kApprovalField.setReadonly(false);
            }
        } else {
            this.kOnline.setEnabled(false);
            this.setBankAccountProcessor(null);
        }
    }

    public boolean checkMandatory() {
        return true;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok;
        ValueNamePair vp;
        String newCCType = this.m_CCType;
        ListItem selected = this.kTypeCombo.getSelectedItem();
        ValueNamePair valueNamePair = vp = selected != null ? selected.toValueNamePair() : null;
        if (vp != null) {
            newCCType = vp.getValue();
        }
        if (!(ok = this.save(newCCType, this.kNumberField.getText(), this.kExpField.getText(), (BigDecimal)this.kAmountField.getValue(), trxName))) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            FDialog.info(this.getWindowNo(), (Component)this.window, "PaymentCreated", this.processMsg);
        }
        return ok;
    }

    public void processOnline() {
        this.log.config("");
        if (!this.checkMandatory()) {
            return;
        }
        ValueNamePair vp = this.kTypeCombo.getSelectedItem().toValueNamePair();
        String CCType = vp.getValue();
        boolean ok = this.processOnline(CCType, this.kNumberField.getText(), this.kApprovalField.getText(), this.kExpField.getText());
        if (!ok) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentNotProcessed", this.processMsg);
        } else {
            this.loadData();
            if (this.processMsg != null) {
                FDialog.info(this.getWindowNo(), (Component)this.window, "PaymentProcessed", this.processMsg);
            }
        }
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

