/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCheck;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPaymentValidate;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Space;

public class WPaymentFormCheck
extends PaymentFormCheck
implements EventListener<Event> {
    private WPaymentFormWindow window;
    private Label sBankAccountLabel = new Label();
    private Listbox sBankAccountCombo = ListboxFactory.newDropdownListbox();
    private Label sCurrencyLabel = new Label();
    private Listbox sCurrencyCombo = ListboxFactory.newDropdownListbox();
    private Space sCurrencySpace = new Space();
    private Label sAmountLabel = new Label();
    private WNumberEditor sAmountField = new WNumberEditor();
    private Label sRoutingLabel = new Label();
    private Textbox sRoutingField = new Textbox();
    private Label sNumberLabel = new Label();
    private Textbox sNumberField = new Textbox();
    private Textbox sCheckField = new Textbox();
    private Label sCheckLabel = new Label();
    private Button sOnline = new Button();
    private Label sStatus = new Label();

    public WPaymentFormCheck(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.window = new WPaymentFormWindow((PaymentForm)this, windowNo);
        this.init();
    }

    public void init() {
        Grid sPanelLayout = GridFactory.newGridLayout();
        this.window.getPanel().appendChild((Component)sPanelLayout);
        this.sBankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.sAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.sRoutingLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"RoutingNo"));
        this.sNumberLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AccountNo"));
        this.sCheckLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"CheckNo"));
        this.sCheckField.setCols(8);
        this.sCurrencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.sNumberField, "100pt");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.sRoutingField, "70pt");
        this.sOnline.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.sOnline);
        this.sOnline.addActionListener(this);
        this.window.getPanel().setId("sPanel");
        Columns columns = new Columns();
        sPanelLayout.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.sAmountField.getComponent(), "150px");
        Rows rows = sPanelLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.sBankAccountLabel.rightAlign());
        row.appendChild((Component)this.sBankAccountCombo);
        row = rows.newRow();
        row.appendChild(this.sCurrencyLabel.rightAlign());
        row.appendChild((Component)this.sCurrencyCombo);
        row = rows.newRow();
        row.appendChild(this.sAmountLabel.rightAlign());
        row.appendChild((Component)this.sAmountField.getComponent());
        this.sAmountField.getComponent().addEventListener("onBlur", this);
        row = rows.newRow();
        row.appendChild(this.sRoutingLabel.rightAlign());
        row.appendChild((Component)this.sRoutingField);
        row = rows.newRow();
        row.appendChild(this.sNumberLabel.rightAlign());
        row.appendChild((Component)this.sNumberField);
        row = rows.newRow();
        row.appendChild(this.sCheckLabel.rightAlign());
        row.appendChild((Component)this.sCheckField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.sOnline);
        row = rows.newRow();
        row.appendCellChild((Component)this.sStatus, 2);
    }

    public void loadData() {
        Integer C_Currency_ID;
        super.loadData();
        this.sAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.sRoutingField.setText(this.m_mPayment.getRoutingNo());
            this.sNumberField.setText(this.m_mPayment.getAccountNo());
            this.sCheckField.setText(this.m_mPayment.getCheckNo());
            this.sStatus.setText(this.m_mPayment.getR_PnRef());
            this.sAmountField.setValue(this.m_mPayment.getPayAmt());
        }
        if (this.s_Currencies.containsKey(C_Currency_ID = Integer.valueOf(this.m_C_Currency_ID))) {
            Enumeration en = this.s_Currencies.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.sCurrencyCombo.addItem((KeyNamePair)this.s_Currencies.get(key));
            }
            this.sCurrencyCombo.addActionListener(this);
            this.sCurrencyCombo.setSelectedKeyNamePair((KeyNamePair)this.s_Currencies.get(C_Currency_ID));
        } else {
            this.sCurrencyLabel.setVisible(false);
            this.sCurrencyCombo.setVisible(false);
            this.sCurrencySpace.setVisible(false);
        }
        ArrayList list = this.getBankAccountList();
        for (KeyNamePair pp : list) {
            this.sBankAccountCombo.addItem(pp);
        }
        if (this.selectedBankAccount != null) {
            this.sBankAccountCombo.setSelectedKeyNamePair(this.selectedBankAccount);
        }
        boolean exist = this.isBankAccountProcessorExist(this.m_C_Currency_ID, (BigDecimal)this.sAmountField.getValue());
        this.sOnline.setVisible(exist);
        if (exist) {
            this.updateOnlineButton();
        }
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.sCurrencyCombo || e.getTarget() == this.sAmountField) {
            int C_Currency_ID = 0;
            KeyNamePair pp = this.sCurrencyCombo.getSelectedItem().toKeyNamePair();
            if (pp != null) {
                C_Currency_ID = pp.getKey();
            }
            if (e.getTarget() == this.sCurrencyCombo) {
                BigDecimal amt = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)this.m_Amount, (int)this.m_C_Currency_ID, (int)C_Currency_ID, (int)this.m_AD_Client_ID, (int)this.m_AD_Org_ID);
                this.sAmountField.setValue(amt);
            }
            this.updateOnlineButton();
        } else if (e.getTarget() == this.sOnline) {
            this.window.lockUI();
            Clients.response((AuResponse)new AuEcho((Component)this.window, "runProcessOnline", null));
        }
    }

    private void updateOnlineButton() {
        int C_Currency_ID = 0;
        KeyNamePair pp = this.sCurrencyCombo.getSelectedItem().toKeyNamePair();
        if (pp != null) {
            C_Currency_ID = pp.getKey();
        }
        BigDecimal PayAmt = (BigDecimal)this.sAmountField.getValue();
        if (C_Currency_ID > 0 && PayAmt != null) {
            MBankAccountProcessor bankAccountProcessor = this.getBankAccountProcessor(C_Currency_ID, PayAmt);
            this.sOnline.setEnabled(bankAccountProcessor != null);
            this.setBankAccountProcessor(bankAccountProcessor);
        } else {
            this.sOnline.setEnabled(false);
            this.setBankAccountProcessor(null);
        }
    }

    public boolean checkMandatory() {
        String error;
        KeyNamePair kp;
        int C_BankAccount_ID = 0;
        boolean dataOK = true;
        ListItem selected = this.sBankAccountCombo.getSelectedItem();
        KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
        if (kp != null) {
            C_BankAccount_ID = kp.getKey();
        }
        if ((error = MPaymentValidate.validateRoutingNo((String)this.sRoutingField.getText())).length() != 0) {
            FDialog.error(this.getWindowNo(), (Component)this.window, error);
            dataOK = false;
        }
        if ((error = MPaymentValidate.validateAccountNo((String)this.sNumberField.getText())).length() != 0) {
            FDialog.error(this.getWindowNo(), (Component)this.window, error);
            dataOK = false;
        }
        if ((error = MPaymentValidate.validateCheckNo((String)this.sCheckField.getText())).length() != 0) {
            FDialog.error(this.getWindowNo(), (Component)this.window, error);
            dataOK = false;
        }
        if (C_BankAccount_ID == 0) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "FillMandatory", this.sBankAccountLabel.getValue());
            dataOK = false;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + dataOK);
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        boolean ok;
        KeyNamePair kp;
        int newC_BankAccount_ID = 0;
        ListItem selected = this.sBankAccountCombo.getSelectedItem();
        KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
        if (kp != null) {
            newC_BankAccount_ID = kp.getKey();
        }
        if (!(ok = this.save(newC_BankAccount_ID, this.sRoutingField.getText(), this.sNumberField.getText(), this.sCheckField.getText(), (BigDecimal)this.sAmountField.getValue(), trxName))) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            FDialog.info(this.getWindowNo(), (Component)this.window, "PaymentCreated", this.m_mPayment.getDocumentNo());
        }
        return ok;
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

