/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.adempiere.webui.apps.form.WPaymentFormWindow;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.grid.PaymentForm;
import org.compiere.grid.PaymentFormCash;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class WPaymentFormCash
extends PaymentFormCash
implements EventListener<Event> {
    private WPaymentFormWindow window;
    private Label bBankAccountLabel = new Label();
    private Listbox bBankAccountCombo = ListboxFactory.newDropdownListbox();
    private Label bCashBookLabel = new Label();
    private Listbox bCashBookCombo = ListboxFactory.newDropdownListbox();
    private Label bCurrencyLabel = new Label();
    private Listbox bCurrencyCombo = ListboxFactory.newDropdownListbox();
    private Label bDateLabel = new Label();
    private WDateEditor bDateField;
    private Label bAmountLabel = new Label();
    private WNumberEditor bAmountField = new WNumberEditor();

    public WPaymentFormCash(int windowNo, GridTab mTab) {
        super(windowNo, mTab);
        this.bDateField = new WDateEditor("DateAcct", false, false, true, "DateAcct");
        this.window = new WPaymentFormWindow((PaymentForm)this, windowNo);
        this.init();
        this.bAmountField.setValue(this.m_Amount);
    }

    public void init() {
        Grid bPanelLayout = GridFactory.newGridLayout();
        this.window.getPanel().appendChild((Component)bPanelLayout);
        this.bCashBookLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_CashBook_ID"));
        this.bCurrencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.bAmountLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Amount"));
        this.bDateLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        this.window.getPanel().setId("bPanel");
        Columns columns = new Columns();
        bPanelLayout.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.bAmountField.getComponent(), "150px");
        Rows rows = bPanelLayout.newRows();
        Row row = rows.newRow();
        if (this.m_Cash_As_Payment) {
            this.bBankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
            row.appendChild(this.bBankAccountLabel.rightAlign());
            row.appendChild((Component)this.bBankAccountCombo);
        } else {
            row.appendChild(this.bCashBookLabel.rightAlign());
            row.appendChild((Component)this.bCashBookCombo);
        }
        row = rows.newRow();
        row.appendChild(this.bCurrencyLabel.rightAlign());
        row.appendChild((Component)this.bCurrencyCombo);
        row = rows.newRow();
        row.appendChild(this.bDateLabel.rightAlign());
        row.appendChild((Component)this.bDateField.getComponent());
        row = rows.newRow();
        row.appendChild(this.bAmountLabel.rightAlign());
        row.appendChild((Component)this.bAmountField.getComponent());
    }

    public void loadData() {
        super.loadData();
        this.bAmountField.setValue(this.m_Amount);
        if (this.m_C_Payment_ID != 0) {
            this.bAmountField.setValue(this.m_mPayment.getPayAmt());
        }
        if (this.m_C_CashLine_ID != 0) {
            this.bAmountField.setValue(this.m_cashLine.getAmount());
        }
        this.bDateField.setValue(this.m_DateAcct);
        Integer C_Currency_ID = this.m_C_Currency_ID;
        if (this.s_Currencies.containsKey(C_Currency_ID)) {
            Enumeration en = this.s_Currencies.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.bCurrencyCombo.addItem((KeyNamePair)this.s_Currencies.get(key));
            }
            this.bCurrencyCombo.addActionListener(this);
            this.bCurrencyCombo.setSelectedKeyNamePair((KeyNamePair)this.s_Currencies.get(C_Currency_ID));
        } else {
            this.bCurrencyLabel.setVisible(false);
            this.bCurrencyCombo.setVisible(false);
        }
        ArrayList list = this.getBankAccountList();
        for (KeyNamePair pp : list) {
            this.bBankAccountCombo.addItem(pp);
        }
        if (this.selectedBankAccount != null) {
            this.bBankAccountCombo.setSelectedKeyNamePair(this.selectedBankAccount);
        }
        list = this.getCashBookList();
        for (KeyNamePair pp : list) {
            this.bCashBookCombo.addItem(pp);
        }
        if (this.selectedCashBook != null) {
            this.bCashBookCombo.setSelectedKeyNamePair(this.selectedCashBook);
        }
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.bCurrencyCombo) {
            KeyNamePair pp = this.bCurrencyCombo.getSelectedItem().toKeyNamePair();
            BigDecimal amt = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)this.m_Amount, (int)this.m_C_Currency_ID, (int)pp.getKey(), (int)this.m_AD_Client_ID, (int)this.m_AD_Org_ID);
            this.bAmountField.setValue(amt);
        }
    }

    public boolean checkMandatory() {
        int C_BankAccount_ID = 0;
        boolean dataOK = true;
        if (this.m_Cash_As_Payment) {
            KeyNamePair kp;
            ListItem selected = this.bBankAccountCombo.getSelectedItem();
            KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
            if (kp != null) {
                C_BankAccount_ID = kp.getKey();
            }
        }
        if (this.m_Cash_As_Payment && C_BankAccount_ID == 0 && C_BankAccount_ID == 0 && this.m_Cash_As_Payment) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "FillMandatory", this.bBankAccountLabel.getValue());
            dataOK = false;
        }
        return dataOK;
    }

    public boolean saveChangesInTrx(String trxName) {
        Timestamp newDateAcct;
        boolean ok;
        KeyNamePair kp;
        ListItem selected;
        int newC_CashBook_ID = this.m_C_CashBook_ID;
        int newC_BankAccount_ID = 0;
        if (this.m_Cash_As_Payment) {
            selected = this.bBankAccountCombo.getSelectedItem();
            KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
            if (kp != null) {
                newC_BankAccount_ID = kp.getKey();
            }
        } else {
            selected = this.bCashBookCombo.getSelectedItem();
            KeyNamePair keyNamePair = kp = selected != null ? selected.toKeyNamePair() : null;
            if (kp != null) {
                newC_CashBook_ID = kp.getKey();
            }
        }
        if (!(ok = this.save(newC_BankAccount_ID, newC_CashBook_ID, newDateAcct = (Timestamp)this.bDateField.getValue(), (BigDecimal)this.bAmountField.getValue(), trxName))) {
            FDialog.error(this.getWindowNo(), (Component)this.window, "PaymentError", this.processMsg);
        } else if (this.processMsg != null) {
            FDialog.info(this.getWindowNo(), (Component)this.window, "PaymentCreated", this.processMsg);
        }
        return ok;
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }
}

