/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.apps.form.WPayPrint;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.form.PaySelect;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;

public class WPaySelect
extends PaySelect
implements IFormController,
EventListener<Event>,
WTableModelListener,
IProcessUI,
ValueChangeListener {
    private CustomForm form = new CustomForm();
    private Panel mainPanel = new Panel();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Label labelBankAccount = new Label();
    private Listbox fieldBankAccount = ListboxFactory.newDropdownListbox();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Label labelBankBalance = new Label();
    private Label labelCurrency = new Label();
    private Label labelBalance = new Label();
    private Checkbox onlyDue = new Checkbox();
    private Label labelBPartner = new Label();
    private Listbox fieldBPartner = ListboxFactory.newDropdownListbox();
    private Label dataStatus = new Label();
    private WListbox miniTable = ListboxFactory.newDataTable();
    private ConfirmPanel commandPanel = new ConfirmPanel(true, false, false, false, false, false, false);
    private Button bCancel = this.commandPanel.getButton("Cancel");
    private Button bGenerate = this.commandPanel.createButton("Process");
    private Button bRefresh = this.commandPanel.createButton("Refresh");
    private Label labelPayDate = new Label();
    private WDateEditor fieldPayDate = new WDateEditor();
    private Label labelPaymentRule = new Label();
    private Listbox fieldPaymentRule = ListboxFactory.newDropdownListbox();
    private Label labelDtype = new Label();
    private Listbox fieldDtype = ListboxFactory.newDropdownListbox();
    private Panel southPanel;
    private ProcessInfo m_pi;
    private boolean m_isLock;

    public WPaySelect() {
        try {
            this.m_WindowNo = this.form.getWindowNo();
            this.zkInit();
            this.dynInit();
            this.loadBankInfo();
            this.southPanel.appendChild((Component)new Separator());
            this.southPanel.appendChild((Component)this.commandPanel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainPanel);
        this.mainPanel.appendChild((Component)this.mainLayout);
        this.mainPanel.setStyle("width: 100%; height: 100%; padding: 0; margin: 0");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "99%");
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.labelBankAccount.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.fieldBankAccount.addActionListener(this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldBankAccount, "1");
        this.labelBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.fieldBPartner.addActionListener(this);
        this.bRefresh.addActionListener(this);
        this.labelPayDate.setText(Msg.translate((Properties)Env.getCtx(), (String)"PayDate"));
        this.labelPaymentRule.setText(Msg.translate((Properties)Env.getCtx(), (String)"PaymentRule"));
        this.fieldPaymentRule.addActionListener(this);
        this.labelDtype.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.fieldDtype.addActionListener(this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDtype, "1");
        this.labelBankBalance.setText(Msg.translate((Properties)Env.getCtx(), (String)"CurrentBalance"));
        this.labelBalance.setText("0");
        this.onlyDue.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"OnlyDue"));
        this.dataStatus.setText(" ");
        this.dataStatus.setPre(true);
        this.onlyDue.addActionListener(this);
        this.fieldPayDate.addValueChangeListener(this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldPayDate.getComponent(), "1");
        this.bGenerate.setEnabled(false);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        North north = new North();
        north.setStyle("border: none; max-height: 60%;");
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setSplittable(true);
        north.setCollapsible(true);
        north.setAutoscroll(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        if (ClientInfo.maxWidth(999)) {
            Columns cols = new Columns();
            this.parameterLayout.appendChild((Component)cols);
            Column col = new Column();
            col.setHflex("min");
            cols.appendChild((Component)col);
            col = new Column();
            col.setHflex("1");
            cols.appendChild((Component)col);
            col = new Column();
            col.setHflex("min");
            cols.appendChild((Component)col);
            if (ClientInfo.minWidth(700)) {
                col = new Column();
                col.setWidth("20%");
                cols.appendChild((Component)col);
            }
        }
        Rows rows = this.parameterLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.labelBankAccount.rightAlign());
        row.appendChild((Component)this.fieldBankAccount);
        if (ClientInfo.maxWidth(999)) {
            row.appendChild((Component)new Space());
            row = rows.newRow();
        }
        row.appendChild(this.labelBankBalance.rightAlign());
        Panel balancePanel = new Panel();
        balancePanel.appendChild((Component)this.labelCurrency);
        balancePanel.appendChild((Component)this.labelBalance);
        row.appendChild((Component)balancePanel);
        row.appendChild((Component)new Space());
        row = rows.newRow();
        row.appendChild(this.labelBPartner.rightAlign());
        row.appendChild((Component)this.fieldBPartner);
        if (ClientInfo.maxWidth(999)) {
            row.appendChild((Component)new Space());
            row = rows.newRow();
        }
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.onlyDue);
        row.appendChild((Component)new Space());
        row = rows.newRow();
        row.appendChild(this.labelDtype.rightAlign());
        row.appendChild((Component)this.fieldDtype);
        row.appendChild((Component)new Space());
        if (ClientInfo.minWidth(1000)) {
            row.appendChild((Component)new Space());
            row.appendChild((Component)new Space());
        }
        row = rows.newRow();
        row.appendChild(this.labelPayDate.rightAlign());
        row.appendChild((Component)this.fieldPayDate.getComponent());
        if (ClientInfo.maxWidth(999)) {
            row.appendChild((Component)new Space());
            row = rows.newRow();
        }
        row.appendChild(this.labelPaymentRule.rightAlign());
        row.appendChild((Component)this.fieldPaymentRule);
        row.appendChild((Component)this.bRefresh);
        if (ClientInfo.minWidth(700)) {
            LayoutUtils.expandTo(this.parameterLayout, 4, true);
        }
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        this.southPanel = new Panel();
        this.southPanel.appendChild((Component)this.dataStatus);
        south.appendChild((Component)this.southPanel);
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.miniTable);
        this.commandPanel.addButton(this.bGenerate);
        this.commandPanel.getButton("Ok").setVisible(false);
    }

    private void dynInit() {
        ArrayList bankAccountData = this.getBankAccountData();
        for (PaySelect.BankInfo bi : bankAccountData) {
            this.fieldBankAccount.appendItem(bi.toString(), bi);
        }
        if (this.fieldBankAccount.getItemCount() == 0) {
            FDialog.error(this.m_WindowNo, (Component)this.form, "VPaySelectNoBank");
        } else {
            this.fieldBankAccount.setSelectedIndex(0);
        }
        ArrayList bpartnerData = this.getBPartnerData();
        for (KeyNamePair pp : bpartnerData) {
            this.fieldBPartner.appendItem(pp.getName(), pp);
        }
        this.fieldBPartner.setSelectedIndex(0);
        ArrayList docTypeData = this.getDocTypeData();
        for (KeyNamePair pp : docTypeData) {
            this.fieldDtype.appendItem(pp.getName(), pp);
        }
        this.prepareTable(this.miniTable);
        this.miniTable.getModel().addTableModelListener(this);
        this.fieldPayDate.setMandatory(true);
        this.fieldPayDate.setValue(new Timestamp(System.currentTimeMillis()));
    }

    private void loadBankInfo() {
        if (this.fieldBankAccount.getItemCount() == 0) {
            return;
        }
        PaySelect.BankInfo bi = (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem().getValue();
        this.labelCurrency.setText(bi.Currency);
        this.labelBalance.setText(this.m_format.format(bi.Balance));
        this.fieldPaymentRule.removeAllItems();
        ArrayList paymentRuleData = this.getPaymentRuleData(bi);
        for (ValueNamePair vp : paymentRuleData) {
            this.fieldPaymentRule.appendItem(vp.getName(), vp);
        }
        this.fieldPaymentRule.setSelectedIndex(0);
    }

    private void loadTableInfo() {
        Timestamp payDate = (Timestamp)this.fieldPayDate.getValue();
        if (payDate == null) {
            throw new WrongValueException((Component)this.fieldPayDate.getComponent(), String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + this.labelPayDate.getValue());
        }
        this.miniTable.setColorCompare(payDate);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("PayDate=" + payDate);
        }
        if (this.fieldBankAccount.getItemCount() == 0) {
            FDialog.error(this.m_WindowNo, (Component)this.form, "VPaySelectNoBank");
            return;
        }
        PaySelect.BankInfo bi = (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem().getValue();
        ValueNamePair paymentRule = (ValueNamePair)this.fieldPaymentRule.getSelectedItem().getValue();
        KeyNamePair bpartner = (KeyNamePair)this.fieldBPartner.getSelectedItem().getValue();
        KeyNamePair docType = (KeyNamePair)this.fieldDtype.getSelectedItem().getValue();
        this.loadTableInfo(bi, payDate, paymentRule, this.onlyDue.isSelected(), bpartner, docType, this.miniTable);
        this.calculateSelection();
        if (ClientInfo.maxHeight(699)) {
            this.mainLayout.getNorth().setOpen(false);
            LayoutUtils.addSclass("slide", (HtmlBasedComponent)this.mainLayout.getNorth());
        }
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) {
        if (e.getTarget() == this.fieldBankAccount) {
            this.loadBankInfo();
        } else if (e.getTarget() == this.bGenerate) {
            this.generatePaySelect();
        } else if (e.getTarget() == this.bCancel) {
            this.dispose();
        } else if (e.getTarget() == this.fieldBPartner || e.getTarget() == this.bRefresh || e.getTarget() == this.fieldDtype || e.getTarget() == this.fieldPaymentRule || e.getTarget() == this.onlyDue) {
            this.loadTableInfo();
        } else if ("onWindowClose".equals(e.getName())) {
            FDialog.ask(this.m_WindowNo, (Component)this.form, "VPaySelectPrint?", new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        int AD_Form_ID = 106;
                        ADForm form = SessionManager.getAppDesktop().openForm(AD_Form_ID);
                        if (WPaySelect.this.m_ps != null) {
                            WPayPrint pp = (WPayPrint)form.getICustomForm();
                            pp.setPaySelection(WPaySelect.this.m_ps.getC_PaySelection_ID());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (e.getSource() == this.fieldPayDate) {
            this.loadTableInfo();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        if (e.getColumn() == 0) {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.dataStatus.setText(this.calculateSelection(this.miniTable));
        this.bGenerate.setEnabled(this.m_noSelected != 0);
    }

    private void generatePaySelect() {
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setSelectedIndices(new int[1]);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        String msg = this.generatePaySelect(this.miniTable, (ValueNamePair)this.fieldPaymentRule.getSelectedItem().getValue(), new Timestamp(this.fieldPayDate.getComponent().getValue().getTime()), (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem().getValue());
        if (msg != null && msg.length() > 0) {
            FDialog.error(this.m_WindowNo, (Component)this.form, "SaveError", msg);
            return;
        }
        this.loadTableInfo();
        if (MSysConfig.getBooleanValue((String)"PAYMENT_SELECTION_MANUAL_ASK_INVOKE_GENERATE", (boolean)true, (int)this.m_ps.getAD_Client_ID(), (int)this.m_ps.getAD_Org_ID())) {
            FDialog.ask(this.m_WindowNo, (Component)this.form, "VPaySelectGenerate?", new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    int AD_Proces_ID;
                    ProcessModalDialog dialog;
                    if (result.booleanValue() && (dialog = new ProcessModalDialog(WPaySelect.this, WPaySelect.this.m_WindowNo, AD_Proces_ID = 155, 426, WPaySelect.this.m_ps.getC_PaySelection_ID(), false)).isValid()) {
                        try {
                            dialog.setVisible(true);
                            dialog.setPage(WPaySelect.this.form.getPage());
                            dialog.doHighlighted();
                        }
                        catch (SuspendNotAllowedException e) {
                            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
            });
        } else {
            AEnv.zoom(426, this.m_ps.getC_PaySelection_ID());
        }
    }

    public void lockUI(ProcessInfo pi) {
        if (this.m_isLock) {
            return;
        }
        this.m_isLock = true;
        Clients.showBusy(null);
    }

    public void unlockUI(ProcessInfo pi) {
        if (!this.m_isLock) {
            return;
        }
        this.m_isLock = false;
        this.m_pi = pi;
        Clients.clearBusy();
        this.dispose();
    }

    public void executeASync(ProcessInfo pi) {
    }

    public boolean isUILocked() {
        return this.m_isLock;
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    public void statusUpdate(String message) {
    }

    public void ask(final String message, final Callback<Boolean> callback) {
        Executions.schedule((Desktop)this.form.getDesktop(), (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                FDialog.ask(WPaySelect.this.m_WindowNo, null, message, (Callback<Boolean>)callback);
            }
        }, (Event)new Event("onAsk"));
    }

    public void download(File file) {
    }

    public void askForInput(final String message, final Callback<String> callback) {
        Executions.schedule((Desktop)this.form.getDesktop(), (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                FDialog.askForInput(WPaySelect.this.m_WindowNo, null, message, (Callback<String>)callback);
            }
        }, (Event)new Event("onAskForInput"));
    }
}

