/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.apps.form.WMergeUI;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.form.Merge;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.South;

public class WMerge
extends Merge
implements IFormController,
EventListener<Event> {
    private static final long serialVersionUID = 5797395051958101596L;
    private WMergeUI form;
    private Label[] m_label = null;
    private WEditor[] m_from = null;
    private WEditor[] m_to = null;
    private Borderlayout mainLayout = new Borderlayout();
    private Panel CenterPanel = new Panel();
    private Grid centerLayout = GridFactory.newGridLayout();
    private Label mergeFromLabel = new Label();
    private Label mergeToLabel = new Label();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private String m_msg;
    private boolean m_success;
    private MergeRunnable runnable;

    public WMerge() {
        this.form = new WMergeUI(this);
        this.m_WindowNo = this.form.getWindowNo();
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.zkInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    private void preInit() {
        int count = 4;
        this.m_columnName = new String[count];
        this.m_label = new Label[count];
        this.m_from = new WEditor[count];
        this.m_to = new WEditor[count];
        this.preInit(0, 2163, 19, AD_ORG_ID);
        this.preInit(1, 2762, 30, C_BPARTNER_ID);
        this.preInit(2, 971, 30, AD_USER_ID);
        this.preInit(3, 2221, 30, M_PRODUCT_ID);
    }

    private void preInit(int index, int AD_Column_ID, int displayType, String ColumnName) {
        this.m_columnName[index] = ColumnName;
        String what = Msg.translate((Properties)Env.getCtx(), (String)ColumnName);
        this.m_label[index] = new Label(what);
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)displayType);
        if (displayType == 30) {
            this.m_from[index] = new WSearchEditor(ColumnName, false, false, true, (Lookup)lookup);
            this.m_to[index] = new WSearchEditor(ColumnName, false, false, true, (Lookup)lookup);
        } else {
            this.m_from[index] = new WTableDirEditor(ColumnName, false, false, true, (Lookup)lookup);
            this.m_to[index] = new WTableDirEditor(ColumnName, false, false, true, (Lookup)lookup);
        }
    }

    void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        South south = new South();
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        Rows rows = this.centerLayout.newRows();
        this.CenterPanel.appendChild((Component)this.centerLayout);
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.CenterPanel);
        Row row = rows.newRow();
        row.appendChild((Component)new Label());
        row.appendChild((Component)this.mergeFromLabel);
        row.appendChild((Component)this.mergeToLabel);
        this.mergeFromLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MergeFrom"));
        this.mergeFromLabel.setStyle("font-weight: bold");
        this.mergeToLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MergeTo"));
        this.mergeToLabel.setStyle("font-weight: bold");
        int i = 0;
        while (i < this.m_label.length) {
            row = rows.newRow();
            row.appendChild((Component)this.m_label[i]);
            row.appendChild(this.m_from[i].getComponent());
            row.appendChild(this.m_to[i].getComponent());
            ++i;
        }
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) {
        if (e.getTarget().getId().equals("Cancel")) {
            this.dispose();
            return;
        }
        String columnName = null;
        String from_Info = null;
        String to_Info = null;
        int from_ID = 0;
        int to_ID = 0;
        int i = 0;
        while (i < this.m_columnName.length && from_ID == 0 && to_ID == 0) {
            Object value = this.m_from[i].getValue();
            if (value != null && value instanceof Integer) {
                from_ID = (Integer)value;
                value = this.m_to[i].getValue();
                if (value != null && value instanceof Integer) {
                    to_ID = (Integer)value;
                } else {
                    from_ID = 0;
                }
                if (from_ID != 0) {
                    columnName = this.m_columnName[i];
                    from_Info = this.m_from[i].getDisplay();
                    to_Info = this.m_to[i].getDisplay();
                }
            }
            ++i;
        }
        if (from_ID == 0 || from_ID == to_ID) {
            return;
        }
        this.m_msg = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"MergeFrom")) + " = " + from_Info + "\n" + Msg.getMsg((Properties)Env.getCtx(), (String)"MergeTo") + " = " + to_Info;
        final String columnNameRef = columnName;
        final int fromIdRef = from_ID;
        final int toIdRef = to_ID;
        FDialog.ask(this.m_WindowNo, (Component)this.form, "MergeQuestion", this.m_msg, new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WMerge.this.updateDeleteTable(columnNameRef);
                    Clients.showBusy((String)"");
                    WMerge.this.runnable = new MergeRunnable(columnNameRef, fromIdRef, toIdRef);
                    Clients.response((AuResponse)new AuEcho((Component)WMerge.this.form, "runProcess", null));
                }
            }
        });
    }

    public void runProcess() {
        this.runnable.run();
    }

    public void onAfterProcess() {
        if (!this.m_success) {
            FDialog.error(this.m_WindowNo, (Component)this.form, "MergeError", this.m_errorLog.toString());
            return;
        }
        FDialog.info(this.m_WindowNo, (Component)this.form, "MergeSuccess", String.valueOf(this.m_msg) + " #" + this.m_totalCount);
        this.dispose();
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    class MergeRunnable
    implements Runnable {
        private int to_ID;
        private int from_ID;
        private String columnName;

        private MergeRunnable(String columnName, int from_ID, int to_ID) {
            this.columnName = columnName;
            this.from_ID = from_ID;
            this.to_ID = to_ID;
        }

        @Override
        public void run() {
            try {
                WMerge.this.m_success = WMerge.this.merge(this.columnName, this.from_ID, this.to_ID);
                if (WMerge.this.m_success) {
                    WMerge.this.postMerge(this.columnName, this.to_ID);
                }
            }
            finally {
                Clients.clearBusy();
                Clients.response((AuResponse)new AuEcho((Component)WMerge.this.form, "onAfterProcess", null));
            }
        }
    }
}

