/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.Serializable;
import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.WAppsAction;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.CreateFromForm;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Window;

public class WCreateFromForm
extends ADForm
implements EventListener<Event>,
WTableModelListener,
DialogEvents {
    private static final long serialVersionUID = -3703236565441597403L;
    private CreateFromForm form;
    private Panel parameterPanel = new Panel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private WListbox dataTable = ListboxFactory.newDataTable();
    private boolean isCancel;
    public static final String SELECT_ALL = "SelectAll";

    public WCreateFromForm(CreateFromForm createFrom) {
        this.form = createFrom;
        this.setSizable(true);
        this.setMaximizable(true);
        this.setBorder("normal");
        this.setSclass("create-from-form");
    }

    @Override
    protected void initForm() {
        try {
            this.zkInit();
            this.confirmPanel.addActionListener(this);
            this.statusBar.setStatusDB("");
            this.tableChanged(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void zkInit() throws Exception {
        Borderlayout contentPane = new Borderlayout();
        this.appendChild((Component)contentPane);
        North north = new North();
        contentPane.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setAutoscroll(true);
        north.setSplittable(true);
        north.setCollapsible(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        Center center = new Center();
        contentPane.appendChild((Component)center);
        center.appendChild((Component)this.dataTable);
        WAppsAction selectAllAction = new WAppsAction(SELECT_ALL, null, null);
        Button selectAllButton = selectAllAction.getButton();
        this.confirmPanel.addComponentsLeft(selectAllButton);
        selectAllButton.addActionListener(this);
        South south = new South();
        contentPane.appendChild((Component)south);
        Panel southPanel = new Panel();
        south.appendChild((Component)southPanel);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.confirmPanel);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.statusBar);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 750);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 550);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)contentPane, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)contentPane, "100%");
    }

    @Override
    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Ok")) {
            this.isCancel = false;
            try {
                Trx.run((TrxRunnable)new TrxRunnable(){

                    public void run(String trxName) {
                        WCreateFromForm.this.save(trxName);
                    }
                });
                this.dispose();
            }
            catch (Exception ex) {
                FDialog.error(this.getWindowNo(), (Component)this, "Error", ex.getLocalizedMessage());
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.isCancel = true;
            this.dispose();
        } else if (e.getTarget().getId().equals(SELECT_ALL)) {
            ListModelTable model = this.dataTable.getModel();
            int rows = model.getSize();
            int i = 0;
            while (i < rows) {
                model.setValueAt(Boolean.TRUE, i, 0);
                ++i;
            }
            this.dataTable.setModel((ListModel<?>)model);
            this.info();
        } else {
            super.onEvent(e);
        }
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        int type = -1;
        if (e != null && (type = e.getType()) != 0) {
            return;
        }
        this.info();
    }

    public boolean save(String trxName) {
        ListModelTable model = this.dataTable.getModel();
        int rows = model.getSize();
        if (rows == 0) {
            return false;
        }
        return this.form.save((IMiniTable)this.dataTable, trxName, this.getGridTab());
    }

    public void info() {
        ListModelTable model = this.dataTable.getModel();
        int rows = model.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)model.getValueAt(i, 0)).booleanValue()) {
                ++count;
            }
            ++i;
        }
        this.setStatusLine(count, null);
        this.form.info((IMiniTable)this.dataTable, (IStatusBar)this.statusBar);
    }

    public void setStatusLine(int selectedRowCount, String text) {
        StringBuilder sb = new StringBuilder(String.valueOf(selectedRowCount));
        if (text != null && text.trim().length() > 0) {
            sb.append(" - ").append(text);
        }
        this.statusBar.setStatusLine(sb.toString());
        this.confirmPanel.getOKButton().setEnabled(selectedRowCount > 0);
    }

    public WListbox getWListbox() {
        return this.dataTable;
    }

    public Panel getParameterPanel() {
        return this.parameterPanel;
    }

    public ConfirmPanel getConfirmPanel() {
        return this.confirmPanel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void postQueryEvent() {
        Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
        Events.echoEvent((String)"onExecuteQuery", (Component)this, null);
    }

    public void onExecuteQuery() {
        try {
            this.form.executeQuery();
        }
        finally {
            Clients.clearBusy();
        }
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }

    public boolean setVisible(boolean visible) {
        boolean ok = super.setVisible(visible);
        if (visible && this.getProcessInfo() != null) {
            this.form.initForm();
        }
        return ok;
    }
}

