/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.form.Charge;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

public class WCharge
extends Charge
implements IFormController,
EventListener<Event> {
    private static final long serialVersionUID = 4210542409436277344L;
    private CustomForm form = new CustomForm();
    private static final String AD_MESSAGE_CREATE = "Create";
    private static CLogger log = CLogger.getCLogger(WCharge.class);
    private Grid m_grdNew = GridFactory.newGridLayout();
    private Label m_lblValue = new Label();
    private Textbox m_txbValueField = new Textbox();
    private Checkbox m_chbIsExpense = new Checkbox();
    private Label m_lblName = new Label();
    private Textbox m_txbNameField = new Textbox();
    private Button m_btnNew = new Button();
    private Panel m_pnlAccount = new Panel();
    private Button m_btnAccount = new Button();
    private WListbox m_tblData = new WListbox();
    private ConfirmPanel m_pnlConfirm = new ConfirmPanel();
    private Grid m_grdConfirm = GridFactory.newGridLayout();

    public WCharge() {
        this.m_WindowNo = this.form.getWindowNo();
        this.initForm();
    }

    protected void initForm() {
        log.info("");
        try {
            this.staticInitialise();
            this.dynamicInitialise();
            this.zkInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void staticInitialise() {
        this.createNewChargePanel();
        this.createAccountPanel();
        this.createConfirmPanel();
    }

    private void zkInit() {
        Borderlayout contentPane = new Borderlayout();
        this.form.appendChild((Component)contentPane);
        North north = new North();
        contentPane.appendChild((Component)north);
        north.appendChild((Component)this.m_grdNew);
        north.setCollapsible(true);
        north.setSplittable(true);
        Center center = new Center();
        contentPane.appendChild((Component)center);
        center.appendChild((Component)this.m_pnlAccount);
        South south = new South();
        contentPane.appendChild((Component)south);
        Panel southPanel = new Panel();
        south.appendChild((Component)southPanel);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.m_grdConfirm);
    }

    private void createAccountPanel() {
        Borderlayout borderlayout = new Borderlayout();
        borderlayout.setStyle("position: relative");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)borderlayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)borderlayout, "100%");
        this.m_pnlAccount.appendChild((Component)borderlayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.m_pnlAccount, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.m_pnlAccount, "100%");
        North north = new North();
        north.setBorder("none");
        borderlayout.appendChild((Component)north);
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"ChargeFromAccount"));
        label.setStyle("font-weight: bold;");
        north.appendChild((Component)label);
        Center center = new Center();
        center.setBorder("none");
        center.setAutoscroll(true);
        borderlayout.appendChild((Component)center);
        center.appendChild((Component)this.m_tblData);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_tblData, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_tblData, "1");
        South south = new South();
        south.setBorder("none");
        borderlayout.appendChild((Component)south);
        Panel southPanel = new Panel();
        southPanel.setStyle("text-align: right;");
        south.appendChild((Component)southPanel);
        this.m_btnAccount.setLabel(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)AD_MESSAGE_CREATE)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"From") + " " + Msg.getElement((Properties)Env.getCtx(), (String)"Account_ID"));
        this.m_btnAccount.addEventListener("onClick", this);
        southPanel.appendChild((Component)this.m_btnAccount);
    }

    private void createNewChargePanel() {
        int nameFieldColumns = 20;
        int valueFieldColumns = 10;
        this.m_lblValue.setValue(Msg.getElement((Properties)Env.getCtx(), (String)EColumn.VALUE.title()));
        this.m_txbValueField.setCols(10);
        this.m_chbIsExpense.setChecked(true);
        this.m_chbIsExpense.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)EColumn.EXPENSE.title()));
        this.m_lblName.setValue(Msg.getElement((Properties)Env.getCtx(), (String)EColumn.NAME.title()));
        this.m_txbNameField.setCols(20);
        this.m_btnNew.setLabel(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)AD_MESSAGE_CREATE)) + " " + Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")));
        this.m_btnNew.addEventListener("onClick", this);
        Rows rows = new Rows();
        this.m_grdNew.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Label label = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"ChargeNewAccount"));
        label.setStyle("font-weight: bold;");
        row.appendCellChild((Component)label, 3);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.m_lblValue.rightAlign());
        row.appendChild((Component)this.m_txbValueField);
        row.appendChild((Component)this.m_chbIsExpense);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbValueField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.m_lblName.rightAlign());
        row.appendChild((Component)this.m_txbNameField);
        row.appendChild((Component)this.m_btnNew);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbNameField, "1");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendCellChild((Component)new Separator(), 3);
    }

    private void dynamicInitialise() {
        this.findChargeElementID();
        ListModelTable model = new ListModelTable(this.getData());
        this.m_tblData.setData(model, this.getColumnNames());
        this.setColumnClass(this.m_tblData);
        this.findTaxCategoryID();
    }

    public void onEvent(Event event) {
        log.info(event.getName());
        if (event.getTarget().getId().equals("Ok") || this.m_C_Element_ID == 0) {
            this.close();
        } else if (event.getTarget().equals((Object)this.m_btnNew)) {
            this.createNew();
        } else if (event.getTarget().equals((Object)this.m_btnAccount)) {
            this.createAccount();
        }
    }

    private void createNew() {
        log.config("");
        String value = this.m_txbValueField.getValue();
        if (value.length() == 0) {
            throw new WrongValueException((Component)this.m_txbValueField, String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + this.m_lblValue.getValue());
        }
        String name = this.m_txbNameField.getText();
        if (name.length() == 0) {
            throw new WrongValueException((Component)this.m_txbNameField, String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + this.m_lblName.getValue());
        }
        int elementValueId = this.createElementValue(value, name, this.m_chbIsExpense.isChecked());
        if (elementValueId == 0) {
            FDialog.error(this.form.getWindowNo(), (Component)this.form, "ChargeNotCreated", name);
            return;
        }
        int chargeId = this.createCharge(name, elementValueId);
        if (chargeId == 0) {
            FDialog.error(this.form.getWindowNo(), (Component)this.form, "ChargeNotCreated", name);
            return;
        }
        FDialog.info(this.form.getWindowNo(), (Component)this.form, "ChargeCreated", name);
    }

    private void createAccount() {
        this.createAccount(this.m_tblData);
        if (this.listCreated.length() > 0) {
            FDialog.info(this.form.getWindowNo(), (Component)this.form, "ChargeCreated", this.listCreated.toString());
        }
        if (this.listRejected.length() > 0) {
            FDialog.error(this.form.getWindowNo(), (Component)this.form, "ChargeNotCreated", this.listRejected.toString());
        }
    }

    public void createConfirmPanel() {
        Rows rows = new Rows();
        Row row = new Row();
        this.m_pnlConfirm.addActionListener(this);
        row.appendChild((Component)this.m_pnlConfirm);
        rows.appendChild((Component)row);
        this.m_grdConfirm.appendChild((Component)rows);
    }

    public void close() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    private static enum EColumn {
        SELECT(0, "Select"),
        VALUE(1, "Value"),
        NAME(2, "Name"),
        EXPENSE(3, "Expense");

        private final int m_index;
        private final String m_title;

        private EColumn(int index, String title) {
            this.m_index = index;
            this.m_title = title;
        }

        public String title() {
            return this.m_title;
        }
    }
}

