/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Layout;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

public class WBOMDrop
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = 8864346687201400591L;
    private MProduct m_product;
    private BigDecimal m_qty = Env.ONE;
    private int m_bomLine = 0;
    private static CLogger log = CLogger.getCLogger(WBOMDrop.class);
    private ArrayList<org.zkoss.zul.Checkbox> m_selectionList = new ArrayList();
    private ArrayList<Decimalbox> m_qtyList = new ArrayList();
    private ArrayList<Integer> m_productList = new ArrayList();
    private ArrayList<Layout> m_childPanelList = new ArrayList();
    private ArrayList<Layout> m_containPanel = new ArrayList();
    private HashMap<String, Radiogroup> m_buttonGroups = new HashMap();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Grid selectionPanel = GridFactory.newGridLayout();
    private Listbox productField = new Listbox();
    private Decimalbox productQty = new Decimalbox();
    private Listbox orderField = new Listbox();
    private Listbox invoiceField = new Listbox();
    private Listbox projectField = new Listbox();
    private Groupbox grpSelectionPanel = new Groupbox();
    private Groupbox grpSelectProd = new Groupbox();
    private int indend = 20;
    private int maxBomDeep = 0;
    private List<org.zkoss.zul.Checkbox> displayList = new ArrayList<org.zkoss.zul.Checkbox>();

    @Override
    protected void initForm() {
        log.info("");
        try {
            this.confirmPanel = new ConfirmPanel(true);
            this.createSelectionPanel(true, true, true);
            this.createMainPanel();
            this.confirmPanel.addActionListener("onClick", this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.selectionPanel != null) {
            this.selectionPanel.getChildren().clear();
        }
        this.selectionPanel = null;
        if (this.m_selectionList != null) {
            this.m_selectionList.clear();
        }
        this.m_selectionList = null;
        if (this.m_productList != null) {
            this.m_productList.clear();
        }
        this.m_productList = null;
        if (this.m_qtyList != null) {
            this.m_qtyList.clear();
        }
        this.m_qtyList = null;
        if (this.m_childPanelList != null) {
            this.m_childPanelList.clear();
        }
        this.m_childPanelList = null;
        if (this.m_containPanel != null) {
            this.m_containPanel.clear();
        }
        this.m_containPanel = null;
        if (this.m_buttonGroups != null) {
            this.m_buttonGroups.clear();
        }
        this.m_buttonGroups = null;
    }

    private void createSelectionPanel(boolean order, boolean invoice, boolean project) {
        Caption caption = new Caption(Msg.translate((Properties)Env.getCtx(), (String)"Selection"));
        this.grpSelectionPanel.appendChild((Component)caption);
        this.grpSelectionPanel.appendChild((Component)this.selectionPanel);
        this.productField.setRows(1);
        this.productField.setMold("select");
        KeyNamePair[] keyNamePair = this.getProducts();
        int i = 0;
        while (i < keyNamePair.length) {
            this.productField.addItem(keyNamePair[i]);
            ++i;
        }
        Rows rows = this.selectionPanel.newRows();
        Row boxProductQty = rows.newRow();
        Label lblProduct = new Label(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        Label lblQty = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        this.productQty.setValue(Env.ONE);
        this.productField.addEventListener("onSelect", this);
        this.productQty.addEventListener("onChange", (EventListener)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.productField, "99%");
        boxProductQty.appendChild(lblProduct.rightAlign());
        boxProductQty.appendChild((Component)this.productField);
        boxProductQty.appendChild(lblQty.rightAlign());
        boxProductQty.appendChild((Component)this.productQty);
        if (order) {
            keyNamePair = this.getOrders();
            this.orderField.setRows(1);
            this.orderField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.orderField, "99%");
            int i2 = 0;
            while (i2 < keyNamePair.length) {
                this.orderField.addItem(keyNamePair[i2]);
                ++i2;
            }
            Label lblOrder = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID"));
            Row boxOrder = rows.newRow();
            this.orderField.addEventListener("onClick", this);
            boxOrder.appendChild(lblOrder.rightAlign());
            boxOrder.appendChild((Component)this.orderField);
            boxOrder.appendChild((Component)new Space());
            boxOrder.appendChild((Component)new Space());
        }
        if (invoice) {
            this.invoiceField.setRows(1);
            this.invoiceField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceField, "99%");
            keyNamePair = this.getInvoices();
            int i3 = 0;
            while (i3 < keyNamePair.length) {
                this.invoiceField.addItem(keyNamePair[i3]);
                ++i3;
            }
            Label lblInvoice = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
            Row boxInvoices = rows.newRow();
            this.invoiceField.addEventListener("onSelect", this);
            boxInvoices.appendChild(lblInvoice.rightAlign());
            boxInvoices.appendChild((Component)this.invoiceField);
            boxInvoices.appendChild((Component)new Space());
            boxInvoices.appendChild((Component)new Space());
        }
        if (project) {
            this.projectField.setRows(1);
            this.projectField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.projectField, "99%");
            keyNamePair = this.getProjects();
            int i4 = 0;
            while (i4 < keyNamePair.length) {
                this.projectField.addItem(keyNamePair[i4]);
                ++i4;
            }
            Label lblProject = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Project_ID"));
            Row boxProject = rows.newRow();
            this.projectField.addEventListener("onSelect", this);
            boxProject.appendChild(lblProject.rightAlign());
            boxProject.appendChild((Component)this.projectField);
            boxProject.appendChild((Component)new Space());
            boxProject.appendChild((Component)new Space());
        }
        this.confirmPanel.setEnabled("Ok", false);
    }

    private KeyNamePair[] getProducts() {
        String sql = "SELECT M_Product_ID, Name FROM M_Product WHERE IsBOM='Y' AND IsVerified='Y' AND IsActive='Y' ORDER BY Name";
        return DB.getKeyNamePairs((String)MRole.getDefault().addAccessSQL(sql, "M_Product", false, false), (boolean)true);
    }

    private KeyNamePair[] getOrders() {
        String sql = "SELECT C_Order_ID, DocumentNo || '_' || GrandTotal FROM C_Order WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs((String)MRole.getDefault().addAccessSQL(sql, "C_Order", false, false), (boolean)true);
    }

    private KeyNamePair[] getProjects() {
        String sql = "SELECT C_Project_ID, Name FROM C_Project WHERE Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S' ORDER BY Name";
        return DB.getKeyNamePairs((String)MRole.getDefault().addAccessSQL(sql, "C_Project", false, false), (boolean)true);
    }

    private KeyNamePair[] getInvoices() {
        String sql = "SELECT C_Invoice_ID, DocumentNo || '_' || GrandTotal FROM C_Invoice WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs((String)MRole.getDefault().addAccessSQL(sql, "C_Invoice", false, false), (boolean)true);
    }

    private void createMainPanel() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(": " + this.m_product);
        }
        this.getChildren().clear();
        this.m_selectionList.clear();
        this.m_productList.clear();
        this.m_qtyList.clear();
        this.m_buttonGroups.clear();
        this.m_childPanelList.clear();
        this.m_containPanel.clear();
        this.appendChild((Component)new Separator());
        this.appendChild((Component)this.grpSelectionPanel);
        this.appendChild((Component)new Separator());
        this.appendChild((Component)this.grpSelectProd);
        this.appendChild((Component)new Separator());
        this.appendChild((Component)this.confirmPanel);
        this.appendChild((Component)new Separator());
        this.setBorder("normal");
        this.setContentStyle("overflow: auto");
        Caption title = new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectProduct"));
        this.grpSelectProd.getChildren().clear();
        this.grpSelectProd.appendChild((Component)title);
        if (this.m_product != null && this.m_product.get_ID() > 0) {
            title.setLabel(this.m_product.getName());
            if (this.m_product.getDescription() == null || this.m_product.getDescription().length() > 0) {
                // empty if block
            }
            this.m_bomLine = 0;
            this.maxBomDeep = this.getDeepBom(this.m_product, 0);
            this.addBOMLines(this.m_product, this.m_qty, (Component)this.grpSelectProd, 0);
            this.updateBomList();
        }
    }

    private int getDeepBom(MProduct product, int curentBomDeep) {
        int bomDeep = curentBomDeep;
        if (product.isBOM()) {
            MProductBOM[] bomLines;
            MProductBOM[] mProductBOMArray = bomLines = MProductBOM.getBOMLines((MProduct)product);
            int n = bomLines.length;
            int n2 = 0;
            while (n2 < n) {
                MProductBOM bomLine = mProductBOMArray[n2];
                int testBomDeep = this.getDeepBom(bomLine.getProduct(), curentBomDeep + 1);
                if (testBomDeep > bomDeep) {
                    bomDeep = testBomDeep;
                }
                ++n2;
            }
        }
        return bomDeep;
    }

    private void addBOMLines(MProduct product, BigDecimal qty, Component parentPanel, int bomLevel) {
        MProductBOM[] bomLines = MProductBOM.getBOMLines((MProduct)product);
        Arrays.sort(bomLines, new Comparator<MProductBOM>(){

            @Override
            public int compare(MProductBOM arg0, MProductBOM arg1) {
                return arg0.getBOMType().compareTo(arg1.getBOMType());
            }
        });
        Arrays.sort(bomLines, new Comparator<MProductBOM>(){

            @Override
            public int compare(MProductBOM arg0, MProductBOM arg1) {
                String t1 = String.valueOf(arg0.getLine() + 100000);
                String t2 = String.valueOf(arg1.getLine() + 100000);
                return t1.compareTo(t2);
            }
        });
        int i = 0;
        while (i < bomLines.length) {
            this.addBOMLine(bomLines[i], qty, parentPanel, bomLevel);
            ++i;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + bomLines.length);
        }
    }

    private void addBOMLine(MProductBOM line, BigDecimal qty, Component parentPanel, int bomLevel) {
        String bomType;
        if (log.isLoggable(Level.FINE)) {
            log.fine(line.toString());
        }
        if ((bomType = line.getBOMType()) == null) {
            bomType = "P";
        }
        BigDecimal lineQty = line.getBOMQty().multiply(qty);
        MProduct product = line.getProduct();
        if (product == null) {
            return;
        }
        Layout producPanel = this.addDisplay(line.getM_Product_ID(), product.getM_Product_ID(), bomType, product.getName(), lineQty, parentPanel, bomLevel);
        this.m_containPanel.add(producPanel);
        if (product.isBOM() && product.isVerified()) {
            Vlayout childPanel = this.createVlayoutPanel("100%");
            this.m_childPanelList.add((Layout)childPanel);
            producPanel.appendChild((Component)childPanel);
            this.addBOMLines(product, lineQty, (Component)childPanel, bomLevel + 1);
        } else {
            this.m_childPanelList.add(null);
        }
    }

    private Layout addDisplay(int parentM_Product_ID, int M_Product_ID, String bomType, String name, BigDecimal lineQty, Component parentPanel, int bomLevel) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("M_Product_ID=" + M_Product_ID + ",Type=" + bomType + ",Name=" + name + ",Qty=" + lineQty);
        }
        boolean selected = false;
        Hlayout productPanel = null;
        productPanel = this.createHlayoutPanel("100%");
        Vlayout outerProductPanel = new Vlayout();
        outerProductPanel.appendChild((Component)productPanel);
        Div selectPanel = this.createDivPanel(25);
        Checkbox rd = null;
        boolean isStandard = "P".equals(bomType);
        if ("P".equals(bomType) || "O".equals(bomType)) {
            rd = new Checkbox();
            rd.setChecked(isStandard);
            rd.setDisabled(isStandard);
            selected = isStandard;
        } else {
            rd = new Radio();
        }
        selectPanel.appendChild((Component)rd);
        this.m_selectionList.add(rd);
        productPanel.appendChild((Component)selectPanel);
        if (!isStandard) {
            rd.addEventListener("onCheck", this);
        }
        Div rightInden = this.createDivPanel((this.maxBomDeep - bomLevel) * this.indend);
        productPanel.appendChild((Component)rightInden);
        this.m_productList.add(M_Product_ID);
        selectPanel = this.createDivPanel(200);
        Label label = new Label(name);
        HtmlBasedComponent c = (HtmlBasedComponent)label.rightAlign();
        c.setStyle(String.valueOf(c.getStyle()) + ";margin-right: 5px");
        selectPanel.appendChild((Component)c);
        productPanel.appendChild((Component)selectPanel);
        selectPanel = this.createDivPanel(200);
        Decimalbox qty = new Decimalbox();
        qty.setValue(lineQty);
        selectPanel.appendChild((Component)qty);
        productPanel.appendChild((Component)selectPanel);
        this.m_qtyList.add(qty);
        Hlayout outerContainer = this.createHlayoutPanel("100%");
        parentPanel.appendChild((Component)outerContainer);
        if (!parentPanel.equals(this.grpSelectProd)) {
            Div cellInden = this.createDivPanel(this.indend);
            outerContainer.appendChild((Component)cellInden);
        }
        if ("P".equals(bomType) || "O".equals(bomType)) {
            outerContainer.appendChild((Component)outerProductPanel);
        } else {
            String groupName = String.valueOf(String.valueOf(parentM_Product_ID)) + "_" + bomType + "_" + parentPanel.toString();
            Radiogroup group = this.m_buttonGroups.get(groupName);
            if (group == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("ButtonGroup=" + groupName);
                }
                group = new Radiogroup();
                this.m_buttonGroups.put(groupName, group);
                rd.setChecked(true);
                selected = true;
                outerContainer.appendChild((Component)group);
            }
            group.appendChild((Component)outerProductPanel);
        }
        qty.setReadonly(!selected);
        return outerProductPanel;
    }

    private Div createDivPanel(int with) {
        Div divPanel = new Div();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)divPanel, String.format("%1$spx", with));
        divPanel.setStyle("padding-right:0;padding-left:0");
        return divPanel;
    }

    private Hlayout createHlayoutPanel(String width) {
        Hlayout layout = new Hlayout();
        layout.setSpacing("0");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, width);
        return layout;
    }

    private Vlayout createVlayoutPanel(String width) {
        Vlayout layout = new Vlayout();
        layout.setSpacing("0");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, width);
        return layout;
    }

    @Override
    public void onEvent(Event e) throws Exception {
        boolean OK;
        ListItem listitem;
        Component source;
        if (log.isLoggable(Level.CONFIG)) {
            log.config(e.getName());
        }
        if ((source = e.getTarget()) instanceof org.zkoss.zul.Checkbox) {
            org.zkoss.zul.Checkbox chbSource = (org.zkoss.zul.Checkbox)source;
            int index = this.m_selectionList.indexOf(chbSource);
            this.m_qtyList.get(index).setReadonly(!chbSource.isChecked());
            if (chbSource instanceof Radio) {
                Radiogroup group = ((Radio)chbSource).getRadiogroup();
                List lsRadio = group.getItems();
                for (Radio testRadio : lsRadio) {
                    if (chbSource.equals((Object)testRadio)) continue;
                    testRadio.setChecked(false);
                    index = this.m_selectionList.indexOf(testRadio);
                    this.m_qtyList.get(index).setReadonly(true);
                }
            }
            this.updateBomList();
        } else if (source == this.productField || source == this.productQty) {
            this.m_qty = this.productQty.getValue();
            listitem = this.productField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            this.m_product = pp != null ? MProduct.get((Properties)Env.getCtx(), (int)pp.getKey()) : null;
            this.createMainPanel();
        } else if (source == this.orderField) {
            boolean valid;
            listitem = this.orderField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.invoiceField != null) {
                this.invoiceField.setEnabled(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setEnabled(!valid);
            }
        } else if (source == this.invoiceField) {
            boolean valid;
            listitem = this.invoiceField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setEnabled(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setEnabled(!valid);
            }
        } else if (source == this.projectField) {
            boolean valid;
            listitem = this.projectField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setEnabled(!valid);
            }
            if (this.invoiceField != null) {
                this.invoiceField.setEnabled(!valid);
            }
        } else if (this.confirmPanel.getButton("Ok").equals(e.getTarget())) {
            if (this.onSave()) {
                SessionManager.getAppDesktop().closeActiveWindow();
            }
        } else if (this.confirmPanel.getButton("Cancel").equals(e.getTarget())) {
            SessionManager.getAppDesktop().closeActiveWindow();
        } else {
            super.onEvent(e);
        }
        boolean bl = OK = this.m_product != null;
        if (OK) {
            ListItem listitem2;
            KeyNamePair pp = null;
            if (this.orderField != null && (listitem2 = this.orderField.getSelectedItem()) != null) {
                pp = listitem2.toKeyNamePair();
            }
            if ((pp == null || pp.getKey() <= 0) && this.invoiceField != null && (listitem2 = this.invoiceField.getSelectedItem()) != null) {
                pp = listitem2.toKeyNamePair();
            }
            if ((pp == null || pp.getKey() <= 0) && this.projectField != null && (listitem2 = this.projectField.getSelectedItem()) != null) {
                pp = listitem2.toKeyNamePair();
            }
            OK = pp != null && pp.getKey() > 0;
        }
        this.confirmPanel.setEnabled("Ok", OK);
    }

    protected void updateBomList() {
        int index = 0;
        for (org.zkoss.zul.Checkbox chbSource : this.m_selectionList) {
            index = this.m_selectionList.indexOf(chbSource);
            Layout childPanel = this.m_childPanelList.get(index);
            Layout containPanel = this.m_containPanel.get(index);
            if (childPanel != null && chbSource.isChecked() && !containPanel.getChildren().contains(childPanel)) {
                containPanel.appendChild((Component)childPanel);
                continue;
            }
            if (childPanel == null || chbSource.isChecked() || !containPanel.getChildren().contains(childPanel)) continue;
            childPanel.detach();
        }
    }

    private List<org.zkoss.zul.Checkbox> getDisplayList() {
        this.displayList.clear();
        for (org.zkoss.zul.Checkbox chbSource : this.m_selectionList) {
            if (chbSource.getPage() == null) continue;
            this.displayList.add(chbSource);
        }
        return this.displayList;
    }

    private boolean onSave() {
        String trxName = Trx.createTrxName((String)"BDP");
        localTrx.setDisplayName(String.valueOf(this.getClass().getName()) + "_onSave");
        try (Trx localTrx = Trx.get((String)trxName, (boolean)true);){
            if (this.cmd_save(localTrx)) {
                localTrx.commit();
                return true;
            }
            localTrx.rollback();
            return false;
        }
    }

    private boolean cmd_save(Trx trx) {
        ListItem listitem = this.orderField.getSelectedItem();
        KeyNamePair pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveOrder(pp.getKey(), trx);
        }
        listitem = this.invoiceField.getSelectedItem();
        pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveInvoice(pp.getKey(), trx);
        }
        listitem = this.projectField.getSelectedItem();
        pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveProject(pp.getKey(), trx);
        }
        log.log(Level.SEVERE, "Nothing selected");
        return false;
    }

    private boolean cmd_saveOrder(int C_Order_ID, Trx trx) {
        MOrder order;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Order_ID=" + C_Order_ID);
        }
        if ((order = new MOrder(Env.getCtx(), C_Order_ID, trx != null ? trx.getTrxName() : null)).get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Order_ID=" + C_Order_ID);
            return false;
        }
        int lineCount = 0;
        try {
            List<org.zkoss.zul.Checkbox> displayList = this.getDisplayList();
            for (org.zkoss.zul.Checkbox displayChb : displayList) {
                int i = this.m_selectionList.indexOf(displayChb);
                if (!this.m_selectionList.get(i).isChecked()) continue;
                BigDecimal qty = this.m_qtyList.get(i).getValue();
                int M_Product_ID = this.m_productList.get(i);
                MOrderLine ol = new MOrderLine(order);
                ol.setM_Product_ID(M_Product_ID, true);
                ol.setQty(qty);
                ol.setPrice();
                ol.setTax();
                ol.saveEx();
                ++lineCount;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Line not saved");
            if (trx != null) {
                trx.rollback();
            }
            throw new AdempiereException(e.getMessage());
        }
        FDialog.info(-1, (Component)this, String.valueOf(Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID")) + " : " + order.getDocumentInfo() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + lineCount);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + lineCount);
        }
        return true;
    }

    private boolean cmd_saveInvoice(int C_Invoice_ID, Trx trx) {
        MInvoice invoice;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Invoice_ID=" + C_Invoice_ID);
        }
        if ((invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trx != null ? trx.getTrxName() : null)).get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        int lineCount = 0;
        try {
            List<org.zkoss.zul.Checkbox> displayList = this.getDisplayList();
            for (org.zkoss.zul.Checkbox displayChb : displayList) {
                int i = this.m_selectionList.indexOf(displayChb);
                if (!this.m_selectionList.get(i).isChecked()) continue;
                BigDecimal qty = this.m_qtyList.get(i).getValue();
                int M_Product_ID = this.m_productList.get(i);
                MInvoiceLine il = new MInvoiceLine(invoice);
                il.setM_Product_ID(M_Product_ID, true);
                il.setQty(qty);
                il.setPrice();
                il.setTax();
                il.saveEx();
                ++lineCount;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Line not saved");
            if (trx != null) {
                trx.rollback();
            }
            throw new AdempiereException(e.getMessage());
        }
        FDialog.info(-1, (Component)this, String.valueOf(Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID")) + " : " + invoice.getDocumentInfo() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + lineCount);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + lineCount);
        }
        return true;
    }

    private boolean cmd_saveProject(int C_Project_ID, Trx trx) {
        MProject project;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Project_ID=" + C_Project_ID);
        }
        if ((project = new MProject(Env.getCtx(), C_Project_ID, trx != null ? trx.getTrxName() : null)).get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Project_ID=" + C_Project_ID);
            return false;
        }
        int lineCount = 0;
        try {
            List<org.zkoss.zul.Checkbox> displayList = this.getDisplayList();
            for (org.zkoss.zul.Checkbox displayChb : displayList) {
                int i = this.m_selectionList.indexOf(displayChb);
                if (!this.m_selectionList.get(i).isChecked()) continue;
                BigDecimal qty = this.m_qtyList.get(i).getValue();
                int M_Product_ID = this.m_productList.get(i);
                MProjectLine pl = new MProjectLine(project);
                pl.setM_Product_ID(M_Product_ID);
                pl.setPlannedQty(qty);
                pl.saveEx();
                ++lineCount;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Line not saved");
            if (trx != null) {
                trx.rollback();
            }
            throw new AdempiereException(e.getMessage());
        }
        FDialog.info(-1, (Component)this, String.valueOf(Msg.translate((Properties)Env.getCtx(), (String)"C_Project_ID")) + " : " + project.getName() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + lineCount);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + lineCount);
        }
        return true;
    }
}

