/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.session.SessionManager;
import org.compiere.apps.AbstractProcessCtl;
import org.compiere.apps.IProcessParameter;
import org.compiere.model.MPInstance;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public class WProcessCtl
extends AbstractProcessCtl {
    private static CLogger log = CLogger.getCLogger(WProcessCtl.class);

    public static void process(int WindowNo, ProcessInfo pi, Trx trx) {
        WProcessCtl.process(WindowNo, pi, trx, null);
    }

    public static void process(int WindowNo, ProcessInfo pi, Trx trx, EventListener<Event> listener) {
        ProcessModalDialog para;
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + pi);
        }
        if (pi.getAD_PInstance_ID() < 1) {
            MPInstance instance = null;
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
            }
            catch (Exception e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
            }
            catch (Error e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
                pi.setError(true);
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        }
        if ((para = new ProcessModalDialog(listener, WindowNo, pi, false)).isValid()) {
            para.setVisible(true);
            Object window = SessionManager.getAppDesktop().findWindow(WindowNo);
            if (window != null && window instanceof Component && window instanceof ISupportMask) {
                final ISupportMask parent = LayoutUtils.showWindowWithMask((Window)para, (Component)window, 3);
                para.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        parent.hideMask();
                    }
                });
            } else if (window != null && window instanceof Component) {
                final Mask mask = LayoutUtils.showWindowWithMask((Window)para, (Component)window, null);
                para.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        mask.hideMask();
                    }
                });
            } else {
                para.setPosition("center");
                para.setAttribute("mode", "highlighted");
                AEnv.showWindow(para);
            }
        }
    }

    public static void process(IProcessUI aProcessUI, int WindowNo, IProcessParameter parameter, ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + pi);
        }
        if (pi.getAD_PInstance_ID() < 1) {
            MPInstance instance = null;
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
            }
            catch (Exception e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return;
            }
            catch (Error e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return;
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
                pi.setError(true);
                return;
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        }
        if (parameter != null && !parameter.saveParameters()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessCancelled"));
            pi.setError(true);
            return;
        }
        WProcessCtl worker = new WProcessCtl(aProcessUI, WindowNo, pi, trx);
        worker.run();
    }

    public WProcessCtl(IProcessUI aProcessUI, int WindowNo, ProcessInfo pi, Trx trx) {
        super(aProcessUI, WindowNo, pi, trx);
    }

    protected void updateProgressWindowTimerEstimate(int estSeconds) {
    }

    protected void updateProgressWindowTitle(String title) {
    }

    protected void lock() {
        if (this.getProcessMonitor() != null) {
            this.getProcessMonitor().lockUI(this.getProcessInfo());
        }
    }

    protected void unlock() {
        if (this.getProcessMonitor() != null) {
            this.getProcessMonitor().unlockUI(this.getProcessInfo());
        }
    }
}

