/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.IProcessParameterListener;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.IProcessParameter;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Div;
import org.zkoss.zul.Space;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.impl.XulElement;

public class ProcessParameterPanel
extends Panel
implements ValueChangeListener,
IProcessParameter,
EventListener<Event> {
    private static final long serialVersionUID = 2388338147222636369L;
    private int m_WindowNo;
    private ProcessInfo m_processInfo;
    private int m_AD_Window_ID = 0;
    private int m_InfoWindowID = 0;
    private static CLogger log = CLogger.getCLogger(ProcessParameterPanel.class);
    private ArrayList<WEditor> m_wEditors = new ArrayList();
    private ArrayList<WEditor> m_wEditors2 = new ArrayList();
    private ArrayList<GridField> m_mFields = new ArrayList();
    private ArrayList<GridField> m_mFields2 = new ArrayList();
    private ArrayList<Space> m_separators = new ArrayList();
    private Grid centerPanel = null;

    public ProcessParameterPanel(int WindowNo, ProcessInfo pi) {
        this.m_WindowNo = WindowNo;
        this.m_processInfo = pi;
        this.m_AD_Window_ID = AEnv.getADWindowID(WindowNo);
        this.m_InfoWindowID = pi.getAD_InfoWindow_ID();
        this.initComponent();
        this.addEventListener("onDynamicDisplay", this);
        this.addEventListener("onPostEditorValueChange", this);
    }

    private void initComponent() {
        this.centerPanel = GridFactory.newGridLayout();
        this.appendChild((Component)this.centerPanel);
        Columns columns = new Columns();
        this.centerPanel.appendChild((Component)columns);
        Column col = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "30%");
        columns.appendChild((Component)col);
        col = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "70%");
        columns.appendChild((Component)col);
    }

    public void dispose() {
        this.m_wEditors.clear();
        this.m_wEditors2.clear();
        this.m_mFields.clear();
        this.m_mFields2.clear();
    }

    public boolean init() {
        Rows rows;
        boolean hasFields;
        block10: {
            log.config("");
            MClient client = MClient.get((Properties)Env.getCtx());
            String ASPFilter = "";
            if (client.isUseASP()) {
                ASPFilter = "   AND (   p.AD_Process_Para_ID not IN (               SELECT pp.AD_Process_Para_ID                 FROM ASP_Process_Para pp, ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND pp.ASP_Process_ID = p.ASP_Process_ID " + "                 AND pp.IsActive = 'Y' " + "                 AND p.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "\t\t\t\t\tAND p.ad_process_ID=" + this.m_processInfo.getAD_Process_ID() + "                 AND pp.ASP_Status = 'H' " + "\t\t\t\t\tAND pp.AD_Process_Para_ID not in (" + " \t\t\t\t\tSELECT AD_Process_Para_ID" + " \t\t\t\t\tFROM ASP_ClientException ce" + " \t\t\t\t\tWHERE ce.AD_Client_ID =" + client.getAD_Client_ID() + " \t\t\t\t\tAND ce.IsActive = 'Y'" + " \t\t\t\t\tAND ce.AD_Process_Para_ID IS NOT NULL" + " \t\t\t\t\tAND ce.AD_Tab_ID IS NULL" + " \t\t\t\t\tAND ce.AD_Field_ID IS NULL" + " \t\t\t\t\tAND ce.ASP_Status in('S','U') )  " + "  UNION ALL " + "          SELECT AD_Process_Para_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Process_Para_ID IS NOT NULL " + "             AND ce.AD_Tab_ID IS NULL " + "\t\t\t\tAND ce.AD_Process_Para_ID=" + this.m_processInfo.getAD_Process_ID() + "             AND ce.AD_Field_ID IS NULL " + "             AND ce.ASP_Status = 'H'))";
            }
            String sql = null;
            sql = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Process_Para") ? "SELECT p.Name, p.Description, p.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic, p.IsEncrypted, NULL AS FormatPattern, p.MandatoryLogic, p.Placeholder, p.Placeholder2 FROM AD_Process_Para p LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo" : "SELECT t.Name, t.Description, t.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic, p.IsEncrypted, NULL AS FormatPattern,p.MandatoryLogic, t.Placeholder, t.Placeholder2 FROM AD_Process_Para p INNER JOIN AD_Process_Para_Trl t ON (p.AD_Process_Para_ID=t.AD_Process_Para_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND t.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "'" + " AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo";
            hasFields = false;
            rows = new Rows();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_processInfo.getAD_Process_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        hasFields = true;
                        this.createField(rs, rows);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.m_mFields.size() != this.m_mFields2.size() || this.m_mFields.size() != this.m_wEditors.size() || this.m_mFields2.size() != this.m_wEditors2.size()) {
            log.log(Level.SEVERE, "View & Model vector size is different");
        }
        if (hasFields) {
            this.centerPanel.appendChild((Component)rows);
            this.dynamicDisplay();
        } else {
            this.dispose();
        }
        return hasFields;
    }

    private void createField(ResultSet rs, Rows rows) {
        GridFieldVO voF = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)this.m_processInfo.getAD_Process_ID(), (int)this.m_AD_Window_ID, (int)this.m_InfoWindowID, (ResultSet)rs);
        GridField mField = new GridField(voF);
        this.m_mFields.add(mField);
        Row row = new Row();
        WEditor editor = WebEditorFactory.getEditor(mField, false);
        editor.setProcessParameter(true);
        editor.getComponent().addEventListener("onFocus", (EventListener)this);
        editor.addValueChangeListener(this);
        editor.dynamicDisplay();
        mField.addPropertyChangeListener((PropertyChangeListener)editor);
        Object defaultObject = mField.getDefaultForPanel();
        mField.setValue(defaultObject, true);
        editor.fillHorizontal();
        WEditorPopupMenu popupMenu = editor.getPopupMenu();
        if (popupMenu != null) {
            popupMenu.addMenuListener((ContextMenuListener)((Object)editor));
            popupMenu.setId(String.valueOf(mField.getColumnName()) + "-popup");
            this.appendChild((Component)popupMenu);
            if (!mField.isFieldOnly()) {
                Label label = editor.getLabel();
                if (popupMenu.isZoomEnabled() && editor instanceof IZoomableEditor) {
                    label.addEventListener("onClick", new ZoomListener((IZoomableEditor)((Object)editor)));
                }
                popupMenu.addContextElement((XulElement)label);
                if (editor.getComponent() instanceof XulElement) {
                    popupMenu.addContextElement((XulElement)editor.getComponent());
                }
            }
        }
        this.m_wEditors.add(editor);
        Div div = new Div();
        div.setStyle("text-align: right;");
        Label label = editor.getLabel();
        div.appendChild((Component)label);
        if (label.getDecorator() != null) {
            div.appendChild(label.getDecorator());
        }
        row.appendChild((Component)div);
        if (voF.isRange) {
            Div box = new Div();
            box.setStyle("display: flex; align-items: center;");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)box, "100%");
            box.appendChild(editor.getComponent());
            ZKUpdateUtil.setWidth((HtmlBasedComponent)editor.getComponent(), "49%");
            GridFieldVO voF2 = GridFieldVO.createParameter((GridFieldVO)voF);
            GridField mField2 = new GridField(voF2);
            this.m_mFields2.add(mField2);
            WEditor editor2 = WebEditorFactory.getEditor(mField2, false);
            editor2.setProcessParameter(true);
            editor2.getComponent().setClientAttribute("columnName", String.valueOf(mField2.getColumnName()) + "_To");
            editor2.getComponent().addEventListener("onFocus", (EventListener)this);
            mField2.addPropertyChangeListener((PropertyChangeListener)editor2);
            editor2.dynamicDisplay();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)editor2.getComponent(), "49%");
            this.setEditorPlaceHolder(editor2, mField2.getPlaceholder2());
            popupMenu = editor2.getPopupMenu();
            if (popupMenu != null) {
                popupMenu.addMenuListener((ContextMenuListener)((Object)editor2));
                this.appendChild((Component)popupMenu);
            }
            Object defaultObject2 = mField2.getDefaultForPanel();
            mField2.setValue(defaultObject2, true);
            this.m_wEditors2.add(editor2);
            Space separator = new Space();
            separator.setStyle("margin:0; width: 2%;");
            this.m_separators.add(separator);
            box.appendChild((Component)separator);
            box.appendChild(editor2.getComponent());
            row.appendChild((Component)box);
        } else {
            row.appendChild(editor.getComponent());
            this.m_mFields2.add(null);
            this.m_wEditors2.add(null);
            this.m_separators.add(null);
        }
        rows.appendChild((Component)row);
    }

    private void setEditorPlaceHolder(WEditor editor, String msg) {
        Component c = editor.getComponent();
        if (c instanceof InputElement) {
            ((InputElement)c).setPlaceholder(msg);
        } else {
            for (Component e : c.getChildren()) {
                if (!(e instanceof InputElement)) continue;
                ((InputElement)e).setPlaceholder(msg);
                break;
            }
        }
    }

    public boolean validateParameters() {
        log.config("");
        StringBuilder sb = new StringBuilder();
        int size = this.m_mFields.size();
        int i = 0;
        while (i < size) {
            GridField field = this.m_mFields.get(i);
            if (field.isMandatory(true)) {
                WEditor wEditor2;
                WEditor wEditor = this.m_wEditors.get(i);
                Object data = wEditor.getValue();
                if (data == null || data.toString().length() == 0) {
                    field.setInserting(true);
                    field.setError(true);
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(field.getHeader());
                    if (this.m_wEditors2.get(i) != null) {
                        sb.append(" (").append(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessParameterRangeFrom")).append(")");
                    }
                } else {
                    field.setError(false);
                }
                if ((wEditor2 = this.m_wEditors2.get(i)) != null) {
                    Object data2 = wEditor2.getValue();
                    GridField field2 = this.m_mFields2.get(i);
                    if (data2 == null || data2.toString().length() == 0) {
                        field2.setInserting(true);
                        field2.setError(true);
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(field2.getHeader());
                        sb.append(" (").append(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessParameterRangeTo")).append(")");
                    } else {
                        field2.setError(false);
                    }
                }
            }
            ++i;
        }
        if (sb.length() != 0) {
            FDialog.error(this.m_WindowNo, (Component)this, "FillMandatory", sb.toString());
            return false;
        }
        if (this.m_processInfo.getAD_Process_ID() > 0) {
            String className = MProcess.get((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_Process_ID()).getClassname();
            List<IProcessParameterListener> listeners = Extensions.getProcessParameterListeners(className, null);
            for (IProcessParameterListener listener : listeners) {
                String error = listener.validate(this);
                if (Util.isEmpty((String)error)) continue;
                FDialog.error(this.m_WindowNo, (Component)this, error);
                return false;
            }
        }
        return true;
    }

    public boolean loadParameters(MPInstance instance) {
        log.config("");
        MPInstancePara[] params = instance.getParameters();
        int j = 0;
        while (j < this.m_mFields.size()) {
            GridField mField = this.m_mFields.get(j);
            if (mField.isEditablePara(true)) {
                WEditor editor = this.m_wEditors.get(j);
                WEditor editor2 = this.m_wEditors2.get(j);
                editor.setValue(null);
                if (editor2 != null) {
                    editor2.setValue(null);
                }
                int i = 0;
                while (i < params.length) {
                    MPInstancePara para = params[i];
                    if (mField.getColumnName().equals(para.getParameterName())) {
                        if (para.getP_Date() != null || para.getP_Date_To() != null) {
                            editor.setValue(para.getP_Date());
                            if (editor2 != null) {
                                editor2.setValue(para.getP_Date_To());
                            }
                        } else if (para.getP_String() != null || para.getP_String_To() != null) {
                            editor.setValue(para.getP_String());
                            if (editor2 != null) {
                                editor2.setValue(para.getP_String_To());
                            }
                        } else if (!Env.ZERO.equals(para.getP_Number()) || !Env.ZERO.equals(para.getP_Number_To())) {
                            if (DisplayType.isID((int)para.getDisplayType())) {
                                editor.setValue(para.getP_Number().intValue());
                                if (editor2 != null) {
                                    editor2.setValue(para.getP_Number_To().intValue());
                                }
                            } else {
                                editor.setValue(para.getP_Number());
                                if (editor2 != null) {
                                    editor2.setValue(para.getP_Number_To());
                                }
                            }
                        }
                        if (editor.getValue() != null) {
                            ValueChangeEvent changeEvent = new ValueChangeEvent(editor, editor.getColumnName(), null, editor.getValue());
                            this.valueChange(changeEvent);
                        }
                        log.fine(para.toString());
                        break;
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.dynamicDisplay();
        return true;
    }

    public boolean saveParameters() {
        log.config("");
        if (!this.validateParameters()) {
            return false;
        }
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            MPInstancePara para = MPInstancePara.getOrCreate((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_PInstance_ID(), (int)i);
            GridField mField = this.m_mFields.get(i);
            para.setParameterName(mField.getColumnName());
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                if (result instanceof Timestamp) {
                    para.setP_Date((Timestamp)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof Timestamp) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null && result instanceof Integer) {
                    ii = (Integer)result;
                    para.setP_Number(ii.intValue());
                }
                if (editor2 != null && result2 != null && result2 instanceof Integer) {
                    ii = (Integer)result2;
                    para.setP_Number_To(ii.intValue());
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                if (result instanceof BigDecimal) {
                    para.setP_Number((BigDecimal)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof BigDecimal) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (editor2 != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(editor.getDisplay());
            if (editor2 != null) {
                para.setInfo_To(editor2.getDisplay());
            }
            para.saveEx();
            if (log.isLoggable(Level.FINE)) {
                log.fine(para.toString());
            }
            ++i;
        }
        return true;
    }

    public MPInstancePara[] getParameters() {
        log.config("");
        if (!this.validateParameters()) {
            return new MPInstancePara[0];
        }
        ArrayList<MPInstancePara> paras = new ArrayList<MPInstancePara>();
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            MPInstancePara para = new MPInstancePara(Env.getCtx(), 0, i);
            GridField mField = this.m_mFields.get(i);
            para.setParameterName(mField.getColumnName());
            para.setP_Date(null);
            para.setP_Date_To(null);
            para.setP_Number(null);
            para.setP_Number_To(null);
            para.setP_String(null);
            para.setP_String_To(null);
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                if (result instanceof Timestamp) {
                    para.setP_Date((Timestamp)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof Timestamp) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null && result instanceof Integer) {
                    ii = (Integer)result;
                    para.setP_Number(ii.intValue());
                }
                if (editor2 != null && result2 != null && result2 instanceof Integer) {
                    ii = (Integer)result2;
                    para.setP_Number_To(ii.intValue());
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                if (result instanceof BigDecimal) {
                    para.setP_Number((BigDecimal)result);
                }
                if (editor2 != null && result2 != null && result2 instanceof BigDecimal) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (editor2 != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(editor.getDisplay());
            if (editor2 != null) {
                para.setInfo_To(editor2.getDisplay());
            }
            paras.add(para);
            ++i;
        }
        return paras.toArray(new MPInstancePara[0]);
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        if (evt.getSource() instanceof WEditor) {
            GridField changedField = ((WEditor)evt.getSource()).getGridField();
            if (changedField != null) {
                this.processDependencies(changedField);
            }
            Events.postEvent((String)"onPostEditorValueChange", (Component)this, (Object)evt.getSource());
        }
        this.processNewValue(evt.getNewValue(), evt.getPropertyName());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onFocus")) {
            for (WEditor editor : this.m_wEditors) {
                if (!editor.isComponentOfEditor(event.getTarget())) continue;
                SessionManager.getAppDesktop().updateHelpTooltip(editor.getGridField());
                return;
            }
            for (WEditor editor : this.m_wEditors2) {
                if (editor == null || editor.getComponent() == null || !editor.isComponentOfEditor(event.getTarget())) continue;
                SessionManager.getAppDesktop().updateHelpTooltip(editor.getGridField());
                return;
            }
        } else if (event.getName().equals("onDynamicDisplay")) {
            this.dynamicDisplay();
        } else if (event.getName().equals("onPostEditorValueChange")) {
            this.onPostEditorValueChange((WEditor)event.getData());
        }
    }

    private void onPostEditorValueChange(WEditor editor) {
        if (this.m_processInfo.getAD_Process_ID() > 0) {
            String className = MProcess.get((Properties)Env.getCtx(), (int)this.m_processInfo.getAD_Process_ID()).getClassname();
            List<IProcessParameterListener> listeners = Extensions.getProcessParameterListeners(className, editor.getColumnName());
            for (IProcessParameterListener listener : listeners) {
                listener.onChange(this, editor.getColumnName(), editor);
            }
        }
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getColumnName();
        for (GridField field : this.m_mFields) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
        for (GridField field : this.m_mFields2) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
    }

    private void verifyChangedField(GridField field, String columnName) {
        MLookup mLookup;
        ArrayList list = field.getDependentOn();
        if (list.contains(columnName) && field.getLookup() instanceof MLookup && (mLookup = (MLookup)field.getLookup()).getValidation().indexOf("@" + columnName + "@") != -1) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(columnName) + " changed - " + field.getColumnName() + " set to null");
            }
            field.setValue(null, true);
        }
    }

    private void processNewValue(Object value, String name) {
        if (value == null) {
            value = new String("");
        }
        if (value instanceof String) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (String)((String)value));
        } else if (value instanceof Integer) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (int)((Integer)value));
        } else if (value instanceof Boolean) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (boolean)((Boolean)value));
        } else if (value instanceof Timestamp) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (Timestamp)((Timestamp)value));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)name, (String)value.toString());
        }
        Events.postEvent((String)"onDynamicDisplay", (Component)this, null);
    }

    private void dynamicDisplay() {
        int i = 0;
        while (i < this.m_wEditors.size()) {
            WEditor editor = this.m_wEditors.get(i);
            GridField mField = editor.getGridField();
            if (mField.isDisplayed(true)) {
                if (!editor.isVisible()) {
                    editor.setVisible(true);
                    if (mField.getVO().isRange) {
                        this.m_separators.get(i).setVisible(true);
                        this.m_wEditors2.get(i).setVisible(true);
                    }
                }
                boolean rw = mField.isEditablePara(true);
                editor.setReadWrite(rw);
                editor.dynamicDisplay();
                if (mField.getVO().isRange) {
                    this.m_wEditors2.get(i).setReadWrite(rw);
                    this.m_wEditors2.get(i).dynamicDisplay();
                }
            } else if (editor.isVisible()) {
                editor.setVisible(false);
                if (mField.getVO().isRange) {
                    this.m_separators.get(i).setVisible(false);
                    this.m_wEditors2.get(i).setVisible(false);
                }
            }
            editor.setMandatory(mField.isMandatory(true));
            editor.updateStyle();
            ++i;
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    protected void restoreContext() {
        for (GridField f : this.m_mFields) {
            if (f == null) continue;
            f.restoreValue();
        }
        for (GridField f : this.m_mFields2) {
            if (f == null) continue;
            f.restoreValue();
        }
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.m_processInfo = processInfo;
    }

    public boolean focusToFirstEditor() {
        if (this.m_wEditors.isEmpty()) {
            return false;
        }
        for (WEditor editor : this.m_wEditors) {
            if (!editor.isVisible()) continue;
            this.focusToEditor(editor);
            return true;
        }
        return false;
    }

    private void focusToEditor(WEditor toFocus) {
        Object c = toFocus.getComponent();
        if (c instanceof EditorBox) {
            c = ((EditorBox)((Object)c)).getTextbox();
        } else if (c instanceof NumberBox) {
            c = ((NumberBox)((Object)c)).getDecimalbox();
        } else if (c instanceof Urlbox) {
            c = ((Urlbox)((Object)c)).getTextbox();
        }
        ((HtmlBasedComponent)c).focus();
    }

    public WEditor getEditor(String columnName) {
        int i = 0;
        while (i < this.m_mFields.size()) {
            if (this.m_mFields.get(i).getColumnName().equals(columnName)) {
                return this.m_wEditors.get(i);
            }
            ++i;
        }
        return null;
    }

    public WEditor getEditorTo(String columnName) {
        int i = 0;
        while (i < this.m_mFields.size()) {
            if (this.m_mFields.get(i).getColumnName().equals(columnName)) {
                return this.m_wEditors2.get(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isWaitingForDialog() {
        int i = 0;
        while (i < this.m_mFields.size()) {
            WEditor editor = this.m_wEditors.get(i);
            WEditor editor2 = this.m_wEditors2.get(i);
            if (editor != null && editor instanceof WSearchEditor ? ((WSearchEditor)editor).isShowingDialog() : editor2 != null && editor2 instanceof WSearchEditor && ((WSearchEditor)editor2).isShowingDialog()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class ZoomListener
    implements EventListener<Event> {
        private IZoomableEditor searchEditor;

        ZoomListener(IZoomableEditor editor) {
            this.searchEditor = editor;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                this.searchEditor.actionZoom();
            }
        }
    }
}

