/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AbstractProcessDialog;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;

public class ProcessModalDialog
extends AbstractProcessDialog
implements EventListener<Event>,
DialogEvents {
    private static final long serialVersionUID = -6227339628038418701L;
    private static final String ON_OK_ECHO = "onOkEcho";
    private static CLogger log = CLogger.getCLogger(ProcessModalDialog.class);
    private String orientation;

    public ProcessModalDialog(int WindowNo, ProcessInfo pi, boolean autoStart) {
        this(null, WindowNo, pi, autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, ProcessInfo pi, boolean autoStart) {
        if (listener != null) {
            this.addEventListener("onWindowClose", listener);
            this.addEventListener("onBeforeRunProcess", listener);
        }
        log.info("Process=" + pi.getAD_Process_ID());
        try {
            this.init(Env.getCtx(), WindowNo, pi.getAD_Process_ID(), pi, autoStart, true);
            if (this.mainParameterLayout != null) {
                this.mainParameterLayout.setStyle("max-height:" + ClientInfo.get().desktopHeight + "px");
                ZKUpdateUtil.setVflex(this.mainParameterLayout, "1");
            }
            if (this.topParameterLayout != null) {
                this.topParameterLayout.setStyle("max-height:" + (ClientInfo.get().desktopHeight - 130) + "px");
            }
            if (this.bottomParameterLayout != null) {
                for (Component c : this.bottomParameterLayout.getChildren()) {
                    if (!(c instanceof HtmlBasedComponent)) continue;
                    ZKUpdateUtil.setVflex((HtmlBasedComponent)c, "min");
                }
            }
            this.setSclass("popup-dialog process-modal-dialog");
            if (ClientInfo.isMobile()) {
                this.orientation = ClientInfo.get().orientation;
                ClientInfo.onClientInfo((Component)this, this::onClientInfo);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.addEventListener(ON_OK_ECHO, this);
    }

    public ProcessModalDialog(int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(null, WindowNo, AD_Process_ID, tableId, recordId, autoStart);
    }

    public ProcessModalDialog(EventListener<Event> listener, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(listener, WindowNo, new ProcessInfo("", AD_Process_ID, tableId, recordId), autoStart);
    }

    public ProcessModalDialog(Window parent, String title, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(WindowNo, AD_Process_ID, tableId, recordId, autoStart);
    }

    public boolean setVisible(boolean visible) {
        return super.setVisible(visible);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getParameterPanel().restoreContext();
        this.detach();
    }

    @Override
    public void showBusyDialog() {
        BusyDialog progressWindow = this.createBusyDialog();
        if (this.getParent() != null) {
            this.getParent().appendChild((Component)progressWindow);
            LayoutUtils.openOverlappedWindow(this.getParent(), progressWindow, "middle_center");
        }
        this.setVisible(false);
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void hideBusyDialog() {
        this.closeBusyDialog();
    }

    @Override
    public void onEvent(Event event) {
        Component component = event.getTarget();
        if (component.equals((Object)this.bOK)) {
            super.onEvent(event);
            this.onOk();
        } else if (event.getName().equals(ON_OK_ECHO)) {
            this.onOk();
        } else if (component.equals((Object)this.bCancel)) {
            super.onEvent(event);
            this.cancelProcess();
        } else {
            super.onEvent(event);
        }
    }

    private void onOk() {
        if (this.getParameterPanel().isWaitingForDialog()) {
            Events.echoEvent((String)ON_OK_ECHO, (Component)this, null);
            return;
        }
        this.startProcess();
    }

    protected void onClientInfo() {
        String newOrientation;
        if (this.getPage() != null && !(newOrientation = ClientInfo.get().orientation).equals(this.orientation)) {
            this.orientation = newOrientation;
            if (this.mainParameterLayout != null) {
                this.mainParameterLayout.setStyle("max-height:" + ClientInfo.get().desktopHeight + "px");
            }
            if (this.topParameterLayout != null) {
                this.topParameterLayout.setStyle("max-height:" + (ClientInfo.get().desktopHeight - 130) + "px");
            }
            this.invalidate();
        }
    }
}

