/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.AbstractProcessDialog;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.component.DocumentLink;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.process.WProcessInfo;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.Vlayout;

public class ProcessDialog
extends AbstractProcessDialog
implements EventListener<Event>,
IHelpContext {
    private static final long serialVersionUID = -6728929130788829223L;
    public static final String ON_INITIAL_FOCUS_EVENT = "onInitialFocus";
    private static final String ON_OK_ECHO = "onOkEcho";
    private static CLogger log = CLogger.getCLogger(ProcessDialog.class);
    private Table logMessageTable;
    private int[] m_ids = null;
    private boolean isParameterPage = true;
    private Mask mask;
    private HtmlBasedComponent resultPanelLayout;
    private HtmlBasedComponent messageResultContent;
    private HtmlBasedComponent infoResultContent;
    private int m_WindowNo = -1;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;

    public ProcessDialog(int AD_Process_ID, boolean isSOTrx) {
        log.info("Process=" + AD_Process_ID);
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.setAttribute("desktop.windowno", this.m_WindowNo);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)(isSOTrx ? "Y" : "N"));
        try {
            this.init(Env.getCtx(), this.m_WindowNo, AD_Process_ID, null, false, false);
            this.querySaved();
            this.addEventListener("onWindowContainerSelectionChanged", this);
            this.addEventListener(ON_INITIAL_FOCUS_EVENT, this);
            this.addEventListener(ON_OK_ECHO, this);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        try {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setVisible(boolean visible) {
        return super.setVisible(visible);
    }

    @Override
    public void dispose() {
        super.dispose();
        SessionManager.getAppDesktop().closeWindow(this.getWindowNo());
    }

    @Override
    public void onEvent(Event event) {
        Component component = event.getTarget();
        if (component instanceof A && event.getName().equals("onClick")) {
            this.doOnClick((A)component);
        } else if (this.bOK.equals(component)) {
            super.onEvent(event);
            this.onOk();
        } else if (event.getName().equals(ON_OK_ECHO)) {
            this.onOk();
        } else if (this.bCancel.equals(component)) {
            super.onEvent(event);
            this.cancelProcess();
        } else if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("P", this.getAD_Process_ID());
        } else if (event.getName().equals(ON_INITIAL_FOCUS_EVENT)) {
            if (!this.isUILocked() && !this.getParameterPanel().focusToFirstEditor()) {
                this.bOK.focus();
            }
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        } else {
            super.onEvent(event);
        }
    }

    private void onOk() {
        if (this.isParameterPage) {
            if (this.getParameterPanel().isWaitingForDialog()) {
                Events.echoEvent((String)ON_OK_ECHO, (Component)this, null);
                return;
            }
            this.startProcess();
        } else {
            this.restart();
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 && this.m_WindowNo > 0) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            SessionManager.getAppDesktop().closeWindow(this.m_WindowNo);
        }
    }

    private void doOnClick(A btn) {
        int Record_ID = 0;
        int AD_Table_ID = 0;
        try {
            Record_ID = Integer.valueOf((String)btn.getAttribute("Record_ID"));
            AD_Table_ID = Integer.valueOf((String)btn.getAttribute("AD_Table_ID"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Record_ID > 0 && AD_Table_ID > 0) {
            AEnv.zoom(AD_Table_ID, Record_ID);
        }
    }

    @Override
    public void showBusyDialog() {
        BusyDialog progressWindow = this.createBusyDialog();
        progressWindow.setStyle("position: absolute;");
        this.showBusyMask(progressWindow);
        LayoutUtils.openOverlappedWindow((Component)this, progressWindow, "middle_center");
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    private void showBusyMask(Window window) {
        if (this.getParent() != null) {
            this.getParent().appendChild((Component)this.getMask());
            StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
            script.append(this.getParent().getUuid()).append("');");
            if (window != null) {
                script.append("var d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
            } else {
                script.append("w.busy=true;");
            }
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    private void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
            StringBuilder script = new StringBuilder("var w=zk.Widget.$('#");
            script.append(this.getParent().getUuid()).append("');w.busy=false;");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    @Override
    public void hideBusyDialog() {
        this.hideBusyMask();
        this.closeBusyDialog();
    }

    @Override
    public void updateUI() {
        this.swithToFinishScreen();
    }

    protected void swithToFinishScreen() {
        ProcessInfo pi = this.getProcessInfo();
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        this.layoutResultPanel(this.topParameterLayout);
        StringBuilder buildMsg = new StringBuilder(this.getInitialMessage());
        buildMsg.append("<hr><p><font color=\"").append(pi.isError() ? "#FF0000" : "#0000FF").append("\">** ").append(pi.getSummary()).append("</font></p>");
        ((Html)this.messageResultContent).setContent(buildMsg.toString());
        this.infoResultContent.getChildren().removeAll(this.infoResultContent.getChildren());
        this.appendRecordLogInfo(pi.getLogs(), this.infoResultContent);
        this.bOK.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Parameter"));
        this.bOK.setImage(ThemeManager.getThemeResource("images/Reset16.png"));
        this.bOK.setDisabled(false);
        this.bCancel.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Close"));
        this.bCancel.setImage(ThemeManager.getThemeResource("images/Cancel16.png"));
        this.bCancel.setDisabled(false);
        this.isParameterPage = false;
        this.m_ids = pi.getIDs();
        this.replaceComponent(this.resultPanelLayout, this.topParameterLayout);
        this.invalidate();
        Clients.response((AuResponse)new AuEcho((Component)this, "onAfterProcess", null));
    }

    private void layoutResultPanel(HtmlBasedComponent topParameterLayout) {
        if (this.resultPanelLayout == null) {
            this.resultPanelLayout = new Vlayout();
            this.resultPanelLayout.setSclass("result-parameter-layout");
            ZKUpdateUtil.setVflex(this.resultPanelLayout, "true");
            this.messageResultContent = this.setHeadMessage(this.resultPanelLayout, null);
            this.infoResultContent = new Div();
            this.resultPanelLayout.appendChild((Component)this.infoResultContent);
        }
    }

    protected void replaceComponent(HtmlBasedComponent newComponent, HtmlBasedComponent oldComponent) {
        oldComponent.getParent().insertBefore((Component)newComponent, (Component)oldComponent);
        oldComponent.detach();
    }

    private void appendRecordLogInfo(ProcessInfoLog[] m_logs, HtmlBasedComponent infoResultContent) {
        if (m_logs == null) {
            return;
        }
        SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)15);
        this.logMessageTable = new Table();
        this.logMessageTable.setId("logrecords");
        this.logMessageTable.setDynamicProperty("border", (Object)"1");
        this.logMessageTable.setDynamicProperty("cellpadding", (Object)"0");
        this.logMessageTable.setDynamicProperty("cellspacing", (Object)"0");
        this.logMessageTable.setDynamicProperty("width", (Object)"100%");
        infoResultContent.appendChild((Component)this.logMessageTable);
        boolean datePresents = false;
        boolean numberPresents = false;
        boolean msgPresents = false;
        ProcessInfoLog[] processInfoLogArray = m_logs;
        int n = m_logs.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoLog log = processInfoLogArray[n2];
            if (log.getP_Date() != null) {
                datePresents = true;
            }
            if (log.getP_Number() != null) {
                numberPresents = true;
            }
            if (log.getP_Msg() != null) {
                msgPresents = true;
            }
            ++n2;
        }
        int i = 0;
        while (i < m_logs.length) {
            Td td2;
            Tr tr2 = new Tr();
            this.logMessageTable.appendChild((Component)tr2);
            ProcessInfoLog log = m_logs[i];
            if (datePresents) {
                td2 = new Td();
                if (log.getP_Date() != null) {
                    Label label = new Label(dateFormat.format(log.getP_Date()));
                    td2.appendChild((Component)label);
                }
                tr2.appendChild((Component)td2);
            }
            if (numberPresents) {
                td2 = new Td();
                if (log.getP_Number() != null) {
                    Label labelPno = new Label("" + log.getP_Number());
                    td2.appendChild((Component)labelPno);
                }
                tr2.appendChild((Component)td2);
            }
            if (msgPresents) {
                td2 = new Td();
                if (log.getP_Msg() != null) {
                    if (log.getAD_Table_ID() > 0 && log.getRecord_ID() > 0) {
                        DocumentLink recordLink = new DocumentLink(log.getP_Msg(), log.getAD_Table_ID(), log.getRecord_ID());
                        td2.appendChild((Component)recordLink);
                    } else {
                        Text t = new Text();
                        t.setEncode(false);
                        t.setValue(log.getP_Msg());
                        td2.appendChild((Component)t);
                    }
                }
                tr2.appendChild((Component)td2);
            }
            ++i;
        }
    }

    private void restart() {
        this.replaceComponent(this.topParameterLayout, this.resultPanelLayout);
        this.isParameterPage = true;
        this.bOK.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Start"));
        this.bOK.setImage(ThemeManager.getThemeResource("images/Ok16.png"));
        this.bCancel.setLabel(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"Cancel")));
        this.bCancel.setImage(ThemeManager.getThemeResource("images/Cancel16.png"));
        WProcessInfo m_pi = new WProcessInfo(this.getName(), this.getAD_Process_ID());
        m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.setProcessInfo(m_pi);
        this.getParameterPanel().setProcessInfo(m_pi);
        this.m_ids = null;
        if (this.fSavedName != null) {
            this.querySaved();
        }
        this.invalidate();
    }

    public void onAfterProcess() {
        if (!this.afterProcessTask() && this.getShowHelp() != null && "S".equals(this.getShowHelp())) {
            this.dispose();
        }
    }

    private boolean afterProcessTask() {
        if (this.m_ids != null && this.m_ids.length > 0) {
            log.config("");
            if (this.getAD_Process_ID() == 119) {
                this.printInvoices();
                return true;
            }
            if (this.getAD_Process_ID() == 118) {
                this.printShipments();
                return true;
            }
            return false;
        }
        return false;
    }

    private void printShipments() {
        if (this.m_ids == null) {
            return;
        }
        FDialog.ask(this.getWindowNo(), (Component)this, "PrintShipments", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    StringBuilder buildMsg = new StringBuilder(((Html)ProcessDialog.this.messageResultContent).getContent());
                    buildMsg.append("<p>").append(Msg.getMsg((Properties)Env.getCtx(), (String)"PrintShipments")).append("</p>");
                    ((Html)ProcessDialog.this.messageResultContent).setContent(buildMsg.toString());
                    ProcessDialog.this.showBusyDialog();
                    Clients.response((AuResponse)new AuEcho((Component)ProcessDialog.this, "onPrintShipments", null));
                }
            }
        });
    }

    public void onPrintShipments() {
        block15: {
            ArrayList<File> pdfList = new ArrayList<File>();
            int i = 0;
            while (i < this.m_ids.length) {
                int M_InOut_ID = this.m_ids[i];
                ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)1, (int)M_InOut_ID);
                pdfList.add(re.getPDF());
                ++i;
            }
            if (pdfList.size() > 1) {
                try {
                    try {
                        File outFile = File.createTempFile("PrintShipments", ".pdf");
                        Document document = null;
                        PdfWriter copy = null;
                        for (File f : pdfList) {
                            String fileName = f.getAbsolutePath();
                            PdfReader reader = new PdfReader(fileName);
                            reader.consolidateNamedDestinations();
                            if (document == null) {
                                document = new Document(reader.getPageSizeWithRotation(1));
                                copy = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outFile));
                                document.open();
                            }
                            int pages = reader.getNumberOfPages();
                            PdfContentByte cb = copy.getDirectContent();
                            int i2 = 1;
                            while (i2 <= pages) {
                                document.newPage();
                                PdfImportedPage page = copy.getImportedPage(reader, i2);
                                cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                                ++i2;
                            }
                        }
                        document.close();
                        this.hideBusyDialog();
                        SimplePDFViewer win = new SimplePDFViewer(this.getProcessInfo().getTitle(), new FileInputStream(outFile));
                        SessionManager.getAppDesktop().showWindow(win, "center");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                        this.hideBusyDialog();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    this.hideBusyDialog();
                    throw throwable;
                }
                this.hideBusyDialog();
            } else if (pdfList.size() > 0) {
                this.hideBusyDialog();
                try {
                    SimplePDFViewer win = new SimplePDFViewer(this.getProcessInfo().getTitle(), new FileInputStream((File)pdfList.get(0)));
                    SessionManager.getAppDesktop().showWindow(win, "center");
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (this.getShowHelp() != null && "S".equals(this.getShowHelp())) {
            this.dispose();
        }
    }

    private void printInvoices() {
        if (this.m_ids == null) {
            return;
        }
        FDialog.ask(this.getWindowNo(), (Component)this, "PrintInvoices", new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    StringBuilder buildMsg = new StringBuilder(((Html)ProcessDialog.this.messageResultContent).getContent());
                    buildMsg.append("<p>").append(Msg.getMsg((Properties)Env.getCtx(), (String)"PrintInvoices")).append("</p>");
                    ((Html)ProcessDialog.this.messageResultContent).setContent(buildMsg.toString());
                    ProcessDialog.this.showBusyDialog();
                    Clients.response((AuResponse)new AuEcho((Component)ProcessDialog.this, "onPrintInvoices", null));
                }
            }
        });
    }

    public void onPrintInvoices() {
        block15: {
            ArrayList<File> pdfList = new ArrayList<File>();
            int i = 0;
            while (i < this.m_ids.length) {
                int C_Invoice_ID = this.m_ids[i];
                ReportEngine re = ReportEngine.get((Properties)Env.getCtx(), (int)2, (int)C_Invoice_ID);
                pdfList.add(re.getPDF());
                ++i;
            }
            if (pdfList.size() > 1) {
                try {
                    try {
                        File outFile = File.createTempFile("PrintInvoices", ".pdf");
                        Document document = null;
                        PdfWriter copy = null;
                        for (File f : pdfList) {
                            PdfReader reader = new PdfReader(f.getAbsolutePath());
                            if (document == null) {
                                document = new Document(reader.getPageSizeWithRotation(1));
                                copy = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outFile));
                                document.open();
                            }
                            PdfContentByte cb = copy.getDirectContent();
                            int pages = reader.getNumberOfPages();
                            int i2 = 1;
                            while (i2 <= pages) {
                                document.newPage();
                                PdfImportedPage page = copy.getImportedPage(reader, i2);
                                cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                                ++i2;
                            }
                        }
                        document.close();
                        this.hideBusyDialog();
                        SimplePDFViewer win = new SimplePDFViewer(this.getProcessInfo().getTitle(), new FileInputStream(outFile));
                        SessionManager.getAppDesktop().showWindow(win, "center");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                        this.hideBusyDialog();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    this.hideBusyDialog();
                    throw throwable;
                }
                this.hideBusyDialog();
            } else if (pdfList.size() > 0) {
                this.hideBusyDialog();
                try {
                    SimplePDFViewer win = new SimplePDFViewer(this.getProcessInfo().getTitle(), new FileInputStream((File)pdfList.get(0)));
                    SessionManager.getAppDesktop().showWindow(win, "center");
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (this.getShowHelp() != null && "S".equals(this.getShowHelp())) {
            this.dispose();
        }
    }
}

