/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.DocumentSearchController;
import org.adempiere.webui.apps.MenuItem;
import org.adempiere.webui.apps.MenuSearchController;
import org.adempiere.webui.component.Bandbox;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.util.DocumentSearch;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.Div;
import org.zkoss.zul.Textbox;

public class GlobalSearch
extends Div
implements EventListener<Event> {
    private static final String ON_ENTER_KEY = "onEnterKey";
    private static final String ON_POST_ENTER_KEY = "onPostEnterKey";
    private static final String ON_CREATE_ECHO = "onCreateEcho";
    private static final String ON_SEARCH = "onSearch";
    private static final String PREFIX_DOCUMENT_SEARCH = "/";
    private static final long serialVersionUID = -8793878697269469837L;
    private Bandbox bandbox;
    private MenuSearchController menuController;
    private DocumentSearchController docController;
    private Tabbox tabbox;

    public GlobalSearch(MenuSearchController menuController) {
        this.menuController = menuController;
        this.docController = new DocumentSearchController();
        this.init();
    }

    private void init() {
        this.bandbox = new Bandbox();
        this.bandbox.setSclass("global-search-box");
        this.appendChild((Component)this.bandbox);
        this.bandbox.setAutodrop(true);
        this.bandbox.addEventListener("onChanging", this);
        this.bandbox.addEventListener("onChange", this);
        this.bandbox.setCtrlKeys("#up#down");
        this.bandbox.addEventListener("onCtrlKey", this);
        Bandpopup popup = new Bandpopup();
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)popup, ClientInfo.get().desktopHeight - 50);
        this.bandbox.appendChild((Component)popup);
        this.tabbox = new Tabbox();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "true");
        this.tabbox.addEventListener("onSelect", this);
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        Tab tab = new Tab();
        tab.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Menu")));
        tabs.appendChild((Component)tab);
        Tabpanels tabPanels = new Tabpanels();
        this.tabbox.appendChild((Component)tabPanels);
        Tabpanel tabPanel = new Tabpanel();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)tabPanel, "true");
        tabPanel.setSclass("global-search-tabpanel");
        tabPanels.appendChild((Component)tabPanel);
        popup.appendChild((Component)this.tabbox);
        this.menuController.create((Component)tabPanel);
        tab = new Tab();
        tab.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"search")));
        tabs.appendChild((Component)tab);
        tabPanel = new Tabpanel();
        tabPanel.setSclass("global-search-tabpanel");
        tabPanels.appendChild((Component)tabPanel);
        this.docController.create((Component)tabPanel);
        this.addEventListener(ON_SEARCH, this);
        this.addEventListener(ON_CREATE_ECHO, this);
        this.bandbox.addEventListener(ON_ENTER_KEY, this);
        this.addEventListener(ON_POST_ENTER_KEY, this);
    }

    public void onEvent(Event event) throws Exception {
        if ("onChanging".equals(event.getName())) {
            InputEvent inputEvent = (InputEvent)event;
            String value = inputEvent.getValue();
            this.bandbox.setAttribute("last.onchanging", value);
            Events.postEvent((String)ON_SEARCH, (Component)this, (Object)value);
        } else if ("onChange".equals(event.getName())) {
            this.bandbox.removeAttribute("last.onchanging");
        } else if ("onCtrlKey".equals(event.getName())) {
            KeyEvent ke = (KeyEvent)event;
            if (ke.getKeyCode() == 38) {
                if (this.bandbox.getFirstChild().isVisible()) {
                    if (this.tabbox.getSelectedIndex() == 0) {
                        MenuItem selected = this.menuController.selectPrior();
                        if (selected != null) {
                            this.bandbox.setText(selected.getLabel());
                        }
                    } else {
                        DocumentSearchController.SearchResult selected = this.docController.selectPrior();
                        if (selected != null) {
                            this.bandbox.setText(selected.getLabel());
                        }
                    }
                }
            } else if (ke.getKeyCode() == 40 && this.bandbox.getFirstChild().isVisible()) {
                if (this.tabbox.getSelectedIndex() == 0) {
                    MenuItem selected = this.menuController.selectNext();
                    if (selected != null && !"...".equals(selected.getType())) {
                        this.bandbox.setText(selected.getLabel());
                    }
                } else {
                    DocumentSearchController.SearchResult selected = this.docController.selectNext();
                    if (selected != null) {
                        this.bandbox.setText(selected.getLabel());
                    }
                }
            }
        } else if (event.getName().equals(ON_SEARCH)) {
            String value = (String)event.getData();
            if (this.tabbox.getSelectedIndex() == 0) {
                this.menuController.search(value);
            } else {
                this.docController.search(value);
            }
            this.bandbox.focus();
        } else if (event.getName().equals(ON_CREATE_ECHO)) {
            StringBuilder script = new StringBuilder("jq('#").append(this.bandbox.getUuid()).append("').bind('keydown', function(e) {var code=e.keyCode||e.which;console.log(code);if(code==13){").append("var widget=zk.Widget.$(this);").append("var event=new zk.Event(widget,'").append(ON_ENTER_KEY).append("',{},{toServer:true});").append("zAu.send(event);").append("}});");
            Clients.evalJavaScript((String)script.toString());
        } else if (event.getName().equals(ON_ENTER_KEY)) {
            Clients.showBusy((Component)this.bandbox, null);
            Events.echoEvent((String)ON_POST_ENTER_KEY, (Component)this, null);
        } else if (event.getName().equals(ON_POST_ENTER_KEY)) {
            Clients.clearBusy((Component)this.bandbox);
            if (this.bandbox.getValue() != null && this.bandbox.getValue().startsWith(PREFIX_DOCUMENT_SEARCH)) {
                DocumentSearch search = new DocumentSearch();
                if (search.openDocumentsByDocumentNo(this.bandbox.getValue().substring(1))) {
                    this.bandbox.setText(null);
                }
            } else if (this.tabbox.getSelectedIndex() == 0) {
                this.menuController.onOk((Textbox)this.bandbox);
            } else {
                this.docController.onOk((Textbox)this.bandbox);
            }
        } else if (event.getName().equals("onSelect")) {
            String value = (String)this.bandbox.getAttribute("last.onchanging");
            if (value == null) {
                value = this.bandbox.getValue();
            }
            Events.postEvent((String)ON_SEARCH, (Component)this, (Object)value);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        Events.echoEvent((String)ON_CREATE_ECHO, (Component)this, null);
    }

    public void closePopup() {
        if (this.bandbox != null) {
            this.bandbox.close();
        }
    }

    public void onClientInfo() {
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this.bandbox.getDropdown(), ClientInfo.get().desktopHeight - 50);
    }
}

