/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletRequest;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.DesktopRunnable;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.IServerPushCallback;
import org.adempiere.webui.util.ServerPushTemplate;
import org.compiere.acct.Doc;
import org.compiere.model.GridWindowVO;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MZoomCondition;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public final class AEnv {
    public static final String LOCALE = "#Locale";
    private static int s_workflow_Window_ID = 0;
    private static CLogger log = CLogger.getCLogger(AEnv.class);
    private static Map<String, CCache<Integer, GridWindowVO>> windowCache = new HashMap<String, CCache<Integer, GridWindowVO>>();
    private static String m_ApplicationUrl = null;

    public static void showCenterScreen(Window window) {
        if (SessionManager.getAppDesktop() != null) {
            SessionManager.getAppDesktop().showWindow(window, "center");
        } else {
            String mode;
            window.setPosition("center");
            window.setPage(AEnv.getDesktop().getFirstPage());
            Object objMode = window.getAttribute("mode");
            String string = mode = objMode != null ? objMode.toString() : "highlighted";
            if ("modal".equals(mode)) {
                window.doModal();
            } else {
                window.doHighlighted();
            }
        }
    }

    public static void showScreen(Window window, String position) {
        SessionManager.getAppDesktop().showWindow(window, position);
    }

    public static void showCenterWindow(Window parent, Window window) {
        parent.appendChild((Component)window);
        AEnv.showScreen(window, "parent,center");
    }

    public static char getMnemonic(String text) {
        int pos = text.indexOf(38);
        if (pos != -1) {
            return text.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static void zoom(int AD_Table_ID, int Record_ID) {
        int AD_Window_ID = Env.getZoomWindowID((int)AD_Table_ID, (int)Record_ID);
        if (AD_Window_ID == 0) {
            return;
        }
        MTable table2 = MTable.get((Properties)Env.getCtx(), (int)AD_Table_ID);
        MQuery query = MQuery.getEqualQuery((String)table2.getKeyColumns()[0], (int)Record_ID);
        query.setZoomTableName(table2.getTableName());
        query.setZoomColumnName(table2.getKeyColumns()[0]);
        query.setZoomValue((Object)Record_ID);
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoom(int AD_Table_ID, int Record_ID, MQuery query, int windowNo) {
        int AD_Window_ID = Env.getZoomWindowID((int)AD_Table_ID, (int)Record_ID, (int)windowNo);
        if (AD_Window_ID == 0) {
            return;
        }
        AEnv.zoom(AD_Window_ID, query);
    }

    public static void zoom(int AD_Table_ID, int Record_ID, MQuery query) {
        AEnv.zoom(AD_Table_ID, Record_ID, query, 0);
    }

    public static void exit(int status) {
        Env.exitEnv((int)status);
    }

    public static void logout() {
        String sessionID = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        windowCache.remove(sessionID);
        MSession session = MSession.get((Properties)Env.getCtx(), (boolean)false);
        if (session != null) {
            session.logout();
        }
    }

    public static void startWorkflowProcess(int AD_Table_ID, int Record_ID) {
        if (s_workflow_Window_ID <= 0) {
            int AD_Window_ID;
            s_workflow_Window_ID = AD_Window_ID = DB.getSQLValue(null, (String)"SELECT AD_Window_ID FROM AD_Window WHERE Name = 'Workflow Process'");
        }
        if (s_workflow_Window_ID <= 0) {
            return;
        }
        MQuery query = new MQuery();
        query.addRestriction("AD_Table_ID", "=", AD_Table_ID);
        query.addRestriction("Record_ID", "=", Record_ID);
        AEnv.zoom(s_workflow_Window_ID, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridWindowVO getMWindowVO(int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        CCache cache;
        Map<String, CCache<Integer, GridWindowVO>> map;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        }
        GridWindowVO mWindowVO = null;
        String sessionID = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Session_ID");
        if (AD_Window_ID != 0 && Ini.isCacheWindow()) {
            map = windowCache;
            synchronized (map) {
                cache = windowCache.get(sessionID);
                if (cache != null && (mWindowVO = (GridWindowVO)cache.get((Object)AD_Window_ID)) != null) {
                    mWindowVO = mWindowVO.clone(WindowNo);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Cached=" + mWindowVO);
                    }
                }
            }
        }
        if (mWindowVO == null) {
            log.config("create local");
            mWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)WindowNo, (int)AD_Window_ID, (int)AD_Menu_ID);
            if (mWindowVO != null && Ini.isCacheWindow()) {
                map = windowCache;
                synchronized (map) {
                    cache = windowCache.get(sessionID);
                    if (cache == null) {
                        cache = new CCache("AD_Window", 10);
                        windowCache.put(sessionID, (CCache<Integer, GridWindowVO>)cache);
                    }
                    cache.put((Object)AD_Window_ID, (Object)mWindowVO);
                }
            }
        }
        if (mWindowVO == null) {
            return null;
        }
        if (!mWindowVO.ctx.equals(Env.getCtx())) {
            Enumeration<Object> keyEnum = mWindowVO.ctx.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.startsWith(String.valueOf(WindowNo) + "|")) continue;
                String value = mWindowVO.ctx.getProperty(key);
                Env.setContext((Properties)Env.getCtx(), (String)key, (String)value);
            }
            mWindowVO.setCtx(Env.getCtx());
        }
        return mWindowVO;
    }

    public static String postImmediate(int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        log.info("Window=" + WindowNo + ", AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        return Doc.manualPosting((int)WindowNo, (int)AD_Client_ID, (int)AD_Table_ID, (int)Record_ID, (boolean)force);
    }

    public static void cacheReset(String tableName, int Record_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("TableName=" + tableName + ", Record_ID=" + Record_ID);
        }
        CacheMgt.get().reset(tableName, Record_ID);
    }

    public static void actionRefresh(Lookup lookup, Object value, boolean mandatory, boolean shortList) {
        if (lookup == null) {
            return;
        }
        lookup.refresh();
        if (lookup.isValidated()) {
            lookup.fillComboBox(mandatory, false, false, false, shortList);
        } else {
            lookup.fillComboBox(mandatory, true, false, false, shortList);
        }
    }

    public static void actionZoom(Lookup lookup, Object value) {
        if (lookup == null) {
            return;
        }
        MQuery zoomQuery = lookup.getZoomQuery();
        if (value == null) {
            value = -1;
        }
        if (zoomQuery == null || value != null) {
            zoomQuery = new MQuery();
            String column = lookup.getColumnName();
            if (lookup instanceof MLookup && 17 == lookup.getDisplayType()) {
                int AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID();
                column = "AD_Ref_List_ID";
                value = DB.getSQLValue(null, (String)"SELECT AD_Ref_List_ID FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?", (Object[])new Object[]{AD_Reference_ID, value});
            }
            if (column.indexOf(".") > 0) {
                int p2 = column.indexOf(".");
                String tableName = column.substring(0, p2);
                column = column.substring(column.indexOf(".") + 1);
                zoomQuery.setZoomTableName(tableName);
                zoomQuery.setZoomColumnName(column);
            } else {
                zoomQuery.setZoomColumnName(column);
                zoomQuery.setZoomTableName(column.substring(0, column.length() - 3));
            }
            zoomQuery.setZoomValue(value);
            zoomQuery.addRestriction(column, "=", value);
            zoomQuery.setRecordCount(1);
        }
        if (value instanceof Integer && (Integer)value >= 0 && zoomQuery != null && zoomQuery.getZoomTableName() != null) {
            int tableId = MTable.getTable_ID((String)zoomQuery.getZoomTableName());
            AEnv.zoom(tableId, (Integer)value, zoomQuery, lookup.getWindowNo());
        } else {
            int windowId = lookup.getZoom(zoomQuery);
            AEnv.zoom(windowId, zoomQuery, lookup.getWindowNo());
        }
    }

    public static void showZoomWindow(int AD_Window_ID, MQuery query) {
        SessionManager.getAppDesktop().showZoomWindow(AD_Window_ID, query);
    }

    public static void zoom(int AD_Window_ID, MQuery query, int windowNo) {
        int zoomId = MZoomCondition.findZoomWindowByWindowId((int)AD_Window_ID, (MQuery)query, (int)windowNo);
        AEnv.showZoomWindow(zoomId > 0 ? zoomId : AD_Window_ID, query);
    }

    public static void zoom(int AD_Window_ID, MQuery query) {
        AEnv.zoom(AD_Window_ID, query, 0);
    }

    public static void showWindow(Window win) {
        SessionManager.getAppDesktop().showWindow(win);
    }

    public static void zoom(MQuery query) {
        if (query == null || query.getTableName() == null || query.getTableName().length() == 0) {
            return;
        }
        int AD_Window_ID = Env.getZoomWindowID((MQuery)query);
        if (AD_Window_ID == 0) {
            return;
        }
        AEnv.showZoomWindow(AD_Window_ID, query);
    }

    public static URI getImage(String fileNameInImageDir) {
        URI uri = null;
        try {
            uri = new URI(ThemeManager.getThemeResource("images/" + fileNameInImageDir));
        }
        catch (URISyntaxException exception) {
            log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        return uri;
    }

    public static boolean isFirefox2() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            String userAgent = Servlets.getUserAgent((ServletRequest)((ServletRequest)n));
            return userAgent.indexOf("Firefox/2") >= 0;
        }
        return false;
    }

    public static boolean isBrowserSupported() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            Double version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"ff");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"chrome");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"webkit");
            if (version != null) {
                return true;
            }
            version = Servlets.getBrowser((ServletRequest)((ServletRequest)n), (String)"ie");
            if (version != null && version.intValue() >= 8) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInternetExplorer() {
        Execution execution = Executions.getCurrent();
        if (execution == null) {
            return false;
        }
        Object n = execution.getNativeRequest();
        if (n instanceof ServletRequest) {
            String browser = Servlets.getBrowser((ServletRequest)((ServletRequest)n));
            return browser != null && browser.equals("ie");
        }
        return false;
    }

    public static boolean contains(Component parent, Component child) {
        if (child == parent) {
            return true;
        }
        Component c = child.getParent();
        while (c != null) {
            if (c == parent) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void mergePdf(List<File> pdfList, File outFile) throws IOException, DocumentException, FileNotFoundException {
        document = null;
        copy = null;
        pdfReaders = new ArrayList<PdfReader>();
        try {
            for (File f : pdfList) {
                reader = new PdfReader(f.getAbsolutePath());
                pdfReaders.add(reader);
                if (document == null) {
                    document = new Document(reader.getPageSizeWithRotation(1));
                    copy = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outFile));
                    document.open();
                }
                pages = reader.getNumberOfPages();
                cb = copy.getDirectContent();
                i = 1;
                while (i <= pages) {
                    document.newPage();
                    copy.newPage();
                    page = copy.getImportedPage(reader, i);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    copy.releaseTemplate((PdfTemplate)page);
                    ++i;
                }
            }
            document.close();
        }
        finally {
            ** for (reader : pdfReaders)
        }
lbl-1000:
        // 1 sources

        {
            reader.close();
            continue;
        }
lbl33:
        // 1 sources

    }

    public static String getWindowHeader(Properties ctx, int WindowNo) {
        StringBuilder sb = new StringBuilder();
        if (WindowNo > 0) {
            sb.append(Env.getContext((Properties)ctx, (int)WindowNo, (String)"_WinInfo_WindowName", (boolean)false)).append("  ");
            String documentNo = Env.getContext((Properties)ctx, (int)WindowNo, (String)"DocumentNo", (boolean)false);
            String value = Env.getContext((Properties)ctx, (int)WindowNo, (String)"Value", (boolean)false);
            String name = Env.getContext((Properties)ctx, (int)WindowNo, (String)"Name", (boolean)false);
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        return sb.toString();
    }

    public static Language getLanguage(Properties ctx) {
        Locale locale = AEnv.getLocale(ctx);
        Language language = Env.getLanguage((Properties)ctx);
        if (!language.getLocale().equals(locale)) {
            Language tmp = Language.getLanguage((String)locale.toString());
            String adLanguage = language.getAD_Language();
            language = new Language(tmp.getName(), adLanguage, tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        }
        return language;
    }

    public static Locale getLocale(Properties ctx) {
        String value = Env.getContext((Properties)ctx, (String)LOCALE);
        Locale locale = null;
        if (value != null && value.length() > 0) {
            String[] components = value.split("\\_");
            String language = components.length > 0 ? components[0] : "";
            String country = components.length > 1 ? components[1] : "";
            locale = new Locale(language, country);
        } else {
            locale = Env.getLanguage((Properties)ctx).getLocale();
        }
        return locale;
    }

    public static String getDialogHeader(Properties ctx, int windowNo, String prefix) {
        String header;
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (windowNo > 0) {
            String name;
            String value;
            sb.append(Env.getContext((Properties)ctx, (int)windowNo, (String)"_WinInfo_WindowName", (boolean)false)).append(": ");
            String documentNo = Env.getContext((Properties)ctx, (int)windowNo, (String)"DocumentNo", (boolean)false);
            if (Util.isEmpty((String)documentNo)) {
                documentNo = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"DocumentNo", (boolean)false);
            }
            if (Util.isEmpty((String)(value = Env.getContext((Properties)ctx, (int)windowNo, (String)"Value", (boolean)false)))) {
                value = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"Value", (boolean)false);
            }
            if (Util.isEmpty((String)(name = Env.getContext((Properties)ctx, (int)windowNo, (String)"Name", (boolean)false)))) {
                name = Env.getContext((Properties)ctx, (int)windowNo, (int)0, (String)"Name", (boolean)false);
            }
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        if ((header = sb.toString().trim()).length() == 0) {
            header = ThemeManager.getBrowserTitle();
        }
        if (header.endsWith(":")) {
            header = header.substring(0, header.length() - 1);
        }
        return header;
    }

    public static String getDialogHeader(Properties ctx, int windowNo) {
        return AEnv.getDialogHeader(ctx, windowNo, null);
    }

    public static void executeDesktopTask(final Runnable runnable) {
        Desktop desktop = AEnv.getDesktop();
        ServerPushTemplate template = new ServerPushTemplate(desktop);
        template.execute(new IServerPushCallback(){

            @Override
            public void updateUI() {
                runnable.run();
            }
        });
    }

    public static void executeAsyncDesktopTask(final Runnable runnable) {
        Desktop desktop = AEnv.getDesktop();
        ServerPushTemplate template = new ServerPushTemplate(desktop);
        template.executeAsync(new IServerPushCallback(){

            @Override
            public void updateUI() {
                runnable.run();
            }
        });
    }

    public static Desktop getDesktop() {
        boolean inUIThread;
        boolean bl = inUIThread = Executions.getCurrent() != null;
        if (inUIThread) {
            return Executions.getCurrent().getDesktop();
        }
        WeakReference<Desktop> ref = DesktopRunnable.getThreadLocalDesktop();
        return ref != null ? (Desktop)ref.get() : null;
    }

    public static boolean isTablet() {
        return ClientInfo.isMobile();
    }

    public static int getADWindowID(int windowNo) {
        int adWindowID = 0;
        Object window = SessionManager.getAppDesktop().findWindow(windowNo);
        if (window != null && window instanceof ADWindow) {
            adWindowID = ((ADWindow)window).getAD_Window_ID();
        } else if (window != null && (window instanceof ProcessDialog || window instanceof InfoWindow)) {
            adWindowID = Env.adWindowDummyID;
        }
        return adWindowID;
    }

    public static WTableDirEditor getListDocumentLanguage(MClient client) throws Exception {
        WTableDirEditor fLanguageType = null;
        if (client.isMultiLingualDocument()) {
            MLookup lookupLanguage = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"AD_Language_ID", (int)0, (boolean)false, (String)" IsActive='Y' AND IsLoginLocale = 'Y' ");
            fLanguageType = new WTableDirEditor("AD_Language_ID", false, false, true, (Lookup)lookupLanguage);
        }
        return fLanguageType;
    }

    public static String getApplicationUrl() {
        String url = MSysConfig.getValue((String)"APPLICATION_URL", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (!Util.isEmpty((String)url) && !url.equals("USE_HARDCODED")) {
            return MSysConfig.getValue((String)"APPLICATION_URL", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        }
        if (m_ApplicationUrl != null) {
            return m_ApplicationUrl;
        }
        int port = Executions.getCurrent().getServerPort();
        String sch = Executions.getCurrent().getScheme();
        String sport = null;
        sport = sch.equals("http") && port == 80 || sch.equals("https") && port == 443 ? "" : ":" + port;
        m_ApplicationUrl = String.valueOf(sch) + "://" + Executions.getCurrent().getServerName() + sport + Executions.getCurrent().getContextPath() + Executions.getCurrent().getDesktop().getRequestPath();
        return m_ApplicationUrl;
    }

    public static String getZoomUrlTableID(PO po) {
        return String.valueOf(AEnv.getApplicationUrl()) + "?Action=Zoom&AD_Table_ID=" + po.get_Table_ID() + "&Record_ID=" + po.get_ID();
    }

    public static String getZoomUrlTableName(PO po) {
        return String.valueOf(AEnv.getApplicationUrl()) + "?Action=Zoom&TableName" + po.get_TableName() + "&Record_ID=" + po.get_ID();
    }
}

