/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.util.Callback;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.validator.WindowValidator;
import org.adempiere.webui.adwindow.validator.WindowValidatorEvent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WindowValidatorManager
implements BundleActivator,
ServiceTrackerCustomizer<WindowValidator, WindowValidator> {
    private static WindowValidatorManager instance = null;
    private BundleContext context;
    private Map<String, List<WindowValidator>> validatorMap = new HashMap<String, List<WindowValidator>>();
    private List<WindowValidator> globalValidators = new ArrayList<WindowValidator>();
    private ServiceTracker<WindowValidator, WindowValidator> serviceTracker;

    public WindowValidator addingService(ServiceReference<WindowValidator> reference) {
        WindowValidator service = (WindowValidator)this.context.getService(reference);
        Object obj = reference.getProperty("AD_Window_UU");
        if (obj instanceof String) {
            String uuid = (String)reference.getProperty("AD_Window_UU");
            if (uuid == null || "*".equals(uuid)) {
                this.globalValidators.add(service);
                return service;
            }
            this.addService(service, uuid);
        } else if (obj instanceof String[]) {
            String[] uuids;
            String[] stringArray = uuids = (String[])reference.getProperty("AD_Window_UU");
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                this.addService(service, uuid);
                ++n2;
            }
        }
        return service;
    }

    void addService(WindowValidator service, String uuid) {
        List<WindowValidator> list = this.validatorMap.get(uuid);
        if (list == null) {
            list = new ArrayList<WindowValidator>();
            this.validatorMap.put(uuid, list);
        }
        list.add(service);
    }

    public void modifiedService(ServiceReference<WindowValidator> reference, WindowValidator service) {
    }

    public void removedService(ServiceReference<WindowValidator> reference, WindowValidator service) {
        Object obj = reference.getProperty("AD_Window_UU");
        if (obj instanceof String) {
            String uuid = (String)reference.getProperty("AD_Window_UU");
            if (uuid == null || "*".equals(uuid)) {
                this.globalValidators.remove(service);
            } else {
                this.removeService(service, uuid);
            }
        } else if (obj instanceof String[]) {
            String[] uuids;
            String[] stringArray = uuids = (String[])reference.getProperty("AD_Window_UU");
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                this.removeService(service, uuid);
                ++n2;
            }
        }
    }

    void removeService(WindowValidator service, String uuid) {
        List<WindowValidator> list = this.validatorMap.get(uuid);
        if (list != null) {
            list.remove(service);
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.serviceTracker = new ServiceTracker(context, WindowValidator.class.getName(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceTracker.close();
        this.context = null;
        instance = null;
    }

    public static WindowValidatorManager getInstance() {
        return instance;
    }

    public void fireWindowValidatorEvent(WindowValidatorEvent event, Callback<Boolean> callback) {
        ADWindow window = event.getWindow();
        String uuid = window.getAD_Window_UU();
        List<WindowValidator> list = this.validatorMap.get(uuid);
        int listSize = list != null ? list.size() : 0;
        WindowValidator[] validators = new WindowValidator[listSize + this.globalValidators.size()];
        int index = -1;
        if (listSize > 0) {
            for (WindowValidator validator : list) {
                validators[++index] = validator;
            }
        }
        for (WindowValidator validator : this.globalValidators) {
            validators[++index] = validator;
        }
        ChainCallback chain = new ChainCallback(event, validators, callback);
        chain.start();
    }

    private static class ChainCallback
    implements Callback<Boolean> {
        private Callback<Boolean> callback;
        private WindowValidator[] validators;
        private WindowValidatorEvent event;
        private int index = -1;

        public ChainCallback(WindowValidatorEvent event, WindowValidator[] validators, Callback<Boolean> callback) {
            this.event = event;
            this.validators = validators;
            this.callback = callback;
        }

        public void start() {
            this.index = 0;
            if (this.index < this.validators.length) {
                this.validators[this.index].onWindowEvent(this.event, this);
            } else if (this.callback != null) {
                this.callback.onCallback((Object)true);
            }
        }

        public void onCallback(Boolean result) {
            if (result.booleanValue()) {
                if (this.index < this.validators.length - 1) {
                    ++this.index;
                    this.validators[this.index].onWindowEvent(this.event, this);
                } else if (this.callback != null) {
                    this.callback.onCallback((Object)result);
                }
            } else if (this.callback != null) {
                this.callback.onCallback((Object)result);
            }
        }
    }
}

