/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.DocumentLink;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.process.ProcessInfoLog;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;

public class StatusBar
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = 1519490416637936553L;
    private Label infoLine;
    private Div west;
    private Div east;
    private ProcessInfoLog[] pInfoLogs;
    private String m_statusText;
    private boolean m_statusError;
    private Window msgPopup;
    private Div msgPopupCnt;
    private Hlayout messageContainer;
    private Caption msgPopupCaption;

    public StatusBar() {
        this.init();
        this.createPopup();
    }

    private void init() {
        this.infoLine = new Label();
        this.east = new Div();
        this.east.setSclass("adwindow-status-docinfo");
        this.east.appendChild((Component)this.infoLine);
        this.west = new Div();
        this.west.setSclass("adwindow-status-docstatus");
        this.messageContainer = new Hlayout();
        this.messageContainer.setId("messages");
        this.west.appendChild((Component)this.messageContainer);
        this.appendChild((Component)this.west);
        this.appendChild((Component)this.east);
    }

    public void setInfo(String text) {
        this.infoLine.setValue(text != null ? text : "");
        this.infoLine.setTooltiptext(text);
        this.infoLine.setStyle("font-weight: bold;");
    }

    public void setStatusLine(String text) {
        this.setStatusLine(text, false, null);
    }

    public void setStatusLine(String text, boolean error) {
        this.setStatusLine(text, error, null);
    }

    public void setStatusLine(String text, boolean error, ProcessInfoLog[] m_logs) {
        this.pInfoLogs = m_logs;
        Div div = null;
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            String key = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + this.getUuid();
            Object o = execution.getAttribute(key);
            if (o != null) {
                if (text == null || text.trim().length() == 0) {
                    return;
                }
            } else {
                execution.setAttribute(key, (Object)Boolean.TRUE);
            }
        }
        this.m_statusText = text;
        this.m_statusError = error;
        this.messageContainer.getChildren().clear();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        String labelText = this.buildLabelText(this.m_statusText);
        if (error) {
            Clients.showNotification((String)this.buildNotificationText(this.m_statusText), (String)"error", (Component)this.findTabpanel((Component)this), (String)"top_left", (int)3500, (boolean)true);
        }
        Label label = new Label(labelText);
        this.messageContainer.setSclass(error ? "docstatus-error" : "docstatus-normal");
        this.messageContainer.appendChild((Component)label);
        if (m_logs != null) {
            div = new Div();
            int i = 0;
            while (i < m_logs.length) {
                if (m_logs[i].getP_Msg() != null && m_logs[i].getAD_Table_ID() > 0 && m_logs[i].getRecord_ID() > 0) {
                    DocumentLink recordLink = new DocumentLink(m_logs[i].getP_Msg(), m_logs[i].getAD_Table_ID(), m_logs[i].getRecord_ID());
                    if (!div.getChildren().isEmpty()) {
                        div.appendChild((Component)new Separator("horizontal"));
                    }
                    div.appendChild((Component)recordLink);
                }
                ++i;
            }
        }
        if (labelText.length() != this.m_statusText.length() || div != null && div.getChildren().size() > 0) {
            label.addEventListener("onClick", this);
            label.setStyle("cursor: pointer");
            label = new Label(" ...");
            label.setStyle("cursor: pointer");
            this.messageContainer.appendChild((Component)label);
            label.addEventListener("onClick", this);
        }
        this.messageContainer.appendChild((Component)new Space());
        this.createPopupContent();
        if (div != null) {
            this.msgPopupCnt.appendChild((Component)div);
        }
    }

    private String buildLabelText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 80) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return statusText.substring(0, 80);
    }

    protected void createPopupContent() {
        Text t = new Text(this.m_statusText);
        this.msgPopupCnt.getChildren().clear();
        this.msgPopupCnt.appendChild((Component)t);
    }

    private String buildNotificationText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 140) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return String.valueOf(statusText.substring(0, 136)) + " ...";
    }

    private Component findTabpanel(Component comp) {
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent instanceof Tabpanel) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() instanceof Label) {
            this.showPopup();
        }
    }

    private void showPopup() {
        this.appendChild((Component)this.msgPopup);
        LayoutUtils.openOverlappedWindow((Component)this.messageContainer, this.msgPopup, "overlap_end");
    }

    public ProcessInfoLog[] getPLogs() {
        return this.pInfoLogs;
    }

    public String getStatusLine() {
        return this.m_statusText;
    }

    public boolean getStatusError() {
        return this.m_statusError;
    }

    private void createPopup() {
        this.msgPopupCnt = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.msgPopupCnt, "1");
        this.msgPopup = new Window();
        this.msgPopup.setBorder(true);
        this.msgPopup.setClosable(true);
        this.msgPopup.setSizable(true);
        this.msgPopup.setContentStyle("overflow: auto");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.msgPopup, "500px");
        this.msgPopup.appendChild((Component)this.msgPopupCnt);
        this.msgPopup.setShadow(true);
        this.msgPopupCaption = new Caption();
        this.msgPopup.appendChild((Component)this.msgPopupCaption);
    }
}

