/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.panel.CustomizeGridViewPanel;
import org.adempiere.webui.part.AbstractUIPart;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;

public abstract class AbstractADTabbox
extends AbstractUIPart
implements IADTabbox {
    private static CLogger log = CLogger.getCLogger(AbstractADTabbox.class);
    private ArrayList<String> m_dependents = new ArrayList();
    protected List<IADTabpanel> tabPanelList = new ArrayList<IADTabpanel>();
    protected AbstractADWindowContent adWindowPanel;

    @Override
    public void addTab(GridTab gTab, IADTabpanel tabPanel) {
        this.tabPanelList.add(tabPanel);
        ArrayList dependents = gTab.getDependentOn();
        int i = 0;
        while (i < dependents.size()) {
            String name = (String)dependents.get(i);
            if (!this.m_dependents.contains(name)) {
                this.m_dependents.add(name);
            }
            ++i;
        }
        this.doAddTab(gTab, tabPanel);
    }

    protected abstract void doAddTab(GridTab var1, IADTabpanel var2);

    public boolean isEnabledAt(int index) {
        return true;
    }

    private boolean isDisplay(IADTabpanel newTab) {
        boolean display;
        String logic = newTab.getDisplayLogic();
        if (logic != null && logic.length() > 0 && !(display = Evaluator.evaluateLogic((Evaluatee)newTab, (String)logic))) {
            log.info("Not displayed - " + logic);
            return false;
        }
        return true;
    }

    @Override
    public boolean updateSelectedIndex(int oldIndex, int newIndex) {
        IADTabpanel newTab = this.tabPanelList.get(newIndex);
        if (!this.isDisplay(newTab)) {
            return false;
        }
        boolean canJump = true;
        if (newIndex != oldIndex && (canJump = this.canNavigateTo(oldIndex, newIndex, true))) {
            this.prepareContext(newIndex, newTab);
            this.doTabSelectionChanged(oldIndex, newIndex);
        }
        return canJump;
    }

    private void prepareContext(int newIndex, IADTabpanel newTab) {
        if (newTab != null) {
            int n;
            IADTabpanel adtab;
            ArrayList<Integer> parents = new ArrayList<Integer>();
            if (newIndex > 0) {
                int currentLevel = newTab.getTabLevel();
                int i = newIndex - 1;
                while (i > 0) {
                    adtab = this.tabPanelList.get(i);
                    if (adtab.getGridTab() != null && !(adtab instanceof CustomizeGridViewPanel) && adtab.getTabLevel() < currentLevel) {
                        parents.add(i);
                        currentLevel = adtab.getTabLevel();
                    }
                    --i;
                }
                parents.add(0);
                Collections.reverse(parents);
            } else {
                parents.add(0);
            }
            int i = 0;
            while (i < this.tabPanelList.size()) {
                IADTabpanel adtab2 = this.tabPanelList.get(i);
                if (adtab2.getGridTab() != null && !(adtab2 instanceof CustomizeGridViewPanel)) {
                    GridField[] fields;
                    GridField[] gridFieldArray = fields = adtab2.getGridTab().getFields();
                    n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GridField gf = gridFieldArray[n2];
                        Env.setContext((Properties)Env.getCtx(), (int)gf.getWindowNo(), (String)gf.getColumnName(), (String)"");
                        ++n2;
                    }
                }
                ++i;
            }
            Iterator iterator = parents.iterator();
            while (iterator.hasNext()) {
                GridField[] fields;
                i = (Integer)iterator.next();
                adtab = this.tabPanelList.get(i);
                GridField[] gridFieldArray = fields = adtab.getGridTab().getFields();
                int n3 = fields.length;
                n = 0;
                while (n < n3) {
                    GridField gf = gridFieldArray[n];
                    gf.updateContext();
                    ++n;
                }
            }
        }
    }

    protected abstract void doTabSelectionChanged(int var1, int var2);

    @Override
    public boolean isDisplay(int index) {
        if (index >= this.tabPanelList.size()) {
            return false;
        }
        IADTabpanel newTab = this.tabPanelList.get(index);
        return !(newTab instanceof ADTabpanel) || this.isDisplay(newTab);
    }

    @Override
    public boolean canNavigateTo(int fromIndex, int toIndex) {
        return this.canNavigateTo(fromIndex, toIndex, false);
    }

    public boolean canNavigateTo(int fromIndex, int toIndex, boolean checkRecordID) {
        IADTabpanel newTab = this.tabPanelList.get(toIndex);
        if (newTab instanceof ADTabpanel && !this.isDisplay(newTab)) {
            return false;
        }
        boolean canJump = true;
        if (toIndex != fromIndex) {
            IADTabpanel oldTabpanel;
            IADTabpanel iADTabpanel = oldTabpanel = fromIndex >= 0 ? this.tabPanelList.get(fromIndex) : null;
            if (oldTabpanel != null && newTab.getTabLevel() > oldTabpanel.getTabLevel()) {
                int currentLevel = newTab.getTabLevel();
                int i = toIndex - 1;
                while (i >= 0) {
                    IADTabpanel tabPanel = this.tabPanelList.get(i);
                    if (tabPanel.getTabLevel() < currentLevel) {
                        if (!tabPanel.isCurrent()) {
                            canJump = false;
                            break;
                        }
                        currentLevel = tabPanel.getTabLevel();
                    }
                    --i;
                }
                if (canJump && checkRecordID) {
                    int zeroValid;
                    int n = zeroValid = MTable.isZeroIDTable((String)oldTabpanel.getTableName()) ? 1 : 0;
                    if (oldTabpanel.getRecord_ID() + zeroValid <= 0) {
                        canJump = false;
                    }
                    if (!canJump && Util.isEmpty((String)oldTabpanel.getGridTab().getKeyColumnName())) {
                        canJump = true;
                    }
                }
            }
        }
        return canJump;
    }

    @Override
    public String getPath() {
        StringBuilder path = new StringBuilder();
        int s = this.getSelectedIndex();
        if (s <= 0) {
            s = 0;
        }
        IADTabpanel p2 = this.tabPanelList.get(s);
        int i = 0;
        while (i <= s) {
            String n = null;
            if (i == s) {
                n = p2.getTitle();
            } else {
                IADTabpanel t = this.tabPanelList.get(i);
                if (t.getTabLevel() < p2.getTabLevel()) {
                    n = t.getTitle();
                }
            }
            if (n != null) {
                if (path.length() > 0) {
                    path.append(" > ");
                }
                path.append(n);
            }
            ++i;
        }
        return path.toString();
    }

    @Override
    public void evaluate(DataStatusEvent e) {
        boolean process = e == null;
        String columnName = null;
        if (!process) {
            columnName = e.getColumnName();
            process = columnName != null ? this.m_dependents.contains(columnName) : true;
        }
        if (process) {
            this.updateTabState();
        }
    }

    protected abstract void updateTabState();

    @Override
    public int getTabCount() {
        return this.tabPanelList.size();
    }

    @Override
    public IADTabpanel getADTabpanel(int index) {
        try {
            IADTabpanel tabPanel = this.tabPanelList.get(index);
            return tabPanel;
        }
        catch (Exception ex) {
            throw new IndexOutOfBoundsException(ex.getMessage());
        }
    }

    @Override
    public void setSelectedIndex(int newIndex) {
        int oldIndex = this.getSelectedIndex();
        this.updateSelectedIndex(oldIndex, newIndex);
    }

    @Override
    public void setADWindowPanel(AbstractADWindowContent abstractADWindowPanel) {
        this.adWindowPanel = abstractADWindowPanel;
    }
}

