/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IServiceHolder;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.action.Actions;
import org.adempiere.webui.action.IAction;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ToolbarCustomButton;
import org.adempiere.webui.component.FToolbar;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.event.ToolbarListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridTab;
import org.compiere.model.MRole;
import org.compiere.model.MToolBarButton;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Toolbarbutton;

public class ADWindowToolbar
extends FToolbar
implements EventListener<Event> {
    private static final long serialVersionUID = -9183846974546235806L;
    public static final String BTNPREFIX = "Btn";
    private static CLogger log = CLogger.getCLogger(ADWindowToolbar.class);
    private ToolBarButton btnIgnore;
    private ToolBarButton btnHelp;
    private ToolBarButton btnNew;
    private ToolBarButton btnCopy;
    private ToolBarButton btnDelete;
    private ToolBarButton btnSave;
    private ToolBarButton btnSaveAndCreate;
    private ToolBarButton btnRefresh;
    private ToolBarButton btnFind;
    private ToolBarButton btnLock;
    private ToolBarButton btnAttachment;
    private ToolBarButton btnGridToggle;
    private ToolBarButton btnParentRecord;
    private ToolBarButton btnDetailRecord;
    private ToolBarButton btnReport;
    private ToolBarButton btnArchive;
    private ToolBarButton btnPrint;
    private ToolBarButton btnZoomAcross;
    private ToolBarButton btnActiveWorkflows;
    private ToolBarButton btnRequests;
    private ToolBarButton btnProductInfo;
    private ToolBarButton btnChat;
    private ToolBarButton btnPostIt;
    private ToolBarButton btnCustomize;
    private ToolBarButton btnExport;
    private ToolBarButton btnFileImport;
    private ToolBarButton btnCSVImport;
    private ToolBarButton btnProcess;
    private HashMap<String, ToolBarButton> buttons = new HashMap();
    private ArrayList<ToolbarListener> listeners = new ArrayList();
    private Event event;
    private Map<Integer, ToolBarButton> keyMap = new HashMap<Integer, ToolBarButton>();
    private Map<Integer, ToolBarButton> altKeyMap = new HashMap<Integer, ToolBarButton>();
    private Map<Integer, ToolBarButton> ctrlKeyMap = new HashMap<Integer, ToolBarButton>();
    private List<ToolbarCustomButton> toolbarCustomButtons = new ArrayList<ToolbarCustomButton>();
    public boolean isPersonalLock = MRole.getDefault().isPersonalLock();
    private boolean isAllowProductInfo = MRole.getDefault().canAccess_Info_Product();
    private int windowNo = 0;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;
    private A overflowButton;
    private ArrayList<ToolBarButton> overflows;
    private Popup overflowPopup;
    private int prevWidth;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    private boolean ToolBarMenuRestictionLoaded = false;

    public ADWindowToolbar() {
        this(0);
    }

    public ADWindowToolbar(int windowNo) {
        this.setWindowNo(windowNo);
        this.init();
        if (ClientInfo.isMobile()) {
            this.mobileInit();
        }
    }

    private void init() {
        MToolBarButton[] officialButtons;
        LayoutUtils.addSclass("adwindow-toolbar", (HtmlBasedComponent)this);
        this.btnIgnore = this.createButton("Ignore", "Ignore", "Ignore");
        this.btnIgnore.setTooltiptext(String.valueOf(this.btnIgnore.getTooltiptext()) + "    Alt+Z");
        this.btnHelp = this.createButton("Help", "Help", "Help");
        this.btnHelp.setTooltiptext(String.valueOf(this.btnHelp.getTooltiptext()) + "    Alt+H");
        this.btnNew = this.createButton("New", "New", "New");
        this.btnNew.setTooltiptext(String.valueOf(this.btnNew.getTooltiptext()) + "    Alt+N");
        this.btnCopy = this.createButton("Copy", "Copy", "Copy");
        this.btnCopy.setTooltiptext(String.valueOf(this.btnCopy.getTooltiptext()) + "    Alt+C");
        this.btnDelete = this.createButton("Delete", "Delete", "Delete");
        this.btnDelete.setTooltiptext(String.valueOf(this.btnDelete.getTooltiptext()) + "    Alt+D");
        this.btnSave = this.createButton("Save", "Save", "Save");
        this.btnSave.setTooltiptext(String.valueOf(this.btnSave.getTooltiptext()) + "    Alt+S");
        this.btnSaveAndCreate = this.createButton("SaveCreate", "SaveCreate", "SaveCreate");
        this.btnSaveAndCreate.setTooltiptext(String.valueOf(this.btnSaveAndCreate.getTooltiptext()) + "    Alt+A");
        this.btnRefresh = this.createButton("Refresh", "Refresh", "Refresh");
        this.btnRefresh.setTooltiptext(String.valueOf(this.btnRefresh.getTooltiptext()) + "    Alt+E");
        this.btnFind = this.createButton("Find", "Find", "Find");
        this.btnFind.setTooltiptext(String.valueOf(this.btnFind.getTooltiptext()) + "    Alt+F");
        this.btnAttachment = this.createButton("Attachment", "Attachment", "Attachment");
        this.btnPostIt = this.createButton("PostIt", "PostIt", "PostIt");
        this.btnChat = this.createButton("Chat", "Chat", "Chat");
        this.btnGridToggle = this.createButton("Toggle", "Multi", "Multi");
        this.btnGridToggle.setTooltiptext(String.valueOf(this.btnGridToggle.getTooltiptext()) + "    Alt+T");
        this.btnParentRecord = this.createButton("ParentRecord", "Parent", "Parent");
        this.btnParentRecord.setTooltiptext(String.valueOf(this.btnParentRecord.getTooltiptext()) + "   Alt+Up");
        this.btnDetailRecord = this.createButton("DetailRecord", "Detail", "Detail");
        this.btnDetailRecord.setTooltiptext(String.valueOf(this.btnDetailRecord.getTooltiptext()) + "   Alt+Down");
        this.btnReport = this.createButton("Report", "Report", "Report");
        this.btnReport.setTooltiptext(String.valueOf(this.btnReport.getTooltiptext()) + "    Alt+R");
        this.btnArchive = this.createButton("Archive", "Archive", "Archive");
        this.btnPrint = this.createButton("Print", "Print", "Print");
        this.btnPrint.setTooltiptext(String.valueOf(this.btnPrint.getTooltiptext()) + "    Alt+P");
        if (this.isPersonalLock) {
            this.btnLock = this.createButton("Lock", "Lock", "Lock");
            this.btnLock.setDisabled(!this.isPersonalLock);
            this.btnLock.setVisible(this.isPersonalLock);
        }
        this.btnZoomAcross = this.createButton("ZoomAcross", "ZoomAcross", "ZoomAcross");
        this.btnActiveWorkflows = this.createButton("ActiveWorkflows", "WorkFlow", "WorkFlow");
        this.btnRequests = this.createButton("Requests", "Request", "Request");
        if (this.isAllowProductInfo) {
            this.btnProductInfo = this.createButton("ProductInfo", "Product", "InfoProduct");
            this.btnProductInfo.setDisabled(!this.isAllowProductInfo);
            this.btnProductInfo.setVisible(this.isAllowProductInfo);
        }
        this.btnCustomize = this.createButton("Customize", "Customize", "Customize");
        this.btnCustomize.setDisabled(false);
        this.btnProcess = this.createButton("Process", "Process", "Process");
        this.btnProcess.setTooltiptext(String.valueOf(this.btnProcess.getTooltiptext()) + "    Alt+O");
        this.btnProcess.setDisabled(false);
        this.btnHelp.setDisabled(false);
        this.btnGridToggle.setDisabled(false);
        this.btnZoomAcross.setDisabled(false);
        this.btnActiveWorkflows.setDisabled(false);
        this.btnRequests.setDisabled(false);
        this.btnArchive.setDisabled(false);
        if (MRole.getDefault().isCanExport()) {
            this.btnExport = this.createButton("Export", "Export", "Export");
        }
        this.btnFileImport = this.createButton("FileImport", "FileImport", "FileImport");
        this.btnCSVImport = this.createButton("CSVImport", "CSVImport", "CSVImport");
        MToolBarButton[] mToolBarButtonArray = officialButtons = MToolBarButton.getToolbarButtons((String)"W", null);
        int n = officialButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton button = mToolBarButtonArray[n2];
            if (!button.isActive()) {
                this.buttons.remove(button.getComponentName());
            } else {
                if (button.isCustomization()) {
                    String actionId = button.getActionClassName();
                    IServiceHolder<IAction> serviceHolder = Actions.getAction(actionId);
                    IAction action = (IAction)serviceHolder.getService();
                    if (serviceHolder != null && action != null) {
                        String labelKey = String.valueOf(actionId) + ".label";
                        String tooltipKey = String.valueOf(actionId) + ".tooltip";
                        String label = Msg.getMsg((Properties)Env.getCtx(), (String)labelKey);
                        String tooltiptext = Msg.getMsg((Properties)Env.getCtx(), (String)tooltipKey);
                        if (labelKey.equals(label)) {
                            label = button.getName();
                        }
                        if (tooltipKey.equals(tooltiptext)) {
                            tooltipKey = null;
                        }
                        ToolBarButton btn = this.createButton(button.getComponentName(), null, tooltipKey);
                        this.appendChild((Component)btn);
                        btn.removeEventListener("onClick", this);
                        btn.setId(button.getName());
                        btn.setDisabled(false);
                        AImage aImage = Actions.getActionImage(actionId);
                        if (aImage != null) {
                            btn.setImageContent((Image)aImage);
                        } else {
                            btn.setLabel(label);
                        }
                        ToolbarCustomButton toolbarCustomBtn = new ToolbarCustomButton(button, btn, actionId, this.windowNo);
                        this.toolbarCustomButtons.add(toolbarCustomBtn);
                        this.appendChild((Component)btn);
                        action.decorate(btn);
                    }
                }
                if (this.buttons.get(button.getComponentName()) != null) {
                    this.appendChild((Component)this.buttons.get(button.getComponentName()));
                    if (button.isAddSeparator()) {
                        this.appendChild((Component)new Separator("vertical"));
                    }
                }
            }
            ++n2;
        }
        this.configureKeyMap();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
    }

    private ToolBarButton createButton(String name, String image, String tooltip) {
        ToolBarButton btn = new ToolBarButton("");
        btn.setName(BTNPREFIX + name);
        btn.setId(btn.getName());
        if (image != null) {
            if (ThemeManager.isUseFontIconForImage()) {
                String iconSclass = "z-icon-" + image;
                btn.setIconSclass(iconSclass);
                LayoutUtils.addSclass("font-icon-toolbar-button", (HtmlBasedComponent)btn);
            } else {
                Executions.createComponents((String)ThemeManager.getPreference(), (Component)this, null);
                String size = Env.getContext((Properties)Env.getCtx(), (String)"#ZK_Toolbar_Button_Size");
                String suffix = "24.png";
                if (!Util.isEmpty((String)size)) {
                    suffix = String.valueOf(size) + ".png";
                }
                btn.setImage(ThemeManager.getThemeResource("images/" + image + suffix));
            }
        }
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)tooltip));
        LayoutUtils.addSclass("toolbar-button", (HtmlBasedComponent)btn);
        this.buttons.put(name, btn);
        btn.setTabindex(0);
        btn.addEventListener("onClick", this);
        btn.setDisabled(true);
        return btn;
    }

    public ToolBarButton getButton(String name) {
        return this.buttons.get(name);
    }

    private void configureKeyMap() {
        this.altKeyMap.put(72, this.btnHelp);
        this.altKeyMap.put(78, this.btnNew);
        this.altKeyMap.put(68, this.btnDelete);
        this.altKeyMap.put(83, this.btnSave);
        this.altKeyMap.put(65, this.btnSaveAndCreate);
        this.altKeyMap.put(67, this.btnCopy);
        this.altKeyMap.put(69, this.btnRefresh);
        this.altKeyMap.put(84, this.btnGridToggle);
        this.altKeyMap.put(38, this.btnParentRecord);
        this.altKeyMap.put(40, this.btnDetailRecord);
        this.altKeyMap.put(70, this.btnFind);
        this.altKeyMap.put(90, this.btnIgnore);
        this.altKeyMap.put(82, this.btnReport);
        this.altKeyMap.put(80, this.btnPrint);
        this.altKeyMap.put(79, this.btnProcess);
    }

    protected void addSeparator() {
        Space s = new Space();
        s.setSpacing("6px");
        s.setOrient("vertical");
        this.appendChild((Component)s);
    }

    public void addListener(ToolbarListener toolbarListener) {
        this.listeners.add(toolbarListener);
    }

    public void removeListener(ToolbarListener toolbarListener) {
        this.listeners.remove(toolbarListener);
    }

    public void onEvent(Event event) {
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            if (event.getTarget() instanceof ToolBarButton) {
                this.doOnClick(event);
            }
        } else if (eventName.equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    private void doOnClick(Event event) {
        this.event = event;
        ToolBarButton cComponent = (ToolBarButton)event.getTarget();
        String compName = cComponent.getName();
        String methodName = "on" + compName.substring(3);
        Iterator<ToolbarListener> listenerIter = this.listeners.iterator();
        while (listenerIter.hasNext()) {
            try {
                ToolbarListener tListener = listenerIter.next();
                Method method = tListener.getClass().getMethod(methodName, null);
                method.invoke((Object)tListener, null);
            }
            catch (Exception e) {
                Throwable cause;
                String msg = null;
                ValueNamePair vp = CLogger.retrieveError();
                if (vp != null) {
                    msg = vp.getName();
                }
                if (msg == null && (cause = e.getCause()) != null) {
                    msg = cause.getLocalizedMessage();
                }
                if (msg == null) {
                    msg = "Could not invoke Toolbar listener method: " + methodName + "()";
                }
                FDialog.error(this.windowNo, (Component)this, "Error", msg);
                log.log(Level.SEVERE, msg, (Throwable)e);
            }
        }
        this.event = null;
    }

    public void enableTabNavigation(boolean enabled) {
        this.enableTabNavigation(enabled, enabled);
    }

    public void enableTabNavigation(boolean enableParent, boolean enableDetail) {
        this.btnParentRecord.setDisabled(!enableParent);
        this.btnDetailRecord.setDisabled(!enableDetail);
    }

    public void enableRefresh(boolean enabled) {
        this.btnRefresh.setDisabled(!enabled);
    }

    public void enableSave(boolean enabled) {
        this.btnSave.setDisabled(!enabled);
        this.btnSaveAndCreate.setDisabled(!enabled);
    }

    public boolean isSaveEnable() {
        return !this.btnSave.isDisabled();
    }

    public void enableDelete(boolean enabled) {
        this.btnDelete.setDisabled(!enabled);
    }

    public boolean isDeleteEnable() {
        return !this.btnDelete.isDisabled();
    }

    public boolean isNewEnabled() {
        return !this.btnNew.isDisabled();
    }

    public void enableIgnore(boolean enabled) {
        this.btnIgnore.setDisabled(!enabled);
    }

    public void enableNew(boolean enabled) {
        this.btnNew.setDisabled(!enabled);
    }

    public void enableCopy(boolean enabled) {
        this.btnCopy.setDisabled(!enabled);
    }

    public void enableAttachment(boolean enabled) {
        this.btnAttachment.setDisabled(!enabled);
    }

    public void enableChat(boolean enabled) {
        this.btnChat.setDisabled(!enabled);
    }

    public void enablePrint(boolean enabled) {
        this.btnPrint.setDisabled(!enabled);
    }

    public void enableReport(boolean enabled) {
        this.btnReport.setDisabled(!enabled);
    }

    public void enableFind(boolean enabled) {
        this.btnFind.setDisabled(!enabled);
    }

    public void enableGridToggle(boolean enabled) {
        this.btnGridToggle.setDisabled(!enabled);
    }

    public void enableCustomize(boolean enabled) {
        this.btnCustomize.setDisabled(!enabled);
    }

    public void enableArchive(boolean enabled) {
        this.btnArchive.setDisabled(!enabled);
    }

    public void enableZoomAcross(boolean enabled) {
        this.btnZoomAcross.setDisabled(!enabled);
    }

    public void enableActiveWorkflows(boolean enabled) {
        this.btnActiveWorkflows.setDisabled(!enabled);
    }

    public void enableRequests(boolean enabled) {
        this.btnRequests.setDisabled(!enabled);
    }

    public void lock(boolean locked) {
        this.btnLock.setPressed(locked);
        if (ThemeManager.isUseFontIconForImage()) {
            String iconSclass = "z-icon-" + (this.btnLock.isPressed() ? "lock" : "unlock");
            this.btnLock.setIconSclass(iconSclass);
            LayoutUtils.addSclass("font-icon-toolbar-button", (HtmlBasedComponent)this.btnLock);
        } else {
            String size = Env.getContext((Properties)Env.getCtx(), (String)"#ZK_Toolbar_Button_Size");
            String suffix = "24.png";
            if (!Util.isEmpty((String)size)) {
                suffix = String.valueOf(size) + ".png";
            }
            String imgURL = "images/" + (this.btnLock.isPressed() ? "LockX" : "Lock") + suffix;
            imgURL = ThemeManager.getThemeResource(imgURL);
            this.btnLock.setImage(imgURL);
        }
    }

    public void enablePostIt(boolean enabled) {
        this.btnPostIt.setDisabled(!enabled);
    }

    public Event getEvent() {
        return this.event;
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        ToolBarButton btn = null;
        if (keyEvent.isAltKey() && !keyEvent.isCtrlKey() && !keyEvent.isShiftKey()) {
            if (keyEvent.getKeyCode() == 88) {
                if (this.windowNo > 0) {
                    this.prevKeyEventTime = System.currentTimeMillis();
                    this.prevKeyEvent = keyEvent;
                    keyEvent.stopPropagation();
                    SessionManager.getAppDesktop().closeWindow(this.windowNo);
                }
            } else {
                btn = this.altKeyMap.get(keyEvent.getKeyCode());
            }
        } else if (!keyEvent.isAltKey() && keyEvent.isCtrlKey() && !keyEvent.isShiftKey()) {
            btn = this.ctrlKeyMap.get(keyEvent.getKeyCode());
        } else if (!(keyEvent.isAltKey() || keyEvent.isCtrlKey() || keyEvent.isShiftKey())) {
            btn = this.keyMap.get(keyEvent.getKeyCode());
        }
        if (btn != null) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            if (!btn.isDisabled() && btn.isVisible()) {
                Events.sendEvent((Component)btn, (Event)new Event("onClick", (Component)btn));
                String script = "var w=zk.Widget.$('#" + btn.getUuid() + "'); " + "zWatch.fire('onFloatUp', w);";
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }

    public void setVisibleAll(boolean visible) {
        for (ToolBarButton btn : this.buttons.values()) {
            btn.setVisible(visible);
        }
    }

    public void setVisible(String buttonName, boolean visible) {
        ToolBarButton btn = this.buttons.get(buttonName);
        if (btn != null) {
            btn.setVisible(visible);
        }
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public void enableExport(boolean b) {
        if (this.btnExport != null) {
            this.btnExport.setDisabled(!b);
        }
    }

    public void enableFileImport(boolean b) {
        if (this.btnFileImport != null) {
            this.btnFileImport.setDisabled(!b);
        }
    }

    public void enableCSVImport(boolean b) {
        if (this.btnCSVImport != null) {
            this.btnCSVImport.setDisabled(!b);
        }
    }

    public void updateToolbarAccess(int xAD_Window_ID) {
        GridTab gridTab;
        if (this.ToolBarMenuRestictionLoaded) {
            return;
        }
        ADWindow adwindow = ADWindow.findADWindow((Component)this);
        List<String> restrictionList = adwindow.getWindowToolbarRestrictList();
        block0: for (String restrictName : restrictionList) {
            Component p = this.getFirstChild();
            while (p != null) {
                if (p instanceof ToolBarButton && restrictName.equals(((ToolBarButton)p).getName())) {
                    this.removeChild(p);
                    continue block0;
                }
                p = p.getNextSibling();
            }
        }
        if (!MRole.getDefault().isAccessAdvanced()) {
            List<String> advancedList = adwindow.getWindowAdvancedButtonList();
            block2: for (String advancedName : advancedList) {
                Component p = this.getFirstChild();
                while (p != null) {
                    if (p instanceof ToolBarButton && advancedName.equals(((ToolBarButton)p).getName())) {
                        this.removeChild(p);
                        continue block2;
                    }
                    p = p.getNextSibling();
                }
            }
        }
        this.dynamicDisplay();
        if (!this.btnActiveWorkflows.isDisabled() && (gridTab = adwindow.getADWindowContent().getActiveGridTab()) != null) {
            this.btnActiveWorkflows.setDisabled(!this.hasWorkflow(gridTab));
        }
        this.ToolBarMenuRestictionLoaded = true;
    }

    boolean hasWorkflow(GridTab gridTab) {
        String sql = "SELECT COUNT(*) FROM AD_Workflow WHERE IsActive='Y' AND AD_Table_ID=? AND AD_Client_ID IN (0,?)";
        return DB.getSQLValueEx(null, (String)sql, (Object[])new Object[]{gridTab.getAD_Table_ID(), Env.getAD_Client_ID((Properties)Env.getCtx())}) > 0;
    }

    public void enableProcessButton(boolean b) {
        if (this.btnProcess != null) {
            this.btnProcess.setDisabled(!b);
        }
    }

    public void dynamicDisplay() {
        ArrayList<Toolbarbutton> customButtons = new ArrayList<Toolbarbutton>();
        for (ToolbarCustomButton toolbarCustomBtn : this.toolbarCustomButtons) {
            toolbarCustomBtn.dynamicDisplay();
            customButtons.add(toolbarCustomBtn.getToolbarbutton());
        }
        ADWindow adwindow = ADWindow.findADWindow((Component)this);
        GridTab gridTab = adwindow.getADWindowContent().getActiveGridTab();
        if (gridTab != null) {
            int AD_Tab_ID = gridTab.getAD_Tab_ID();
            List<String> restrictionList = adwindow.getTabToolbarRestrictList(AD_Tab_ID);
            Component p = this.getFirstChild();
            while (p != null) {
                if (p instanceof ToolBarButton && !customButtons.contains(p) && !p.isVisible()) {
                    p.setVisible(true);
                }
                p = p.getNextSibling();
            }
            block2: for (String restrictName : restrictionList) {
                Component p2 = this.getFirstChild();
                while (p2 != null) {
                    if (p2 instanceof ToolBarButton && restrictName.equals(((ToolBarButton)p2).getName())) {
                        p2.setVisible(false);
                        continue block2;
                    }
                    p2 = p2.getNextSibling();
                }
            }
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        }
    }

    private void mobileInit() {
        LayoutUtils.addSclass("mobile", (HtmlBasedComponent)this);
        this.addEventListener("onOverflowButton", evt -> this.onOverflowButton(evt));
        this.setWidgetOverride("toolbarScrollable", "function (wgt) {\n\tvar total = jq(wgt.$n()).width();\n\tvar w = wgt.firstChild;\n\n\t// make sure all images are loaded.\n\tif (zUtl.isImageLoading()) {\n\t\tvar f = arguments.callee;\n\t\tsetTimeout(function () {\n\t\t\treturn f(wgt);\n\t\t}, 20);\n\t\treturn;\n\t}\n\tfor (; w; w = w.nextSibling) {\n\t\ttotal -= jq(w.$n()).outerWidth(true);\n\t\tif (total < 0 && w.className == 'zul.wgt.Toolbarbutton') {\n\t\t\tbreak;\n\t\t}\n\t}\n\tif (w) {\n       var event = new zk.Event(wgt, 'onOverflowButton', w.uuid, {toServer: true}); \n       zAu.send(event); \n\t}\n}");
        this.addEventListener("onAfterSize", evt -> this.onAfterSize((AfterSizeEvent)evt));
        this.addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached());
    }

    private void afterPageAttached() {
        Component p = this.getParent();
        while (p != null) {
            if (p instanceof Tabpanel) {
                p.addEventListener("onMobileSetSelectedTab", evt -> this.invalidate());
                break;
            }
            p = p.getParent();
        }
    }

    private void onAfterSize(AfterSizeEvent evt) {
        int width = evt.getWidth();
        if (width != this.prevWidth) {
            this.prevWidth = width;
            if (this.overflowButton != null) {
                this.overflowButton.detach();
            }
            if (this.overflowPopup != null) {
                this.overflowPopup.detach();
            }
            if (this.overflows != null) {
                for (ToolBarButton btn : this.overflows) {
                    this.appendChild((Component)btn);
                }
                this.overflows = null;
            }
            Events.postEvent((String)"onPostAfterSize", (Component)this, null);
        }
    }

    private void onOverflowButton(Event evt) {
        this.overflows = new ArrayList();
        String uuid = (String)evt.getData();
        boolean overflowStarted = false;
        for (Component comp : this.getChildren()) {
            if (!(comp instanceof ToolBarButton)) continue;
            if (overflowStarted) {
                this.overflows.add((ToolBarButton)comp);
                continue;
            }
            if (!comp.getUuid().equals(uuid)) continue;
            this.overflows.add((ToolBarButton)comp);
            overflowStarted = true;
        }
        if (this.overflows.size() > 0) {
            this.overflowButton = new A();
            this.overflowButton.setIconSclass("z-icon-angle-double-down");
            this.overflowButton.setStyle("position: absolute; right: 2px; bottom: 6px; font-size: 12px; font-weight: 500;");
            this.appendChild((Component)this.overflowButton);
            this.overflowPopup = new Popup();
            this.overflowPopup.addEventListener("onOpen", oe -> {
                if (!oe.isOpen()) {
                    this.overflowPopup.setAttribute("popup.close", (Object)System.currentTimeMillis());
                }
            });
            this.appendChild((Component)this.overflowPopup);
            for (ToolBarButton btn : this.overflows) {
                this.overflowPopup.appendChild((Component)btn);
            }
            this.overflowButton.addEventListener("onClick", e -> {
                Long ts = (Long)this.overflowPopup.removeAttribute("popup.close");
                if (ts != null && System.currentTimeMillis() - ts < 500L) {
                    return;
                }
                this.overflowPopup.open((Component)this.overflowButton, "after_end");
            });
            int cnt = 0;
            for (Component c : this.getChildren()) {
                if (!(c instanceof ToolBarButton)) continue;
                ++cnt;
            }
            if (this.overflows.size() >= cnt) {
                String script = "var e = jq('#" + this.getUuid() + "');";
                script = String.valueOf(script) + "var b=zk.Widget.$('#" + this.overflowPopup.getUuid() + "'); ";
                script = String.valueOf(script) + "b.setWidth(e.css('width'));";
                Clients.evalJavaScript((String)script);
            } else {
                this.overflowPopup.setWidth(null);
            }
        }
    }

    public void onPostAfterSize() {
        if (this.getPage() != null) {
            String script = "var w = zk.Widget.$('#" + this.getUuid() + "'); w.toolbarScrollable(w);";
            Clients.evalJavaScript((String)script);
        }
    }
}

