/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.action;

import java.io.IOException;
import java.io.InputStream;
import org.adempiere.base.IServiceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.action.IAction;
import org.compiere.util.CCache;
import org.zkoss.image.AImage;

public class Actions {
    private static final String ACTION_IMAGES_PATH = "/action/images/";
    private static CCache<String, IServiceHolder<IAction>> trackerCache = new CCache(null, "ActionsServiceTracker", 5, false);
    private static CCache<String, AImage> imageCache = new CCache(null, "ActionsImages", 5, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServiceHolder<IAction> getAction(String actionId) {
        IServiceHolder action = null;
        CCache<String, IServiceHolder<IAction>> cCache = trackerCache;
        synchronized (cCache) {
            action = (IServiceHolder)trackerCache.get((Object)actionId);
        }
        if (action != null) {
            return action;
        }
        action = Service.locator().locate(IAction.class, actionId, null);
        if (action != null) {
            cCache = trackerCache;
            synchronized (cCache) {
                trackerCache.put((Object)actionId, (Object)action);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AImage getActionImage(String actionId) {
        AImage aImage = null;
        CCache<String, AImage> cCache = imageCache;
        synchronized (cCache) {
            aImage = (AImage)imageCache.get((Object)actionId);
        }
        if (aImage != null) {
            return aImage;
        }
        IServiceHolder action = Service.locator().locate(IAction.class, actionId, null);
        if (action.getService() != null) {
            String path = ACTION_IMAGES_PATH + actionId + "24.png";
            InputStream inputStream = ((IAction)action.getService()).getClass().getClassLoader().getResourceAsStream(path);
            if (inputStream != null) {
                try {
                    aImage = new AImage(actionId, inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (aImage != null) {
                CCache<String, AImage> cCache2 = imageCache;
                synchronized (cCache2) {
                    imageCache.put((Object)actionId, (Object)aImage);
                }
            }
        }
        return aImage;
    }
}

