/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;

public class ValuePreference
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 7594680475358417813L;
    public static final String NAME = "ValuePreference";
    private static CLogger log = CLogger.getCLogger(ValuePreference.class);
    private AbstractADWindowContent adwindowContent;
    private Properties m_ctx;
    private int m_WindowNo;
    private int m_AD_Client_ID;
    private int m_AD_Org_ID;
    private int m_AD_User_ID;
    private int m_AD_Window_ID;
    private String m_Attribute;
    private String m_DisplayAttribute;
    private String m_Value;
    private String m_DisplayValue;
    private int m_DisplayType;
    private MRole m_role;
    private int m_AD_Process_ID_Of_Panel;
    private int m_AD_Infowindow_ID;
    private Panel setPanel = new Panel();
    private Grid setLayout = new Grid();
    private Label lAttribute = new Label();
    private Textbox fAttribute = new Textbox();
    private Label lAttributeValue = new Label();
    private Label lValue = new Label();
    private Label lValueValue = new Label();
    private Textbox fValue = new Textbox();
    private Label lSetFor = new Label();
    private Checkbox cbClient = new Checkbox();
    private Checkbox cbOrg = new Checkbox();
    private Checkbox cbUser = new Checkbox();
    private Checkbox cbWindow = new Checkbox();
    private Checkbox cbProcess = new Checkbox();
    private Checkbox cbInfowindow = new Checkbox();
    private Label lExplanation = new Label();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Button bDelete;
    private boolean isProcessInIW = false;

    public static void start(Component ref, GridField mField, Object aValue) {
        if (aValue != null && aValue instanceof Boolean) {
            aValue = (Boolean)aValue != false ? Character.valueOf('Y') : Character.valueOf('N');
        }
        ValuePreference.start(ref, mField, aValue, null);
    }

    public static void start(Component ref, GridField mField, Object aValue, String aDisplayValue) {
        if (!mField.isEditable(false)) {
            log.info("Field not editable (R/O)");
            return;
        }
        String Value = null;
        String DisplayValue = null;
        if (aValue != null) {
            Value = aValue.toString();
            DisplayValue = aDisplayValue == null ? Value : aDisplayValue;
        }
        int AD_Window_ID = mField.getAD_Window_ID_Of_Panel();
        String Attribute2 = mField.getColumnName();
        String DisplayAttribute = mField.getHeader();
        int displayType = mField.getDisplayType();
        int AD_Reference_ID = 0;
        int WindowNo = mField.getWindowNo();
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (String)"AD_Org_ID");
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        ValuePreference vp = new ValuePreference(WindowNo, AD_Client_ID, AD_Org_ID, AD_User_ID, AD_Window_ID, mField.getAD_Process_ID_Of_Panel(), mField.getAD_Infowindow_ID(), Attribute2, DisplayAttribute, Value, DisplayValue, displayType, AD_Reference_ID, ref);
    }

    public ValuePreference(int WindowNo, int AD_Client_ID, int AD_Org_ID, int AD_User_ID, int AD_Window_ID, int AD_Process_ID_Of_Panel, int AD_Infowindow_ID, String Attribute2, String DisplayAttribute, String Value, String DisplayValue, int displayType, int AD_Reference_ID, Component ref) {
        this.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)NAME)) + " " + DisplayAttribute);
        if (log.isLoggable(Level.CONFIG)) {
            log.config("WindowNo=" + WindowNo + ", Client_ID=" + AD_Client_ID + ", Org_ID=" + AD_Org_ID + ", User_ID=" + AD_User_ID + ", Window_ID=" + AD_Window_ID + ",  Attribute=" + Attribute2 + "/" + DisplayAttribute + ",  Value=" + Value + "/" + DisplayValue + ",  DisplayType=" + displayType + ", Reference_ID=" + AD_Reference_ID);
        }
        this.m_ctx = Env.getCtx();
        this.m_WindowNo = WindowNo;
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Window_ID = AD_Window_ID;
        this.m_Attribute = Attribute2;
        this.m_DisplayAttribute = DisplayAttribute;
        this.m_Value = Value;
        this.m_DisplayValue = DisplayValue;
        this.m_DisplayType = displayType;
        this.m_AD_Process_ID_Of_Panel = AD_Process_ID_Of_Panel;
        this.m_AD_Infowindow_ID = AD_Infowindow_ID;
        this.m_role = MRole.getDefault();
        if (this.m_AD_Infowindow_ID > 0 && this.m_AD_Process_ID_Of_Panel > 0) {
            this.isProcessInIW = true;
        }
        try {
            this.init();
            this.dynInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.setClosable(true);
        this.adwindowContent = this.findADWindowContent(ref);
        if (this.adwindowContent != null) {
            ZkCssHelper.appendStyle((HtmlBasedComponent)this, "position: absolute;");
            this.adwindowContent.getComponent().getParent().appendChild((Component)this);
            this.adwindowContent.showBusyMask(this);
            LayoutUtils.openOverlappedWindow(ref, this, "after_start");
        } else {
            AEnv.showCenterScreen(this);
        }
    }

    private AbstractADWindowContent findADWindowContent(Component comp) {
        ADWindow adwindow = ADWindow.findADWindow(comp);
        return adwindow != null ? adwindow.getADWindowContent() : null;
    }

    private void init() throws Exception {
        this.lAttribute.setValue(Msg.translate((Properties)this.m_ctx, (String)"Attribute").replace("&", ""));
        this.lValue.setValue(Msg.translate((Properties)this.m_ctx, (String)"Value").replace("&", ""));
        this.lSetFor.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"ValuePreferenceSetFor"));
        this.cbClient.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_Client_ID"));
        this.cbOrg.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_Org_ID"));
        this.cbUser.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_User_ID"));
        this.cbUser.setChecked(true);
        this.cbWindow.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_Window_ID"));
        this.cbWindow.setChecked(true);
        this.cbProcess.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_Process_ID"));
        this.cbProcess.setChecked(true);
        this.cbInfowindow.setLabel(Msg.translate((Properties)this.m_ctx, (String)"AD_InfoWindow_ID"));
        this.cbInfowindow.setChecked(true);
        this.setPanel.appendChild((Component)this.setLayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.setPanel, "1");
        this.fAttribute.setReadonly(true);
        this.fValue.setReadonly(true);
        Vbox box = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)box, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)box, "100%");
        box.setParent((Component)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)box, "1");
        box.appendChild((Component)this.setPanel);
        Rows rows = new Rows();
        rows.setParent((Component)this.setLayout);
        Row row = new Row();
        Div div = new Div();
        div.setStyle("text-align: right");
        div.appendChild((Component)this.lAttribute);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.fAttribute, 4);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fAttribute, "96%");
        row.appendCellChild((Component)this.lAttributeValue, 1);
        rows.appendChild((Component)row);
        row = new Row();
        div = new Div();
        div.setStyle("text-align: right");
        div.appendChild((Component)this.lValue);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.fValue, 4);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fValue, "96%");
        row.appendCellChild((Component)this.lValueValue, 1);
        rows.appendChild((Component)row);
        row = new Row();
        div = new Div();
        div.setStyle("text-align: right");
        div.appendChild((Component)this.lSetFor);
        row.appendChild((Component)div);
        Hlayout chlayout = new Hlayout();
        chlayout.setSpacing("5px");
        chlayout.appendChild((Component)this.cbClient);
        chlayout.appendChild((Component)this.cbOrg);
        chlayout.appendChild((Component)this.cbUser);
        if (this.isProcessInIW) {
            this.cbWindow.setChecked(true);
        } else {
            chlayout.appendChild((Component)this.cbWindow);
        }
        if (this.m_AD_Infowindow_ID > 0) {
            chlayout.appendChild((Component)this.cbInfowindow);
        }
        if (this.m_AD_Process_ID_Of_Panel > 0) {
            chlayout.appendChild((Component)this.cbProcess);
        }
        row.appendCellChild((Component)chlayout, 5);
        rows.appendChild((Component)row);
        row = new Row();
        row.appendCellChild((Component)new Space(), 1);
        row.appendCellChild((Component)this.lExplanation, 5);
        rows.appendChild((Component)row);
        Separator separator = new Separator();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)separator, "10px");
        box.appendChild((Component)separator);
        box.appendChild((Component)this.confirmPanel);
        this.setBorder("normal");
        this.setLayout.makeNoStrip();
        this.setLayout.setOddRowSclass("even");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        }
        this.setSizable(true);
        this.setSclass("value-preference-dialog");
    }

    private void dynInit() {
        this.fAttribute.setText(this.m_DisplayAttribute);
        this.lAttributeValue.setValue(this.m_Attribute);
        this.fValue.setText(this.m_DisplayValue);
        this.lValueValue.setValue(this.m_Value);
        if (CLogMgt.isLevelFine()) {
            this.lAttributeValue.setVisible(false);
            this.lValueValue.setVisible(false);
        }
        this.cbClient.setEnabled(false);
        this.cbClient.setChecked(true);
        if ("C".equals(this.m_role.getPreferenceType())) {
            this.cbOrg.addEventListener("onCheck", this);
        } else {
            this.cbOrg.setEnabled(false);
            this.cbOrg.setChecked(true);
        }
        if ("C".equals(this.m_role.getPreferenceType()) || "O".equals(this.m_role.getPreferenceType())) {
            this.cbUser.addEventListener("onCheck", this);
        } else {
            this.cbUser.setEnabled(false);
            this.cbUser.setChecked(true);
        }
        this.cbWindow.addEventListener("onCheck", this);
        this.cbProcess.addEventListener("onCheck", this);
        this.cbInfowindow.addEventListener("onCheck", this);
        this.confirmPanel.addComponentsLeft(this.confirmPanel.createButton("Delete"));
        this.confirmPanel.addActionListener("onClick", this);
        this.bDelete = this.confirmPanel.getButton("Delete");
        this.setExplanation();
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Cancel")) {
            this.detach();
        } else if (e.getTarget().getId().equals("Ok")) {
            this.insert();
            this.detach();
        } else if (e.getTarget() == this.bDelete) {
            int no = this.delete();
            if (no == 0) {
                FDialog.warn(this.m_WindowNo, this.getTitle(), "ValuePreferenceNotFound");
            } else {
                FDialog.info(this.m_WindowNo, (Component)this, "ValuePreferenceDeleted", String.valueOf(no));
            }
            this.detach();
        } else {
            this.setExplanation();
        }
    }

    private void setExplanation() {
        StringBuilder expl = new StringBuilder("For ");
        if (this.cbClient.isChecked() && this.cbOrg.isChecked()) {
            expl.append("this Client and Organization");
        } else if (this.cbClient.isChecked() && !this.cbOrg.isChecked()) {
            expl.append("all Organizations of this Client");
        } else if (!this.cbClient.isChecked() && this.cbOrg.isChecked()) {
            this.cbOrg.setChecked(false);
            expl.append("entire System");
        } else {
            expl.append("entire System");
        }
        if (this.cbUser.isChecked()) {
            expl.append(", this User");
        } else {
            expl.append(", all Users");
        }
        if (this.cbWindow.isChecked()) {
            expl.append(" and this Window");
        } else {
            expl.append(" and all Windows");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0) {
            if (this.cbProcess.isChecked()) {
                expl.append(" and this Process");
            } else {
                expl.append(" and all Process");
            }
        }
        if (this.m_AD_Infowindow_ID > 0) {
            if (this.cbInfowindow.isChecked()) {
                expl.append(" and this Info Window");
            } else {
                expl.append(" and all Info Window");
            }
        }
        if (Env.getLanguage((Properties)Env.getCtx()).isBaseLanguage()) {
            this.lExplanation.setValue(expl.toString());
        }
    }

    public int delete() {
        int no;
        log.info("");
        StringBuilder sql = new StringBuilder("DELETE FROM AD_Preference WHERE ");
        sql.append("AD_Client_ID=").append(this.cbClient.isChecked() ? this.m_AD_Client_ID : 0);
        sql.append(" AND AD_Org_ID=").append(this.cbOrg.isChecked() ? this.m_AD_Org_ID : 0);
        if (this.cbUser.isChecked()) {
            sql.append(" AND AD_User_ID=").append(this.m_AD_User_ID);
        } else {
            sql.append(" AND AD_User_ID IS NULL");
        }
        if (this.cbWindow.isChecked()) {
            sql.append(" AND AD_Window_ID=").append(this.m_AD_Window_ID);
        } else {
            sql.append(" AND AD_Window_ID IS NULL");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0 && this.cbProcess.isChecked()) {
            sql.append(" AND AD_Process_ID=").append(this.m_AD_Process_ID_Of_Panel);
        } else {
            sql.append(" AND AD_Process_ID IS NULL");
        }
        if (this.m_AD_Infowindow_ID > 0 && this.cbInfowindow.isChecked()) {
            sql.append(" AND AD_InfoWindow_ID=").append(this.m_AD_Infowindow_ID);
        } else {
            sql.append(" AND AD_InfoWindow_ID IS NULL");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0) {
            sql.append(" AND PreferenceFor = 'P'");
        } else if (this.m_AD_Infowindow_ID > 0) {
            sql.append(" AND PreferenceFor = 'I'");
        } else {
            sql.append(" AND PreferenceFor = 'W'");
        }
        sql.append(" AND Attribute='").append(this.m_Attribute).append("'");
        if (log.isLoggable(Level.FINE)) {
            log.fine(sql.toString());
        }
        if ((no = DB.executeUpdate((String)sql.toString(), null)) > 0) {
            Env.setContext((Properties)this.m_ctx, (String)this.getContextKey(), null);
        }
        return no;
    }

    private String getContextKey() {
        StringBuilder preferencesContextKey = new StringBuilder("P");
        if (this.m_AD_Window_ID > 0) {
            preferencesContextKey.append(this.m_AD_Window_ID);
        } else {
            preferencesContextKey.append("0");
        }
        if (this.cbInfowindow.isChecked()) {
            preferencesContextKey.append("|").append(this.m_AD_Infowindow_ID);
        } else {
            preferencesContextKey.append("|0");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0) {
            if (this.cbProcess.isChecked()) {
                return preferencesContextKey.append("|").append(this.m_AD_Process_ID_Of_Panel).append("|").append(this.m_Attribute).toString();
            }
            return preferencesContextKey.append("|0|").append(this.m_Attribute).toString();
        }
        if (this.m_AD_Infowindow_ID > 0) {
            return preferencesContextKey.append("|").append(this.m_Attribute).toString();
        }
        if (this.cbWindow.isChecked()) {
            return "P" + this.m_AD_Window_ID + "|" + this.m_Attribute;
        }
        return "P|" + this.m_Attribute;
    }

    public void insert() {
        log.info("");
        int no = this.delete();
        if (this.m_Value == null || this.m_Value.length() == 0) {
            if (DisplayType.isLookup((int)this.m_DisplayType)) {
                this.m_Value = "-1";
            } else if (DisplayType.isDate((int)this.m_DisplayType)) {
                this.m_Value = " ";
            } else {
                FDialog.warn(this.m_WindowNo, this.getTitle(), "ValuePreferenceNotInserted");
                return;
            }
        }
        int Client_ID = this.cbClient.isChecked() ? this.m_AD_Client_ID : 0;
        int Org_ID = this.cbOrg.isChecked() ? this.m_AD_Org_ID : 0;
        int AD_Preference_ID = DB.getNextID((Properties)this.m_ctx, (String)"AD_Preference", null);
        StringBuilder sql = new StringBuilder("INSERT INTO AD_Preference (AD_Preference_ID, AD_Preference_UU, AD_Client_ID, AD_Org_ID, IsActive, Created,CreatedBy,Updated,UpdatedBy,AD_Window_ID, AD_Process_ID, AD_InfoWindow_ID, PreferenceFor, AD_User_ID, Attribute, Value) VALUES (");
        sql.append(AD_Preference_ID).append(",").append(DB.TO_STRING((String)UUID.randomUUID().toString())).append(",").append(Client_ID).append(",").append(Org_ID).append(", 'Y',SysDate,").append(this.m_AD_User_ID).append(",SysDate,").append(this.m_AD_User_ID).append(", ");
        if (this.cbWindow.isChecked()) {
            sql.append(this.m_AD_Window_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0 && this.cbProcess.isChecked()) {
            sql.append(this.m_AD_Process_ID_Of_Panel).append(",");
        } else {
            sql.append("NULL,");
        }
        if (this.m_AD_Infowindow_ID > 0 && this.cbInfowindow.isChecked()) {
            sql.append(this.m_AD_Infowindow_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        if (this.m_AD_Process_ID_Of_Panel > 0) {
            sql.append("'P',");
        } else if (this.m_AD_Infowindow_ID > 0) {
            sql.append("'I',");
        } else {
            sql.append("'W',");
        }
        if (this.cbUser.isChecked()) {
            sql.append(this.m_AD_User_ID).append(",");
        } else {
            sql.append("NULL,");
        }
        sql.append(DB.TO_STRING((String)this.m_Attribute)).append(",").append(DB.TO_STRING((String)this.m_Value)).append(")");
        if (log.isLoggable(Level.FINE)) {
            log.fine(sql.toString());
        }
        if ((no = DB.executeUpdate((String)sql.toString(), null)) == 1) {
            Env.setContext((Properties)this.m_ctx, (String)this.getContextKey(), (String)this.m_Value);
            FDialog.info(this.m_WindowNo, (Component)this, "ValuePreferenceInserted");
        } else {
            FDialog.warn(this.m_WindowNo, this.getTitle(), "ValuePreferenceNotInserted");
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.adwindowContent != null) {
            this.adwindowContent.hideBusyMask();
        }
    }
}

