/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.io.Serializable;
import java.util.Properties;
import java.util.TimeZone;
import org.adempiere.webui.session.SessionManager;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.Callback;

public class ClientInfo
implements Serializable {
    private static final long serialVersionUID = -713195891415378500L;
    public int colorDepth;
    public int desktopWidth;
    public int desktopHeight;
    public int desktopXOffset;
    public int desktopYOffset;
    public int screenHeight;
    public int screenWidth;
    public String orientation;
    public TimeZone timeZone;
    public String userAgent;
    public boolean tablet;
    public double devicePixelRatio;
    public static final int LARGE_WIDTH = 1200;
    public static final int MEDIUM_WIDTH = 1000;
    public static final int SMALL_WIDTH = 700;
    public static final int EXTRA_SMALL_WIDTH = 500;
    public static final int LARGE_HEIGHT = 1000;
    public static final int MEDIUM_HEIGHT = 700;
    public static final int SMALL_HEIGHT = 500;
    public static final int EXTRA_SMALL_HEIGHT = 360;
    private static String AFTER_PAGE_DETACHED = "afterPageDetached";

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User Agent: ").append(this.userAgent).append("\r\n").append("Time Zone: ").append(this.timeZone.getID()).append("\r\n").append("Screen Size: ").append(this.screenWidth).append(" x ").append(this.screenHeight).append("\r\n").append("Browser Desktop Size: ").append(this.desktopWidth).append(" x ").append(this.desktopHeight).append("\r\n").append("Orientation: ").append(this.orientation).append("\r\n").append("Color Depth: ").append(this.colorDepth).append("\r\n").append("Pixel Ratio: ").append(this.devicePixelRatio);
        return builder.toString();
    }

    public static boolean isMobile() {
        return "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#clientInfo_mobile"));
    }

    public static ClientInfo get() {
        return SessionManager.getSessionApplication().getClientInfo();
    }

    public static boolean minWidth(int minWidth) {
        return ClientInfo.get().desktopWidth > 0 && ClientInfo.get().desktopWidth >= minWidth;
    }

    public static boolean maxWidth(int maxWidth) {
        return ClientInfo.get().desktopWidth > 0 && ClientInfo.get().desktopWidth <= maxWidth;
    }

    public static boolean minHeight(int minHeight) {
        return ClientInfo.get().desktopHeight > 0 && ClientInfo.get().desktopHeight >= minHeight;
    }

    public static boolean maxHeight(int maxHeight) {
        return ClientInfo.get().desktopHeight > 0 && ClientInfo.get().desktopHeight <= maxHeight;
    }

    public static void onClientInfo(Component component, Runnable runnable) {
        ComponentCtrl ctrl = (ComponentCtrl)component;
        EventListener eventListener = evt -> runnable.run();
        Component root = SessionManager.getAppDesktop().getComponent().getRoot();
        root.addEventListener("onClientInfo", eventListener);
        ctrl.addCallback(AFTER_PAGE_DETACHED, (Callback & Serializable)t -> {
            boolean bl = root.removeEventListener("onClientInfo", eventListener);
        });
    }
}

