/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.adempiere.util.ServerContext;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.IWebClient;
import org.adempiere.webui.WLogin;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.DrillCommand;
import org.adempiere.webui.component.TokenCommand;
import org.adempiere.webui.component.ZoomCommand;
import org.adempiere.webui.desktop.DefaultDesktop;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.session.SessionContextListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.BrowserToken;
import org.adempiere.webui.util.UserPreference;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkforge.keylistener.Keylistener;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.ClientInfoEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Window;

public class AdempiereWebUI
extends Window
implements EventListener<Event>,
IWebClient {
    private static final long serialVersionUID = -3320656546509525766L;
    private static final String SAVED_CONTEXT = "saved.context";
    public static final String APPLICATION_DESKTOP_KEY = "application.desktop";
    public static String APP_NAME = null;
    public static final String UID = "1.0.0";
    public static final String WIDGET_INSTANCE_NAME = "instanceName";
    private WLogin loginDesktop;
    private ClientInfo clientInfo = new ClientInfo();
    private String langSession;
    private UserPreference userPreference;
    private MUserPreference userPreferences;
    private Keylistener keyListener;
    private static final CLogger logger = CLogger.getCLogger(AdempiereWebUI.class);
    public static final String EXECUTION_CARRYOVER_SESSION_KEY = "execution.carryover";
    private static final String CLIENT_INFO = "client.info";
    private static boolean eventThreadEnabled = false;
    private ConcurrentMap<String, String[]> m_URLParameters;

    public AdempiereWebUI() {
        this.setVisible(false);
        this.userPreference = new UserPreference();
        this.m_URLParameters = new ConcurrentHashMap<String, String[]>(Executions.getCurrent().getParameterMap());
    }

    public void onCreate() {
        this.getPage().setTitle(ThemeManager.getBrowserTitle());
        SessionManager.setSessionApplication(this);
        Session session = Executions.getCurrent().getDesktop().getSession();
        Map map = (Map)session.removeAttribute(SAVED_CONTEXT);
        if (map != null && !map.isEmpty()) {
            this.onChangeRole(map);
            return;
        }
        Properties ctx = Env.getCtx();
        this.langSession = Env.getContext((Properties)ctx, (String)"#AD_Language");
        if (session.getAttribute("WebUISessionContext") == null || !SessionManager.isUserLoggedIn(ctx)) {
            this.loginDesktop = new WLogin(this);
            this.loginDesktop.createPart(this.getPage());
            this.loginDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
        } else {
            this.loginCompleted();
        }
        Executions.getCurrent().getDesktop().enableServerPush(true);
        Executions.getCurrent().getDesktop().addListener((Object)new DrillCommand());
        Executions.getCurrent().getDesktop().addListener((Object)new TokenCommand());
        Executions.getCurrent().getDesktop().addListener((Object)new ZoomCommand());
        eventThreadEnabled = Executions.getCurrent().getDesktop().getWebApp().getConfiguration().isEventThreadEnabled();
    }

    public void onOk() {
    }

    public void onCancel() {
    }

    @Override
    public void loginCompleted() {
        Properties ctx;
        String langLogin;
        if (this.loginDesktop != null) {
            this.loginDesktop.getComponent().getRoot().removeEventListener("onClientInfo", (EventListener)this);
            this.loginDesktop.detach();
            this.loginDesktop = null;
        }
        if ((langLogin = Env.getContext((Properties)(ctx = Env.getCtx()), (String)"#AD_Language")) == null || langLogin.length() <= 0) {
            langLogin = this.langSession;
            Env.setContext((Properties)ctx, (String)"#AD_Language", (String)this.langSession);
        }
        MSystem system = MSystem.get((Properties)Env.getCtx());
        Env.setContext((Properties)ctx, (String)"#System_Name", (String)system.getName());
        Language language = Language.getLanguage((String)langLogin);
        String locale = Env.getContext((Properties)ctx, (String)"#Locale");
        if (locale != null && locale.length() > 0 && !language.getLocale().toString().equals(locale)) {
            String adLanguage = language.getAD_Language();
            Language tmp = Language.getLanguage((String)locale);
            language = new Language(tmp.getName(), adLanguage, tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        } else {
            Language tmp = language;
            language = new Language(tmp.getName(), tmp.getAD_Language(), tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        }
        Env.verifyLanguage((Properties)ctx, (Language)language);
        Env.setContext((Properties)ctx, (String)"#AD_Language", (String)language.getAD_Language());
        StringBuilder calendarMsgScript = new StringBuilder();
        String monthMore = Msg.getMsg((Properties)ctx, (String)"more");
        String dayMore = Msg.getMsg((Properties)ctx, (String)"more");
        calendarMsgScript.append("function _overrideMsgCal() { msgcal.monthMORE = '+{0} ").append(monthMore).append("';");
        calendarMsgScript.append("msgcal.dayMORE = '+{0} ").append(dayMore).append("'; }");
        AuScript auscript = new AuScript(calendarMsgScript.toString());
        Clients.response((AuResponse)auscript);
        Session currSess = Executions.getCurrent().getDesktop().getSession();
        HttpSession httpSess = (HttpSession)currSess.getNativeSession();
        String x_Forward_IP = Executions.getCurrent().getHeader("X-Forwarded-For");
        MSession mSession = MSession.get((Properties)ctx, (String)(x_Forward_IP != null ? x_Forward_IP : Executions.getCurrent().getRemoteAddr()), (String)Executions.getCurrent().getRemoteHost(), (String)httpSess.getId());
        if (this.clientInfo.userAgent != null) {
            mSession.setDescription(String.valueOf(mSession.getDescription()) + "\n" + this.clientInfo.toString());
            mSession.saveEx();
        }
        currSess.setAttribute("Check_AD_User_ID", (Object)Env.getAD_User_ID((Properties)ctx));
        Env.setContext((Properties)ctx, (String)"#ShowTrl", (boolean)true);
        Env.setContext((Properties)ctx, (String)"#ShowAcct", (boolean)MRole.getDefault().isShowAcct());
        this.userPreference = this.loadUserPreference(Env.getAD_User_ID((Properties)ctx));
        this.userPreferences = MUserPreference.getUserPreference((int)Env.getAD_User_ID((Properties)ctx), (int)Env.getAD_Client_ID((Properties)ctx));
        this.userPreferences.fillPreferences();
        this.keyListener = new Keylistener();
        this.keyListener.setPage(this.getPage());
        this.keyListener.setCtrlKeys("@a@c@d@e@f@h@n@o@p@r@s@t@z@x@#left@#right@#up@#down@#home@#end#enter^u@u@#pgdn@#pgup");
        this.keyListener.setAutoBlur(false);
        IDesktop appDesktop = this.createDesktop();
        appDesktop.setClientInfo(this.clientInfo);
        appDesktop.createPart(this.getPage());
        this.getPage().getDesktop().setAttribute(APPLICATION_DESKTOP_KEY, new WeakReference<IDesktop>(appDesktop));
        appDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
        SessionContextListener.addDesktopId(mSession.getAD_Session_ID(), this.getPage().getDesktop().getId());
        if (!this.getPage().getDesktop().isServerPushEnabled()) {
            this.getPage().getDesktop().enableServerPush(true);
        }
        currSess.setAttribute("WebUISessionContext", (Object)ServerContext.getCurrentInstance());
        MUser user = MUser.get((Properties)ctx);
        BrowserToken.save(mSession, user);
        Env.setContext((Properties)ctx, (String)"#UIClient", (String)"zk");
        Env.setContext((Properties)ctx, (String)"#DBType", (String)DB.getDatabase().getName());
        StringBuilder localHttpAddr = new StringBuilder(Executions.getCurrent().getScheme());
        localHttpAddr.append("://").append(Executions.getCurrent().getLocalAddr());
        int port = Executions.getCurrent().getLocalPort();
        if (port > 0 && port != 80) {
            localHttpAddr.append(":").append(port);
        }
        Env.setContext((Properties)ctx, (String)"#LocalHttpAddr", (String)localHttpAddr.toString());
        Clients.response((AuResponse)new AuScript("zAu.cmd0.clearBusy()"));
        FavouriteController.getInstance(currSess);
        this.processParameters();
    }

    private void processParameters() {
        String action = this.getPrmString("Action");
        if ("Zoom".equalsIgnoreCase(action)) {
            MTable table;
            String tableName;
            int tableID = this.getPrmInt("AD_Table_ID");
            if (tableID == 0 && !Util.isEmpty((String)(tableName = this.getPrmString("TableName"))) && (table = MTable.get((Properties)Env.getCtx(), (String)tableName)) != null) {
                tableID = table.getAD_Table_ID();
            }
            int recordID = this.getPrmInt("Record_ID");
            if (tableID > 0) {
                AEnv.zoom(tableID, recordID);
            }
        }
        this.m_URLParameters = null;
    }

    private String getPrmString(String prm) {
        String[] strs;
        String retValue = "";
        if (this.m_URLParameters != null && (strs = (String[])this.m_URLParameters.get(prm)) != null && strs.length == 1 && strs[0] != null) {
            retValue = strs[0];
        }
        return retValue;
    }

    private int getPrmInt(String prm) {
        int retValue = 0;
        String str = this.getPrmString(prm);
        try {
            if (!Util.isEmpty((String)str)) {
                retValue = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retValue;
    }

    @Override
    public Keylistener getKeylistener() {
        return this.keyListener;
    }

    private IDesktop createDesktop() {
        IDesktop appDesktop = null;
        String className = MSysConfig.getValue((String)"ZK_DESKTOP_CLASS");
        if (className != null && className.trim().length() > 0) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                appDesktop = (IDesktop)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                logger.warning("Failed to instantiate desktop. Class=" + className);
            }
        }
        if (appDesktop == null) {
            appDesktop = new DefaultDesktop();
        }
        return appDesktop;
    }

    @Override
    public void logout() {
        Session session = this.logout0();
        DesktopCache desktopCache = ((SessionCtrl)session).getDesktopCache();
        Env.getCtx().clear();
        session.invalidate();
        Executions.sendRedirect((String)"index.zul");
        if (desktopCache != null) {
            desktopCache.removeDesktop(Executions.getCurrent().getDesktop());
        }
    }

    @Override
    public void logoutAfterTabDestroyed() {
        Session session = this.logout0();
        Env.getCtx().clear();
        session.invalidate();
    }

    protected Session logout0() {
        IDesktop appDesktop;
        Session session = Executions.getCurrent().getDesktop().getSession();
        if (this.keyListener != null) {
            this.keyListener.detach();
            this.keyListener = null;
        }
        if ((appDesktop = this.getAppDeskop()) != null) {
            appDesktop.logout();
        }
        this.getChildren().clear();
        this.getPage().removeComponents();
        session.getAttributes().clear();
        AEnv.logout();
        return session;
    }

    @Override
    public IDesktop getAppDeskop() {
        WeakReference ref;
        Desktop desktop = Executions.getCurrent() != null ? Executions.getCurrent().getDesktop() : null;
        IDesktop appDesktop = null;
        if (desktop != null && (ref = (WeakReference)desktop.getAttribute(APPLICATION_DESKTOP_KEY)) != null) {
            appDesktop = (IDesktop)ref.get();
        }
        return appDesktop;
    }

    public void onEvent(Event event) {
        if (event instanceof ClientInfoEvent) {
            String ua;
            ClientInfoEvent c = (ClientInfoEvent)event;
            this.clientInfo = new ClientInfo();
            this.clientInfo.colorDepth = c.getColorDepth();
            this.clientInfo.screenHeight = c.getScreenHeight();
            this.clientInfo.screenWidth = c.getScreenWidth();
            this.clientInfo.devicePixelRatio = c.getDevicePixelRatio();
            this.clientInfo.desktopHeight = c.getDesktopHeight();
            this.clientInfo.desktopWidth = c.getDesktopWidth();
            this.clientInfo.desktopXOffset = c.getDesktopXOffset();
            this.clientInfo.desktopYOffset = c.getDesktopYOffset();
            this.clientInfo.orientation = c.getOrientation();
            this.clientInfo.timeZone = c.getTimeZone();
            this.clientInfo.userAgent = ua = Servlets.getUserAgent((ServletRequest)((ServletRequest)Executions.getCurrent().getNativeRequest()));
            ua = ua.toLowerCase();
            this.clientInfo.tablet = false;
            if (Executions.getCurrent().getBrowser("mobile") != null) {
                this.clientInfo.tablet = true;
            } else if (ua.contains("ipad") || ua.contains("iphone") || ua.contains("android")) {
                this.clientInfo.tablet = true;
            }
            if (this.getDesktop() != null && this.getDesktop().getSession() != null) {
                this.getDesktop().getSession().setAttribute(CLIENT_INFO, (Object)this.clientInfo);
            } else if (Executions.getCurrent() != null) {
                Executions.getCurrent().getSession().setAttribute(CLIENT_INFO, (Object)this.clientInfo);
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_desktopWidth", (int)this.clientInfo.desktopWidth);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_desktopHeight", (int)this.clientInfo.desktopHeight);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_orientation", (String)this.clientInfo.orientation);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_mobile", (boolean)this.clientInfo.tablet);
            IDesktop appDesktop = this.getAppDeskop();
            if (appDesktop != null) {
                appDesktop.setClientInfo(this.clientInfo);
            }
        }
    }

    private void onChangeRole(Map<String, Object> map) {
        Locale locale = (Locale)map.get("locale");
        Properties properties = (Properties)map.get("context");
        SessionManager.setSessionApplication(this);
        this.loginDesktop = new WLogin(this);
        this.loginDesktop.createPart(this.getPage());
        this.loginDesktop.changeRole(locale, properties);
        this.loginDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
    }

    @Override
    public UserPreference loadUserPreference(int userId) {
        this.userPreference.loadPreference(userId);
        return this.userPreference;
    }

    @Override
    public UserPreference getUserPreference() {
        return this.userPreference;
    }

    public static boolean isEventThreadEnabled() {
        return eventThreadEnabled;
    }

    @Override
    public void changeRole(MUser user) {
        Properties properties = new Properties();
        Env.setContext((Properties)properties, (String)"#AD_Client_ID", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_Org_ID", (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_User_ID", (int)user.getAD_User_ID());
        Env.setContext((Properties)properties, (String)"#AD_Role_ID", (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_Org_Name", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Org_Name"));
        Env.setContext((Properties)properties, (String)"#M_Warehouse_ID", (String)Env.getContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID"));
        Env.setContext((Properties)properties, (String)"#LanguageName", (String)Env.getContext((Properties)Env.getCtx(), (String)"#LanguageName"));
        Env.setContext((Properties)properties, (String)"#AD_Language", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Language"));
        Env.setContext((Properties)properties, (String)"#Locale", (String)Env.getContext((Properties)Env.getCtx(), (String)"#Locale"));
        Locale locale = (Locale)Executions.getCurrent().getDesktop().getSession().getAttribute("org.zkoss.web.preferred.locale");
        HttpServletRequest httpRequest = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
        Session session = this.logout0();
        Env.getCtx().clear();
        ((SessionCtrl)session).invalidateNow();
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        map.put("context", properties);
        map.put("locale", locale);
        HttpSession newSession = httpRequest.getSession(true);
        newSession.setAttribute(SAVED_CONTEXT, map);
        properties.setProperty("servlet.sessionId", newSession.getId());
        Executions.sendRedirect((String)"index.zul");
    }

    @Override
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public static String getUploadSetting() {
        StringBuilder uploadSetting = new StringBuilder("true,native");
        int size = MSysConfig.getIntValue((String)"ZK_MAX_UPLOAD_SIZE", (int)0);
        if (size > 0) {
            uploadSetting.append(",maxsize=").append(size);
        }
        return uploadSetting.toString();
    }
}

