/*
 * Decompiled with CFR 0.152.
 */
package fi.jawsy.jawwa.zk.atmosphere;

import fi.jawsy.jawwa.zk.atmosphere.AtmosphereServerPush;
import fi.jawsy.jawwa.zk.atmosphere.Either;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResponse;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class ZkAtmosphereHandler
implements AtmosphereHandler {
    public void destroy() {
    }

    private Either<String, Desktop> getDesktop(Session session, String dtid) {
        if (session.getWebApp() instanceof WebAppCtrl) {
            WebAppCtrl webAppCtrl = (WebAppCtrl)session.getWebApp();
            Desktop desktop = webAppCtrl.getDesktopCache(session).getDesktopIfAny(dtid);
            return new Either<String, Desktop>("Could not find desktop", desktop);
        }
        return new Either<String, Object>("Webapp does not implement WebAppCtrl", null);
    }

    private Either<String, String> getDesktopId(HttpServletRequest request) {
        String dtid = request.getParameter("dtid");
        return new Either<String, String>(dtid, "Could not find desktop id");
    }

    private Either<String, AtmosphereServerPush> getServerPush(AtmosphereResource resource) {
        AtmosphereRequest request = resource.getRequest();
        Either<String, Session> sessionEither = this.getSession(resource, (HttpServletRequest)request);
        if (sessionEither.getRightValue() == null) {
            return new Either<String, Object>(sessionEither.getLeftValue(), null);
        }
        Session session = sessionEither.getRightValue();
        Either<String, String> dtidEither = this.getDesktopId((HttpServletRequest)request);
        if (dtidEither.getLeftValue() == null || dtidEither.getLeftValue().trim().length() == 0) {
            return new Either<String, Object>(dtidEither.getRightValue(), null);
        }
        String dtid = dtidEither.getLeftValue();
        Either<String, Desktop> desktopEither = this.getDesktop(session, dtid);
        if (desktopEither.getRightValue() == null) {
            return new Either<String, Object>(desktopEither.getLeftValue(), null);
        }
        Desktop desktop = desktopEither.getRightValue();
        return this.getServerPush(desktop);
    }

    private Either<String, AtmosphereServerPush> getServerPush(Desktop desktop) {
        if (desktop instanceof DesktopCtrl) {
            DesktopCtrl desktopCtrl = (DesktopCtrl)desktop;
            if (desktopCtrl.getServerPush() == null) {
                return new Either<String, Object>("Server push is not enabled", null);
            }
            if (desktopCtrl.getServerPush() instanceof AtmosphereServerPush) {
                return new Either<Object, AtmosphereServerPush>(null, (AtmosphereServerPush)desktopCtrl.getServerPush());
            }
            return new Either<String, Object>("Server push implementation is not AtmosphereServerPush", null);
        }
        return new Either<String, Object>("Desktop does not implement DesktopCtrl", null);
    }

    private Either<String, Session> getSession(AtmosphereResource resource, HttpServletRequest request) {
        Session session = WebManager.getSession((ServletContext)resource.getAtmosphereConfig().getServletContext(), (HttpServletRequest)request, (boolean)false);
        if (session == null) {
            return new Either<String, Object>("Could not find session", null);
        }
        return new Either<Object, Session>(null, session);
    }

    public void onRequest(AtmosphereResource resource) throws IOException {
        AtmosphereResponse response = resource.getResponse();
        response.setContentType("text/plain");
        Either<String, AtmosphereServerPush> serverPushEither = this.getServerPush(resource);
        String error = serverPushEither.getLeftValue();
        if (error != null && serverPushEither.getRightValue() == null) {
            response.setStatus(400);
            response.getWriter().write(error);
            response.getWriter().flush();
            return;
        }
        AtmosphereServerPush serverPush = serverPushEither.getRightValue();
        serverPush.onRequest(resource);
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        AtmosphereServerPush serverPush;
        AtmosphereResource resource = event.getResource();
        if ((event.isCancelled() || event.isResumedOnTimeout()) && (serverPush = this.getServerPush(resource).getRightValue()) != null) {
            serverPush.clearResource(resource);
        }
    }
}

