/*
 * Decompiled with CFR 0.152.
 */
package fi.jawsy.jawwa.zk.atmosphere;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.impl.ExecutionCarryOver;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.util.Clients;

public class AtmosphereServerPush
implements ServerPush {
    private static final String ON_ACTIVATE_DESKTOP = "onActivateDesktop";
    public static final int DEFAULT_TIMEOUT = 120000;
    private final AtomicReference<Desktop> desktop = new AtomicReference();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<AtmosphereResource> resource = new AtomicReference();
    private final int timeout;
    private ThreadInfo _active;
    private ExecutionCarryOver _carryOver;
    private final Object _mutex = new Object();

    public AtmosphereServerPush() {
        String timeoutString = Library.getProperty((String)"fi.jawsy.jawwa.zk.atmosphere.timeout");
        this.timeout = timeoutString == null || timeoutString.trim().length() == 0 ? 120000 : Integer.valueOf(timeoutString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active.thread.equals(curr)) {
            ++this._active.nActive;
            return true;
        }
        final ThreadInfo info = new ThreadInfo(curr);
        EventListener<Event> task = new EventListener<Event>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event event) throws Exception {
                if (event.getName().equals(AtmosphereServerPush.ON_ACTIVATE_DESKTOP)) {
                    Object object = AtmosphereServerPush.this._mutex;
                    synchronized (object) {
                        AtmosphereServerPush.this._carryOver = new ExecutionCarryOver(AtmosphereServerPush.this.desktop.get());
                        ThreadInfo threadInfo = info;
                        synchronized (threadInfo) {
                            info.nActive = 1;
                            info.notifyAll();
                        }
                        try {
                            AtmosphereServerPush.this._mutex.wait();
                        }
                        catch (InterruptedException ex) {
                            throw UiException.Aide.wrap((Throwable)ex);
                        }
                    }
                }
            }
        };
        ThreadInfo threadInfo = info;
        synchronized (threadInfo) {
            Executions.schedule((Desktop)this.desktop.get(), (EventListener)task, (Event)new Event(ON_ACTIVATE_DESKTOP));
            if (info.nActive == 0) {
                info.wait(timeout <= 0L ? 600000L : timeout);
            }
        }
        this._carryOver.carryOver();
        this._active = info;
        return true;
    }

    public void clearResource(AtmosphereResource resource) {
        this.resource.compareAndSet(resource, null);
    }

    private boolean commitResponse() throws IOException {
        AtmosphereResource resource = this.resource.getAndSet(null);
        if (resource != null && resource.isSuspended()) {
            resource.resume();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active.thread) && --this._active.nActive <= 0) {
            if (stop) {
                this.stop();
                stopped = true;
            }
            this._carryOver.cleanup();
            this._carryOver = null;
            this._active.nActive = 0;
            this._active = null;
            Object object = this._mutex;
            synchronized (object) {
                this._mutex.notifyAll();
            }
        }
        return stopped;
    }

    public boolean isActive() {
        return this._active != null && this._active.nActive > 0;
    }

    public void onPiggyback() {
    }

    public <T extends Event> void schedule(EventListener<T> task, T event, Scheduler<T> scheduler) {
        scheduler.schedule(task, event);
        try {
            this.commitResponse();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void start(Desktop desktop) {
        Desktop oldDesktop = this.desktop.getAndSet(desktop);
        if (oldDesktop != null) {
            this.log.warn("Server push already started for desktop " + desktop.getId());
            return;
        }
        this.log.debug("Starting server push for " + desktop);
        Clients.response((String)"jawwa.atmosphere.serverpush", (AuResponse)new AuScript(null, "jawwa.atmosphere.startServerPush('" + desktop.getId() + "', " + this.timeout + ");"));
    }

    public void stop() {
        Desktop desktop = this.desktop.getAndSet(null);
        if (desktop == null) {
            this.log.warn("Server push hasn't been started or has already stopped");
            return;
        }
        this.log.debug("Stopping server push for " + desktop);
        Clients.response((String)"jawwa.atmosphere.serverpush", (AuResponse)new AuScript(null, "jawwa.atmosphere.stopServerPush('" + desktop.getId() + "');"));
        try {
            this.commitResponse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onRequest(AtmosphereResource resource) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(resource.transport().name());
        }
        try {
            this.commitResponse();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        DesktopCtrl desktopCtrl = (DesktopCtrl)this.desktop.get();
        if (desktopCtrl == null) {
            this.log.error("No desktop available");
            return;
        }
        if (!resource.isSuspended()) {
            resource.suspend(-1L);
        }
        this.resource.set(resource);
    }

    public void resume() {
    }

    private static class ThreadInfo {
        private final Thread thread;
        private int nActive;

        private ThreadInfo(Thread thread) {
            this.thread = thread;
        }

        public String toString() {
            return "[" + this.thread + ',' + this.nActive + ']';
        }
    }
}

