/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.POFinder;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.X_AD_Package_Imp_Backup;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractElementHandler
implements ElementHandler {
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public X_AD_Package_Imp_Detail createImportDetail(PIPOContext ctx, String type, String tableName, int tableId) {
        X_AD_Package_Imp_Detail impDetail = new X_AD_Package_Imp_Detail(ctx.ctx, 0, this.getTrxName(ctx));
        impDetail.setAD_Package_Imp_ID(this.getPackageImpId(ctx.ctx));
        impDetail.setAD_Org_ID(Env.getAD_Org_ID((Properties)ctx.ctx));
        impDetail.setType(type);
        impDetail.setName("");
        impDetail.setAction("");
        impDetail.setRecord_ID(1);
        impDetail.setTableName(tableName);
        impDetail.setAD_Table_ID(tableId);
        impDetail.saveEx(this.getTrxName(ctx));
        return impDetail;
    }

    public void logImportDetail(PIPOContext ctx, X_AD_Package_Imp_Detail detail, int success, String objectName, int objectID, String action) throws SAXException {
        String result = success == 1 ? "Success" : "Failure";
        detail.setName(objectName);
        detail.setAction(action);
        detail.setSuccess(result);
        if (objectID >= 0) {
            detail.setRecord_ID(objectID);
        }
        ctx.packIn.addImportDetail(detail);
        StringBuilder msg = new StringBuilder(action).append(" ");
        if (detail.getTableName() != null) {
            msg.append(detail.getTableName());
        }
        msg.append("=").append(objectName).append("[").append(objectID).append("]");
        if (success == 1) {
            ctx.packIn.getNotifier().addSuccessLine(msg.toString());
        } else {
            ctx.packIn.getNotifier().addFailureLine(msg.toString());
        }
    }

    public void backupRecord(PIPOContext ctx, int AD_Package_Imp_Detail_ID, String tableName, PO from) {
        MTable mTable = MTable.get((Properties)ctx.ctx, (String)tableName);
        int tableID = mTable.getAD_Table_ID();
        POInfo poInfo = POInfo.getPOInfo((Properties)ctx.ctx, (int)tableID);
        CPreparedStatement pstmtReferenceId = DB.prepareStatement((String)"SELECT AD_Reference_ID FROM AD_COLUMN WHERE AD_Column_ID = ?", (String)this.getTrxName(ctx));
        ResultSet rs = null;
        try {
            try {
                int i = 0;
                while (i < poInfo.getColumnCount()) {
                    if (from.is_ValueChanged(i)) {
                        MColumn mColumn = mTable.getColumn(poInfo.getColumnName(i));
                        int columnID = mColumn.getAD_Column_ID();
                        int referenceID = 0;
                        pstmtReferenceId.setInt(1, columnID);
                        rs = pstmtReferenceId.executeQuery();
                        if (rs.next()) {
                            referenceID = rs.getInt(1);
                        }
                        X_AD_Package_Imp_Backup backup = new X_AD_Package_Imp_Backup(ctx.ctx, 0, this.getTrxName(ctx));
                        backup.setAD_Org_ID(Env.getAD_Org_ID((Properties)ctx.ctx));
                        backup.setAD_Package_Imp_ID(this.getPackageImpId(ctx.ctx));
                        backup.setAD_Package_Imp_Detail_ID(AD_Package_Imp_Detail_ID);
                        backup.setAD_Table_ID(tableID);
                        backup.setAD_Column_ID(columnID);
                        backup.setAD_Reference_ID(referenceID);
                        Object value = from.get_ValueOld(i);
                        backup.setColValue(value != null ? value.toString() : null);
                        backup.saveEx();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new DatabaseAccessException(e);
            }
        }
        finally {
            DB.close(rs, (Statement)pstmtReferenceId);
        }
    }

    public FileInputStream OpenInputfile(String filePath) {
        FileInputStream fileTarget = null;
        try {
            fileTarget = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filePath);
            return null;
        }
        return fileTarget;
    }

    public OutputStream OpenOutputfile(String filePath) {
        FileOutputStream fileTarget = null;
        try {
            fileTarget = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filePath);
            return null;
        }
        return fileTarget;
    }

    public int copyFile(InputStream source, OutputStream target) {
        int byteCount = 0;
        int success = 0;
        try {
            int data;
            while ((data = source.read()) >= 0) {
                target.write(data);
                ++byteCount;
            }
            source.close();
            target.close();
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Successfully copied " + byteCount + " bytes.");
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            success = -1;
        }
        return success;
    }

    protected int getClientId(Properties ctx) {
        return Env.getContextAsInt((Properties)ctx, (String)"AD_Client_ID");
    }

    protected int getPackageImpId(Properties ctx) {
        return Env.getContextAsInt((Properties)ctx, (String)"AD_Package_Imp_ID");
    }

    protected String getUpdateMode(Properties ctx) {
        return Env.getContext((Properties)ctx, (String)"UpdateMode");
    }

    protected String getTrxName(PIPOContext ctx) {
        return ctx.trx != null ? ctx.trx.getTrxName() : null;
    }

    protected String getPackageDirectory(Properties ctx) {
        return Env.getContext((Properties)ctx, (String)"PackageDirectory");
    }

    protected boolean isProcessElement(Properties ctx, String entityType) {
        if ("D".equals(entityType) || "C".equals(entityType)) {
            return "Y".equalsIgnoreCase(this.getUpdateMode(ctx));
        }
        return true;
    }

    protected String getStringValue(Element element, String qName) {
        return this.getStringValue(element, qName, null);
    }

    protected String getStringValue(Element element, String qName, List<String> excludes) {
        if (element == null) {
            return null;
        }
        if (qName == null) {
            return null;
        }
        Element propertyElement = element.properties.get(qName);
        if (propertyElement == null || propertyElement.contents == null) {
            return null;
        }
        String s = propertyElement.contents.toString();
        if (s != null && s.trim().length() > 0 && excludes != null) {
            excludes.add(qName);
        }
        return s == null || s.trim().length() == 0 ? null : s.trim();
    }

    protected boolean getBooleanValue(Element element, String qName, boolean defaultValue) {
        String value = element.properties.get((Object)qName).contents.toString();
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }

    protected BigDecimal getBigDecimal(Element element, String qName) {
        String value = element.properties.get((Object)qName).contents.toString();
        return value != null ? new BigDecimal(value) : null;
    }

    protected int getIntValue(Element element, String qName) {
        Element pe = element.properties.get(qName);
        String value = pe != null ? pe.contents.toString() : null;
        return value != null ? Integer.parseInt(value) : 0;
    }

    protected boolean isHandleTranslations(Properties ctx) {
        return "Y".equalsIgnoreCase(Env.getContext((Properties)ctx, (String)"isHandleTranslations"));
    }

    protected List<String> defaultExcludeList(String tableName) {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("ad_client_id");
        excludes.add("ad_org_id");
        excludes.add("created");
        excludes.add("createdby");
        excludes.add("updated");
        excludes.add("updatedby");
        return excludes;
    }

    protected int getParentId(Element element, String expectedName) {
        if (element.parent != null && element.parent.getElementValue().equals(expectedName) && element.parent.recordId > 0) {
            return element.parent.recordId;
        }
        return 0;
    }

    protected boolean isParentDefer(Element element, String expectedName) {
        return element.parent != null && (expectedName == null || element.parent.getElementValue().equals(expectedName)) && element.parent.defer;
    }

    protected boolean isParentSkip(Element element, String expectedName) {
        return element.parent != null && (expectedName == null || element.parent.getElementValue().equals(expectedName)) && element.parent.skip;
    }

    protected boolean isOfficialId(Element element, String columnName) {
        int value = this.getIntValue(element, columnName);
        return value > 0 && value <= 999999;
    }

    protected void addTextProperty(TransformerHandler handler, String qName, String text) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", qName, "reference", "property");
        handler.startElement("", "", qName, atts);
        this.append(handler, text);
        handler.endElement("", "", qName);
    }

    protected void append(TransformerHandler document, String str) throws SAXException {
        char[] contents = str != null ? str.toCharArray() : new char[]{};
        document.characters(contents, 0, contents.length);
    }

    protected <T extends PO> T findPO(PIPOContext ctx, Element element) {
        return POFinder.findPO(ctx, element);
    }

    protected boolean hasUUIDKey(PIPOContext ctx, Element element) {
        String tableName = element.getElementValue();
        String uuidColumn = PO.getUUIDColumnName((String)tableName);
        String uuid = null;
        if (element.properties.containsKey(uuidColumn)) {
            uuid = element.properties.get((Object)uuidColumn).contents.toString();
        }
        return uuid != null && uuid.trim().length() <= 36;
    }

    protected String getUUIDKey(PIPOContext ctx, Element element) {
        String uuid;
        String tableName = element.getElementValue();
        String uuidColumn = PO.getUUIDColumnName((String)tableName);
        if (element.properties.containsKey(uuidColumn) && (uuid = element.properties.get((Object)uuidColumn).contents.toString()) != null && uuid.trim().length() <= 36) {
            return uuid.trim();
        }
        return null;
    }

    protected void addTypeName(AttributesImpl atts, String typeName) {
        atts.addAttribute("", "", "type", "CDATA", typeName);
    }

    protected void verifyPackOutRequirement(PO po) {
        String uidColumn = po.getUUIDColumnName();
        String[] keys = po.get_KeyColumns();
        if (Util.isEmpty((String)((String)po.get_Value(uidColumn))) && (keys == null || keys.length != 1 || po.get_ID() > 999999)) {
            throw new IllegalStateException("2Pack doesn't work with record without official Id and UUID -> " + po.getUUIDColumnName());
        }
    }

    protected boolean isPackOutElement(PIPOContext ctx, PO element) {
        Object entityType;
        if (ctx.packOut.getFromDate() != null && element.getUpdated().compareTo(ctx.packOut.getFromDate()) < 0) {
            return false;
        }
        return ctx.packOut.isExportDictionaryEntity() || element.get_ColumnIndex("EntityType") < 0 || !"D".equals(entityType = element.get_Value("EntityType"));
    }
}

