/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jpiere.plugin.webui.adwindow.JPiereADTabpanel;
import jpiere.plugin.webui.adwindow.JPiereADWindow;
import jpiere.plugin.webui.adwindow.JPiereGridView;
import jpiere.plugin.webui.adwindow.JPiereIADTabpanel;
import org.adempiere.base.IServiceHolder;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.action.Actions;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.ProcessButtonPopup;
import org.adempiere.webui.adwindow.ToolbarCustomButton;
import org.adempiere.webui.component.ADTabListModel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MToolBarButton;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Toolbarbutton;

public class JPiereDetailPane
extends Panel
implements EventListener<Event>,
IdSpace {
    private static final long serialVersionUID = -7914602940626352282L;
    private static final String BTN_PROCESS_ID = "BtnProcess";
    private static final String BTN_DELETE_ID = "BtnDelete";
    private static final String BTN_EDIT_ID = "BtnEdit";
    private static final String BTN_NEW_ID = "BtnNew";
    private static final String BTN_SAVE_ID = "BtnSave";
    private static final String TABBOX_ONSELECT_ATTRIBUTE = "detailpane.tabbox.onselect";
    public static final String ON_POST_SELECT_TAB_EVENT = "onPostSelectTab";
    private static final String STATUS_TEXT_ATTRIBUTE = "status.text";
    private static final String STATUS_ERROR_ATTRIBUTE = "status.error";
    private static final String DELETE_IMAGE = "images/Delete16.png";
    private static final String EDIT_IMAGE = "images/EditRecord16.png";
    private static final String NEW_IMAGE = "images/New16.png";
    private static final String PROCESS_IMAGE = "images/Process16.png";
    private static final String SAVE_IMAGE = "images/Save16.png";
    private ToolBarButton btnNew;
    private long prevKeyEventTime = 0L;
    private KeyEvent prevKeyEvent;
    private Tabbox tabbox;
    private EventListener<Event> eventListener;
    private Map<Integer, Hbox> messageContainers = new HashMap<Integer, Hbox>();
    private Div msgPopupCnt;
    private Window msgPopup;
    private int prevSelectedIndex = 0;
    public static final String ON_ACTIVATE_DETAIL_EVENT = "onActivateDetail";
    public static final String ON_DELETE_EVENT = "onDelete";
    public static final String ON_NEW_EVENT = "onNew";
    public static final String ON_EDIT_EVENT = "onEdit";
    public static final String ON_SAVE_EVENT = "onSave";
    private HashMap<String, ToolBarButton> buttons = new HashMap();
    private List<ToolbarCustomButton> toolbarCustomButtons = new ArrayList<ToolbarCustomButton>();
    public static final int VK_N = 78;

    public JPiereDetailPane() {
        this.tabbox = new Tabbox();
        this.tabbox.setParent((Component)this);
        this.tabbox.addEventListener("onSelect", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                JPiereDetailPane.this.fireActivateDetailEvent();
                Events.postEvent((Event)new Event(JPiereDetailPane.ON_POST_SELECT_TAB_EVENT, (Component)JPiereDetailPane.this));
                Executions.getCurrent().setAttribute(JPiereDetailPane.TABBOX_ONSELECT_ATTRIBUTE, (Object)Boolean.TRUE);
            }
        });
        this.tabbox.setSclass("adwindow-detailpane-tabbox");
        this.tabbox.setTabscroll(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, (String)"100%");
        this.createPopup();
        this.setSclass("adwindow-detailpane");
        this.addEventListener("onRedraw", this);
        this.setId("detailPane");
    }

    public int getSelectedIndex() {
        return this.tabbox.getSelectedIndex();
    }

    public void setSelectedIndex(int curTabIndex) {
        this.tabbox.setSelectedIndex(curTabIndex);
        this.prevSelectedIndex = curTabIndex;
    }

    public int getTabcount() {
        int count = 0;
        Tabs tabs = this.tabbox.getTabs();
        if (tabs != null) {
            count = tabs.getChildren().size();
        }
        return count;
    }

    public void undoLastTabSelection() {
        this.tabbox.setSelectedIndex(this.prevSelectedIndex);
    }

    public void refresh() {
        this.tabbox.invalidate();
    }

    public void setADTabpanel(int index, JPiereIADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel) {
        if (index < this.getTabcount()) {
            this.tabbox.getTabpanel(index).appendChild((Component)tabPanel);
        } else {
            this.addADTabpanel(tabPanel, tabLabel);
        }
    }

    public void setADTabpanel(int index, JPiereIADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel, boolean enabled) {
        if (index < this.getTabcount()) {
            this.tabbox.getTabpanel(index).appendChild((Component)tabPanel);
        } else {
            this.addADTabpanel(tabPanel, tabLabel, enabled);
        }
    }

    public void addADTabpanel(JPiereIADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel) {
        this.addADTabpanel(tabPanel, tabLabel, true);
    }

    public void addADTabpanel(JPiereIADTabpanel tabPanel, ADTabListModel.ADTabLabel tabLabel, boolean enabled) {
        MToolBarButton[] officialButtons;
        Tabs tabs = this.tabbox.getTabs();
        if (tabs == null) {
            tabs = new Tabs();
            this.tabbox.appendChild((Component)tabs);
        }
        Tab tab = new Tab();
        tabs.appendChild((Component)tab);
        tab.setLabel(tabLabel.label);
        if (!enabled) {
            tab.setDisabled(true);
            tab.setSclass("adwindow-detailpane-sub-tab");
        }
        tab.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Tab tab = (Tab)event.getTarget();
                if (!tab.isSelected()) {
                    return;
                }
                if (Executions.getCurrent().getAttribute(JPiereDetailPane.TABBOX_ONSELECT_ATTRIBUTE) != null) {
                    return;
                }
                org.zkoss.zul.Tabpanel zkTabpanel = tab.getLinkedPanel();
                IADTabpanel adtab = null;
                for (Component c : zkTabpanel.getChildren()) {
                    if (!(c instanceof IADTabpanel)) continue;
                    adtab = (IADTabpanel)c;
                    break;
                }
                if (adtab != null && adtab.isDetailPaneMode()) {
                    JPiereDetailPane.this.onEdit(adtab.getGridTab().isSingleRow());
                }
            }
        });
        Tabpanels tabpanels = this.tabbox.getTabpanels();
        if (tabpanels == null) {
            tabpanels = new Tabpanels();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)tabpanels, (String)"100%");
            this.tabbox.appendChild((Component)tabpanels);
        }
        Tabpanel tp = new Tabpanel();
        tabpanels.appendChild((Component)tp);
        tp.setSclass("adwindow-detailpane-tabpanel");
        ToolBar toolbar = new ToolBar();
        tp.appendChild((Component)toolbar);
        this.btnNew = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnNew.setIconSclass("z-icon-New");
        } else {
            this.btnNew.setImage(ThemeManager.getThemeResource((String)NEW_IMAGE));
        }
        this.btnNew.setId(BTN_NEW_ID);
        this.btnNew.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                JPiereDetailPane.this.onNew();
            }
        });
        this.btnNew.setTooltiptext(String.valueOf(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New"))) + "    Shift+Alt+N");
        this.buttons.put(BTN_NEW_ID.substring(3, BTN_NEW_ID.length()), this.btnNew);
        ToolBarButton button = new ToolBarButton();
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Edit");
        } else {
            button.setImage(ThemeManager.getThemeResource((String)EDIT_IMAGE));
        }
        button.setId(BTN_EDIT_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                JPiereDetailPane.this.onEdit(true);
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord")));
        this.buttons.put(BTN_EDIT_ID.substring(3, BTN_EDIT_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Delete");
        } else {
            button.setImage(ThemeManager.getThemeResource((String)DELETE_IMAGE));
        }
        button.setId(BTN_DELETE_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Event openEvent = new Event(JPiereDetailPane.ON_DELETE_EVENT, (Component)JPiereDetailPane.this);
                JPiereDetailPane.this.eventListener.onEvent(openEvent);
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Delete")));
        this.buttons.put(BTN_DELETE_ID.substring(3, BTN_DELETE_ID.length()), button);
        button = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            button.setIconSclass("z-icon-Save");
        } else {
            button.setImage(ThemeManager.getThemeResource((String)SAVE_IMAGE));
        }
        button.setId(BTN_SAVE_ID);
        button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Event openEvent = new Event(JPiereDetailPane.ON_SAVE_EVENT, (Component)JPiereDetailPane.this);
                JPiereDetailPane.this.eventListener.onEvent(openEvent);
            }
        });
        button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Save")));
        this.buttons.put(BTN_SAVE_ID.substring(3, BTN_SAVE_ID.length()), button);
        if (!tabPanel.getGridTab().isSortTab()) {
            button = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                button.setIconSclass("z-icon-Process");
            } else {
                button.setImage(ThemeManager.getThemeResource((String)PROCESS_IMAGE));
            }
            button.setId(BTN_PROCESS_ID);
            button.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    JPiereDetailPane.this.onProcess(event.getTarget());
                }
            });
            button.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Process")));
            this.buttons.put(BTN_PROCESS_ID.substring(3, BTN_PROCESS_ID.length()), button);
        }
        MToolBarButton[] mToolBarButtonArray = officialButtons = MToolBarButton.getToolbarButtons((String)"D", null);
        int n = officialButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton toolbarButton = mToolBarButtonArray[n2];
            if (!toolbarButton.isActive()) {
                this.buttons.remove(toolbarButton.getComponentName());
            } else if (toolbarButton.isCustomization()) {
                String actionId = toolbarButton.getActionClassName();
                IServiceHolder serviceHolder = Actions.getAction((String)actionId);
                if (serviceHolder != null && serviceHolder.getService() != null) {
                    String labelKey = String.valueOf(actionId) + ".label";
                    String tooltipKey = String.valueOf(actionId) + ".tooltip";
                    String label = Msg.getMsg((Properties)Env.getCtx(), (String)labelKey);
                    String tooltiptext = Msg.getMsg((Properties)Env.getCtx(), (String)tooltipKey);
                    if (labelKey.equals(label)) {
                        label = toolbarButton.getName();
                    }
                    if (tooltipKey.equals(tooltiptext)) {
                        tooltipKey = null;
                    }
                    ToolBarButton btn = new ToolBarButton();
                    btn.setName("Btn" + toolbarButton.getComponentName());
                    btn.setId("Btn" + toolbarButton.getComponentName());
                    btn.setTooltiptext(tooltiptext);
                    btn.setDisabled(false);
                    AImage aImage = Actions.getActionImage((String)actionId);
                    if (aImage != null) {
                        btn.setImageContent((Image)aImage);
                    } else {
                        btn.setLabel(label);
                    }
                    ToolbarCustomButton toolbarCustomBtn = new ToolbarCustomButton(toolbarButton, (Toolbarbutton)btn, actionId, tabPanel.getGridTab().getWindowNo());
                    this.toolbarCustomButtons.add(toolbarCustomBtn);
                    toolbar.appendChild((Component)btn);
                }
            } else if (this.buttons.get(toolbarButton.getComponentName()) != null) {
                toolbar.appendChild((Component)this.buttons.get(toolbarButton.getComponentName()));
                if (toolbarButton.isAddSeparator()) {
                    toolbar.appendChild((Component)new Separator("vertical"));
                }
            }
            ++n2;
        }
        Hbox messageContainer = new Hbox();
        messageContainer.setPack("end");
        messageContainer.setAlign("center");
        messageContainer.setSclass("adwindow-detailpane-message");
        messageContainer.setId("messages");
        toolbar.appendChild((Component)messageContainer);
        toolbar.setSclass("adwindow-detailpane-toolbar");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)toolbar, (String)"0");
        this.messageContainers.put(tabLabel.AD_Tab_ID, messageContainer);
        tabPanel.setAttribute("AD_Tab_ID", tabLabel.AD_Tab_ID);
        tp.appendChild((Component)tabPanel);
        if (tabPanel.getJPiereGridView() != null) {
            tabPanel.addEventListener("onDynamicDisplay", this);
            tabPanel.getJPiereGridView().addEventListener(ON_EDIT_EVENT, (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    JPiereGridView gridView = (JPiereGridView)event.getTarget();
                    if (gridView.isDetailPaneMode()) {
                        JPiereDetailPane.this.onEdit(true);
                    }
                }
            });
        }
    }

    protected void onProcess(Component button) {
        ProcessButtonPopup popup = new ProcessButtonPopup();
        JPiereADTabpanel adtab = (JPiereADTabpanel)this.getSelectedADTabpanel();
        popup.render(adtab.getToolbarButtons());
        if (popup.getChildren().size() > 0) {
            popup.setPage(button.getPage());
            popup.open(button, "after_start");
        }
    }

    public void setEventListener(EventListener<Event> listener) {
        this.eventListener = listener;
    }

    public void reset() {
        if (this.tabbox.getTabs() != null) {
            this.tabbox.getTabs().getChildren().clear();
        }
        if (this.tabbox.getTabpanels() != null) {
            this.tabbox.getTabpanels().getChildren().clear();
        }
    }

    public JPiereIADTabpanel getADTabpanel(int index) {
        if (index < 0 || index >= this.tabbox.getTabpanels().getChildren().size()) {
            return null;
        }
        Tabpanel tabPanel = this.tabbox.getTabpanel(index);
        for (Component c : tabPanel.getChildren()) {
            if (!(c instanceof IADTabpanel)) continue;
            return (JPiereIADTabpanel)c;
        }
        return null;
    }

    public JPiereIADTabpanel getSelectedADTabpanel() {
        org.zkoss.zul.Tabpanel selectedPanel = this.tabbox.getSelectedPanel();
        if (selectedPanel != null) {
            for (Component c : selectedPanel.getChildren()) {
                if (!(c instanceof JPiereIADTabpanel)) continue;
                return (JPiereIADTabpanel)c;
            }
        }
        return null;
    }

    public void setStatusMessage(String status, boolean error) {
        JPiereIADTabpanel tabPanel = this.getSelectedADTabpanel();
        if (tabPanel == null) {
            return;
        }
        Hbox messageContainer = this.messageContainers.get(tabPanel.getAttribute("AD_Tab_ID"));
        Execution execution = Executions.getCurrent();
        if (execution != null) {
            String key = String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + messageContainer.getUuid();
            Object o = execution.getAttribute(key);
            if (o != null) {
                if (status == null || status.trim().length() == 0) {
                    return;
                }
            } else {
                execution.setAttribute(key, (Object)Boolean.TRUE);
            }
        }
        messageContainer.getChildren().clear();
        messageContainer.setAttribute(STATUS_ERROR_ATTRIBUTE, (Object)error);
        messageContainer.setAttribute(STATUS_TEXT_ATTRIBUTE, (Object)status);
        messageContainer.setSclass(error ? "docstatus-error" : "docstatus-normal");
        if (status == null || status.trim().length() == 0) {
            return;
        }
        String labelText = this.buildLabelText(status);
        if (error) {
            Clients.showNotification((String)this.buildNotificationText(status), (String)"error", (Component)this.findTabpanel((Component)this), (String)"top_left", (int)3500, (boolean)true);
        }
        Label label = new Label(labelText);
        messageContainer.appendChild((Component)label);
        if (labelText.length() != status.length()) {
            label.addEventListener("onClick", (EventListener)this);
            label.setStyle("cursor: pointer");
            label = new Label(" ...");
            label.setStyle("cursor: pointer");
            messageContainer.appendChild((Component)label);
            label.addEventListener("onClick", (EventListener)this);
        }
        messageContainer.appendChild((Component)new Space());
    }

    private String buildLabelText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 80) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return statusText.substring(0, 80);
    }

    private String buildNotificationText(String statusText) {
        if (statusText == null) {
            return "";
        }
        if (statusText.length() <= 140) {
            return statusText;
        }
        int index = statusText.indexOf(" - java.lang.Exception");
        if (index > 0) {
            return statusText.substring(0, index);
        }
        return String.valueOf(statusText.substring(0, 136)) + " ...";
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onClick")) {
            Component messageContainer = event.getTarget().getParent();
            Boolean error = (Boolean)messageContainer.getAttribute(STATUS_ERROR_ATTRIBUTE);
            String status = (String)messageContainer.getAttribute(STATUS_TEXT_ATTRIBUTE);
            this.showPopup(error, status);
        } else if (event.getName().equals("onDynamicDisplay")) {
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.updateProcessToolbar();
            }
        } else if (event.getName().equals("onRedraw")) {
            ExecutionCtrl ctrl = (ExecutionCtrl)Executions.getCurrent();
            Event evt = ctrl.getNextEvent();
            if (evt != null) {
                Events.sendEvent((Event)evt);
                Events.postEvent((Event)new Event("onRedraw", (Component)this));
                return;
            }
            LayoutUtils.redraw((AbstractComponent)this);
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                long time = System.currentTimeMillis();
                if (this.prevKeyEvent != null && this.prevKeyEventTime > 0L && this.prevKeyEvent.getKeyCode() == keyEvent.getKeyCode() && this.prevKeyEvent.getTarget() == keyEvent.getTarget() && this.prevKeyEvent.isAltKey() == keyEvent.isAltKey() && this.prevKeyEvent.isCtrlKey() == keyEvent.isCtrlKey() && this.prevKeyEvent.isShiftKey() == keyEvent.isShiftKey() && time - this.prevKeyEventTime <= 300L) {
                    return;
                }
                this.onCtrlKeyEvent(keyEvent);
            }
        }
    }

    protected void createPopupContent(String status) {
        Text t = new Text(status);
        this.msgPopupCnt.getChildren().clear();
        this.msgPopupCnt.appendChild((Component)t);
    }

    private void showPopup(boolean error, String msg) {
        Clients.showNotification((String)this.buildNotificationText(msg), (String)"error", (Component)this.findTabpanel((Component)this), (String)"at_pointer", (int)3500, (boolean)true);
    }

    private void createPopup() {
        this.msgPopupCnt = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.msgPopupCnt, (String)"1");
        this.msgPopup = new Window();
        this.msgPopup.setVisible(false);
        this.msgPopup.setBorder(true);
        this.msgPopup.setClosable(true);
        this.msgPopup.setSizable(true);
        this.msgPopup.setContentStyle("overflow: auto");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.msgPopup, (String)"500px");
        this.msgPopup.appendChild((Component)this.msgPopupCnt);
        this.msgPopup.setPage(SessionManager.getAppDesktop().getComponent().getPage());
        this.msgPopup.setShadow(true);
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.msgPopup != null) {
            this.msgPopup.detach();
        }
        try {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", (EventListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", (EventListener)this);
        }
    }

    public void setVflex(String flex) {
        if (this.getHeight() != null) {
            this.setHeight(null);
        }
        super.setVflex(flex);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, (String)flex);
    }

    public void updateToolbar(boolean changed, boolean readOnly) {
        boolean enableNew;
        boolean deleteRecord;
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = this.tabbox.getTabpanel(index);
        Toolbar toolbar = (Toolbar)tabpanel.getFirstChild();
        JPiereIADTabpanel adtab = this.getADTabpanel(index);
        if (adtab == null) {
            return;
        }
        if (adtab.getGridTab().isSortTab() || adtab.getGridTab().isReadOnly()) {
            readOnly = true;
        }
        boolean insertRecord = !readOnly;
        boolean bl = deleteRecord = !readOnly;
        if (insertRecord) {
            insertRecord = adtab.getGridTab().isInsertRecord();
        }
        boolean bl2 = enableNew = !changed && insertRecord && !adtab.getGridTab().isSortTab();
        if (deleteRecord) {
            deleteRecord = adtab.getGridTab().isDeleteRecord();
        }
        boolean enableDelete = !changed && deleteRecord && !adtab.getGridTab().isSortTab();
        JPiereADWindow adwindow = JPiereADWindow.findADWindow((Component)this);
        if (adwindow == null) {
            return;
        }
        List<String> tabRestrictList = adwindow.getTabToolbarRestrictList(adtab.getGridTab().getAD_Tab_ID());
        List<String> windowRestrictList = adwindow.getWindowToolbarRestrictList();
        for (Component c : toolbar.getChildren()) {
            if (!(c instanceof ToolBarButton)) continue;
            ToolBarButton btn = (ToolBarButton)c;
            if (BTN_NEW_ID.equals(btn.getId())) {
                btn.setDisabled(!enableNew);
            } else if (BTN_DELETE_ID.equals(btn.getId())) {
                btn.setDisabled(!enableDelete);
            } else if (BTN_EDIT_ID.equals(btn.getId())) {
                btn.setDisabled(false);
            } else if (BTN_SAVE_ID.equals(btn.getId())) {
                btn.setDisabled(false);
            }
            if (windowRestrictList.contains(btn.getId())) {
                btn.setVisible(false);
                continue;
            }
            if (tabRestrictList.contains(btn.getId())) {
                btn.setVisible(false);
                continue;
            }
            btn.setVisible(true);
        }
    }

    private void updateProcessToolbar() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = this.tabbox.getTabpanel(index);
        Toolbar toolbar = (Toolbar)tabpanel.getFirstChild();
        JPiereIADTabpanel adtab = this.getADTabpanel(index);
        if (adtab == null) {
            return;
        }
        String processImage = ThemeManager.getThemeResource((String)PROCESS_IMAGE);
        for (Component c : toolbar.getChildren()) {
            ToolBarButton btn;
            if (!(c instanceof ToolBarButton) || !processImage.equals((btn = (ToolBarButton)c).getImage())) continue;
            if (adtab.getGridTab().isSortTab()) {
                btn.setDisabled(true);
                break;
            }
            btn.setDisabled(((JPiereADTabpanel)adtab).getToolbarButtons().isEmpty());
            break;
        }
    }

    public void onEdit(boolean formView) throws Exception {
        Event openEvent = new Event(ON_EDIT_EVENT, (Component)this, (Object)formView);
        this.eventListener.onEvent(openEvent);
    }

    public void fireActivateDetailEvent() {
        int index = this.tabbox.getSelectedIndex();
        JPiereIADTabpanel tabPanel = (JPiereIADTabpanel)this.tabbox.getTabpanel(index).getChildren().get(1);
        Event activateEvent = new Event(ON_ACTIVATE_DETAIL_EVENT, (Component)tabPanel, (Object)this.prevSelectedIndex);
        Events.sendEvent((Event)activateEvent);
    }

    public void setTabVisibility(int tabIndex, boolean visible) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return;
        }
        Tab tab = (Tab)this.tabbox.getTabs().getChildren().get(tabIndex);
        tab.setVisible(visible);
        if (tab.isSelected()) {
            tab.setSelected(false);
        }
        if (tab.getLinkedPanel() != null) {
            tab.getLinkedPanel().setVisible(visible);
        }
    }

    public boolean isTabVisible(int tabIndex) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return false;
        }
        return ((Component)this.tabbox.getTabs().getChildren().get(tabIndex)).isVisible();
    }

    public boolean isTabEnabled(int tabIndex) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return false;
        }
        Tab tab = (Tab)this.tabbox.getTabs().getChildren().get(tabIndex);
        return !tab.isDisabled();
    }

    public void setTabEnabled(int tabIndex, boolean enabled) {
        if (tabIndex < 0 || this.tabbox.getTabs() == null || tabIndex >= this.tabbox.getTabs().getChildren().size()) {
            return;
        }
        Tab tab = (Tab)this.tabbox.getTabs().getChildren().get(tabIndex);
        tab.setDisabled(!enabled);
    }

    public void disableToolbar() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getTabcount()) {
            return;
        }
        Tabpanel tabpanel = this.tabbox.getTabpanel(index);
        Toolbar toolbar = (Toolbar)tabpanel.getFirstChild();
        for (Component c : toolbar.getChildren()) {
            if (!(c instanceof ToolBarButton)) continue;
            ToolBarButton btn = (ToolBarButton)c;
            btn.setDisabled(true);
        }
    }

    private Component findTabpanel(Component comp) {
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent instanceof Tabpanel) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void onNew() throws Exception {
        Event openEvent = new Event(ON_NEW_EVENT, (Component)this);
        this.eventListener.onEvent(openEvent);
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        ToolBarButton btn = null;
        if (keyEvent.isAltKey() && !keyEvent.isCtrlKey() && keyEvent.isShiftKey() && keyEvent.getKeyCode() == 78) {
            btn = this.btnNew;
        }
        if (btn != null) {
            this.prevKeyEventTime = System.currentTimeMillis();
            this.prevKeyEvent = keyEvent;
            keyEvent.stopPropagation();
            if (!btn.isDisabled() && btn.isVisible()) {
                Events.sendEvent((Component)btn, (Event)new Event("onClick", (Component)btn));
                String script = "var w=zk.Widget.$('#" + btn.getUuid() + "'); " + "zWatch.fire('onFloatUp', w);";
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }
}

