/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.webui.adwindow;

import java.beans.PropertyChangeListener;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.plugin.webui.adwindow.JPiereAbstractADWindowContent;
import jpiere.plugin.webui.adwindow.JPiereDetailPane;
import jpiere.plugin.webui.adwindow.JPiereGridTabRowRenderer;
import jpiere.plugin.webui.adwindow.JPiereGridView;
import jpiere.plugin.webui.adwindow.JPiereIADTabpanel;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADTreePanel;
import org.adempiere.webui.adwindow.DetailPane;
import org.adempiere.webui.adwindow.GridView;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.adwindow.ToolbarProcessButton;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Group;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WButtonEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.editor.WImageEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.GridTabDataBinder;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MLookup;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButton;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ToolBarButton;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Div;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Style;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.West;
import org.zkoss.zul.impl.XulElement;

public class JPiereADTabpanel
extends Div
implements Evaluatee,
EventListener<Event>,
DataStatusListener,
JPiereIADTabpanel,
IdSpace,
IFieldEditorContainer {
    private static final long serialVersionUID = -3728896318124756192L;
    private static final String ON_SAVE_OPEN_PREFERENCE_EVENT = "onSaveOpenPreference";
    public static final String ON_POST_INIT_EVENT = "onPostInit";
    public static final String ON_SWITCH_VIEW_EVENT = "onSwitchView";
    public static final String ON_DYNAMIC_DISPLAY_EVENT = "onDynamicDisplay";
    private static final String ON_DEFER_SET_SELECTED_NODE = "onDeferSetSelectedNode";
    private static final String ON_DEFER_SET_SELECTED_NODE_ATTR = "onDeferSetSelectedNode.Event.Posted";
    private static final CLogger logger = CLogger.getCLogger(JPiereADTabpanel.class);
    private GridTab gridTab;
    private GridWindow gridWindow;
    private JPiereAbstractADWindowContent windowPanel;
    private int windowNo;
    private Grid form;
    private ArrayList<WEditor> editors = new ArrayList();
    private ArrayList<Component> editorComps = new ArrayList();
    private ArrayList<WButtonEditor> toolbarButtonEditors = new ArrayList();
    private ArrayList<ToolbarProcessButton> toolbarProcessButtons = new ArrayList();
    private boolean uiCreated = false;
    private JPiereGridView listPanel;
    private Map<String, List<Row>> fieldGroupContents;
    private Map<String, List<org.zkoss.zul.Row>> fieldGroupHeaders;
    private ArrayList<Row> rowList;
    List<Group> allCollapsibleGroups;
    private Borderlayout formContainer = null;
    private ADTreePanel treePanel = null;
    private GridTabDataBinder dataBinder;
    protected boolean activated = false;
    private Group currentGroup;
    private JPiereDetailPane JPieredetailPane;
    private boolean detailPaneMode;
    private int tabNo;
    private WEditor defaultFocusField = null;
    private int numberOfFormColumns;
    public static final String ON_TOGGLE_EVENT = "onToggle";
    private static final String DEFAULT_PANEL_WIDTH = "300px";

    public JPiereADTabpanel() {
        this.init();
    }

    private void init() {
        this.initComponents();
        this.addEventListener(ON_DEFER_SET_SELECTED_NODE, this);
        this.addEventListener("onSavePayment", this);
        this.addEventListener("onActivate", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                JPiereADTabpanel.this.removeAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted");
            }
        });
        this.addEventListener(ON_POST_INIT_EVENT, this);
        this.addEventListener(ON_SAVE_OPEN_PREFERENCE_EVENT, this);
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    private void initComponents() {
        LayoutUtils.addSclass((String)"adtab-content", (HtmlBasedComponent)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, (String)"100%");
        this.form = new Grid();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.form, (String)"1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.form, null);
        this.form.setVflex(false);
        this.form.setSclass("grid-layout adwindow-form");
        this.form.setWidgetAttribute("instanceName", "form");
        this.listPanel = new JPiereGridView();
        if ("Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"P|ToggleOnDoubleClick"))) {
            this.listPanel.getListbox().addEventListener("onDoubleClick", (EventListener)this);
        }
    }

    @Override
    public void setJPiereDetailPane(JPiereDetailPane component) {
        String height;
        this.JPieredetailPane = component;
        Borderlayout borderLayout = this.formContainer;
        South south = borderLayout.getSouth();
        if (south == null) {
            south = new South();
            LayoutUtils.addSlideSclass((LayoutRegion)south);
            borderLayout.appendChild((Component)south);
            south.addEventListener("onOpen", (EventListener)this);
            south.addEventListener("onSlide", (EventListener)this);
            south.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

                public void onEvent(SwipeEvent event) throws Exception {
                    Borderlayout borderLayout;
                    South south;
                    if ("down".equals(event.getSwipeDirection()) && (south = (borderLayout = JPiereADTabpanel.this.formContainer).getSouth()).isOpen()) {
                        south.setOpen(false);
                        OpenEvent openEvent = new OpenEvent("onOpen", (Component)south, false);
                        Events.postEvent((Event)openEvent);
                    }
                }
            });
        }
        south.appendChild((Component)component);
        south.setVisible(true);
        south.setCollapsible(true);
        south.setSplittable(true);
        south.setOpen(this.isOpenDetailPane());
        south.setSclass("adwindow-gridview-detail");
        if (!south.isOpen()) {
            LayoutUtils.addSclass((String)"slide", (HtmlBasedComponent)south);
        }
        if (!Util.isEmpty((String)(height = this.heigthDetailPane()))) {
            try {
                ClientInfo browserInfo = SessionManager.getAppDesktop().getClientInfo();
                int browserHeight = browserInfo.desktopHeight;
                int prefHeight = Integer.valueOf(height.replace("px", ""));
                int topmarginpx = MSysConfig.getIntValue((String)"TOP_MARGIN_PIXELS_FOR_HEADER", (int)222);
                int maxHeight = browserHeight - topmarginpx;
                if (prefHeight <= maxHeight) {
                    height = String.valueOf(Integer.toString(prefHeight)) + "px";
                    ZKUpdateUtil.setHeight((HtmlBasedComponent)this.formContainer.getSouth(), (String)height);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public JPiereDetailPane getJPiereDetailPane() {
        return this.JPieredetailPane;
    }

    public void init(JPiereAbstractADWindowContent winPanel, int windowNo, GridTab gridTab, GridWindow gridWindow) {
        this.windowNo = windowNo;
        this.gridWindow = gridWindow;
        this.gridTab = gridTab;
        this.windowPanel = winPanel;
        gridTab.addDataStatusListener((DataStatusListener)this);
        this.dataBinder = new GridTabDataBinder(gridTab);
        this.getChildren().clear();
        this.setId(AdempiereIdGenerator.escapeId((String)gridTab.getName()));
        int AD_Tree_ID = 0;
        if (gridTab.isTreeTab()) {
            AD_Tree_ID = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)gridTab.getKeyColumnName());
        }
        StringBuilder cssContent = new StringBuilder();
        cssContent.append(".adtab-form-borderlayout .z-south-collapsed:before { ");
        cssContent.append("content: \"");
        cssContent.append(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Detail")));
        cssContent.append("\"; ");
        cssContent.append("} ");
        Style style = new Style();
        style.setContent(cssContent.toString());
        this.appendChild((Component)style);
        if (gridTab.isTreeTab() && AD_Tree_ID != 0) {
            Borderlayout layout = new Borderlayout();
            layout.setParent((Component)this);
            layout.setSclass("adtab-form-borderlayout");
            if (ClientInfo.isMobile()) {
                LayoutUtils.addSclass((String)"mobile", (HtmlBasedComponent)layout);
            }
            this.treePanel = new ADTreePanel(windowNo, gridTab.getTabNo());
            West west = new West();
            west.appendChild((Component)this.treePanel);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)west, (String)this.widthTreePanel());
            west.setCollapsible(true);
            west.setSplittable(true);
            west.setAutoscroll(true);
            layout.appendChild((Component)west);
            LayoutUtils.addSlideSclass((LayoutRegion)west);
            if (this.isMobile()) {
                west.setOpen(false);
                LayoutUtils.addSclass((String)"slide", (HtmlBasedComponent)west);
            }
            Center center = new Center();
            Vlayout div = new Vlayout();
            div.appendChild((Component)this.form);
            center.appendChild((Component)div);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)div, (String)"1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)div, (String)"1");
            div.setSclass("adtab-form");
            div.setStyle("overflow-y: visible;");
            div.setSpacing("0px");
            layout.appendChild((Component)center);
            this.formContainer = layout;
            this.treePanel.getTree().addEventListener("onSelect", (EventListener)this);
        } else {
            Vlayout div = new Vlayout();
            div.setSclass("adtab-form");
            div.appendChild((Component)this.form);
            div.setStyle("overflow-y: visible;");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)div, (String)"1");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)div, (String)"100%");
            div.setSpacing("0px");
            Borderlayout layout = new Borderlayout();
            layout.setParent((Component)this);
            layout.setSclass("adtab-form-borderlayout");
            if (ClientInfo.isMobile()) {
                LayoutUtils.addSclass((String)"mobile", (HtmlBasedComponent)layout);
            }
            Center center = new Center();
            layout.appendChild((Component)center);
            center.appendChild((Component)div);
            this.formContainer = layout;
        }
        this.form.getParent().appendChild((Component)this.listPanel);
        this.listPanel.setVisible(false);
        this.listPanel.setWindowNo(windowNo);
        this.listPanel.setADWindowPanel(winPanel);
    }

    public void createUI() {
        this.createUI(false);
    }

    protected void createUI(boolean update) {
        if (update) {
            if (!this.uiCreated) {
                return;
            }
        } else {
            if (this.uiCreated) {
                return;
            }
            this.uiCreated = true;
        }
        this.fieldGroupContents = new HashMap<String, List<Row>>();
        this.fieldGroupHeaders = new HashMap<String, List<org.zkoss.zul.Row>>();
        this.allCollapsibleGroups = new ArrayList<Group>();
        int numCols = this.gridTab.getNumColumns();
        if (numCols <= 0) {
            numCols = 6;
        }
        int diff = 0;
        if (this.isMobile()) {
            if (ClientInfo.maxWidth((int)499)) {
                if (numCols > 3) {
                    diff = numCols - 3;
                    numCols = 3;
                }
            } else if (ClientInfo.maxWidth((int)999) && numCols > 6) {
                diff = numCols - 6;
                numCols = 6;
            }
        }
        this.numberOfFormColumns = numCols;
        if (update) {
            this.form.getColumns().detach();
        }
        Columns columns = new Columns();
        this.form.appendChild((Component)columns);
        double equalWidth = 95.0 / (double)numCols;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        String columnWidth = decimalFormat.format(equalWidth);
        int h = 0;
        while (h < numCols + 1) {
            Column col = new Column();
            if (h == numCols) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, (String)"5%");
            } else {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)col, (String)(String.valueOf(columnWidth) + "%"));
            }
            columns.appendChild((Component)col);
            ++h;
        }
        if (update) {
            this.form.getRows().detach();
            this.rowList = null;
            this.currentGroup = null;
        }
        Rows rows = this.form.newRows();
        GridField[] fields = this.gridTab.getFields();
        Row row = new Row();
        int actualxpos = 0;
        String currentFieldGroup = null;
        int i = 0;
        while (i < fields.length) {
            block64: {
                Div div;
                String fieldGroup;
                GridField field;
                block65: {
                    field = fields[i];
                    if (!field.isDisplayed()) break block64;
                    if (!field.isToolbarButton()) break block65;
                    WButtonEditor editor = null;
                    editor = update ? (WButtonEditor)this.findEditor(field) : (WButtonEditor)WebEditorFactory.getEditor((GridTab)this.gridTab, (GridField)field, (boolean)false);
                    if (editor == null) break block65;
                    if (!update) {
                        if (this.windowPanel != null) {
                            editor.addActionListener((ActionListener)this.windowPanel);
                        }
                        editor.setGridTab(this.getGridTab());
                        editor.setADTabpanel((IADTabpanel)this);
                        field.addPropertyChangeListener((PropertyChangeListener)editor);
                        this.editors.add((WEditor)editor);
                        editor.getComponent().setId(field.getColumnName());
                        this.toolbarButtonEditors.add(editor);
                    }
                    if (field.isToolbarOnlyButton()) break block64;
                }
                if (!Util.isEmpty((String)(fieldGroup = field.getFieldGroup())) && !fieldGroup.equals(currentFieldGroup)) {
                    currentFieldGroup = fieldGroup;
                    if (numCols - actualxpos + 1 > 0) {
                        row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
                    }
                    row.setGroup(this.currentGroup);
                    rows.appendChild((Component)row);
                    if (this.rowList != null) {
                        this.rowList.add(row);
                    }
                    ArrayList<Object> headerRows = new ArrayList<Object>();
                    this.fieldGroupHeaders.put(fieldGroup, headerRows);
                    this.rowList = new ArrayList();
                    this.fieldGroupContents.put(fieldGroup, this.rowList);
                    if ("L".equals(field.getFieldGroupType())) {
                        row = new Row();
                        Label groupLabel = new Label(fieldGroup);
                        row.appendCellChild((Component)groupLabel, numCols);
                        rows.appendChild((Component)row);
                        headerRows.add(row);
                        row = new Row();
                        Separator separator = new Separator();
                        separator.setBar(true);
                        row.appendCellChild((Component)separator, numCols);
                        rows.appendChild((Component)row);
                        headerRows.add(row);
                        this.currentGroup = null;
                    } else {
                        Group rowg = new Group(fieldGroup);
                        Cell cell = (Cell)rowg.getFirstChild();
                        cell.setSclass("z-group-inner");
                        cell.setColspan(numCols + 1);
                        this.allCollapsibleGroups.add(rowg);
                        if ("T".equals(field.getFieldGroupType()) || field.getIsCollapsedByDefault()) {
                            rowg.setOpen(false);
                        }
                        this.currentGroup = rowg;
                        rows.appendChild((Component)rowg);
                        headerRows.add(rowg);
                    }
                    row = new Row();
                    actualxpos = 0;
                }
                int columnSpan = field.getColumnSpan();
                int xpos = field.getXPosition();
                if (xpos + columnSpan > numCols && diff > 0) {
                    if ((xpos -= diff) <= 0) {
                        xpos = 1;
                    }
                    if (xpos == 1 && (field.getDisplayType() == 20 || field.getDisplayType() == 28 || field.isFieldOnly())) {
                        xpos = 2;
                    }
                }
                if (xpos <= actualxpos) {
                    if (numCols - actualxpos + 1 > 0) {
                        row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
                    }
                    row.setGroup(this.currentGroup);
                    rows.appendChild((Component)row);
                    if (this.rowList != null) {
                        this.rowList.add(row);
                    }
                    row = new Row();
                    actualxpos = 0;
                }
                if (xpos - 1 - actualxpos > 0) {
                    row.appendCellChild(this.createSpacer(), xpos - 1 - actualxpos);
                }
                boolean paintLabel = field.getDisplayType() != 28 && field.getDisplayType() != 20 && !field.isFieldOnly();
                int remainCols = numCols - actualxpos;
                if (columnSpan > remainCols) {
                    int n = columnSpan = remainCols - 1 > 0 ? remainCols - 1 : 1;
                }
                actualxpos = field.isHeading() ? xpos : xpos + columnSpan - 1 + (paintLabel ? 1 : 0);
                if (!field.isHeading()) {
                    WEditor editor;
                    WEditor wEditor = editor = update ? this.findEditor(field) : WebEditorFactory.getEditor((GridTab)this.gridTab, (GridField)field, (boolean)false);
                    if (editor != null) {
                        if (!update) {
                            editor.getComponent().setWidgetOverride("fieldHeader", HelpController.escapeJavascriptContent((String)field.getHeader()));
                            editor.getComponent().setWidgetOverride("fieldDescription", HelpController.escapeJavascriptContent((String)field.getDescription()));
                            editor.getComponent().setWidgetOverride("fieldHelp", HelpController.escapeJavascriptContent((String)field.getHelp()));
                            editor.getComponent().setWidgetListener("onFocus", "zWatch.fire('onFieldTooltip', this, null, this.fieldHeader(), this.fieldDescription(), this.fieldHelp());");
                            editor.setGridTab(this.getGridTab());
                            field.addPropertyChangeListener((PropertyChangeListener)editor);
                            this.editors.add(editor);
                            this.editorComps.add(editor.getComponent());
                        }
                        if (paintLabel) {
                            div = new Div();
                            div.setSclass("form-label");
                            Label label = editor.getLabel();
                            div.appendChild((Component)label);
                            if (label.getDecorator() != null) {
                                div.appendChild(label.getDecorator());
                            }
                            row.appendCellChild((Component)div, 1);
                        }
                        row.appendCellChild(editor.getComponent(), columnSpan);
                        row.getLastCell().setStyle("position: relative; overflow: visible;");
                        if (!update) {
                            if (editor instanceof WButtonEditor) {
                                if (this.windowPanel != null) {
                                    ((WButtonEditor)editor).addActionListener((ActionListener)this.windowPanel);
                                }
                            } else {
                                editor.addValueChangeListener((ValueChangeListener)this.dataBinder);
                            }
                        }
                        if (this.defaultFocusField == null && field.isDefaultFocus()) {
                            this.defaultFocusField = editor;
                        }
                        if (!update) {
                            WEditorPopupMenu popupMenu;
                            editor.fillHorizontal();
                            Component fellow = editor.getComponent().getFellowIfAny(field.getColumnName());
                            if (fellow == null) {
                                editor.getComponent().setId(field.getColumnName());
                            }
                            if ((popupMenu = editor.getPopupMenu()) == null) {
                                popupMenu = new WEditorPopupMenu(false, false, false, false, false, false, null);
                                popupMenu.addSuggestion(field);
                            }
                            if (popupMenu != null) {
                                if (editor instanceof ContextMenuListener) {
                                    popupMenu.addMenuListener((ContextMenuListener)editor);
                                }
                                popupMenu.setId(String.valueOf(field.getColumnName()) + "-popup");
                                this.appendChild((Component)popupMenu);
                                if (!field.isFieldOnly()) {
                                    Label label = editor.getLabel();
                                    if (ClientInfo.isMobile()) {
                                        WEditorPopupMenu finalPopupMenu = popupMenu;
                                        label.addEventListener("onClick", evt -> finalPopupMenu.open((Component)label, "after_start"));
                                    } else {
                                        if (popupMenu.isZoomEnabled() && editor instanceof IZoomableEditor) {
                                            label.addEventListener("onClick", (EventListener)new ZoomListener((IZoomableEditor)editor));
                                        }
                                        popupMenu.addContextElement((XulElement)label);
                                        if (editor.getComponent() instanceof XulElement) {
                                            popupMenu.addContextElement((XulElement)editor.getComponent());
                                        }
                                    }
                                }
                                popupMenu.addSuggestion(field);
                            }
                        }
                    }
                } else {
                    Label label = new Label(field.getHeader());
                    div = new Div();
                    div.setSclass("form-label-heading");
                    row.appendCellChild(this.createSpacer());
                    div.appendChild((Component)label);
                    row.appendCellChild((Component)div);
                }
            }
            ++i;
        }
        if (numCols - actualxpos + 1 > 0) {
            row.appendCellChild(this.createSpacer(), numCols - actualxpos + 1);
        }
        row.setGroup(this.currentGroup);
        rows.appendChild((Component)row);
        if (this.rowList != null) {
            this.rowList.add(row);
        }
        if (!update) {
            this.loadToolbarButtons();
        }
        if (!update && this.gridTab.isTreeTab() && this.treePanel != null) {
            int AD_Tree_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"AD_Tree_ID", (boolean)true);
            int AD_Tree_ID_Default = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)this.gridTab.getKeyColumnName());
            if (AD_Tree_ID != 0) {
                this.treePanel.initTree(AD_Tree_ID, this.windowNo);
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
            } else if (AD_Tree_ID_Default != 0) {
                this.treePanel.initTree(AD_Tree_ID_Default, this.windowNo);
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
            }
        }
        if (!(update || this.gridTab.isSingleRow() || this.isGridView())) {
            this.switchRowPresentation();
        }
    }

    private WEditor findEditor(GridField field) {
        for (WEditor editor : this.editors) {
            if (editor.getGridField() != field) continue;
            return editor;
        }
        return null;
    }

    private void loadToolbarButtons() {
        int[] ids;
        MToolBarButton[] mToolbarButtons;
        MToolBarButton[] mToolBarButtonArray = mToolbarButtons = MToolBarButton.getProcessButtonOfTab((int)this.gridTab.getAD_Tab_ID(), null);
        int n = mToolbarButtons.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarButton mToolbarButton = mToolBarButtonArray[n2];
            Boolean access = MRole.getDefault().getProcessAccess(mToolbarButton.getAD_Process_ID());
            if (access != null && access.booleanValue()) {
                ToolbarProcessButton toolbarProcessButton = new ToolbarProcessButton(mToolbarButton, (IADTabpanel)this, (ActionListener)this.windowPanel, this.windowNo);
                this.toolbarProcessButtons.add(toolbarProcessButton);
            }
            ++n2;
        }
        if (this.toolbarProcessButtons.size() > 0 && (ids = MToolBarButtonRestrict.getProcessButtonOfTab((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)this.gridTab.getAD_Tab_ID(), null)) != null && ids.length > 0) {
            int[] nArray = ids;
            int n3 = ids.length;
            n = 0;
            while (n < n3) {
                int id = nArray[n];
                X_AD_ToolBarButton tbt = new X_AD_ToolBarButton(Env.getCtx(), id, null);
                for (ToolbarProcessButton btn : this.toolbarProcessButtons) {
                    if (!tbt.getComponentName().equals(btn.getColumnName())) continue;
                    this.toolbarProcessButtons.remove(btn);
                    break;
                }
                ++n;
            }
        }
    }

    private Component createSpacer() {
        return new Space();
    }

    public void dynamicDisplay(int col) {
        boolean visible;
        boolean noData;
        if (!this.gridTab.isOpen()) {
            return;
        }
        ArrayList<Group> collapsedGroups = new ArrayList<Group>();
        for (Group group : this.allCollapsibleGroups) {
            if (group.isOpen()) continue;
            collapsedGroups.add(group);
        }
        if (col > 0) {
            GridField changedField = this.gridTab.getField(col);
            String columnName = changedField.getColumnName();
            ArrayList dependants = this.gridTab.getDependantFields(columnName);
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("(" + this.gridTab.toString() + ") " + columnName + " - Dependents=" + dependants.size());
            }
            if (dependants.size() <= 0 && changedField.getCallout().length() <= 0 && Core.findCallout((String)this.gridTab.getTableName(), (String)columnName).size() <= 0) {
                for (WEditor comp : this.editors) {
                    comp.updateStyle();
                }
                return;
            }
        }
        boolean bl = noData = this.gridTab.getRowCount() == 0;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(String.valueOf(this.gridTab.toString()) + " - Rows=" + this.gridTab.getRowCount());
        }
        for (WEditor comp : this.editors) {
            GridField mField = comp.getGridField();
            if (mField != null) {
                if (mField.isDisplayed(true)) {
                    if (!comp.isVisible()) {
                        comp.setVisible(true);
                    }
                    if (noData) {
                        comp.setReadWrite(false);
                    } else {
                        boolean rw = mField.isEditable(true);
                        if (rw && !comp.isReadWrite()) {
                            mField.refreshLookup();
                        }
                        comp.setReadWrite(rw);
                        comp.setMandatory(mField.isMandatory(true));
                        comp.dynamicDisplay();
                    }
                } else if (comp.isVisible()) {
                    comp.setVisible(false);
                }
            }
            comp.updateStyle();
        }
        List rows = this.form.getRows().getChildren();
        for (Component comp : rows) {
            if (!(comp instanceof Row)) continue;
            Row row = (Row)comp;
            visible = false;
            boolean editorRow = false;
            for (Component cellComponent : row.getChildren()) {
                Component component = cellComponent.getFirstChild();
                if (!this.editorComps.contains(component)) continue;
                editorRow = true;
                WEditor editor = this.editors.get(this.editorComps.indexOf(component));
                if (editor != null && row.getGroup() != null && !row.getGroup().isOpen() && editor.isMandatoryStyle()) {
                    row.getGroup().setOpen(true);
                    if (collapsedGroups.contains(row.getGroup())) {
                        collapsedGroups.remove(row.getGroup());
                    }
                }
                if (!component.isVisible()) continue;
                visible = true;
                break;
            }
            if (!editorRow || row.isVisible() == visible) continue;
            row.setAttribute("groupRowVisible", (Object)(visible ? "true" : "false"));
            row.setVisible(visible);
        }
        for (Map.Entry<String, List<org.zkoss.zul.Row>> entry : this.fieldGroupHeaders.entrySet()) {
            List<Row> contents = this.fieldGroupContents.get(entry.getKey());
            visible = false;
            for (Row row : contents) {
                if (!row.isVisible()) continue;
                visible = true;
                break;
            }
            List<org.zkoss.zul.Row> headers = entry.getValue();
            for (org.zkoss.zul.Row row : headers) {
                if (row.isVisible() == visible) continue;
                row.setVisible(visible);
            }
        }
        for (Group group : collapsedGroups) {
            group.setOpen(false);
        }
        if (this.listPanel.isVisible()) {
            this.listPanel.dynamicDisplay(col);
        }
        for (ToolbarProcessButton btn : this.toolbarProcessButtons) {
            btn.dynamicDisplay();
        }
        Events.sendEvent((Component)this, (Event)new Event(ON_DYNAMIC_DISPLAY_EVENT, (Component)this));
        this.echoDeferSetSelectedNodeEvent();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(String.valueOf(this.gridTab.toString()) + " - fini - " + (col <= 0 ? "complete" : "seletive"));
        }
    }

    private void echoDeferSetSelectedNodeEvent() {
        if (this.getAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR) == null) {
            this.setAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR, Boolean.TRUE);
            Events.echoEvent((String)ON_DEFER_SET_SELECTED_NODE, (Component)this, null);
        }
    }

    public String getDisplayLogic() {
        return this.gridTab.getDisplayLogic();
    }

    public String getTitle() {
        return this.gridTab.getName();
    }

    public String get_ValueAsString(String variableName) {
        return Env.getContext((Properties)Env.getCtx(), (int)this.windowNo, (String)variableName);
    }

    public int getTabLevel() {
        return this.gridTab.getTabLevel();
    }

    public String getTableName() {
        return this.gridTab.getTableName();
    }

    public int getRecord_ID() {
        return this.gridTab.getRecord_ID();
    }

    public boolean isCurrent() {
        return this.gridTab != null ? this.gridTab.isCurrent() : false;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void query() {
        boolean open = this.gridTab.isOpen();
        this.gridTab.query(false);
        if (this.listPanel.isVisible() && !open) {
            this.gridTab.getTableModel().fireTableDataChanged();
        }
    }

    public void query(boolean onlyCurrentRows, int onlyCurrentDays, int maxRows) {
        boolean open = this.gridTab.isOpen();
        this.gridTab.query(onlyCurrentRows, onlyCurrentDays, maxRows);
        if (this.listPanel.isVisible() && !open) {
            this.gridTab.getTableModel().fireTableDataChanged();
        }
    }

    public void resetDetailForNewParentRecord() {
        boolean open = this.gridTab.isOpen();
        if (open) {
            this.gridTab.resetDetailForNewParentRecord();
        } else {
            this.gridTab.setCurrentRow(-1, true);
        }
    }

    public GridTab getGridTab() {
        return this.gridTab;
    }

    public ADTreePanel getTreePanel() {
        return this.treePanel;
    }

    public String getTreeDisplayedOn() {
        return this.gridTab.getTreeDisplayedOn();
    }

    public void refresh() {
        this.gridTab.dataRefresh();
    }

    public void activate(boolean activate) {
        if (activate) {
            if (this.getAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted") != null) {
                return;
            }
            this.setAttribute("org.adempiere.webui.adwindow.IADTabpanel.onActivatePosted", Boolean.TRUE);
        }
        this.activated = activate;
        if (this.listPanel.isVisible()) {
            if (activate) {
                this.listPanel.activate(this.gridTab);
            } else {
                this.listPanel.deactivate();
            }
        } else if (activate) {
            this.formContainer.setVisible(activate);
            if (!this.isMobile()) {
                this.focusToFirstEditor();
            }
        }
        if (this.gridTab.getRecord_ID() > 0 && this.gridTab.isTreeTab() && this.treePanel != null) {
            this.echoDeferSetSelectedNodeEvent();
        }
        Event event = new Event("onActivate", (Component)this, (Object)activate);
        Events.postEvent((Event)event);
    }

    public void focusToFirstEditor() {
        this.focusToFirstEditor(false);
    }

    public void focusToFirstEditor(boolean checkCurrent) {
        WEditor toFocus = null;
        if (this.defaultFocusField != null && this.defaultFocusField.isVisible() && this.defaultFocusField.isReadWrite() && this.defaultFocusField.getComponent().getParent() != null && !(this.defaultFocusField instanceof WImageEditor)) {
            toFocus = this.defaultFocusField;
        } else {
            for (WEditor editor : this.editors) {
                if (!editor.isVisible() || !editor.isReadWrite() || editor.getComponent().getParent() == null || editor instanceof WImageEditor) continue;
                toFocus = editor;
                break;
            }
        }
        if (toFocus != null) {
            this.focusToEditor(toFocus, checkCurrent);
        }
    }

    public void onEvent(Event event) {
        if (event.getTarget() == this.listPanel.getListbox()) {
            Events.sendEvent((Component)this, (Event)new Event(ON_TOGGLE_EVENT, (Component)this));
        } else if (this.treePanel != null && event.getTarget() == this.treePanel.getTree()) {
            Treeitem item = this.treePanel.getTree().getSelectedItem();
            if (item.getValue() != null) {
                this.navigateTo((DefaultTreeNode<MTreeNode>)((DefaultTreeNode)item.getValue()));
            }
        } else if (ON_DEFER_SET_SELECTED_NODE.equals(event.getName())) {
            this.removeAttribute(ON_DEFER_SET_SELECTED_NODE_ATTR);
            if (this.gridTab.getRecord_ID() >= 0 && this.gridTab.isTreeTab() && this.treePanel != null) {
                this.setSelectedNode(this.gridTab.getRecord_ID());
            }
        } else if ("onSavePayment".equals(event.getName())) {
            this.windowPanel.onSavePayment();
        } else if (ON_POST_INIT_EVENT.equals(event.getName())) {
            if (this.isDetailVisible() && this.JPieredetailPane.getSelectedADTabpanel() != null) {
                this.JPieredetailPane.getSelectedADTabpanel().activate(true);
            }
        } else if (event.getTarget() instanceof South) {
            if (this.JPieredetailPane != null) {
                boolean openEvent = event instanceof OpenEvent;
                if (openEvent) {
                    OpenEvent oe = (OpenEvent)event;
                    this.onSouthEvent(oe.isOpen() ? SouthEvent.OPEN : SouthEvent.CLOSE);
                } else {
                    this.onSouthEvent(SouthEvent.SLIDE);
                }
            }
        } else if (event.getName().equals(ON_SAVE_OPEN_PREFERENCE_EVENT)) {
            Boolean value = (Boolean)event.getData();
            int windowId = this.getGridTab().getAD_Window_ID();
            int adTabId = this.getGridTab().getAD_Tab_ID();
            if (windowId > 0 && adTabId > 0) {
                Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), "AD_Window_ID=? AND Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
                int userId = Env.getAD_User_ID((Properties)Env.getCtx());
                MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setParameters(new Object[]{windowId, String.valueOf(adTabId) + "|DetailPane.IsOpen", userId}).first();
                if (preference == null || preference.getAD_Preference_ID() <= 0) {
                    preference = new MPreference(Env.getCtx(), 0, null);
                    preference.setAD_Window_ID(windowId);
                    preference.set_ValueOfColumn("AD_User_ID", (Object)userId);
                    preference.setAttribute(String.valueOf(adTabId) + "|DetailPane.IsOpen");
                }
                preference.setValue(value != false ? "Y" : "N");
                preference.saveEx();
                Env.getCtx().setProperty("P" + windowId + "|" + adTabId + "|DetailPane.IsOpen", value != false ? "Y" : "N");
            }
        }
    }

    private void onSouthEvent(SouthEvent event) {
        JPiereIADTabpanel tabPanel;
        if (event == SouthEvent.OPEN || event == SouthEvent.CLOSE) {
            boolean open = event == SouthEvent.OPEN;
            Events.echoEvent((String)ON_SAVE_OPEN_PREFERENCE_EVENT, (Component)this, (Object)open);
            if (!open) {
                return;
            }
        }
        if (this.JPieredetailPane.getParent() == null) {
            this.formContainer.appendSouth((Component)this.JPieredetailPane);
        }
        if ((tabPanel = this.JPieredetailPane.getSelectedADTabpanel()) != null) {
            if (!tabPanel.isActivated()) {
                tabPanel.activate(true);
            }
            if (!tabPanel.isGridView()) {
                tabPanel.switchRowPresentation();
            }
        }
    }

    private boolean isOpenDetailPane() {
        String preference;
        if (this.isMobile()) {
            return false;
        }
        boolean open = true;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0 && (preference = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(String.valueOf(adTabId) + "|DetailPane.IsOpen"), (boolean)false)) != null && preference.trim().length() > 0) {
            open = "Y".equals(preference);
        }
        return open;
    }

    private String heigthDetailPane() {
        String height = null;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            height = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(String.valueOf(adTabId) + "|DetailPane.Height"), (boolean)false);
        }
        return height;
    }

    private String widthTreePanel() {
        String width = null;
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            width = Env.getPreference((Properties)Env.getCtx(), (int)windowId, (String)(String.valueOf(adTabId) + "|TreePanel.Width"), (boolean)false);
        }
        return Util.isEmpty(width) ? DEFAULT_PANEL_WIDTH : width;
    }

    private void navigateTo(DefaultTreeNode<MTreeNode> value) {
        MTreeNode treeNode = (MTreeNode)value.getData();
        int nodeID = treeNode.getNode_ID();
        int size = this.gridTab.getRowCount();
        int row = -1;
        int i = 0;
        while (i < size) {
            if (this.gridTab.getKeyID(i) == nodeID) {
                row = i;
                break;
            }
            ++i;
        }
        if (row == -1) {
            if (nodeID > 0 && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Tab does not have ID with Node_ID=" + nodeID);
            }
            if (this.gridTab.getCurrentRow() >= 0) {
                this.gridTab.setCurrentRow(this.gridTab.getCurrentRow(), true);
            }
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"RecordIsNotInCurrentSearch"));
        }
        this.gridTab.navigate(row);
    }

    public void dataStatusChanged(DataStatusEvent e) {
        GridField mField;
        if (Executions.getCurrent() == null || e.isInitEdit()) {
            return;
        }
        int col = e.getChangedColumn();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("(" + this.gridTab + ") Col=" + col + ": " + e.toString());
        }
        if ((mField = this.gridTab.getField(col)) != null && (mField.getCallout().length() > 0 || Core.findCallout((String)this.gridTab.getTableName(), (String)mField.getColumnName()).size() > 0 || this.gridTab.hasDependants(mField.getColumnName()))) {
            String msg = this.gridTab.processFieldChange(mField);
            if (msg.length() > 0) {
                FDialog.error((int)this.windowNo, (Component)this, (String)msg);
            }
            for (GridField dependentField : this.gridTab.getDependantFields(mField.getColumnName())) {
                MLookup mLookup;
                if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + mField.getColumnName() + "@") == -1) continue;
                mLookup.refresh();
            }
        }
        if (!this.uiCreated) {
            this.createUI();
        }
        this.dynamicDisplay(col);
        if (this.treePanel != null) {
            if (this.getTreeDisplayedOn().equals("M")) {
                this.treePanel.getParent().setVisible(!this.isDetailPaneMode());
            } else if (this.getTreeDisplayedOn().equals("D")) {
                this.treePanel.getParent().setVisible(this.isDetailPaneMode());
            }
            if ("Deleted".equalsIgnoreCase(e.getAD_Message())) {
                if (e.Record_ID != null && e.Record_ID instanceof Integer && ((Integer)e.Record_ID).intValue() != this.gridTab.getRecord_ID()) {
                    this.deleteNode((Integer)e.Record_ID);
                } else {
                    this.setSelectedNode(this.gridTab.getRecord_ID());
                }
            } else if (!e.isInserting()) {
                MTreeNode treeNode;
                boolean refresh = true;
                Treeitem item = this.treePanel.getTree().getSelectedItem();
                SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
                if (item != null && item.getValue() != null && (treeNode = (MTreeNode)((DefaultTreeNode)item.getValue()).getData()).getNode_ID() == this.gridTab.getRecord_ID()) {
                    this.setSelectedNode(this.gridTab.getRecord_ID());
                    refresh = false;
                }
                if ("Saved".equals(e.getAD_Message()) && model.find(null, this.gridTab.getRecord_ID()) != null && this.isTreeDrivenByValue()) {
                    model.removeNode(model.find(null, this.gridTab.getRecord_ID()));
                }
                if ("Saved".equals(e.getAD_Message()) && model.find(null, this.gridTab.getRecord_ID()) == null) {
                    this.addNewNode();
                    if (this.isTreeDrivenByValue()) {
                        this.treePanel.prepareForRefresh();
                    }
                }
                if (refresh) {
                    int AD_Tree_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"AD_Tree_ID", (boolean)true);
                    if (AD_Tree_ID != 0) {
                        if (this.treePanel.initTree(AD_Tree_ID, this.windowNo)) {
                            this.echoDeferSetSelectedNodeEvent();
                        } else {
                            this.setSelectedNode(this.gridTab.getRecord_ID());
                        }
                    } else {
                        AD_Tree_ID = MTree.getDefaultAD_Tree_ID((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (String)this.gridTab.getKeyColumnName());
                        this.treePanel.initTree(AD_Tree_ID, this.windowNo);
                    }
                }
            } else if (e.isInserting() && this.gridTab.getRecord_ID() < 0 && this.gridTab.getTabLevel() > 0) {
                int AD_Tree_ID = Integer.parseInt(this.gridTab.getParentTab().getValue("AD_Tree_ID").toString());
                this.treePanel.initTree(AD_Tree_ID, this.windowNo);
            }
        }
        if (this.listPanel.isVisible()) {
            this.listPanel.updateListIndex();
            this.listPanel.dynamicDisplay(col);
            if ("Refreshed".equals(e.getAD_Message()) || "Sorted".equals(e.getAD_Message())) {
                Clients.resize((Component)this.listPanel.getListbox());
            }
        }
    }

    private void deleteNode(int recordId) {
        DefaultTreeNode treeNode;
        MTreeNode data;
        if (recordId <= 0) {
            return;
        }
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        if (this.treePanel.getTree().getSelectedItem() != null && (data = (MTreeNode)(treeNode = (DefaultTreeNode)this.treePanel.getTree().getSelectedItem().getValue()).getData()).getNode_ID() == recordId) {
            model.removeNode(treeNode);
            return;
        }
        treeNode = model.find(null, recordId);
        if (treeNode != null) {
            model.removeNode(treeNode);
        }
    }

    private void addNewNode() {
        if (this.gridTab.getRecord_ID() > 0) {
            String name = (String)this.gridTab.getValue("Name");
            String description = (String)this.gridTab.getValue("Description");
            boolean summary = this.gridTab.getValueAsBoolean("IsSummary");
            String imageIndicator = (String)this.gridTab.getValue("Action");
            SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
            DefaultTreeNode treeNode = model.getRoot();
            MTreeNode root = (MTreeNode)treeNode.getData();
            int parentID = root.getNode_ID();
            DefaultTreeNode parentNode = null;
            if (this.isTreeDrivenByValue()) {
                String value = this.gridTab.getValue("Value").toString();
                parentID = PO.retrieveIdOfParentValue((String)value, (String)this.getTableName(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()), null);
                parentNode = model.find(treeNode, parentID);
                name = String.valueOf(value) + " - " + name;
            }
            MTreeNode node = new MTreeNode(this.gridTab.getRecord_ID(), 0, name, description, parentID, summary, imageIndicator, false, null);
            DefaultTreeNode newNode = new DefaultTreeNode((Object)node);
            if (this.isTreeDrivenByValue() && parentNode != null) {
                model.addNode(parentNode, newNode, 0);
            } else {
                model.addNode(newNode);
            }
            int[] path = model.getPath((TreeNode)newNode);
            Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
            this.treePanel.getTree().setSelectedItem(ti);
        }
    }

    private void setSelectedNode(int recordId) {
        DefaultTreeNode treeNode;
        if (recordId <= 0) {
            return;
        }
        if (TreeUtils.isOnInitRenderPosted((Tree)this.treePanel.getTree()) || this.treePanel.getTree().getTreechildren() == null || this.treePanel.getTree().getTreechildren().getItemCount() == 0) {
            this.treePanel.getTree().onInitRender();
        }
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        if (this.treePanel.getTree().getSelectedItem() != null) {
            Treeitem treeItem = this.treePanel.getTree().getSelectedItem();
            if (!treeItem.isLoaded()) {
                return;
            }
            DefaultTreeNode treeNode2 = (DefaultTreeNode)treeItem.getValue();
            MTreeNode data = (MTreeNode)treeNode2.getData();
            if (data.getNode_ID() == recordId) {
                String name;
                int[] path = model.getPath((TreeNode)treeNode2);
                Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
                if (ti.getPage() == null) {
                    this.echoDeferSetSelectedNodeEvent();
                }
                boolean changed = false;
                if (this.isTreeDrivenByValue()) {
                    String value = (String)this.gridTab.getValue("Value");
                    String name2 = (String)this.gridTab.getValue("Name");
                    String full = String.valueOf(value) + " - " + name2;
                    if (full != null && !full.equals(data.getName())) {
                        data.setName(full);
                        changed = true;
                    }
                } else if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Menu") && (name = (String)this.gridTab.getValue("Name")) != null && !name.equals(data.getName())) {
                    data.setName(name);
                    changed = true;
                }
                Object summaryobj = this.gridTab.getValue("IsSummary");
                boolean summary = false;
                if (summaryobj != null) {
                    summary = summaryobj instanceof Boolean ? ((Boolean)summaryobj).booleanValue() : "Y".equals(summaryobj.toString());
                }
                if (summary != data.isSummary()) {
                    data.setSummary(summary);
                    changed = true;
                }
                if (changed) {
                    treeNode2.setData((Object)data);
                }
                return;
            }
        }
        if ((treeNode = model.find(null, recordId)) != null) {
            int[] path = model.getPath((TreeNode)treeNode);
            Treeitem ti = this.treePanel.getTree().renderItemByPath(path);
            this.treePanel.getTree().selectItem(ti);
        } else {
            this.addNewNode();
        }
    }

    public void switchRowPresentation() {
        if (this.form.isVisible()) {
            this.form.setVisible(false);
            ((HtmlBasedComponent)this.form.getParent()).setStyle("");
        } else {
            this.form.setVisible(true);
            ((HtmlBasedComponent)this.form.getParent()).setStyle("overflow-y: visible;");
        }
        this.listPanel.setVisible(!this.form.isVisible());
        if (this.listPanel.isVisible()) {
            this.listPanel.refresh(this.gridTab);
            this.listPanel.scrollToCurrentRow();
            Clients.resize((Component)this.listPanel.getListbox());
        } else {
            this.listPanel.deactivate();
        }
        Events.sendEvent((Component)this, (Event)new Event(ON_SWITCH_VIEW_EVENT, (Component)this));
    }

    public void afterSave(boolean onSaveEvent) {
    }

    public void focus() {
        if (this.form.isVisible() && !this.isMobile()) {
            this.focusToFirstEditor(true);
        } else {
            this.listPanel.focus();
        }
    }

    public void setFocusToField(String columnName) {
        if (this.formContainer.isVisible()) {
            for (WEditor editor : this.editors) {
                if (!columnName.equals(editor.getColumnName())) continue;
                Clients.response((AuResponse)new AuFocus(editor.getComponent()));
                break;
            }
        } else {
            this.listPanel.setFocusToField(columnName);
        }
    }

    public boolean onEnterKey() {
        if (this.listPanel.isVisible()) {
            return this.listPanel.onEnterKey();
        }
        return false;
    }

    public boolean isGridView() {
        return this.listPanel.isVisible();
    }

    @Override
    public JPiereGridView getJPiereGridView() {
        return this.listPanel;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setDetailPaneMode(boolean detailPaneMode) {
        if (this.detailPaneMode != detailPaneMode) {
            this.detailPaneMode = detailPaneMode;
            if (detailPaneMode) {
                this.detachDetailPane();
            } else {
                this.attachDetailPane();
            }
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this, (String)"true");
            this.listPanel.setDetailPaneMode(detailPaneMode);
        }
    }

    private void attachDetailPane() {
        if (this.formContainer.getSouth() != null) {
            this.formContainer.getSouth().setVisible(true);
            if (this.formContainer.getSouth().isOpen() && this.JPieredetailPane != null && this.JPieredetailPane.getParent() == null) {
                this.formContainer.appendSouth((Component)this.JPieredetailPane);
            }
        }
    }

    private void detachDetailPane() {
        if (this.formContainer.getSouth() != null) {
            this.formContainer.getSouth().setVisible(false);
            if (this.JPieredetailPane != null && this.JPieredetailPane.getParent() != null) {
                this.JPieredetailPane.detach();
            }
        }
    }

    public List<Button> getToolbarButtons() {
        ArrayList<Button> buttonList = new ArrayList<Button>();
        for (WButtonEditor editor : this.toolbarButtonEditors) {
            if (editor.getComponent() == null || !editor.getComponent().isVisible()) continue;
            buttonList.add((Button)editor.getComponent());
        }
        for (ToolbarProcessButton processButton : this.toolbarProcessButtons) {
            if (!processButton.getButton().isVisible()) continue;
            buttonList.add(processButton.getButton());
        }
        return buttonList;
    }

    public boolean needSave(boolean rowChange, boolean onlyRealChange) {
        return this.getGridTab().needSave(rowChange, onlyRealChange);
    }

    public boolean dataSave(boolean onSaveEvent) {
        return this.getGridTab().dataSave(onSaveEvent);
    }

    public boolean isDetailPaneMode() {
        return this.detailPaneMode;
    }

    public void setTabNo(int tabNo) {
        this.tabNo = tabNo;
    }

    public int getTabNo() {
        return this.tabNo;
    }

    public void activateJPiereDetailIfVisible() {
        if (this.isDetailVisible()) {
            RowRenderer renderer;
            JPiereGridTabRowRenderer gtr;
            org.zkoss.zul.Row row;
            JPiereIADTabpanel tabPanel = this.JPieredetailPane.getSelectedADTabpanel();
            if (tabPanel != null && !tabPanel.isActivated()) {
                tabPanel.activate(true);
                if (!tabPanel.isGridView()) {
                    tabPanel.switchRowPresentation();
                }
            } else if (tabPanel != null && !tabPanel.getGridTab().isCurrent()) {
                tabPanel.activate(true);
            } else if (tabPanel != null && tabPanel.isGridView() && (row = (gtr = (JPiereGridTabRowRenderer)(renderer = tabPanel.getJPiereGridView().getListbox().getRowRenderer())).getCurrentRow()) != null) {
                gtr.setCurrentRow(row);
            }
        }
    }

    public boolean isDetailVisible() {
        if (this.formContainer.getSouth() == null || !this.formContainer.getSouth().isVisible() || !this.formContainer.getSouth().isOpen()) {
            return false;
        }
        return this.JPieredetailPane != null;
    }

    public boolean hasDetailTabs() {
        if (this.formContainer.getSouth() == null || !this.formContainer.getSouth().isVisible()) {
            return false;
        }
        return this.JPieredetailPane != null && this.JPieredetailPane.getTabcount() > 0;
    }

    public void focusToNextEditor(WEditor ref) {
        boolean found = false;
        for (WEditor editor : this.editors) {
            if (editor == ref) {
                found = true;
                continue;
            }
            if (!found || !editor.isVisible() || !editor.isReadWrite()) continue;
            this.focusToEditor(editor, false);
            break;
        }
    }

    protected void focusToEditor(WEditor toFocus, boolean checkCurrent) {
        Component c = toFocus.getComponent();
        if (c instanceof EditorBox) {
            c = ((EditorBox)c).getTextbox();
        } else if (c instanceof NumberBox) {
            c = ((NumberBox)c).getDecimalbox();
        } else if (c instanceof Urlbox) {
            c = ((Urlbox)c).getTextbox();
        }
        if (!checkCurrent) {
            ((HtmlBasedComponent)c).focus();
        } else {
            StringBuilder script = new StringBuilder("var b=true;try{if (zk.currentFocus) {");
            script.append("var p=zk.Widget.$('#").append(this.formContainer.getCenter().getUuid()).append("');");
            script.append("if (zUtl.isAncestor(p, zk.currentFocus)) {");
            script.append("b=false;}}}catch(error){}");
            script.append("if(b){var w=zk.Widget.$('#").append(c.getUuid()).append("');w.focus(0);}");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    public void setParent(Component parent) {
        super.setParent(parent);
        if (parent != null) {
            this.listPanel.onADTabPanelParentChanged();
        }
    }

    private boolean isTreeDrivenByValue() {
        SimpleTreeModel model = (SimpleTreeModel)this.treePanel.getTree().getModel();
        boolean retValue = false;
        retValue = model.isTreeDrivenByValue();
        return retValue;
    }

    public void onPageDetached(Page page) {
        String width;
        String height;
        if (this.formContainer.getSouth() != null && this.formContainer.getSouth().isVisible() && this.formContainer.getSouth().isOpen() && !Util.isEmpty((String)(height = this.formContainer.getSouth().getHeight()))) {
            this.savePreference("DetailPane.Height", height);
        }
        if (this.treePanel != null && this.formContainer.getWest() != null && this.formContainer.getWest().isVisible() && this.formContainer.getWest().isOpen() && !Util.isEmpty((String)(width = this.formContainer.getWest().getWidth()))) {
            this.savePreference("TreePanel.Width", width);
        }
        super.onPageDetached(page);
    }

    void savePreference(String attribute, String value) {
        int windowId = this.getGridTab().getAD_Window_ID();
        int adTabId = this.getGridTab().getAD_Tab_ID();
        if (windowId > 0 && adTabId > 0) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), "AD_Window_ID=? AND Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setParameters(new Object[]{windowId, String.valueOf(adTabId) + "|" + attribute, userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_Window_ID(windowId);
                preference.set_ValueOfColumn("AD_User_ID", (Object)userId);
                preference.setAttribute(String.valueOf(adTabId) + "|" + attribute);
            }
            preference.setValue(value);
            preference.saveEx();
            Env.getCtx().setProperty("P" + windowId + "|" + adTabId + "|" + attribute, value);
        }
    }

    protected void onClientInfo() {
        if (!this.uiCreated || this.gridTab == null) {
            return;
        }
        int numCols = this.gridTab.getNumColumns();
        if (numCols <= 0) {
            numCols = 6;
        }
        if (ClientInfo.maxWidth((int)499)) {
            if (numCols > 3) {
                numCols = 3;
            }
        } else if (ClientInfo.maxWidth((int)999) && numCols > 6) {
            numCols = 6;
        }
        if (numCols > 0 && numCols != this.numberOfFormColumns) {
            this.createUI(true);
            this.dynamicDisplay(0);
        }
    }

    protected boolean isMobile() {
        return ClientInfo.isMobile();
    }

    public void editorTraverse(Callback<WEditor> editorTaverseCallback) {
        this.editorTraverse(editorTaverseCallback, this.editors);
    }

    public GridView getGridView() {
        GridView noUse = new GridView();
        return noUse;
    }

    public void setDetailPane(DetailPane detailPane) {
    }

    public DetailPane getDetailPane() {
        DetailPane noUse = new DetailPane();
        return noUse;
    }

    private static enum SouthEvent {
        SLIDE,
        OPEN,
        CLOSE;

    }

    static class ZoomListener
    implements EventListener<Event> {
        private IZoomableEditor searchEditor;

        ZoomListener(IZoomableEditor editor) {
            this.searchEditor = editor;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName())) {
                this.searchEditor.actionZoom();
            }
        }
    }
}

