/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMALine;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class JPiereCreateFromRecognition
extends CreateFrom {
    public JPiereCreateFromRecognition(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Recognition_ID", (boolean)this.isSOTrx)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadShipmentData(int C_BPartner_ID, int M_InOut_ID) {
        ArrayList<KeyNamePair> list;
        block6: {
            list = new ArrayList<KeyNamePair>();
            StringBuffer display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR((String)"s.MovementDate", (int)15, (String)Env.getAD_Language((Properties)Env.getCtx())));
            StringBuffer sql = new StringBuffer("SELECT s.M_InOut_ID,").append(display).append(" FROM M_InOut s WHERE s.C_BPartner_ID=? AND s.DocStatus IN ('CL','CO') AND s.JP_ContractContent_ID IS Not Null  AND s.M_InOut_ID=? ");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, C_BPartner_ID);
                    pstmt.setInt(2, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected Vector<Vector<Object>> getShipmentData(int M_InOut_ID) {
        Vector<Vector<Object>> data;
        block11: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("M_InOut_ID=" + M_InOut_ID);
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append("l.MovementQty-SUM(COALESCE(rl.QtyInvoiced,0)),");
            sql.append(" l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID  FROM M_InOutLine l ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("')");
            }
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" INNER JOIN M_InOut io ON (l.M_InOut_ID=io.M_InOut_ID)");
            sql.append(" LEFT JOIN JP_RecognitionLine rl ON (l.M_InOutLine_ID = rl.M_InOutLine_ID)");
            sql.append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND io.C_BPartner_ID = po.C_BPartner_ID)").append(" WHERE l.M_InOut_ID=? AND l.MovementQty<>0 ").append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ");
            sql.append(" HAVING l.MovementQty-SUM(COALESCE(rl.QtyInvoiced,0)) <>0");
            sql.append("ORDER BY l.Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(false);
                        BigDecimal qtyMovement = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        line.add(rs.getString(7));
                        int C_OrderLine_ID = rs.getInt(10);
                        if (rs.wasNull()) {
                            line.add(null);
                        } else {
                            line.add(new KeyNamePair(C_OrderLine_ID, "."));
                        }
                        pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        line.add(null);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        int JP_Recognition_ID = (Integer)this.getGridTab().getValue("JP_Recognition_ID");
        MRecognition recognition = new MRecognition(Env.getCtx(), JP_Recognition_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(recognition.toString());
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MInOutLine line;
                int j;
                MInOutLine[] lines;
                String whereClause;
                MProduct product = null;
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_UOM_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 3);
                int M_Product_ID = 0;
                if (pp != null) {
                    M_Product_ID = pp.getKey();
                }
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 5);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int M_InOutLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 6);
                if (pp != null) {
                    M_InOutLine_ID = pp.getKey();
                }
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 7);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line QtyEntered=" + QtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
                }
                MRecognitionLine recogLine = new MRecognitionLine(recognition);
                recogLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
                recogLine.setQty(QtyEntered);
                BigDecimal QtyInvoiced = null;
                if (M_Product_ID > 0 && product.getC_UOM_ID() != C_UOM_ID) {
                    QtyInvoiced = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)M_Product_ID, (int)C_UOM_ID, (BigDecimal)QtyEntered);
                }
                if (QtyInvoiced == null) {
                    QtyInvoiced = QtyEntered;
                }
                recogLine.setQtyInvoiced(QtyInvoiced);
                MOrderLine orderLine = null;
                if (C_OrderLine_ID != 0) {
                    orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                }
                MRMALine rmaLine = null;
                if (M_RMALine_ID > 0) {
                    rmaLine = new MRMALine(Env.getCtx(), M_RMALine_ID, null);
                }
                MInOutLine inoutLine = null;
                if (M_InOutLine_ID != 0) {
                    inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
                    if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                        C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                        orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    }
                } else if (C_OrderLine_ID > 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfOrderLine((Properties)Env.getCtx(), (int)C_OrderLine_ID, (String)whereClause, (String)trxName);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Receipt Lines with OrderLine = #" + lines.length);
                    }
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (line.getQtyEntered().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (M_RMALine_ID != 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfRMALine((Properties)Env.getCtx(), (int)M_RMALine_ID, (String)whereClause, null);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Receipt Lines with RMALine = #" + lines.length);
                    }
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (rmaLine.getQty().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                        if (rmaLine == null) {
                            inoutLine = lines[0];
                            M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                        }
                    }
                }
                if (inoutLine != null) {
                    recogLine.setRecogLine(inoutLine);
                    recogLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", inoutLine.get_Value("JP_ProductExplodeBOM_ID"));
                } else {
                    this.log.fine("No Receipt Line");
                    if (orderLine != null) {
                        recogLine.setOrderLine(orderLine);
                        recogLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", orderLine.get_Value("JP_ProductExplodeBOM_ID"));
                    } else {
                        this.log.fine("No Order Line");
                        recogLine.setPrice();
                        recogLine.setTax();
                    }
                    if (rmaLine != null) {
                        recogLine.setRMALine(rmaLine);
                    } else {
                        this.log.fine("No RMA Line");
                    }
                }
                recogLine.saveEx();
            }
            ++i;
        }
        recognition.saveEx();
        recognition.load(recognition.get_TrxName());
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"VendorProductNo", (boolean)this.isSOTrx));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)this.isSOTrx));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOutLine_ID", (boolean)this.isSOTrx));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMALine_ID", (boolean)this.isSOTrx));
        return columnNames;
    }
}

