/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.window.FDialog;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class JPiereCreateFromReceipt
extends CreateFrom {
    protected int shipLocator_ID = 0;
    protected boolean isShipFromScheduledShipLocator = true;
    protected boolean isSelectPhysicalWarehouse = false;
    protected int Doc_PhysicalWarehouse_ID = 0;

    public JPiereCreateFromReceipt(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Receipt_Doc", (boolean)true)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice) {
        Vector<Vector<Object>> data;
        block20: {
            ArrayList<IOLineOrderLineSummary> IOLineOrderLineSummary_list;
            block18: {
                StringBuilder preSQL = new StringBuilder("SELECT iol.C_OrderLine_ID, SUM(iol.QtyEntered), iol.C_UOM_ID FROM M_InOutLine iol INNER JOIN M_InOut io ON(io.M_InOut_ID = iol.M_InOut_ID)  WHERE iol.M_InOut_ID=? GROUP BY C_OrderLine_ID, C_UOM_ID");
                CPreparedStatement prePSTMT = null;
                ResultSet preRS = null;
                IOLineOrderLineSummary_list = new ArrayList<IOLineOrderLineSummary>();
                int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
                try {
                    try {
                        prePSTMT = DB.prepareStatement((String)preSQL.toString(), null);
                        prePSTMT.setInt(1, M_InOut_ID);
                        preRS = prePSTMT.executeQuery();
                        while (preRS.next()) {
                            IOLineOrderLineSummary_list.add(new IOLineOrderLineSummary(preRS.getInt(1), preRS.getBigDecimal(2), preRS.getInt(3)));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, preSQL.toString(), (Throwable)e);
                        DB.close((ResultSet)preRS, (Statement)prePSTMT);
                        preRS = null;
                        prePSTMT = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(preRS, prePSTMT);
                    preRS = null;
                    prePSTMT = null;
                    throw throwable;
                }
                DB.close((ResultSet)preRS, (Statement)prePSTMT);
                preRS = null;
                prePSTMT = null;
            }
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("C_Order_ID=" + C_Order_ID);
            }
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT l.QtyOrdered - l.QtyDelivered ,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END  ,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name) ,l.JP_Locator_ID, loc.Value  ,COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name)  ,p.Value AS ProductValue  ,l.C_OrderLine_ID,l.Line  ,loc.JP_PhysicalWarehouse_ID, pwh.name  ,po.VendorProductNo FROM C_OrderLine l");
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND l.C_BPartner_ID = po.C_BPartner_ID)  LEFT OUTER JOIN M_Locator loc on (l.JP_Locator_ID=loc.M_Locator_ID) LEFT OUTER JOIN JP_PhysicalWarehouse pwh on (loc.JP_PhysicalWarehouse_ID=pwh.JP_PhysicalWarehouse_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("')");
            }
            sql.append(" WHERE l.C_Order_ID=? ");
            if (this.isSelectPhysicalWarehouse) {
                sql.append(" AND loc.JP_PhysicalWarehouse_ID=? ");
            }
            sql.append(" ORDER BY l.Line ");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    if (this.isSelectPhysicalWarehouse) {
                        pstmt.setInt(2, this.Doc_PhysicalWarehouse_ID);
                    }
                    rs = pstmt.executeQuery();
                    boolean isContain = false;
                    while (rs.next()) {
                        BigDecimal qtyEntered;
                        BigDecimal multiplier;
                        BigDecimal qtyOrdered;
                        isContain = false;
                        for (IOLineOrderLineSummary olSum : IOLineOrderLineSummary_list) {
                            if (olSum.C_OrderLine_ID != rs.getInt(10) || olSum.C_UOM_ID != rs.getInt(3)) continue;
                            isContain = true;
                            qtyOrdered = rs.getBigDecimal(1);
                            qtyEntered = qtyOrdered.multiply(multiplier = rs.getBigDecimal(2)).subtract(olSum.QtyEntered);
                            if (qtyEntered.compareTo(Env.ZERO) == 0) break;
                            Vector<Object> line = new Vector<Object>();
                            line.add(false);
                            KeyNamePair pp = new KeyNamePair(rs.getInt(10), rs.getString(11));
                            line.add(pp);
                            line.add(qtyEntered);
                            pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                            line.add(pp);
                            line.add(rs.getString(14));
                            line.add(rs.getString(9));
                            pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                            line.add(pp);
                            pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                            line.add(pp);
                            pp = new KeyNamePair(rs.getInt(12), rs.getString(13));
                            line.add(pp);
                            data.add(line);
                            break;
                        }
                        if (isContain) continue;
                        Vector<Object> line = new Vector<Object>();
                        line.add(false);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(10), rs.getString(11));
                        line.add(pp);
                        qtyOrdered = rs.getBigDecimal(1);
                        multiplier = rs.getBigDecimal(2);
                        qtyEntered = qtyOrdered.multiply(multiplier);
                        line.add(qtyEntered);
                        pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(rs.getString(14));
                        line.add(rs.getString(9));
                        pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(12), rs.getString(13));
                        line.add(pp);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected KeyNamePair getLocatorKeyNamePair(int M_Locator_ID) {
        MWarehouse wh;
        MLocator locator = null;
        if (M_Locator_ID > 0) {
            locator = MLocator.get((Properties)Env.getCtx(), (int)M_Locator_ID);
            if (locator != null && locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
                locator = null;
            }
        } else {
            KeyNamePair pp = null;
            pp = new KeyNamePair(0, "");
            return pp;
        }
        if (locator == null && this.p_order != null && this.p_order.getM_Warehouse_ID() == this.getM_Warehouse_ID() && (wh = MWarehouse.get((Properties)Env.getCtx(), (int)this.p_order.getM_Warehouse_ID())) != null) {
            locator = wh.getDefaultLocator();
        }
        if (locator == null && this.shipLocator_ID > 0) {
            locator = MLocator.get((Properties)Env.getCtx(), (int)this.shipLocator_ID);
        }
        if (locator == null || locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = MWarehouse.get((Properties)Env.getCtx(), (int)this.getM_Warehouse_ID()).getDefaultLocator();
        }
        KeyNamePair pp = null;
        if (locator != null) {
            pp = new KeyNamePair(locator.get_ID(), locator.getValue());
        }
        return pp;
    }

    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, BigDecimal.class, false);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, false);
        miniTable.setColumnClass(8, String.class, false);
        miniTable.autoSize();
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        int M_Locator_ID = this.shipLocator_ID;
        if (!this.isShipFromScheduledShipLocator && M_Locator_ID == 0) {
            FDialog.error((int)0, (String)(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID")));
            return false;
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            KeyNamePair pp;
            int JP_ScheduledShipLocator\uff3fID;
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue() && (JP_ScheduledShipLocator\uff3fID = (pp = (KeyNamePair)miniTable.getValueAt(i, 7)).getKey()) == 0 && M_Locator_ID == 0) {
                pp = (KeyNamePair)miniTable.getValueAt(i, 1);
                FDialog.error((int)0, (String)(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID") + System.lineSeparator() + Msg.getElement((Properties)Env.getCtx(), (String)"Line") + " : " + pp.getName()));
                return false;
            }
            ++i;
        }
        int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        }
        int i2 = 0;
        while (i2 < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i2, 0)).booleanValue()) {
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i2, 2);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i2, 3);
                int C_UOM_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i2, 6);
                int M_Product_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i2, 7);
                int JP_ScheduledShipLocator\uff3fID = pp.getKey();
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i2, 1);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    MProduct product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID);
                }
                MInOutLine iol = new MInOutLine(inout);
                iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
                iol.setQty(QtyEntered);
                MOrderLine ol = null;
                if (C_OrderLine_ID != 0) {
                    iol.setC_OrderLine_ID(C_OrderLine_ID);
                    ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    iol.set_ValueNoCheck("JP_ProductExplodeBOM_ID", ol.get_Value("JP_ProductExplodeBOM_ID"));
                    if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                        iol.setMovementQty(QtyEntered.multiply(ol.getQtyOrdered()).divide(ol.getQtyEntered(), 12, RoundingMode.HALF_UP));
                        iol.setC_UOM_ID(ol.getC_UOM_ID());
                    }
                    iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                    iol.setDescription(ol.getDescription());
                    iol.setC_Project_ID(ol.getC_Project_ID());
                    iol.setC_ProjectPhase_ID(ol.getC_ProjectPhase_ID());
                    iol.setC_ProjectTask_ID(ol.getC_ProjectTask_ID());
                    iol.setC_Activity_ID(ol.getC_Activity_ID());
                    iol.setC_Campaign_ID(ol.getC_Campaign_ID());
                    iol.setAD_OrgTrx_ID(ol.getAD_OrgTrx_ID());
                    iol.setUser1_ID(ol.getUser1_ID());
                    iol.setUser2_ID(ol.getUser2_ID());
                }
                if (M_Product_ID == 0 && ol != null && ol.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(ol.getC_Charge_ID());
                }
                if (this.isShipFromScheduledShipLocator && JP_ScheduledShipLocator\uff3fID > 0) {
                    iol.setM_Locator_ID(JP_ScheduledShipLocator\uff3fID);
                } else if (M_Locator_ID > 0) {
                    iol.setM_Locator_ID(M_Locator_ID);
                } else {
                    return false;
                }
                iol.saveEx();
            }
            ++i2;
        }
        if (this.p_order != null && this.p_order.getC_Order_ID() != 0 && inout.getC_Order_ID() == 0) {
            inout.setC_Order_ID(this.p_order.getC_Order_ID());
            inout.setAD_OrgTrx_ID(this.p_order.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.p_order.getC_Project_ID());
            inout.setC_Campaign_ID(this.p_order.getC_Campaign_ID());
            inout.setC_Activity_ID(this.p_order.getC_Activity_ID());
            inout.setUser1_ID(this.p_order.getUser1_ID());
            inout.setUser2_ID(this.p_order.getUser2_ID());
            if (this.p_order.isDropShip()) {
                inout.setM_Warehouse_ID(this.p_order.getM_Warehouse_ID());
                inout.setIsDropShip(this.p_order.isDropShip());
                inout.setDropShip_BPartner_ID(this.p_order.getDropShip_BPartner_ID());
                inout.setDropShip_Location_ID(this.p_order.getDropShip_Location_ID());
                inout.setDropShip_User_ID(this.p_order.getDropShip_User_ID());
            }
        }
        inout.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(9);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"Line", (boolean)true));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"VendorProductNo", (boolean)false));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"ProductValue", (boolean)false));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"JP_ScheduledReceiptLocator"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"JP_PhysicalWarehouse_ID"));
        return columnNames;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice, int M_Locator_ID) {
        this.shipLocator_ID = M_Locator_ID;
        return this.getOrderData(C_Order_ID, forInvoice);
    }

    private class IOLineOrderLineSummary {
        int C_OrderLine_ID = 0;
        BigDecimal QtyEntered = Env.ZERO;
        int C_UOM_ID = 0;

        public IOLineOrderLineSummary(int C_OrderLine_ID, BigDecimal QtyEntered, int C_UOM_ID) {
            this.C_OrderLine_ID = C_OrderLine_ID;
            this.QtyEntered = QtyEntered;
            this.C_UOM_ID = C_UOM_ID;
        }
    }
}

