/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class JPiereCreateFromRMAInOut
extends CreateFrom {
    private MInvoice m_invoice = null;
    private MRMA m_rma = null;
    protected MDocType m_DocType = null;
    protected boolean isSOTrx = true;
    protected int receiptLocator_ID = 0;
    protected int Doc_PhysicalWarehouse_ID = 0;

    public JPiereCreateFromRMAInOut(GridTab mTab) {
        super(mTab);
        Integer C_DocType_ID = (Integer)mTab.getField("C_DocType_ID").getValue();
        this.m_DocType = MDocType.get((Properties)Env.getCtx(), (int)C_DocType_ID);
        this.isSOTrx = this.m_DocType.isSOTrx();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMA_ID", (boolean)this.isSOTrx)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block6: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX=" + (this.isSOTrx ? "'Y'" : "'N'") + " AND r.DocStatus in ('CO', 'CL') " + "AND r.C_BPartner_ID=? " + "AND r.M_RMA_ID in (SELECT rl.M_RMA_ID FROM M_RMALine rl " + "WHERE rl.M_RMA_ID=r.M_RMA_ID AND rl.QtyDelivered < rl.Qty " + "AND rl.M_InOutLine_ID IS NOT NULL)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block20: {
            ArrayList<IOLineRMALineSummary> IOLineRMALineSummary_list;
            block18: {
                this.m_invoice = null;
                this.p_order = null;
                this.m_rma = new MRMA(Env.getCtx(), M_RMA_ID, null);
                StringBuilder preSQL = new StringBuilder("SELECT iol.M_RMALine_ID, SUM(iol.QtyEntered), iol.C_UOM_ID FROM M_InOutLine iol INNER JOIN M_InOut io ON(io.M_InOut_ID = iol.M_InOut_ID)  WHERE iol.M_InOut_ID=? GROUP BY M_RMALine_ID, C_UOM_ID");
                CPreparedStatement prePSTMT = null;
                ResultSet preRS = null;
                IOLineRMALineSummary_list = new ArrayList<IOLineRMALineSummary>();
                int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
                try {
                    try {
                        prePSTMT = DB.prepareStatement((String)preSQL.toString(), null);
                        prePSTMT.setInt(1, M_InOut_ID);
                        preRS = prePSTMT.executeQuery();
                        while (preRS.next()) {
                            IOLineRMALineSummary_list.add(new IOLineRMALineSummary(preRS.getInt(1), preRS.getBigDecimal(2), preRS.getInt(3)));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, preSQL.toString(), (Throwable)e);
                        DB.close((ResultSet)preRS, (Statement)prePSTMT);
                        preRS = null;
                        prePSTMT = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(preRS, prePSTMT);
                    preRS = null;
                    prePSTMT = null;
                    throw throwable;
                }
                DB.close((ResultSet)preRS, (Statement)prePSTMT);
                preRS = null;
                prePSTMT = null;
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, p.M_Product_ID, COALESCE(p.Name, c.Name), uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language((Properties)Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("LEFT OUTER JOIN C_Charge c ON c.C_Charge_ID=iol.C_Charge_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_InOutLine_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, p.M_Product_ID, p.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_Product p ON p.M_Product_ID = rl.M_Product_ID ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=p.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language((Properties)Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_Product_ID IS NOT NULL AND rl.M_InOutLine_ID IS NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language((Properties)Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL AND rl.M_InOutLine_ID IS NULL");
            sqlStmt.append(" ORDER BY Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    pstmt.setInt(3, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    boolean isContain = false;
                    while (rs.next()) {
                        isContain = false;
                        for (IOLineRMALineSummary olSum : IOLineRMALineSummary_list) {
                            if (olSum.M_RMALine_ID != rs.getInt(1)) continue;
                            isContain = true;
                            BigDecimal qtyReturn = rs.getBigDecimal(3);
                            BigDecimal qtyEntered = qtyReturn.subtract(olSum.QtyEntered);
                            if (qtyEntered.compareTo(Env.ZERO) == 0) break;
                            Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                            line.add(Boolean.valueOf(false));
                            KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                            line.add((Comparable<Boolean>)pp);
                            pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                            line.add((Comparable<Boolean>)pp);
                            line.add(qtyEntered);
                            pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                            line.add((Comparable<Boolean>)pp);
                            data.add(line);
                            break;
                        }
                        if (isContain) continue;
                        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                        line.add(Boolean.valueOf(false));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add((Comparable<Boolean>)pp);
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add((Comparable<Boolean>)pp);
                        line.add(rs.getBigDecimal(3));
                        pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                        line.add((Comparable<Boolean>)pp);
                        data.add(line);
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected KeyNamePair getLocatorKeyNamePair(int M_Locator_ID) {
        MWarehouse wh;
        MLocator locator = null;
        if (M_Locator_ID > 0 && (locator = MLocator.get((Properties)Env.getCtx(), (int)M_Locator_ID)) != null && locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = null;
        }
        if (locator == null && this.p_order != null && this.p_order.getM_Warehouse_ID() == this.getM_Warehouse_ID() && (wh = MWarehouse.get((Properties)Env.getCtx(), (int)this.p_order.getM_Warehouse_ID())) != null) {
            locator = wh.getDefaultLocator();
        }
        if (locator == null && this.receiptLocator_ID > 0) {
            locator = MLocator.get((Properties)Env.getCtx(), (int)this.receiptLocator_ID);
        }
        if (locator == null || locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = MWarehouse.get((Properties)Env.getCtx(), (int)this.getM_Warehouse_ID()).getDefaultLocator();
        }
        KeyNamePair pp = null;
        if (locator != null) {
            pp = new KeyNamePair(locator.get_ID(), locator.getValue());
        }
        return pp;
    }

    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, BigDecimal.class, false);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.autoSize();
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        int M_Locator_ID = this.receiptLocator_ID;
        if (M_Locator_ID == 0) {
            return false;
        }
        int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 3);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 4);
                int C_UOM_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int M_Product_ID = pp.getKey();
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 1);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    MProduct product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID);
                }
                MInOutLine iol = new MInOutLine(inout);
                iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
                iol.setQty(QtyEntered);
                MRMALine rmal = null;
                rmal = new MRMALine(Env.getCtx(), M_RMALine_ID, trxName);
                iol.setM_RMALine_ID(M_RMALine_ID);
                iol.setQtyEntered(QtyEntered);
                iol.setDescription(rmal.getDescription());
                iol.setM_AttributeSetInstance_ID(rmal.getM_AttributeSetInstance_ID());
                iol.setC_Project_ID(rmal.getC_Project_ID());
                iol.setC_ProjectPhase_ID(rmal.getC_ProjectPhase_ID());
                iol.setC_ProjectTask_ID(rmal.getC_ProjectTask_ID());
                iol.setC_Activity_ID(rmal.getC_Activity_ID());
                iol.setAD_OrgTrx_ID(rmal.getAD_OrgTrx_ID());
                iol.setUser1_ID(rmal.getUser1_ID());
                iol.setUser2_ID(rmal.getUser2_ID());
                if (M_Product_ID == 0 && rmal.getC_Charge_ID() != 0) {
                    iol.setC_Charge_ID(rmal.getC_Charge_ID());
                }
                iol.setM_Locator_ID(M_Locator_ID);
                iol.saveEx();
            }
            ++i;
        }
        if (this.p_order != null && this.p_order.getC_Order_ID() != 0) {
            inout.setC_Order_ID(this.p_order.getC_Order_ID());
            inout.setAD_OrgTrx_ID(this.p_order.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.p_order.getC_Project_ID());
            inout.setC_Campaign_ID(this.p_order.getC_Campaign_ID());
            inout.setC_Activity_ID(this.p_order.getC_Activity_ID());
            inout.setUser1_ID(this.p_order.getUser1_ID());
            inout.setUser2_ID(this.p_order.getUser2_ID());
            if (this.p_order.isDropShip()) {
                inout.setM_Warehouse_ID(this.p_order.getM_Warehouse_ID());
                inout.setIsDropShip(this.p_order.isDropShip());
                inout.setDropShip_BPartner_ID(this.p_order.getDropShip_BPartner_ID());
                inout.setDropShip_Location_ID(this.p_order.getDropShip_Location_ID());
                inout.setDropShip_User_ID(this.p_order.getDropShip_User_ID());
            }
        }
        if (this.m_invoice != null && this.m_invoice.getC_Invoice_ID() != 0) {
            if (inout.getC_Order_ID() == 0) {
                inout.setC_Order_ID(this.m_invoice.getC_Order_ID());
            }
            inout.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            inout.setAD_OrgTrx_ID(this.m_invoice.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.m_invoice.getC_Project_ID());
            inout.setC_Campaign_ID(this.m_invoice.getC_Campaign_ID());
            inout.setC_Activity_ID(this.m_invoice.getC_Activity_ID());
            inout.setUser1_ID(this.m_invoice.getUser1_ID());
            inout.setUser2_ID(this.m_invoice.getUser2_ID());
        }
        if (this.m_rma != null && this.m_rma.getM_RMA_ID() != 0) {
            MInOut originalIO = this.m_rma.getShipment();
            inout.setIsSOTrx(this.m_rma.isSOTrx());
            inout.setC_Order_ID(0);
            inout.setC_Invoice_ID(0);
            inout.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            inout.setAD_OrgTrx_ID(originalIO.getAD_OrgTrx_ID());
            inout.setC_Project_ID(originalIO.getC_Project_ID());
            inout.setC_Campaign_ID(originalIO.getC_Campaign_ID());
            inout.setC_Activity_ID(originalIO.getC_Activity_ID());
            inout.setUser1_ID(originalIO.getUser1_ID());
            inout.setUser2_ID(originalIO.getUser2_ID());
        }
        inout.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"Line"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        return columnNames;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID, int M_Locator_ID) {
        this.receiptLocator_ID = M_Locator_ID;
        return this.getRMAData(M_RMA_ID);
    }

    private class IOLineRMALineSummary {
        int M_RMALine_ID = 0;
        BigDecimal QtyEntered = Env.ZERO;
        int C_UOM_ID = 0;

        public IOLineRMALineSummary(int M_RMALine_ID, BigDecimal QtyEntered, int C_UOM_ID) {
            this.M_RMALine_ID = M_RMALine_ID;
            this.QtyEntered = QtyEntered;
            this.C_UOM_ID = C_UOM_ID;
        }
    }
}

