/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;

public class JPiereInvoiceUtil {
    public static BigDecimal getOpenAmtPointOfTime(Properties ctx, MInvoice invoice, Timestamp pointOfTime, boolean creditMemoAdjusted, String trxName) {
        if (pointOfTime == null) {
            return invoice.getOpenAmt(creditMemoAdjusted, null);
        }
        BigDecimal allocatedAmtPointOfTime = Env.ZERO;
        MAllocationHdr[] allocationHdr = MAllocationHdr.getOfInvoice((Properties)ctx, (int)invoice.getC_Invoice_ID(), (String)trxName);
        Timestamp allocatedDate = null;
        int i = 0;
        while (i < allocationHdr.length) {
            allocatedDate = allocationHdr[i].getDateAcct();
            if (!allocatedDate.after(pointOfTime)) {
                MAllocationLine[] allocationLine = allocationHdr[i].getLines(false);
                int j = 0;
                while (j < allocationLine.length) {
                    if (allocationLine[j].getC_Invoice_ID() == invoice.getC_Invoice_ID()) {
                        allocatedAmtPointOfTime = allocatedAmtPointOfTime.add(allocationLine[j].getAmount()).add(allocationLine[j].getDiscountAmt()).add(allocationLine[j].getWriteOffAmt());
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (allocatedAmtPointOfTime.signum() < 0) {
            allocatedAmtPointOfTime = allocatedAmtPointOfTime.abs();
        }
        BigDecimal m_openAmt = invoice.getGrandTotal().subtract(allocatedAmtPointOfTime);
        if (!creditMemoAdjusted) {
            return m_openAmt;
        }
        if (invoice.isCreditMemo()) {
            return m_openAmt.negate();
        }
        return m_openAmt;
    }
}

