/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import jpiere.base.plugin.org.adempiere.model.MContractTaxAcct;
import jpiere.base.plugin.org.adempiere.model.MRecognition;
import jpiere.base.plugin.org.adempiere.model.MRecognitionLine;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MOrderLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_JPRecognition
extends Doc {
    protected DocTax[] m_taxes = null;
    protected int m_precision = -1;
    protected boolean m_allLinesService = true;
    protected boolean m_allLinesItem = true;
    private int m_Reversal_ID = 0;

    public Doc_JPRecognition(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MRecognition.class, rs, null, trxName);
    }

    protected String loadDocumentDetails() {
        MRecognition recognition = (MRecognition)this.getPO();
        this.setDateDoc(recognition.getDateInvoiced());
        this.setIsTaxIncluded(recognition.isTaxIncluded());
        this.m_Reversal_ID = recognition.getReversal_ID();
        this.setAmount(0, recognition.getGrandTotal());
        this.setAmount(1, recognition.getTotalLines());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(recognition);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length + ", Taxes=" + this.m_taxes.length);
        }
        return null;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT rt.C_Tax_ID, t.Name, t.Rate, rt.TaxBaseAmt, rt.TaxAmt, t.IsSalesTax FROM C_Tax t, JP_RecognitionTax rt WHERE t.C_Tax_ID=rt.C_Tax_ID AND rt.JP_Recognition_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "Y".equals(rs.getString(6));
                    DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(taxLine.toString());
                    }
                    list.add(taxLine);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    private DocLine[] loadLines(MRecognition recognition) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MRecognitionLine[] lines = recognition.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MRecognitionLine line = lines[i];
            if (!line.isDescription()) {
                MTax tax;
                DocLine docLine = new DocLine((PO)line, (Doc)this);
                docLine.setReversalLine_ID(line.getReversalLine_ID());
                BigDecimal Qty = line.getQtyInvoiced();
                boolean cm = this.getDocumentType().equals("JPS") || this.getDocumentType().equals("JPY");
                docLine.setQty(cm ? Qty.negate() : Qty, recognition.isSOTrx());
                BigDecimal LineNetAmt = line.getLineNetAmt();
                BigDecimal PriceList = line.getPriceList();
                int C_Tax_ID = docLine.getC_Tax_ID();
                if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get((Properties)this.getCtx(), (int)C_Tax_ID)).isZeroTax()) {
                    BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                    }
                    LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                    if (tax.isSummary()) {
                        BigDecimal sumChildLineNetAmtTax = Env.ZERO;
                        DocTax taxToApplyDiff = null;
                        MTax[] mTaxArray = tax.getChildTaxes(false);
                        int n = mTaxArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MTax childTax = mTaxArray[n2];
                            if (!childTax.isZeroTax()) {
                                BigDecimal childLineNetAmtTax = childTax.calculateTax(LineNetAmt, false, this.getStdPrecision());
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("LineNetAmt=" + LineNetAmt + " - Child Tax=" + childLineNetAmtTax);
                                }
                                int t = 0;
                                while (t < this.m_taxes.length) {
                                    if (this.m_taxes[t].getC_Tax_ID() == childTax.getC_Tax_ID()) {
                                        this.m_taxes[t].addIncludedTax(childLineNetAmtTax);
                                        taxToApplyDiff = this.m_taxes[t];
                                        sumChildLineNetAmtTax = sumChildLineNetAmtTax.add(childLineNetAmtTax);
                                        break;
                                    }
                                    ++t;
                                }
                            }
                            ++n2;
                        }
                        BigDecimal diffChildVsSummary = LineNetAmtTax.subtract(sumChildLineNetAmtTax);
                        if (diffChildVsSummary.signum() != 0 && taxToApplyDiff != null) {
                            taxToApplyDiff.addIncludedTax(diffChildVsSummary);
                        }
                    } else {
                        int t = 0;
                        while (t < this.m_taxes.length) {
                            if (this.m_taxes[t].getC_Tax_ID() == C_Tax_ID) {
                                this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                                break;
                            }
                            ++t;
                        }
                    }
                    BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision());
                    PriceList = PriceList.subtract(PriceListTax);
                }
                docLine.setAmount(LineNetAmt, PriceList, Qty);
                if (docLine.isItem()) {
                    this.m_allLinesService = false;
                } else {
                    this.m_allLinesItem = false;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(docLine.toString());
                }
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        if (this.isTaxIncluded()) {
            int i2 = 0;
            while (i2 < this.m_taxes.length) {
                if (this.m_taxes[i2].isIncludedTaxDifference()) {
                    BigDecimal diff = this.m_taxes[i2].getIncludedTaxDifference();
                    int j = 0;
                    while (j < dls.length) {
                        MTax lineTax = MTax.get((Properties)this.getCtx(), (int)dls[j].getC_Tax_ID());
                        MTax[] composingTaxes = null;
                        composingTaxes = lineTax.isSummary() ? lineTax.getChildTaxes(false) : new MTax[]{lineTax};
                        MTax[] mTaxArray = composingTaxes;
                        int n = composingTaxes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            MTax mTax = mTaxArray[n3];
                            if (mTax.getC_Tax_ID() == this.m_taxes[i2].getC_Tax_ID()) {
                                dls[j].setLineNetAmtDifference(diff);
                                this.m_taxes[i2].addIncludedTax(diff.negate());
                                diff = Env.ZERO;
                                break;
                            }
                            ++n3;
                        }
                        if (diff.signum() == 0) break;
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return dls;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        MRecognition recog = (MRecognition)this.getPO();
        if (recog.getJP_ContractContent_ID() == 0) {
            return facts;
        }
        MContractContent contractContent = MContractContent.get(Env.getCtx(), recog.getJP_ContractContent_ID());
        if (contractContent.getJP_Contract_Acct_ID() == 0) {
            return facts;
        }
        MContractAcct contractAcct = MContractAcct.get(Env.getCtx(), contractContent.getJP_Contract_Acct_ID());
        if (!contractAcct.isPostingContractAcctJP() || !contractAcct.isPostingRecognitionDocJP()) {
            return facts;
        }
        Fact fact = new Fact((Doc)this, as, "A");
        if (!as.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("JPR")) {
            this.postJPR(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("JPS")) {
            this.postJPS(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("JPX")) {
            this.postJPX(as, contractAcct, fact);
        } else if (this.getDocumentType().equals("JPY")) {
            this.postJPY(as, contractAcct, fact);
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        FactLine[] fLines = fact.getLines();
        int i = 0;
        while (i < fLines.length) {
            if (fLines[i] != null) {
                fLines[i].setLocationFromOrg(fLines[i].getAD_Org_ID(), true);
                if (recog.getBill_BPartner_ID() > 0) {
                    fLines[i].setC_BPartner_ID(recog.getBill_BPartner_ID());
                }
                if (recog.getBill_Location_ID() > 0) {
                    fLines[i].setLocationFromBPartner(recog.getBill_Location_ID(), false);
                } else {
                    fLines[i].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                fLines[i].set_ValueNoCheck("JP_Order_ID", (Object)recog.getC_Order_ID());
                fLines[i].set_ValueNoCheck("JP_ContractContent_ID", (Object)recog.getJP_ContractContent_ID());
            }
            ++i;
        }
        facts.add(fact);
        return facts;
    }

    /*
     * Unable to fully structure code
     */
    private String postJPR(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        dr = null;
        cr = null;
        amt = Env.ZERO;
        i = 0;
        while (i < this.m_taxes.length) {
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0 && (recognitionTaxDueAccount = this.getRecognitionTaxDueAccount(this.m_taxes[i], contractAcct, as)) != null) {
                taxLineDR = fact.createLine(null, this.getInvoiceTaxDueAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), amt, null);
                if (taxLineDR != null) {
                    taxLineDR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                if ((taxLineCR = fact.createLine(null, recognitionTaxDueAccount, this.getC_Currency_ID(), null, amt)) != null) {
                    taxLineCR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            block41: {
                block40: {
                    block39: {
                        line = this.p_lines[i];
                        amt = this.p_lines[i].getAmtSource();
                        C_Charge_ID = line.getPO().get_ValueAsInt("C_Charge_ID");
                        if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                            amt = (BigDecimal)line.getPO().get_Value("JP_TaxBaseAmt");
                        }
                        dAmt = null;
                        if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                            amt = amt.add(discount);
                            dAmt = discount;
                            fact.createLine(line, this.getRecognitionTDiscountGrantAccount(line, contractAcct, as), this.getC_Currency_ID(), dAmt, null);
                            fact.createLine(line, this.getInvoiceTDiscountGrantAccount(line, contractAcct, as), this.getC_Currency_ID(), null, dAmt);
                        }
                        if ((dr = fact.createLine(line, this.getInvoiceRevenueAccount(line, contractAcct, as), this.getC_Currency_ID(), amt, null)) != null) {
                            dr.setQty(line.getQty().negate());
                        }
                        if ((cr = fact.createLine(line, this.getRecognitionRevenueAccount(line, contractAcct, as), this.getC_Currency_ID(), null, amt)) != null) {
                            cr.setQty(line.getQty());
                        }
                        JP_RECOGNITION_COGS_SCHEDULED_COST = MSysConfig.getBooleanValue((String)"JP_RECOGNITION_COGS_SCHEDULED_COST", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                        product = line.getProduct();
                        costs = Env.ZERO;
                        if (!JP_RECOGNITION_COGS_SCHEDULED_COST) break block39;
                        if (line.getC_OrderLine_ID() > 0) {
                            oLine = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.getTrxName());
                            costs = (BigDecimal)oLine.get_Value("JP_ScheduledCostLineAmt");
                        }
                        if (costs.compareTo(Env.ZERO) != 0) {
                            dr = fact.createLine(line, this.getCOGSAccount(line, contractAcct, as), as.getC_Currency_ID(), costs, null);
                            if (dr == null) {
                                this.p_Error = "FactLine DR not created: " + line;
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                            M_InOutLine_ID = line.getPO().get_ValueAsInt("M_InOutLine_ID");
                            if (M_InOutLine_ID > 0) {
                                ioLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, this.getTrxName());
                                dr.setM_Locator_ID(ioLine.getM_Locator_ID());
                                dr.setLocationFromLocator(ioLine.getM_Locator_ID(), true);
                            }
                            dr.setAD_Org_ID(line.getOrder_Org_ID());
                            dr.setQty(line.getQty().negate());
                            cr = fact.createLine(line, this.getAssetAccount(line, contractAcct, as), as.getC_Currency_ID(), null, costs);
                            if (cr == null) {
                                this.p_Error = "FactLine CR not created: " + line;
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                            cr.setM_Locator_ID(line.getM_Locator_ID());
                            cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                        }
                        ** GOTO lbl127
                    }
                    if (this.isReversal(line) || product == null) ** GOTO lbl-1000
                    if ("B".equals(product.getCostingLevel(as))) {
                        if (line.getM_AttributeSetInstance_ID() == 0) {
                            ioLine = (MInOutLine)line.getPO();
                            mas = MInOutLineMA.get((Properties)this.getCtx(), (int)ioLine.get_ID(), (String)this.getTrxName());
                            if (mas != null && mas.length > 0) {
                                costs = BigDecimal.ZERO;
                                j = 0;
                                while (j < mas.length) {
                                    ma = mas[j];
                                    QtyMA = ma.getMovementQty();
                                    pc = line.getProductCost();
                                    pc.setQty(QtyMA);
                                    pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                    maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                    costs = costs.add(maCosts);
                                    ++j;
                                }
                            }
                        } else {
                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                        }
                    } else {
                        costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                    }
                    if (costs != null && costs.signum() != 0) break block40;
                    if (product.isStocked()) {
                        count = DB.getSQLValue(null, (String)"SELECT Count(*) FROM M_CostDetail WHERE M_Product_ID=? AND Processed='Y' AND Amt=0.00 AND Qty > 0 AND (C_OrderLine_ID > 0 OR C_InvoiceLine_ID > 0)", (int)product.getM_Product_ID());
                        if (count > 0) {
                            costs = BigDecimal.ZERO;
                        } else {
                            this.p_Error = "No Costs for " + line.getProduct().getName();
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                    }
                    break block41;
lbl-1000:
                    // 1 sources

                    {
                        costs = BigDecimal.ZERO;
                    }
                }
                if (costs.compareTo(Env.ZERO) == 0) ** GOTO lbl127
                dr = fact.createLine(line, this.getCOGSAccount(line, contractAcct, as), as.getC_Currency_ID(), costs, null);
                if (dr == null) {
                    this.p_Error = "FactLine DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                dr.setAD_Org_ID(line.getOrder_Org_ID());
                dr.setQty(line.getQty().negate());
                if (!this.isReversal(line) || dr.updateReverseLine(MRecognition.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl114
                if (product != null && !product.isStocked()) {
                    fact.remove(dr);
                } else {
                    this.p_Error = "Original Shipment/Receipt not posted yet";
                    return null;
lbl114:
                    // 1 sources

                    cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), null, costs);
                    if (cr == null) {
                        this.p_Error = "FactLine CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    if (this.isReversal(line)) {
                        if (!cr.updateReverseLine(MRecognition.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Shipment/Receipt not posted yet";
                            return null;
                        }
                        costs = cr.getAcctBalance();
                    }
lbl127:
                    // 5 sources

                    if ((recogLine = (MRecognitionLine)line.getPO()).getM_InOutLine_ID() > 0 && product != null) {
                        ioLine = new MInOutLine(this.getCtx(), recogLine.getM_InOutLine_ID(), this.getTrxName());
                        if ("B".equals(product.getCostingLevel(as))) {
                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                mas = MInOutLineMA.get((Properties)this.getCtx(), (int)ioLine.get_ID(), (String)this.getTrxName());
                                if (mas != null && mas.length > 0) {
                                    j = 0;
                                    while (j < mas.length) {
                                        ma = mas[j];
                                        if (!MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ma.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ma.getMovementQty().negate(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                                            this.p_Error = "Failed to create cost detail record";
                                            return null;
                                        }
                                        ++j;
                                    }
                                }
                            } else if (ioLine.getM_Product_ID() != 0 && !MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ioLine.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ioLine.getMovementQty().negate(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                                this.p_Error = "Failed to create cost detail record";
                                return null;
                            }
                        } else if (ioLine.getM_Product_ID() != 0 && !MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ioLine.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ioLine.getMovementQty().negate(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String postJPS(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        dr = null;
        cr = null;
        amt = Env.ZERO;
        i = 0;
        while (i < this.m_taxes.length) {
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0 && (recognitionTaxDueAccount = this.getRecognitionTaxDueAccount(this.m_taxes[i], contractAcct, as)) != null) {
                taxLineDR = fact.createLine(null, this.getInvoiceTaxDueAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), null, amt);
                if (taxLineDR != null) {
                    taxLineDR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                if ((taxLineCR = fact.createLine(null, recognitionTaxDueAccount, this.getC_Currency_ID(), amt, null)) != null) {
                    taxLineCR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            line = this.p_lines[i];
                            amt = this.p_lines[i].getAmtSource();
                            C_Charge_ID = line.getPO().get_ValueAsInt("C_Charge_ID");
                            if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                                amt = (BigDecimal)line.getPO().get_Value("JP_TaxBaseAmt");
                            }
                            dAmt = null;
                            if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                                amt = amt.add(discount);
                                dAmt = discount;
                                fact.createLine(line, this.getRecognitionTDiscountGrantAccount(line, contractAcct, as), this.getC_Currency_ID(), null, dAmt);
                                fact.createLine(line, this.getInvoiceTDiscountGrantAccount(line, contractAcct, as), this.getC_Currency_ID(), dAmt, null);
                            }
                            dr = fact.createLine(line, this.getInvoiceRevenueAccount(line, contractAcct, as), this.getC_Currency_ID(), null, amt);
                            dr.setQty(line.getQty().negate());
                            cr = fact.createLine(line, this.getRecognitionRevenueAccount(line, contractAcct, as), this.getC_Currency_ID(), amt, null);
                            cr.setQty(line.getQty());
                            JP_RECOGNITION_COGS_SCHEDULED_COST = MSysConfig.getBooleanValue((String)"JP_RECOGNITION_COGS_SCHEDULED_COST", (boolean)false, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
                            product = line.getProduct();
                            costs = Env.ZERO;
                            if (!JP_RECOGNITION_COGS_SCHEDULED_COST) break block34;
                            if (line.getC_OrderLine_ID() > 0) {
                                oLine = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.getTrxName());
                                costs = (BigDecimal)oLine.get_Value("JP_ScheduledCostLineAmt");
                            }
                            if (costs.compareTo(Env.ZERO) != 0) {
                                dr = fact.createLine(line, this.getCOGSAccount(line, contractAcct, as), as.getC_Currency_ID(), null, costs);
                                if (dr == null) {
                                    this.p_Error = "FactLine DR not created: " + line;
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                                M_InOutLine_ID = line.getPO().get_ValueAsInt("M_InOutLine_ID");
                                if (M_InOutLine_ID > 0) {
                                    ioLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, this.getTrxName());
                                    dr.setM_Locator_ID(ioLine.getM_Locator_ID());
                                    dr.setLocationFromLocator(ioLine.getM_Locator_ID(), true);
                                }
                                dr.setAD_Org_ID(line.getOrder_Org_ID());
                                dr.setQty(line.getQty().negate());
                                cr = fact.createLine(line, this.getAssetAccount(line, contractAcct, as), as.getC_Currency_ID(), costs, null);
                                if (cr == null) {
                                    this.p_Error = "FactLine CR not created: " + line;
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                                cr.setM_Locator_ID(line.getM_Locator_ID());
                                cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                            }
                            ** GOTO lbl123
                        }
                        if (this.isReversal(line) || product == null) break block35;
                        if ("B".equals(product.getCostingLevel(as))) {
                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                ioLine = (MInOutLine)line.getPO();
                                mas = MInOutLineMA.get((Properties)this.getCtx(), (int)ioLine.get_ID(), (String)this.getTrxName());
                                costs = BigDecimal.ZERO;
                                if (mas != null && mas.length > 0) {
                                    j = 0;
                                    while (j < mas.length) {
                                        ma = mas[j];
                                        QtyMA = ma.getMovementQty();
                                        pc = line.getProductCost();
                                        pc.setQty(QtyMA);
                                        pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                        maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                        costs = costs.add(maCosts);
                                        ++j;
                                    }
                                }
                            } else {
                                costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                            }
                        } else {
                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                        }
                        if (costs != null && costs.signum() != 0) break block36;
                        if (product.isStocked()) {
                            this.p_Error = "No Costs for " + line.getProduct().getName();
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                        break block37;
                    }
                    costs = BigDecimal.ZERO;
                }
                if (costs.compareTo(Env.ZERO) == 0) ** GOTO lbl123
                dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs.negate(), null);
                if (dr == null) {
                    this.p_Error = "FactLine DR not created: " + line;
                    this.log.log(Level.WARNING, this.p_Error);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                if (!this.isReversal(line)) ** GOTO lbl111
                if (dr.updateReverseLine(MRecognition.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl110
                if (product != null && !product.isStocked()) {
                    fact.remove(dr);
                } else {
                    this.p_Error = "Original Shipment/Receipt not posted yet";
                    return null;
lbl110:
                    // 1 sources

                    costs = dr.getAcctBalance();
lbl111:
                    // 2 sources

                    if ((cr = fact.createLine(line, this.getCOGSAccount(line, contractAcct, as), as.getC_Currency_ID(), null, costs.negate())) == null) {
                        this.p_Error = "FactLine CR not created: " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                    cr.setAD_Org_ID(line.getOrder_Org_ID());
                    cr.setQty(line.getQty().negate());
                    if (this.isReversal(line) && !cr.updateReverseLine(MRecognition.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                        this.p_Error = "Original Shipment/Receipt not posted yet";
                        return null;
                    }
lbl123:
                    // 4 sources

                    if ((recogLine = (MRecognitionLine)line.getPO()).getM_InOutLine_ID() > 0 && product != null) {
                        ioLine = new MInOutLine(this.getCtx(), recogLine.getM_InOutLine_ID(), this.getTrxName());
                        if ("B".equals(product.getCostingLevel(as))) {
                            if (ioLine.getM_AttributeSetInstance_ID() == 0) {
                                mas = MInOutLineMA.get((Properties)this.getCtx(), (int)ioLine.get_ID(), (String)this.getTrxName());
                                if (mas != null && mas.length > 0) {
                                    j = 0;
                                    while (j < mas.length) {
                                        ma = mas[j];
                                        if (!MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ma.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ma.getMovementQty(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                                            this.p_Error = "Failed to create cost detail record";
                                            return null;
                                        }
                                        ++j;
                                    }
                                }
                            } else if (ioLine.getM_Product_ID() != 0 && !MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ioLine.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ioLine.getMovementQty(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                                this.p_Error = "Failed to create cost detail record";
                                return null;
                            }
                        } else if (line.getM_Product_ID() != 0 && !MCostDetail.createShipment((MAcctSchema)as, (int)ioLine.getAD_Org_ID(), (int)ioLine.getM_Product_ID(), (int)ioLine.getM_AttributeSetInstance_ID(), (int)ioLine.get_ID(), (int)0, (BigDecimal)costs, (BigDecimal)ioLine.getMovementQty(), (String)ioLine.getDescription(), (boolean)true, (String)this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private String postJPX(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal amt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            MAccount recognitionTaxCreditAccount;
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0 && (recognitionTaxCreditAccount = this.getRecognitionTaxCreditAccount(this.m_taxes[i], contractAcct, as)) != null) {
                FactLine taxLineCR;
                FactLine taxLineDR = fact.createLine(null, this.getInvoiceTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), null, amt);
                if (taxLineDR != null) {
                    taxLineDR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                if ((taxLineCR = fact.createLine(null, this.getRecognitionTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), amt, null)) != null) {
                    taxLineCR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            BigDecimal discount;
            MCharge charge;
            DocLine line = this.p_lines[i];
            amt = this.p_lines[i].getAmtSource();
            int C_Charge_ID = line.getPO().get_ValueAsInt("C_Charge_ID");
            if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                amt = (BigDecimal)line.getPO().get_Value("JP_TaxBaseAmt");
            }
            BigDecimal dAmt = null;
            if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                amt = amt.add(discount);
                dAmt = discount;
                fact.createLine(line, this.getRecognitionTDiscountRecAccount(line, contractAcct, as), this.getC_Currency_ID(), null, dAmt);
                fact.createLine(line, this.getInvoiceTDiscountRecAccount(line, contractAcct, as), this.getC_Currency_ID(), dAmt, null);
            }
            dr = fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), null, amt);
            dr.setQty(line.getQty().negate());
            cr = fact.createLine(line, this.getRecognitionExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), amt, null);
            cr.setQty(line.getQty());
            cr.setM_Locator_ID(line.getM_Locator_ID());
            cr.setLocationFromLocator(line.getM_Locator_ID(), true);
            ++i;
        }
        return null;
    }

    private String postJPY(MAcctSchema as, MContractAcct contractAcct, Fact fact) {
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal amt = Env.ZERO;
        int i = 0;
        while (i < this.m_taxes.length) {
            MAccount recognitionTaxCreditAccount;
            amt = this.m_taxes[i].getAmount();
            if (amt != null && amt.signum() != 0 && (recognitionTaxCreditAccount = this.getRecognitionTaxCreditAccount(this.m_taxes[i], contractAcct, as)) != null) {
                FactLine taxLineCR;
                FactLine taxLineDR = fact.createLine(null, this.getInvoiceTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), amt, null);
                if (taxLineDR != null) {
                    taxLineDR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                if ((taxLineCR = fact.createLine(null, this.getRecognitionTaxCreditAccount(this.m_taxes[i], contractAcct, as), this.getC_Currency_ID(), null, amt)) != null) {
                    taxLineCR.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            BigDecimal discount;
            MCharge charge;
            DocLine line = this.p_lines[i];
            amt = this.p_lines[i].getAmtSource();
            int C_Charge_ID = line.getPO().get_ValueAsInt("C_Charge_ID");
            if (C_Charge_ID != 0 && !(charge = MCharge.get((Properties)this.getCtx(), (int)C_Charge_ID)).isSameTax() && charge.isTaxIncluded()) {
                amt = (BigDecimal)line.getPO().get_Value("JP_TaxBaseAmt");
            }
            BigDecimal dAmt = null;
            if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                amt = amt.add(discount);
                dAmt = discount;
                fact.createLine(line, this.getRecognitionTDiscountRecAccount(line, contractAcct, as), this.getC_Currency_ID(), dAmt, null);
                fact.createLine(line, this.getInvoiceTDiscountRecAccount(line, contractAcct, as), this.getC_Currency_ID(), null, dAmt);
            }
            dr = fact.createLine(line, this.getInvoiceExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), amt, null);
            dr.setQty(line.getQty().negate());
            cr = fact.createLine(line, this.getRecognitionExpenseAccount(line, contractAcct, as), this.getC_Currency_ID(), null, amt);
            cr.setQty(line.getQty());
            cr.setM_Locator_ID(line.getM_Locator_ID());
            cr.setLocationFromLocator(line.getM_Locator_ID(), true);
            ++i;
        }
        return null;
    }

    private MAccount getRecognitionRevenueAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getJP_Ch_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getJP_Ch_Expense_Acct());
            }
            return docLine.getAccount(1, as);
        }
        if (line.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getJP_Revenue_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_Revenue_Acct());
            }
            return docLine.getAccount(1, as);
        }
        return docLine.getAccount(1, as);
    }

    private MAccount getInvoiceRevenueAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return docLine.getAccount(1, as);
        }
        if (line.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Revenue_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Revenue_Acct());
            }
            return docLine.getAccount(1, as);
        }
        return docLine.getAccount(1, as);
    }

    private MAccount getRecognitionExpenseAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getJP_Ch_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getJP_Ch_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        if (line.getM_Product_ID() > 0) {
            if (docLine.isItem()) {
                MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
                if (contractProductAcct != null && contractProductAcct.getJP_PurchaseOffset_Acct() > 0 && contractProductAcct.getJP_Purchase_Acct() > 0) {
                    return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_Purchase_Acct());
                }
                return docLine.getAccount(10, as);
            }
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getJP_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        return docLine.getAccount(2, as);
    }

    private MAccount getInvoiceExpenseAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        if (line.getM_Product_ID() > 0) {
            if (docLine.isItem()) {
                MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
                if (contractProductAcct != null && contractProductAcct.getJP_PurchaseOffset_Acct() > 0 && contractProductAcct.getJP_Purchase_Acct() > 0) {
                    return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_PurchaseOffset_Acct());
                }
                return docLine.getAccount(10, as);
            }
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Expense_Acct());
            }
            return docLine.getAccount(2, as);
        }
        return docLine.getAccount(2, as);
    }

    private MAccount getRecognitionTDiscountGrantAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getJP_TradeDiscountGrant_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_TradeDiscountGrant_Acct());
        }
        return docLine.getAccount(8, as);
    }

    private MAccount getInvoiceTDiscountGrantAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountGrant_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_TradeDiscountGrant_Acct());
        }
        return docLine.getAccount(8, as);
    }

    private MAccount getRecognitionTDiscountRecAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getJP_TradeDiscountRec_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getJP_TradeDiscountRec_Acct());
        }
        return docLine.getAccount(7, as);
    }

    private MAccount getInvoiceTDiscountRecAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
        if (contractProductAcct != null && contractProductAcct.getP_TradeDiscountRec_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_TradeDiscountRec_Acct());
        }
        return docLine.getAccount(7, as);
    }

    private MAccount getCOGSAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        MRecognitionLine line = (MRecognitionLine)docLine.getPO();
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return docLine.getAccount(4, as);
        }
        if (line.getM_Product_ID() > 0) {
            MContractProductAcct contractProductAcct = contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_COGS_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_COGS_Acct());
            }
            return docLine.getAccount(4, as);
        }
        return docLine.getAccount(4, as);
    }

    private MAccount getAssetAccount(DocLine docLine, MContractAcct contractAcct, MAcctSchema as) {
        return docLine.getAccount(3, as);
    }

    private MAccount getInvoiceTaxDueAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        if (taxAcct != null && taxAcct.getT_Due_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Due_Acct());
        }
        return doc_Tax.getAccount(0, as);
    }

    private MAccount getInvoiceTaxCreditAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        MTax tax = MTax.get((Properties)this.getCtx(), (int)doc_Tax.getC_Tax_ID());
        if (tax.isSalesTax()) {
            if (taxAcct != null && taxAcct.getT_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Expense_Acct());
            }
            return doc_Tax.getAccount(2, as);
        }
        if (taxAcct != null && taxAcct.getT_Credit_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getT_Credit_Acct());
        }
        return doc_Tax.getAccount(1, as);
    }

    private MAccount getRecognitionTaxDueAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        if (taxAcct != null && taxAcct.getJP_TaxDue_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getJP_TaxDue_Acct());
        }
        return null;
    }

    private MAccount getRecognitionTaxCreditAccount(DocTax doc_Tax, MContractAcct contractAcct, MAcctSchema as) {
        MContractTaxAcct taxAcct = contractAcct.getContracTaxAcct(doc_Tax.getC_Tax_ID(), as.getC_AcctSchema_ID(), false);
        MTax tax = MTax.get((Properties)this.getCtx(), (int)doc_Tax.getC_Tax_ID());
        if (tax.isSalesTax()) {
            if (taxAcct != null && taxAcct.getJP_TaxExpense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getJP_TaxExpense_Acct());
            }
            return null;
        }
        if (taxAcct != null && taxAcct.getJP_TaxCredit_Acct() > 0) {
            return MAccount.get((Properties)this.getCtx(), (int)taxAcct.getJP_TaxCredit_Acct());
        }
        return null;
    }

    private boolean isReversal(DocLine line) {
        return this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0;
    }
}

