/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.webui.editor;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.IDisplayTypeFactory;
import org.adempiere.base.Service;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.MCurrency;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WNumberEditorJP
extends WEditor
implements ContextMenuListener {
    public static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    public static final int MAX_DISPLAY_LENGTH = 35;
    public static final int MIN_DISPLAY_LENGTH = 11;
    private Object oldValue;
    private int displayType;
    private boolean tableEditor;
    private String originalStyle;

    public WNumberEditorJP() {
        this("Number", false, false, true, 22, "");
    }

    public WNumberEditorJP(GridField gridField) {
        this(false, gridField);
    }

    public WNumberEditorJP(boolean tableEditor, GridField gridField) {
        super((Component)new NumberBox(gridField.getDisplayType() == 11, tableEditor), gridField);
        this.displayType = gridField.getDisplayType();
        this.tableEditor = tableEditor;
        this.init();
    }

    public WNumberEditorJP(GridField gridField, boolean integral) {
        super((Component)new NumberBox(integral), gridField);
        this.displayType = integral ? 11 : 22;
        this.init();
    }

    public WNumberEditorJP(String columnName, boolean mandatory, boolean readonly, boolean updateable, int displayType, String title) {
        super((Component)new NumberBox(displayType == 11), columnName, title, null, mandatory, readonly, updateable);
        this.displayType = displayType;
        this.init();
    }

    private void init() {
        this.setChangeEventWhenEditing(true);
        if (this.gridField != null) {
            this.getComponent().setTooltiptext(this.gridField.getDescription());
            int displayLength = this.gridField.getDisplayLength();
            if (displayLength > 35) {
                displayLength = 35;
            } else if (displayLength <= 0 || displayLength < 11) {
                displayLength = 11;
            }
            if (!this.tableEditor) {
                this.getComponent().getDecimalbox().setCols(displayLength);
            }
        }
        if (DisplayType.isID((int)this.displayType)) {
            this.displayType = 11;
        } else if (!DisplayType.isNumeric((int)this.displayType)) {
            this.displayType = 22;
        }
        Language lang = AEnv.getLanguage((Properties)Env.getCtx());
        DecimalFormat format = DisplayType.getNumberFormat((int)this.displayType, (Language)lang);
        if (this.gridField != null && this.gridField.getFormatPattern() != null) {
            this.getComponent().getDecimalbox().setFormat(this.gridField.getFormatPattern());
        } else {
            this.getComponent().getDecimalbox().setFormat(format.toPattern());
        }
        this.getComponent().getDecimalbox().setLocale(lang.getLocale());
        this.getComponent().setFormat((NumberFormat)format);
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.addChangeLogMenu(this.popupMenu);
        this.originalStyle = this.getComponent().getDecimalbox().getStyle();
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Number newValue = this.getComponent().getValue();
            if (this.oldValue == null && newValue == null) {
                return;
            }
            if (this.displayType == 11) {
                if (newValue != null && newValue instanceof BigDecimal) {
                    newValue = new Integer(newValue.intValue());
                }
                if (this.oldValue != null && this.oldValue instanceof BigDecimal) {
                    this.oldValue = new Integer(((BigDecimal)this.oldValue).intValue());
                }
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if ((this.displayType == 12 || this.displayType == 37) && newValue != null && newValue instanceof BigDecimal) {
                newValue = this.addDecimalPlaces((BigDecimal)newValue);
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent((Object)this, this.getColumnName(), this.oldValue, (Object)newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = this.getComponent().getValue();
        }
    }

    public BigDecimal addDecimalPlaces(BigDecimal oldValue) {
        if (oldValue.toString().contains(".")) {
            return oldValue;
        }
        int decimalPlaces = Env.getContextAsInt((Properties)Env.getCtx(), (String)"AutomaticDecimalPlacesForAmoun");
        if (decimalPlaces <= 0) {
            return oldValue;
        }
        BigDecimal divisor = decimalPlaces == 2 ? Env.ONEHUNDRED : (decimalPlaces == 1 ? BigDecimal.TEN : BigDecimal.TEN.pow(decimalPlaces));
        BigDecimal newValue = oldValue.divide(divisor, decimalPlaces, 4);
        return newValue;
    }

    public NumberBox getComponent() {
        return (NumberBox)this.component;
    }

    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public String getDisplay() {
        return this.getComponent().getText();
    }

    public Object getValue() {
        return this.getComponent().getValue();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
        } else if (value instanceof BigDecimal) {
            this.oldValue = (BigDecimal)value;
            if (this.gridField != null && this.displayType == 12) {
                DecimalFormat format = null;
                List factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
                for (IDisplayTypeFactory factory : factoryList) {
                    format = factory.getNumberFormat(this.displayType, null, this.gridField.getFormatPattern());
                }
                format.setMinimumFractionDigits(MCurrency.getStdPrecision((Properties)Env.getCtx(), (int)this.getC_Currency_ID()));
                this.getComponent().getDecimalbox().setFormat(format.toPattern());
                this.getComponent().setFormat((NumberFormat)format);
            } else if (this.gridField != null && this.displayType == 37) {
                DecimalFormat format = null;
                List factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
                for (IDisplayTypeFactory factory : factoryList) {
                    format = factory.getNumberFormat(this.displayType, null, this.gridField.getFormatPattern());
                }
                format.setMinimumFractionDigits(MCurrency.getCostingPrecision((Properties)Env.getCtx(), (int)this.getC_Currency_ID()));
                this.getComponent().getDecimalbox().setFormat(format.toPattern());
                this.getComponent().setFormat((NumberFormat)format);
            }
        } else {
            this.oldValue = value instanceof Number ? BigDecimal.valueOf(((Number)value).doubleValue()) : new BigDecimal(value.toString());
        }
        this.getComponent().setValue(this.oldValue);
    }

    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), (GridField)this.getGridField(), (Object)this.getValue());
            }
            return;
        }
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start((GridField)this.gridField);
        }
    }

    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    protected void setFieldStyle(String style) {
        StringBuilder s = new StringBuilder(this.originalStyle);
        if (s.charAt(s.length() - 1) != ';') {
            s.append(";");
        }
        if (!Util.isEmpty((String)style)) {
            s.append(style);
        }
        this.getComponent().getDecimalbox().setStyle(s.toString());
    }

    public int getC_Currency_ID() {
        int C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridField().getWindowNo(), (String)"C_Currency_ID");
        if (C_Currency_ID == 0) {
            C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.getGridField().getWindowNo(), (int)0, (String)"C_Currency_ID");
        }
        if (C_Currency_ID == 0) {
            C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        }
        return C_Currency_ID;
    }
}

