/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MInvValProfile;
import jpiere.base.plugin.org.adempiere.model.MInvValProfileOrg;
import jpiere.base.plugin.util.JPiereInvValUtil;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class UpdateInventoryValuationPriceList
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_JP_InvValProfile_ID = 0;
    private Timestamp p_DateValue = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("JP_InvValProfile_ID")) {
                    this.p_JP_InvValProfile_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateValue")) {
                    this.p_DateValue = para[i].getParameterAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.p_JP_InvValProfile_ID == 0 || this.p_DateValue == null) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"ParameterMissing");
        }
        MInvValProfile ivp = new MInvValProfile(this.getCtx(), this.p_JP_InvValProfile_ID, null);
        if (ivp.getCostingLevel().equals("B")) {
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CopyError")) + MRefList.getListName((Properties)this.getCtx(), (int)355, (String)"B");
        }
        String DateValueString = new String(this.p_DateValue.toString().substring(0, 10));
        int M_PriceListVersion_ID = 0;
        String returnName = null;
        if (ivp.getCostingLevel().equals("C")) {
            if (ivp.getM_PriceList_ID() == 0) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ParameterMissing")) + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID");
            }
            if (ivp.getM_DiscountSchema_ID() == 0) {
                return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ParameterMissing")) + Msg.getElement((Properties)this.getCtx(), (String)"M_DiscountSchema_ID");
            }
            MPriceList pl = new MPriceList(this.getCtx(), ivp.getM_PriceList_ID(), this.get_TrxName());
            MPriceListVersion version = this.getPriceListVersion(pl.getM_PriceList_ID(), this.p_DateValue);
            if (version == null) {
                version = new MPriceListVersion(pl);
                version.setName(String.valueOf(ivp.getName()) + " : " + DateValueString);
                version.setValidFrom(this.p_DateValue);
                version.setM_DiscountSchema_ID(ivp.getM_DiscountSchema_ID());
                version.saveEx(this.get_TrxName());
            } else {
                StringBuilder sqlDelete = new StringBuilder("DELETE M_ProductPrice ").append(" WHERE M_PriceList_Version_ID=").append(version.getM_PriceList_Version_ID()).append(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
                DB.executeUpdateEx((String)sqlDelete.toString(), (String)this.get_TrxName());
            }
            this.createProductPrice(ivp, 0, version);
            M_PriceListVersion_ID = version.getM_PriceList_Version_ID();
            returnName = String.valueOf(pl.getName()) + "-" + version.getName();
            this.addBufferLog(0, null, null, returnName, 295, M_PriceListVersion_ID);
        } else if (ivp.getCostingLevel().equals("O")) {
            MInvValProfileOrg[] orgs = ivp.getOrgs();
            int i = 0;
            while (i < orgs.length) {
                if (orgs[i].getM_PriceList_ID() != 0 && orgs[i].getM_DiscountSchema_ID() != 0) {
                    MPriceList pl = new MPriceList(this.getCtx(), ivp.getM_PriceList_ID(), this.get_TrxName());
                    MPriceListVersion version = pl.getPriceListVersion(this.p_DateValue);
                    if (version == null) {
                        version = new MPriceListVersion(pl);
                        version.setName(String.valueOf(ivp.getName()) + " : " + DateValueString);
                        version.setValidFrom(this.p_DateValue);
                        version.setM_DiscountSchema_ID(ivp.getM_DiscountSchema_ID());
                        version.saveEx(this.get_TrxName());
                    } else {
                        StringBuilder sqlDelete = new StringBuilder("DELETE M_ProductPrice ").append(" WHERE M_PriceList_Version_ID=").append(version.getM_PriceList_Version_ID()).append(" AND AD_Client_ID=").append(this.p_AD_Client_ID);
                        DB.executeUpdateEx((String)sqlDelete.toString(), (String)this.get_TrxName());
                    }
                    this.createProductPrice(ivp, orgs[i].getAD_Org_ID(), version);
                    M_PriceListVersion_ID = version.getM_PriceList_Version_ID();
                    returnName = String.valueOf(pl.getName()) + "-" + version.getName();
                    this.addBufferLog(0, null, null, returnName, 295, M_PriceListVersion_ID);
                }
                ++i;
            }
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK");
    }

    private void createProductPrice(MInvValProfile ivp, int AD_Org_ID, MPriceListVersion version) throws Exception {
        int M_Product_ID = 0;
        int C_AcctSchema_ID = ivp.getC_AcctSchema_ID();
        int M_CostType_ID = ivp.getC_AcctSchema().getM_CostType_ID();
        int M_CostElement_ID = 0;
        MCostElement[] CostElements = JPiereInvValUtil.getMaterialStandardCostElements(this.getCtx());
        if (CostElements.length > 0) {
            M_CostElement_ID = CostElements[0].getM_CostElement_ID();
        }
        MProductPrice pp = null;
        MCost cost = null;
        StringBuilder sql = new StringBuilder("SELECT DISTINCT s.M_Product_ID, p.Value ").append("FROM JP_StockOrg s INNER JOIN M_Product p ON(p.M_Product_ID = s.M_Product_ID) ").append(" WHERE s.DateValue=? Order by p.Value");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.p_DateValue);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                M_Product_ID = rs.getInt(1);
                cost = MCost.get((Properties)this.getCtx(), (int)this.p_AD_Client_ID, (int)AD_Org_ID, (int)M_Product_ID, (int)M_CostType_ID, (int)C_AcctSchema_ID, (int)M_CostElement_ID, (int)0, (String)this.get_TrxName());
                if (cost == null) continue;
                pp = new MProductPrice(this.getCtx(), version.getM_PriceList_Version_ID(), M_Product_ID, this.get_TrxName());
                pp.setAD_Org_ID(version.getAD_Org_ID());
                pp.setPriceList(cost.getFutureCostPrice());
                pp.setPriceStd(cost.getCurrentCostPrice());
                pp.saveEx(this.get_TrxName());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private MPriceListVersion getPriceListVersion(int M_PriceList_ID, Timestamp valid) {
        if (valid == null) {
            valid = new Timestamp(System.currentTimeMillis());
        }
        String whereClause = "M_PriceList_ID=? AND TRUNC(ValidFrom)=?";
        MPriceListVersion m_plv = (MPriceListVersion)new Query(this.getCtx(), "M_PriceList_Version", "M_PriceList_ID=? AND TRUNC(ValidFrom)=?", this.get_TrxName()).setParameters(new Object[]{M_PriceList_ID, valid}).setOnlyActiveRecords(true).first();
        return m_plv;
    }
}

