/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.compiere.model.PO;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class PostingErrorReposting
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private String success = null;
    private String failure = null;
    private int successNum = 0;
    private int errorNum = 0;

    protected void prepare() {
        this.p_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block7: {
            this.success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
            this.failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
            String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
            if (this.p_AD_Table_ID > 0) {
                sql = String.valueOf(sql) + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
            }
            sql = String.valueOf(sql) + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Table_ID = rs.getInt(1);
                        String TableName = rs.getString(2);
                        this.reposting(AD_Table_ID, TableName);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "(" + this.success + " : " + this.successNum + " / " + this.failure + " : " + this.errorNum + ")";
    }

    private void reposting(int AD_Table_ID, String TableName) {
        int[] records = PO.getAllIDs((String)TableName, (String)(" AD_Client_ID=" + this.p_AD_Client_ID + " AND Posted='E' "), (String)this.get_TrxName());
        GenericPO po = null;
        String docIdentifier = null;
        int i = 0;
        while (i < records.length) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.p_AD_Client_ID, (int)AD_Table_ID, (int)records[i], (boolean)true, (String)this.get_TrxName());
            po = null;
            List factoryList = Service.locator().list(IModelFactory.class).getServices();
            if (factoryList != null) {
                for (IModelFactory factory : factoryList) {
                    po = factory.getPO(TableName, records[i], this.get_TrxName());
                    if (po == null) continue;
                    if (po.get_ID() == records[i] || records[i] <= 0) break;
                    po = null;
                }
            }
            if (po == null && (po = new GenericPO(TableName, this.getCtx(), records[i], this.get_TrxName())).get_ID() != records[i] && records[i] > 0) {
                po = null;
            }
            if (po != null) {
                docIdentifier = po.get_ColumnIndex("DocumentNo") > 0 ? po.get_Value("DocumentNo").toString() : (po.get_ColumnIndex("Name") > 0 ? po.get_Value("Name").toString() : String.valueOf(TableName) + "[" + records[i] + "]");
                if (Util.isEmpty((String)error)) {
                    this.addBufferLog(0, null, null, String.valueOf(this.success) + " : " + docIdentifier, AD_Table_ID, records[i]);
                    ++this.successNum;
                } else {
                    this.addBufferLog(0, null, null, String.valueOf(this.failure) + " : " + docIdentifier, AD_Table_ID, records[i]);
                    ++this.errorNum;
                }
            }
            ++i;
        }
    }
}

