/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRefList;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class JPiereSynchronizeTreeNodes
extends SvrProcess {
    private int p_AD_TreeFrom_ID = 0;
    private int p_AD_TreeTo_ID = 0;

    protected void prepare() {
        this.p_AD_TreeTo_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Tree_ID")) {
                    this.p_AD_TreeFrom_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MTree treeTo = new MTree(this.getCtx(), this.p_AD_TreeTo_ID, this.get_TrxName());
        MTree treeFrom = new MTree(this.getCtx(), this.p_AD_TreeFrom_ID, this.get_TrxName());
        if (this.p_AD_TreeTo_ID == this.p_AD_TreeFrom_ID) {
            String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_CannotSynchronizeSameTree");
            this.addLog(msg);
            return "";
        }
        if (!treeTo.getTreeType().equals(treeFrom.getTreeType())) {
            String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_SelectSameTreeType");
            this.addLog(msg);
            return "";
        }
        if (treeTo.isAllNodes() && !treeFrom.isAllNodes()) {
            String msg = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NotAllNodes");
            this.addLog(msg);
            return "";
        }
        String tableName = MTree_Base.getNodeTableName((String)treeTo.getTreeType());
        if (treeTo.getTreeType().equals("TL")) {
            String msg = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"CopyError")) + MRefList.get((Properties)this.getCtx(), (int)120, (String)treeTo.getTreeType(), (String)this.get_TrxName());
            this.addLog(msg);
            return "";
        }
        String deleteSQL = "DELETE FROM " + tableName + " WHERE AD_Tree_ID=" + this.p_AD_TreeTo_ID;
        int deleteNo = DB.executeUpdateEx((String)deleteSQL, (String)this.get_TrxName());
        String insertSQL = "INSERT INTO " + tableName + " (AD_Tree_ID, Node_ID, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, Parent_ID, SeqNo," + tableName + "_UU)" + "SELECT " + this.p_AD_TreeTo_ID + ", Node_ID," + this.getAD_Client_ID() + ", AD_Org_ID, IsActive, SysDate," + this.getAD_User_ID() + ", SysDate," + this.getAD_User_ID() + ", Parent_ID, SeqNo," + "generate_uuid()" + " FROM " + tableName + " WHERE AD_Tree_ID=" + this.p_AD_TreeFrom_ID;
        int insertNo = DB.executeUpdateEx((String)insertSQL, (String)this.get_TrxName());
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Deleted")) + " = " + deleteNo + " / " + Msg.getMsg((Properties)this.getCtx(), (String)"Inserted") + " = " + insertNo;
    }
}

