/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.X_I_UserJP;
import org.adempiere.process.ImportProcess;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereImportUser
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_IsValidateOnly = false;
    private String p_JP_ImportUserIdentifier = null;
    public static final String JP_ImportUserIdentifier_EMail = "EM";
    public static final String JP_ImportUserIdentifier_Name = "NA";
    public static final String JP_ImportUserIdentifier_Value = "VA";
    public static final String JP_ImportUserIdentifier_ValueEMail = "VE";
    public static final String JP_ImportUserIdentifier_ValueName = "VN";
    public static final String JP_ImportUserIdentifier_ValueNameEmail = "VZ";
    public static final String JP_ImportUserIdentifier_NotCollate = "ZZ";
    private String message = null;
    private IProcessUI processMonitor = null;
    private long startTime = System.currentTimeMillis();

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("IsValidateOnly")) {
                this.p_IsValidateOnly = para[i].getParameterAsBoolean();
            } else if (name.equals("JP_ImportUserIdentifier")) {
                this.p_JP_ImportUserIdentifier = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        this.processMonitor = Env.getProcessUI((Properties)this.getCtx());
        StringBuilder sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.m_deleteOldImported) {
            sql = new StringBuilder("DELETE I_UserJP ").append("WHERE I_IsImported='Y'").append(clientCheck);
            try {
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Delete Old Imported =" + no);
                }
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
            }
        }
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='' ").append(" WHERE I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(no));
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + sql);
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_User_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_Org_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_Org_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_OrgTrx_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupAD_OrgTrx_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"JP_Corporation_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupJP_Corporation_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_BPartner_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_BPartner_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Job_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Job_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"Supervisor_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSupervisor_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"R_DefaultMailText_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupR_DefaultMailText_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Location_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Location_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"SalesRep_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupSalesRep_ID()) {
            return this.message;
        }
        this.commitEx();
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Matching")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"C_Greeting_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        if (!this.reverseLookupC_Greeting_ID()) {
            return this.message;
        }
        this.commitEx();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        if (this.p_IsValidateOnly) {
            return "Validated";
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Register")) + " & " + Msg.getMsg((Properties)this.getCtx(), (String)"Update") + " " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID");
        if (this.processMonitor != null) {
            this.processMonitor.statusUpdate(this.message);
        }
        sql = new StringBuilder("SELECT * FROM I_UserJP WHERE I_IsImported='N' ").append(this.getWhereClause());
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier)) {
            sql.append(clientCheck).append(" ORDER BY Value, Name, EMail ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_EMail)) {
            sql.append(clientCheck).append(" ORDER BY EMail ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Name)) {
            sql.append(clientCheck).append(" ORDER BY Name ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Value)) {
            sql.append(clientCheck).append(" ORDER BY Value ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueEMail)) {
            sql.append(clientCheck).append(" ORDER BY Value, EMail ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueName)) {
            sql.append(clientCheck).append(" ORDER BY Value, Name ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueNameEmail)) {
            sql.append(clientCheck).append(" ORDER BY Value, Name, EMail ");
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
            sql.append(clientCheck).append(" ORDER BY Value, Name, EMail ");
        } else {
            sql.append(clientCheck).append(" ORDER BY Value, Name, EMail ");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int recordsNum = 0;
        int successNewNum = 0;
        int successUpdateNum = 0;
        int failureNewNum = 0;
        int failureUpdateNum = 0;
        String records = Msg.getMsg((Properties)this.getCtx(), (String)"JP_NumberOfRecords");
        String success = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success");
        String failure = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure");
        String newRecord = Msg.getMsg((Properties)this.getCtx(), (String)"New");
        String updateRecord = Msg.getMsg((Properties)this.getCtx(), (String)"Update");
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String preValue = "";
                String preName = "";
                String preEMail = "";
                MUser user = null;
                while (rs.next()) {
                    X_I_UserJP imp = new X_I_UserJP(this.getCtx(), rs, this.get_TrxName());
                    boolean isNew = true;
                    if (imp.getAD_User_ID() != 0) {
                        isNew = false;
                        user = new MUser(this.getCtx(), imp.getAD_User_ID(), this.get_TrxName());
                    } else if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier)) {
                        isNew = true;
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_EMail)) {
                        if (preEMail.equals(imp.getEMail())) {
                            isNew = false;
                        }
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Name)) {
                        if (preName.equals(imp.getName())) {
                            isNew = false;
                        }
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Value)) {
                        if (preValue.equals(imp.getValue())) {
                            isNew = false;
                        }
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueEMail)) {
                        if (preEMail == null && !Util.isEmpty((String)imp.getEMail())) {
                            isNew = true;
                        } else if (preEMail == null && Util.isEmpty((String)imp.getEMail())) {
                            isNew = !preValue.equals(imp.getValue());
                        } else if (preValue.equals(imp.getValue()) && preEMail.equals(imp.getEMail())) {
                            isNew = false;
                        }
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueName)) {
                        if (preValue.equals(imp.getValue()) && preName.equals(imp.getName())) {
                            isNew = false;
                        }
                    } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueNameEmail)) {
                        if (preEMail == null && !Util.isEmpty((String)imp.getEMail())) {
                            isNew = true;
                        } else if (preEMail == null && Util.isEmpty((String)imp.getEMail())) {
                            isNew = !preValue.equals(imp.getValue()) || !preName.equals(imp.getName());
                        } else if (preValue.equals(imp.getValue()) && preName.equals(imp.getName()) && preEMail.equals(imp.getEMail())) {
                            isNew = false;
                        }
                    } else {
                        isNew = this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate) ? true : true;
                    }
                    preValue = imp.getValue();
                    preName = imp.getName();
                    preEMail = imp.getEMail();
                    if (isNew) {
                        user = new MUser(this.getCtx(), 0, this.get_TrxName());
                        if (this.createNewUser(imp, user)) {
                            ++successNewNum;
                        } else {
                            ++failureNewNum;
                        }
                    } else if (this.updateUser(imp, user)) {
                        ++successUpdateNum;
                    } else {
                        ++failureUpdateNum;
                    }
                    this.commitEx();
                    ++recordsNum;
                    if (this.processMonitor == null) continue;
                    this.processMonitor.statusUpdate(String.valueOf(newRecord) + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.toString(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        long endTime = System.currentTimeMillis();
        long time = endTime - this.startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timeFormatted = formatter.format(time);
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + "  " + timeFormatted + "  " + records + recordsNum + " = " + newRecord + "( " + success + " : " + successNewNum + "  /  " + failure + " : " + failureNewNum + " ) + " + updateRecord + " ( " + success + " : " + successUpdateNum + "  /  " + failure + " : " + failureUpdateNum + " ) ";
    }

    public String getImportTableName() {
        return "I_UserJP";
    }

    public String getWhereClause() {
        StringBuilder msgreturn = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
        return msgreturn.toString();
    }

    private boolean reverseLookupAD_User_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
            return true;
        }
        StringBuilder checkUserDuplicationSql = new StringBuilder("SELECT * FROM I_UserJP WHERE I_IsImported='N' AND AD_Client_ID=? ");
        CPreparedStatement checkUserDuplicationPSTMT = null;
        ResultSet checkUserDuplicationRS = null;
        boolean isUserDuplication = false;
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Checking")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ImportUserIdentifier");
        String JP_Checked = Msg.getMsg((Properties)this.getCtx(), (String)"JP_Checked");
        String Error = Msg.getMsg((Properties)this.getCtx(), (String)"Error");
        int i = 0;
        int j = 0;
        try {
            try {
                checkUserDuplicationPSTMT = DB.prepareStatement((String)checkUserDuplicationSql.toString(), (String)this.get_TrxName());
                checkUserDuplicationPSTMT.setInt(1, this.getAD_Client_ID());
                checkUserDuplicationRS = checkUserDuplicationPSTMT.executeQuery();
                while (checkUserDuplicationRS.next()) {
                    ++i;
                    if (this.processMonitor != null) {
                        this.processMonitor.statusUpdate(String.valueOf(this.message) + "(" + Error + j + " / " + JP_Checked + i + ")");
                    }
                    X_I_UserJP imp = new X_I_UserJP(this.getCtx(), checkUserDuplicationRS, this.get_TrxName());
                    if (!JPiereImportUser.isUserDuplication(this.getCtx(), imp.getValue(), imp.getName(), imp.getEMail(), this.p_JP_ImportUserIdentifier, this.get_TrxName())) continue;
                    ++j;
                    imp.setI_ErrorMsg(String.valueOf(Error) + JP_Checked + Msg.getElement((Properties)this.getCtx(), (String)"JP_ImportUserIdentifier"));
                    isUserDuplication = true;
                    imp.saveEx(this.get_TrxName());
                    this.commitEx();
                }
            }
            catch (Exception e) {
                this.message = String.valueOf(this.message) + e.toString();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(checkUserDuplicationRS, checkUserDuplicationPSTMT);
            checkUserDuplicationRS = null;
            checkUserDuplicationPSTMT = null;
            throw throwable;
        }
        DB.close((ResultSet)checkUserDuplicationRS, (Statement)checkUserDuplicationPSTMT);
        checkUserDuplicationRS = null;
        checkUserDuplicationPSTMT = null;
        if (isUserDuplication) {
            this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Checked")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_ImportUserIdentifier") + "(" + Error + j + " / " + JP_Checked + i + ")";
            return false;
        }
        StringBuilder sql = null;
        int no = 0;
        if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_EMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.EMail IS NOT NULL AND i.AD_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Name)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.Name IS NOT NULL AND i.AD_User_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Value)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueEMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND i.EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL  AND i.EMai IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
            }
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND p.EMail IS NULL AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.EMai IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueName)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND i.Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueNameEmail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND i.Name=p.Name AND i.EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Name IS NOT NULL AND i.EMail IS NOT NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
            try {
                no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
            }
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_User_ID=(SELECT MAX(AD_User_ID) FROM AD_User p").append(" WHERE i.Value=p.Value AND i.Name = p.Name AND p.EMail IS NULL AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.AD_User_ID IS NULL AND i.Value IS NOT NULL AND i.Name IS NOT NULL AND i.EMail IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
                return true;
            }
            return true;
        }
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + e.toString();
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isUserDuplication(Properties ctx, String Value, String Name, String EMail, String JP_ImportUserIdentifier, String trxName) throws Exception {
        block87: {
            block88: {
                sql = new StringBuffer("SELECT count(*) From AD_User WHERE (AD_Client_ID = 0 or AD_Client_ID =?) AND ");
                if (JP_ImportUserIdentifier.equals("EM")) {
                    if (EMail == null) {
                        sql.append("EMail IS NULL");
                    } else {
                        sql.append("EMail=?");
                    }
                } else if (JP_ImportUserIdentifier.equals("NA")) {
                    if (Name == null) {
                        sql.append("Name IS NULL");
                    } else {
                        sql.append("Name=?");
                    }
                } else if (JP_ImportUserIdentifier.equals("VA")) {
                    if (Value == null) {
                        sql.append("Value IS NULL");
                    } else {
                        sql.append("Value=?");
                    }
                } else if (JP_ImportUserIdentifier.equals("VE")) {
                    if (Value == null && EMail == null) {
                        sql.append("Value IS NULL AND EMail IS NULL");
                    } else if (Value != null && EMail == null) {
                        sql.append("Value=? AND EMail IS NULL");
                    } else if (Value == null && EMail != null) {
                        sql.append("Value IS NULL AND EMail=?");
                    } else {
                        sql.append("Value=? AND EMail=?");
                    }
                } else if (JP_ImportUserIdentifier.equals("VN")) {
                    if (Value == null && Name == null) {
                        sql.append("Value IS NULL AND Name IS NULL");
                    } else if (Value != null && Name == null) {
                        sql.append("Value=? AND Name IS NULL");
                    } else if (Value == null && Name != null) {
                        sql.append("Value IS NULL AND Name=?");
                    } else {
                        sql.append("Value=? AND Name=?");
                    }
                } else if (JP_ImportUserIdentifier.equals("VZ")) {
                    if (Value == null && Name == null && EMail == null) {
                        sql.append("Value IS NULL AND Name IS NULL AND  EMail IS NULL");
                    } else if (Value == null && Name == null && EMail != null) {
                        sql.append("Value IS NULL AND Name IS NULL AND EMail=?");
                    } else if (Value == null && Name != null && EMail == null) {
                        sql.append("Value IS NULL AND Name = ? AND  EMail IS NULL");
                    } else if (Value == null && Name != null && EMail != null) {
                        sql.append("Value IS NULL AND Name=? AND EMail=?");
                    } else if (Value != null && Name == null && EMail == null) {
                        sql.append("Value=? AND Name IS NULL AND  EMail IS NULL");
                    } else if (Value != null && Name == null && EMail != null) {
                        sql.append("Value=? AND Name IS NULL AND EMail=?");
                    } else if (Value != null && Name != null && EMail == null) {
                        sql.append("Value=? AND Name = ? AND  EMail IS NULL");
                    } else if (Value != null && Name != null && EMail != null) {
                        sql.append("Value=? AND Name=? AND EMail=?");
                    } else {
                        sql.append("Value=? AND Name=? AND EMail=?");
                    }
                } else {
                    if (JP_ImportUserIdentifier.equals("ZZ")) {
                        return false;
                    }
                    return false;
                }
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                pstmt.setInt(1, Env.getAD_Client_ID((Properties)ctx));
                if (JP_ImportUserIdentifier.equals("EM")) {
                    if (EMail != null) {
                        pstmt.setString(2, EMail);
                    }
                    break block87;
                }
                if (JP_ImportUserIdentifier.equals("NA")) {
                    if (Name != null) {
                        pstmt.setString(2, Name);
                    }
                    break block87;
                }
                if (JP_ImportUserIdentifier.equals("VA")) {
                    if (Value != null) {
                        pstmt.setString(2, Value);
                    }
                    break block87;
                }
                if (JP_ImportUserIdentifier.equals("VE")) {
                    if (Value != null || EMail != null) {
                        if (Value != null && EMail == null) {
                            pstmt.setString(2, Value);
                        } else if (Value == null && EMail != null) {
                            pstmt.setString(2, EMail);
                        } else {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, EMail);
                        }
                    }
                    break block87;
                }
                if (JP_ImportUserIdentifier.equals("VN")) {
                    if (Value != null || Name != null) {
                        if (Value != null && Name == null) {
                            pstmt.setString(2, Value);
                        } else if (Value == null && Name != null) {
                            pstmt.setString(2, Name);
                        } else {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, Name);
                        }
                    }
                    break block87;
                }
                if (JP_ImportUserIdentifier.equals("VZ")) {
                    if (Value != null || Name != null || EMail != null) {
                        if (Value == null && Name == null && EMail != null) {
                            pstmt.setString(2, EMail);
                        } else if (Value == null && Name != null && EMail == null) {
                            pstmt.setString(2, Name);
                        } else if (Value == null && Name != null && EMail != null) {
                            pstmt.setString(2, Name);
                            pstmt.setString(3, EMail);
                        } else if (Value != null && Name == null && EMail == null) {
                            pstmt.setString(2, Value);
                        } else if (Value != null && Name == null && EMail != null) {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, EMail);
                        } else if (Value != null && Name != null && EMail == null) {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, Name);
                        } else if (Value != null && Name != null && EMail != null) {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, Name);
                            pstmt.setString(4, EMail);
                        } else {
                            pstmt.setString(2, Value);
                            pstmt.setString(3, Name);
                            pstmt.setString(4, EMail);
                        }
                    }
                    break block87;
                }
                if (!JP_ImportUserIdentifier.equals("ZZ")) break block88;
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return false;
        }
        try {
            rs = pstmt.executeQuery();
            no = 0;
            ** if (!rs.next() || (no = rs.getInt((int)1)) <= 1) goto lbl-1000
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable var10_11) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw var10_11;
            }
        }
lbl-1000:
        // 1 sources

        {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return true;
        }
lbl-1000:
        // 1 sources

        {
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return false;
    }

    private boolean reverseLookupJP_Corporation_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET JP_Corporation_ID=(SELECT JP_Corporation_ID FROM JP_Corporation p").append(" WHERE i.JP_Corporation_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.JP_Corporation_ID IS NULL AND i.JP_Corporation_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Corporation_Value");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE JP_Corporation_ID IS NULL AND JP_Corporation_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_BPartner_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p").append(" WHERE i.JP_BPartner_Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) ").append("WHERE i.C_BPartner_ID IS NULL AND i.JP_BPartner_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Value");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_BPartner_ID IS NULL AND JP_BPartner_Value IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupC_BPartner_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location p").append(" WHERE i.JP_BPartner_Location_Name=p.Name AND i.C_Bpartner_ID =p.C_BPartner_ID) ").append(" WHERE i.C_BPartner_Location_ID IS NULL AND i.JP_BPartner_Location_Name IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_BPartner_Location_Name");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append("WHERE C_BPartner_Location_ID IS NULL AND JP_BPartner_Location_Name IS NOT NULL AND C_BPartner_ID IS NOT NULL").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return true;
    }

    private boolean reverseLookupAD_Org_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_Org_ID=(SELECT AD_Org_ID FROM AD_Org p").append(" WHERE i.JP_Org_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_Org_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Org_Value");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID = 0 AND JP_Org_Value IS NOT NULL AND JP_Org_Value <> '0' ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupAD_OrgTrx_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET AD_OrgTrx_ID=(SELECT AD_Org_ID FROM AD_org p").append(" WHERE i.JP_OrgTrx_Value=p.Value AND (p.AD_Client_ID=i.AD_Client_ID or p.AD_Client_ID=0) AND p.IsSummary='N') ").append(" WHERE i.JP_OrgTrx_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_OrgTrx_Value");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE AD_Org_ID IS NULL AND JP_OrgTrx_Value IS NOT NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Job_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET C_Job_ID=(SELECT C_Job_ID FROM C_Job p").append(" WHERE i.JP_Job_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_Job_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Job_Name");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Job_Name IS NOT NULL AND C_Job_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupSupervisor_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
            return true;
        }
        StringBuilder sql = null;
        int no = 0;
        if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_EMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_EMail=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append("WHERE JP_Supervisor_EMail IS NOT NULL").append(" AND I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Name)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.JP_Supervisor_Name IS NOT NULL AND i.Supervisor_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Value)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_Value=p.Value AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.Supervisor_ID IS NULL AND i.JP_Supervisor_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueEMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_Value=p.Value AND i.JP_Supervisor_EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.Supervisor_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueName)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_Value=p.Value AND i.JP_Supervisor_Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.Supervisor_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueNameEmail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET Supervisor_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_Supervisor_Value=p.Value AND i.JP_Supervisor_Name=p.Name AND i.JP_Supervisor_EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.Supervisor_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
                return true;
            }
            return true;
        }
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = String.valueOf(this.message) + " : " + e.toString() + " : " + sql.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupR_DefaultMailText_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET R_DefaultMailText_ID=(SELECT R_DefaultMailText_ID FROM M_FreightCategory p").append(" WHERE i.JP_MailText_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.JP_MailText_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_MailText_Name");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_MailText_Name IS NOT NULL AND R_DefaultMailText_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupC_Location_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET C_Location_ID=(SELECT C_Location_ID FROM C_Location p").append(" WHERE i.JP_Location_Label= p.JP_Location_Label AND p.AD_Client_ID=i.AD_Client_ID) ").append(" WHERE i.C_Location_ID IS NULL AND JP_Location_Label IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_Location_Label");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Location_Label IS NOT NULL AND C_Location_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean reverseLookupSalesRep_ID() throws Exception {
        if (Util.isEmpty((String)this.p_JP_ImportUserIdentifier) || this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
            return true;
        }
        StringBuilder sql = null;
        int no = 0;
        if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_EMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Email=p.EMail AND ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.JP_SalesRep_Email IS NOT NULL  AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Name)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.JP_SalesRep_Name IS NOT NULL AND i.SalesRep_ID IS NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_Value)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Value=p.Value AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.SalesRep_ID IS NULL AND i.JP_SalesRep_Value IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueEMail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.SalesRep_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueName)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.SalesRep_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_ValueNameEmail)) {
            sql = new StringBuilder("UPDATE I_UserJP i ").append("SET SalesRep_ID=(SELECT AD_User_ID FROM AD_User p").append(" WHERE i.JP_SalesRep_Value=p.Value AND i.JP_SalesRep_Name=p.Name AND i.JP_SalesRep_EMail=p.EMail AND  ( p.AD_Client_ID=i.AD_Client_ID OR p.AD_Client_ID=0 ) ) ").append(" WHERE i.SalesRep_ID IS NULL ").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        } else {
            if (this.p_JP_ImportUserIdentifier.equals(JP_ImportUserIdentifier_NotCollate)) {
                return true;
            }
            return true;
        }
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            this.message = e.toString();
            return false;
        }
        return true;
    }

    private boolean reverseLookupC_Greeting_ID() throws Exception {
        int no = 0;
        StringBuilder sql = new StringBuilder("UPDATE I_UserJP i ").append("SET C_Greeting_ID=(SELECT C_Greeting_ID FROM C_Greeting p").append(" WHERE i.JP_Greeting_Name=p.Name AND p.AD_Client_ID=i.AD_Client_ID ) ").append(" WHERE i.JP_Greeting_Name IS NOT NULL").append(" AND i.I_IsImported='N'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.message + " : " + e.toString() + " : " + sql);
        }
        this.message = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)this.getCtx(), (String)"Invalid") + Msg.getElement((Properties)this.getCtx(), (String)"JP_Greeting_Name");
        sql = new StringBuilder("UPDATE I_UserJP ").append("SET I_ErrorMsg='" + this.message + "'").append(" WHERE JP_Greeting_Name IS NOT NULL AND C_Greeting_ID IS NULL ").append(" AND I_IsImported<>'Y'").append(this.getWhereClause());
        try {
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        }
        catch (Exception e) {
            throw new Exception(String.valueOf(this.message) + " : " + e.toString() + " : " + sql);
        }
        return no <= 0;
    }

    private boolean createNewUser(X_I_UserJP importUser, MUser newUser) throws SQLException {
        String email;
        boolean isEMailLogin = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false, (int)this.getAD_Client_ID());
        if (isEMailLogin && !Util.isEmpty((String)importUser.getPassword()) && Util.isEmpty((String)importUser.getEMail())) {
            Object[] objs = new Object[]{Msg.getElement((Properties)Env.getCtx(), (String)"EMail")};
            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Mandatory", (Object[])objs));
            importUser.setI_IsImported(false);
            importUser.setProcessed(false);
            importUser.saveEx(this.get_TrxName());
            return false;
        }
        if (!Util.isEmpty((String)importUser.getEMail()) && (email = importUser.getEMail()).indexOf("@") == -1) {
            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Invalid")) + Msg.getElement((Properties)Env.getCtx(), (String)"EMail"));
            importUser.setI_IsImported(false);
            importUser.setProcessed(false);
            importUser.saveEx(this.get_TrxName());
            return false;
        }
        if (Util.isEmpty((String)importUser.getName())) {
            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_Null")) + Msg.getElement((Properties)this.getCtx(), (String)"Name"));
            importUser.setI_IsImported(false);
            importUser.setProcessed(false);
            importUser.saveEx(this.get_TrxName());
            return false;
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importUser, (PO)newUser, 30);
        PO.copyValues((PO)importUser, (PO)newUser);
        if (!Util.isEmpty((String)newUser.getDescription())) {
            newUser.setDescription(newUser.getDescription().replaceAll("<CRLF>", "\r\n"));
            newUser.setDescription(newUser.getDescription().replaceAll("<CR>", "\r"));
            newUser.setDescription(newUser.getDescription().replaceAll("<LF>", "\n"));
        }
        if (!Util.isEmpty((String)importUser.getComments())) {
            newUser.setComments(newUser.getComments().replaceAll("<CRLF>", "\r\n"));
            newUser.setComments(newUser.getComments().replaceAll("<CR>", "\r"));
            newUser.setComments(newUser.getComments().replaceAll("<LF>", "\n"));
        }
        newUser.setIsActive(importUser.isI_IsActiveJP());
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importUser, (PO)newUser, 40);
        try {
            newUser.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveIgnored")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID") + " : " + e.toString());
            importUser.setI_IsImported(false);
            importUser.setProcessed(false);
            importUser.saveEx(this.get_TrxName());
            return false;
        }
        importUser.setAD_User_ID(newUser.getAD_User_ID());
        importUser.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"NewRecord"));
        importUser.setI_IsImported(true);
        importUser.setProcessed(true);
        importUser.saveEx(this.get_TrxName());
        return true;
    }

    private boolean updateUser(X_I_UserJP importUser, MUser updateUser) throws SQLException {
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importUser, (PO)updateUser, 30);
        MTable AD_User_Table = MTable.get((Properties)this.getCtx(), (int)114, (String)this.get_TrxName());
        MColumn[] AD_User_Columns = AD_User_Table.getColumns(true);
        MTable I_UserJP_Table = MTable.get((Properties)this.getCtx(), (int)X_I_UserJP.Table_ID, (String)this.get_TrxName());
        MColumn[] I_UserJP_Columns = I_UserJP_Table.getColumns(true);
        MColumn i_Column = null;
        int i = 0;
        while (i < AD_User_Columns.length) {
            i_Column = AD_User_Columns[i];
            if (!(i_Column.isVirtualColumn() || i_Column.isKey() || i_Column.isUUIDColumn() || i_Column.getColumnName().equals("IsActive") || i_Column.getColumnName().equals("AD_Client_ID") || i_Column.getColumnName().equals("Value") || i_Column.getColumnName().equals("Name") || i_Column.getColumnName().equals("Processing") || i_Column.getColumnName().equals("Created") || i_Column.getColumnName().equals("CreatedBy") || i_Column.getColumnName().equals("Updated") || i_Column.getColumnName().equals("UpdatedBy"))) {
                MColumn j_Column = null;
                Object importValue = null;
                int j = 0;
                while (j < I_UserJP_Columns.length) {
                    j_Column = I_UserJP_Columns[j];
                    if (i_Column.getColumnName().equals(j_Column.getColumnName())) {
                        importValue = importUser.get_Value(j_Column.getColumnName());
                        if (importValue == null) break;
                        if (importValue instanceof BigDecimal) {
                            BigDecimal bigDecimal_Value = (BigDecimal)importValue;
                            if (bigDecimal_Value.compareTo(Env.ZERO) == 0) {
                                break;
                            }
                        } else {
                            Integer p_key;
                            if (j_Column.getAD_Reference_ID() == 10) {
                                String string_Value = (String)importValue;
                                if (Util.isEmpty((String)string_Value)) break;
                                if (j_Column.getColumnName().equals("Descripton")) {
                                    importValue = importValue.toString().replaceAll("<CRLF>", "\r\n");
                                    importValue = importValue.toString().replaceAll("<CR>", "\r");
                                    importValue = importValue.toString().replaceAll("<LF>", "\n");
                                }
                                if (j_Column.getColumnName().equals("Commnets")) {
                                    importValue = importValue.toString().replaceAll("<CRLF>", "\r\n");
                                    importValue = importValue.toString().replaceAll("<CR>", "\r");
                                    importValue = importValue.toString().replaceAll("<LF>", "\n");
                                }
                                updateUser.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                                break;
                            }
                            if (j_Column.getColumnName().endsWith("_ID") && (p_key = (Integer)importValue) <= 0 && !j_Column.getColumnName().equals("AD_OrgTrx_ID")) break;
                        }
                        if (importValue == null) break;
                        try {
                            updateUser.set_ValueNoCheck(i_Column.getColumnName(), importValue);
                            if (j_Column.getColumnName().equals("Descripton")) {
                                updateUser.setDescription(updateUser.getDescription().replaceAll("<CRLF>", "\r\n"));
                                updateUser.setDescription(updateUser.getDescription().replaceAll("<CR>", "\r"));
                                updateUser.setDescription(updateUser.getDescription().replaceAll("<LF>", "\n"));
                            }
                            if (!j_Column.getColumnName().equals("Comments")) break;
                            updateUser.setComments(updateUser.getComments().replaceAll("<CRLF>", "\r\n"));
                            updateUser.setComments(updateUser.getComments().replaceAll("<CR>", "\r"));
                            updateUser.setComments(updateUser.getComments().replaceAll("<LF>", "\n"));
                            break;
                        }
                        catch (Exception e) {
                            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " Column = " + i_Column.getColumnName() + " & " + "Value = " + importValue.toString() + " -> " + e.toString());
                            importUser.setI_IsImported(false);
                            importUser.setProcessed(false);
                            importUser.saveEx(this.get_TrxName());
                            return false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        updateUser.setIsActive(importUser.isI_IsActiveJP());
        if (importUser.getAD_User_ID() == 0) {
            importUser.setAD_User_ID(updateUser.getAD_User_ID());
        }
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)importUser, (PO)updateUser, 40);
        try {
            updateUser.saveEx(this.get_TrxName());
        }
        catch (Exception e) {
            importUser.setI_ErrorMsg(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"SaveError")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"AD_User_ID") + " : " + e.toString());
            importUser.setI_IsImported(false);
            importUser.setProcessed(false);
            importUser.saveEx(this.get_TrxName());
            return false;
        }
        importUser.setI_ErrorMsg(Msg.getMsg((Properties)this.getCtx(), (String)"Update"));
        importUser.setI_IsImported(true);
        importUser.setProcessed(true);
        importUser.saveEx(this.get_TrxName());
        return true;
    }
}

